$(document).ready(function () {

    $("#print_acciones").hide();

    $(".calendario").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'mm-yy',
        onClose: function(dateText, inst) { 
            $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
    });

    // Ocultar el calendario para solo mostrar el mes
    $(".calendario").focus(function () {
        $(".ui-datepicker-calendar").hide();
        $("#ui-datepicker-div").position({
            my: "center top",
            at: "center bottom",
            of: $(this)
        });
    });

    // $('select').select2({placeholder: 'Seleccione'});

    $("#txt_cliente").select2({
        placeholder:'Buscar clientes',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'modulo_contratos/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo+" - "+item.nombre,
                    });
                });
                return {
                    results: myResults
                };
            } 
        }
    }); 

    $("#btn_consultar").click(function(){
        event.preventDefault();
        $("#print_acciones").hide();
        var cliente = $("#txt_cliente").val();
        var periodo = $("#txt_periodo").val();
        if (periodo != "") {
            $("#div_contenedor_clientes").hide('slide',{ direction:'right' }, 400,function(){
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url: urlj + 'modulo_contratos/reportes/cuenta_cobrar/1',
                    data:{
                        periodo_fecha: periodo,
                        cliente_espec: cliente,
                        reporte: ""
                    },
                    beforeSend:function(){
                        wait.start('Por favor espere. Consultando la información...');
                    },
                    success:function(data){
                        var oTabla = $("#tblClientes").dataTable();                        
                        oTabla.fnDestroy();
                        $("#respuesta").html(data.tabla);                        
                        if (data.filas > 0) {
                            $("#periodo_fecha").val(periodo);
                            $("#cliente_espec").val(cliente);
                            $("#print_acciones").show();
                        }
                        aplicarDatatable('tblClientes');
                        $("#div_contenedor_clientes").show("slide", { direction: 'left' }, 500);
                        wait.close();
                    }
                });
            });
        } else {
            crear_alerta('error', 'Cuentas por cobrar', 'Por favor especifique el período a consultar.');
            return false;
        } 
    });




});//end doc ready

function aplicarDatatable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

