$(document).ready(function () {

    $('select').select2({placeholder: 'Seleccione una opción'});

    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $(".txt_periodo").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'mm-yy',
        monthNamesShort: ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#txt_periodo_fecha").change(function (){
        if ($(this).val() != ""){
            var fecha       = $(this).val();
            fecha           = "01-"+fecha;
        
            var fecha_array = fecha.split('-');

            var date        = new Date(fecha_array[1]+"-"+fecha_array[0]+"-"+fecha_array[2]);
            var ultimoDia   = new Date(date.getFullYear(), date.getMonth() + 1, 0);
            var mes         = ultimoDia.getMonth() + 1;
            var year        = ultimoDia.getFullYear();   

            var meses       = ["Enero", "Febreo", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];

            $("#txt_periodo").val(meses[ultimoDia.getMonth()] + "-" + year);      
        } else{
            $("#txt_periodo").val("");
        }
    });


    $("#slcServicio").change(function () {
        var servicio = $(this).val();
        if (servicio > 0) {

            $.ajax({
                url: window.gSateliteWhite.baseUrl('modulo_contratos/procesos/get_planes_servicio'),
                data: {servicio: servicio},
                type: "post",
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $("#slcPlanes").html(result);
                    $("#slcPlanes").select2({placeholder: "Seleccione una opción"});
                }
            });
        } else {
            $("#slcPlanes").html('');
            $("#slcPlanes").select2({placeholder: "Seleccione una opción"});
        }
    });


    $("#btn_consultar").click(function () {
        event.preventDefault();

        var fechaInicio_corte   = $("#txt_fecha_corte_inicio").val();
        var fechaFin_corte      = $("#txt_fecha_corte_fin").val();

        var fechaInicio         = $("#txtFechaInicio").val();
        var fechaFin            = $("#txtFechaFin").val();

        var slcServicio         = ($("#slcServicio").val() > 0)?$("#slcServicio").val():'';
        var slcPlanes           = ($("#slcPlanes").val() > 0)?$("#slcServicio").val():'';
        var slcTipoFactura      = ($("#slcTipoFactura").val() > 0)?$("#slcTipoFactura").val():'';
        var respuesta           = false;
        var periodo             = $("#txt_periodo").val();


        if ( slcTipoFactura == "") {
            crear_alerta('error', 'Aviso', 'Favor seleccione un tipo de factura.');
            return false;
        }
        if ( fechaInicio  == "" && fechaFin == "" && fechaInicio_corte == "" && fechaFin_corte == "" && slcServicio == "" && slcPlanes == "" && slcTipoFactura == "" ) {
            crear_alerta('error', 'Aviso', 'Favor ingrese al menos un campo.');
            return false;
        }

        if (fechaInicio_corte != '') {
            
            if ( fechaFin_corte == '') {
                crear_alerta('error', 'Aviso', 'Favor ingrese fecha fin de fecha corte');
                return false;
            }


            if ( fechaInicio != "" || fechaFin != "") {
                crear_alerta('error', 'Aviso', 'La búsqueda debe ser solo por fecha corte o fecha de facturación');
                $("#txtFechaInicio").val("");
                $("#txtFechaFin").val("");
                return false;
            } 

            respuesta = validar_fechas(fechaInicio_corte,fechaFin_corte,"corte");

            if ( respuesta == false ) {
                return false;
            }


        }

        if (fechaFin_corte != '') {

            if ( fechaInicio_corte == '') {
                crear_alerta('error', 'Aviso', 'Favor ingrese fecha inicio de corte');
                return false;
            }

            if ( fechaInicio != "" || fechaFin != "") {
                crear_alerta('error', 'Aviso', 'La búsqueda debe ser solo por fecha Corte o fecha de facturación');
                $("#txtFechaInicio").val("");
                $("#txtFechaFin").val("");
                return false;
            } 

            respuesta = validar_fechas(fechaInicio_corte,fechaFin_corte,"corte");

            if ( respuesta == false ) {
                return false;
            }
        }

      
        if (fechaInicio != '') {

            if ( fechaFin == '') {
                crear_alerta('error', 'Aviso', 'Favor ingrese fecha fin de facturación');
                return false;
            }

            if ( fechaInicio_corte != "" || fechaFin_corte != "") {
                crear_alerta('error', 'Aviso', 'La búsqueda debe ser solo por fecha Corte o fecha de facturación');
                $("#txt_fecha_corte_inicio").val("");
                $("#txt_fecha_corte_fin").val("");
                return false;
            } 

            respuesta = validar_fechas(fechaInicio,fechaFin,"facturación");

            if ( respuesta == false ) {
                return false;
            }

        }


        if (fechaFin != '') {

            if ( fechaInicio == '') {
                crear_alerta('error', 'Aviso', 'Favor ingrese fecha inicial de facturación');
                return false;
            }

            if ( fechaInicio_corte != "" || fechaFin_corte != "") {
                crear_alerta('error', 'Aviso', 'La búsqueda debe ser solo por fecha Corte o fecha de facturación');
                $("#txt_fecha_corte_inicio").val("");
                $("#txt_fecha_corte_fin").val("");
                return false;
            } 

            respuesta = validar_fechas(fechaInicio,fechaFin,"facturación");

            if ( respuesta == false ) {
                return false;
            }

        }

        $.ajax({
            url: window.gSateliteWhite.baseUrl('modulo_contratos/procesos/reimpresion_facturas/1'),
            data: {
                fecha_inicio: fechaInicio,
                fecha_fin:fechaFin,
                servicio:slcServicio,
                plan:slcPlanes,
                tipo_factura:slcTipoFactura,
                fecha_inicio_corte: fechaInicio_corte, 
                fecha_fin_corte: fechaFin_corte,
                periodo:periodo,
                tipo_reporte: ""        
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor_clientes").html(obj.html);
                $("#dv_contenedor_clientes").show("slide", {
                    direction: 'left'
                }, 500);
                if ($("#tbl_contenedor_clientes .tr_facturas").length > 0) {
                    $('.btn_impresion').css("display","block");
                } else {
                    $(".btn_impresion").css('display','none');
                }
                $("#txt_facturas_in").val(obj.facturaciones);
                $("#txt_factura_ini").val(obj.factura_inicial);
                $("#txt_factura_fin").val(obj.factura_final);
                $("#txt_correlativo_inicial_fac").val(obj.factura_numero_inical);
                $("#txt_correlativo_final_fac").val(obj.factura_numero_final);
                wait.close();
            }
        });
    });

    function validar_fechas(fecha_ini, fecha_fin, mensaje){
        var result = true;

        if ( fecha_ini == '' ) {
            crear_alerta('error', 'Aviso', 'Favor ingrese una fecha de '+mensaje+' inicial.');
            result = false;
        }

        if ( fecha_fin == '' ) {
            crear_alerta('error', 'Aviso', 'Favor ingrese una fecha de '+mensaje+' final.');
            result = false;
        }


        if (!validarPeriodo(fecha_ini, fecha_fin)) {
            crear_alerta('info', 'Aviso', 'Verifique el período seleccionado.');
            result = false;
        }

        return result;
    }

    $("#imprimir_modal").click(function(){
        event.preventDefault();

        var error = false;

        if ( $("#txt_correlativo_inicial").val() == "" ) {
            crear_alerta("error","Alerta",'El campo "desde" es obligatorio.');
            $("#txt_correlativo_inicial").focus();
            error = true;
            return false;
        }

        if ( $("#txt_correlativo_final").val() == "") {
            crear_alerta("error","Alerta",'El campo "hasta" es obligatorio.');
            $("#txt_correlativo_final").focus();
            error = true;
            return false;
        }

        if ( error == false ) {
            var correlativo_inicial = parseInt($("#txt_correlativo_inicial").val());
            var correlativo_final = parseInt($("#txt_correlativo_final").val());

            if ( correlativo_inicial < $("#txt_correlativo_inicial_fac").val() ) {
                crear_alerta("error","Alerta",'El campo "hasta" debe estar entre ' + $("#txt_correlativo_inicial_fac").val() + ' y ' + $("#txt_correlativo_final_fac").val() + '.');
                $("#txt_correlativo_inicial").focus();
                error = true;
                return false;
            }
    
            if ( correlativo_final > $("#txt_correlativo_final_fac").val() ) {
                crear_alerta("error","Alerta",'El campo "hasta" debe estar entre ' + $("#txt_correlativo_inicial_fac").val() + ' y ' + $("#txt_correlativo_final_fac").val() + '.');
                $("#txt_correlativo_final").focus();
                error = true;
                return false;
            }
    
            if ( correlativo_inicial > correlativo_final ) {
                crear_alerta("error","Alerta",'El campo "hasta" debe ser mayor al campo final.');
                $("#txt_correlativo_final").focus();
                error = true;
                return false;
            }
    
            if ( (correlativo_final - correlativo_inicial) > 100 ) {
                crear_alerta("info","Alerta",'No se pueden imprimir mas de 100 facturas.');
                error = true;
                return false;
            }
    
            if ( error == false ) {                
                $("#frm_impresion_masiva").submit();
                $("#txt_correlativo_inicial").val("");
                $("#txt_correlativo_final").val("");

            }
        }
    });


    $(".modal_impresion").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
        },
        beforeClose: function () {

        }
    }); 

});