$(document).ready(function () {
    
    $('select').select2({placeholder: 'Seleccione'});
    
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');
    
    $("#btnProcesar").click(function(){
        event.preventDefault();

        var cliente         = $("#txt_cliente").val();
        var fecha_desde     = $("#txt_fecha_inicio").val();
        var fecha_hasta     = $("#txt_fecha_fin").val();
        var fecha_sobre     = $("#txt_fecha_sobre").val();
        var data            = 1;

        if ( fecha_desde == "" || fecha_hasta == "") {
            crear_alerta('error', 'Impresión de sobre de cuotas', 'Por favor ingrese el rango de fechas.');
            $("#txt_fecha_fin").val("");
            return false;
        } 

        if (!validarPeriodo(fecha_desde, fecha_hasta)) {
            crear_alerta('error', 'Impresión de sobre de cuotas', 'Verifique el período de fechas.');
            return false;
        }

        if ( fecha_sobre == "" ) {
            crear_alerta('error', 'Impresión de sobre de cuotas', 'Favor ingrese la fecha con la cual saldra impresa el sobre.');
            $("#txt_fecha_sobre").val("");
            return false;
        } 

        $("#div_contenedor_clientes").hide('slide',{
            direction:'right'
            },
            400,function(){
                $.ajax({
                    type:'post',
                    url:window.gSateliteWhite.baseUrl('modulo_contratos/procesos/impresion_cuotas'),
                    dataTYpe:'json',
                    data:{
                        fecha_desde:fecha_desde,
                        fecha_hasta:fecha_hasta,
                        fecha_sobre:fecha_sobre,
                        cliente:cliente,
                        post:true
                    },
                    beforeSend:function(){
                        wait.start();
                    },
                    success:function(result){
                        var obj = jQuery.parseJSON(result)
                        if ( $.trim(obj.html).length > 0){
                            var oTabla = $("#tblClientes").dataTable();                        
                            oTabla.fnDestroy();
                            $("#tbContenedorClientes").html(obj.html);
                            $("#div_contenedor_clientes").show("slide", {
                                direction: 'left'
                            }, 500);
                            aplicarDatatable('tblClientes');
                            $(".btn_impresion").css("display", "block");
                            $("#filtro_cliente").val(cliente);
                            $("#filtro_registros").val(obj.cantidad);
                            $("#filtro_fecha_inicio").val(fecha_desde);
                            $("#filtro_fecha_fin").val(fecha_hasta);
                            $("#filtro_fecha_sobre").val(fecha_sobre); 
                        } else{
                            var oTabla = $("#tblClientes").dataTable();                        
                            oTabla.fnDestroy();
                            $("#tbContenedorClientes").html("");
                            $("#div_contenedor_clientes").show("slide", {
                                direction: 'left'
                            }, 500);
                            aplicarDatatable('tblClientes');
                            $("#filtro_cliente").val("");
                            $("#filtro_registros").val("");
                            $("#filtro_fecha_inicio").val("");
                            $("#filtro_fecha_fin").val("");
                            $("#filtro_fecha_sobre").val(""); 
                        }
                        wait.close();
                    }
                });
            }
        );
    });

    
    $("#imprimir_modal").click(function(){
        event.preventDefault();

        var inicio  = $("#txt_correlativo_inicial").val();
        var fin     = $("#txt_correlativo_final").val();


        if ( inicio == "" ){
            crear_alerta("error","Alerta",'El campo "desde" es obligatorio.');
            return false;
        }
        
        if ( fin == "" ){
            crear_alerta("error","Alerta",'El campo "hasta" es obligatorio.');
            return false;
        }

        inicio = parseInt(inicio);
        fin = parseInt(fin);

        if ( inicio <= 0 ){
            crear_alerta("error","Alerta",'El campo "desde" debe ser mayor a 0.');
            return false;
        }
        
        if ( fin <0 ){
            crear_alerta("error","Alerta",'El campo "hasta" debe ser mayor a 0.');
            return false;
        }

        if ( inicio > fin ){
            crear_alerta("error","Alerta",'El campo "desde" debe ser menor que el campo "hasta".');
            return false;
        }

        var total = (fin - inicio);

        if ( total > 100 ){
            crear_alerta("error","Alerta",'El rango de la impresión no debe superar las 100 impresiones.');
            return false;
        }

        var valor_max = parseInt($("#txt_registros").val());

        if ( (inicio  > valor_max) || (inicio  > valor_max) ){
            crear_alerta("error","Alerta",'El rango máximo de impresiones es '+ valor_max);
            return false;
        }
        
         $("#frm_impresion").submit();

        $("#txt_correlativo_inicial").val("");
        $("#txt_correlativo_final").val("");
    });

    $("#txt_cliente").select2({
        placeholder:'Buscar clientes',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'modulo_contratos/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente,
                    clasificacion: $("#slc_clasificacion").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo+" - "+item.nombre,
                    });
                });
                return {
                    results: myResults
                };
		    } 
        }
    }); 

    $(document).on('click','.impresion_inividual',function(){
        event.preventDefault();
        var filtro_cliente      = $(this).attr('id');
        var filtro_fecha_inicio = $("#filtro_fecha_inicio").val();
        var filtro_fecha_fin    = $("#filtro_fecha_fin").val();
        var filtro_fecha_sobre  = $("#filtro_fecha_sobre").val();
        $("#filtro_cliente_individual").val(filtro_cliente);          
        $("#filtro_fecha_inicio_individual").val(filtro_fecha_inicio);
        $("#filtro_fecha_fin_individual").val(filtro_fecha_fin);
        $("#filtro_fecha_sobre_individual").val(filtro_fecha_sobre);
        $("#frm_impresion_individual").submit();
    });

    $(document).on('click','.impresion_sobres',function(){
        event.preventDefault();
        $("#filtro_cliente_sobre").val($(this).attr('id'));
        $("#filtro_fecha_inicio_sobre").val($("#filtro_fecha_inicio").val());
        $("#filtro_fecha_fin_sobre").val($("#filtro_fecha_fin").val());
        $("#filtro_fecha_imp_sobre").val($("#filtro_fecha_sobre").val());
        $("#frm_impresion_sobres").submit();
    });

    $("body").on("click", ".envio_correo", function(e){
        e.preventDefault();
        var cli_id = $(this).attr('id');
        var f_ini_sob = $("#filtro_fecha_inicio").val();
        var f_fin_sob = $("#filtro_fecha_fin").val();
        var f_imp_sob = $("#filtro_fecha_sobre").val();
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj + 'modulo_contratos/procesos/enviar_correo_sobre',
            data: {
                cli_id: cli_id,
                f_ini_sob: f_ini_sob,
                f_fin_sob: f_fin_sob,
                f_imp_sob: f_imp_sob
            },
            beforeSend:function(){
                wait.start('<span style="font-size:16px;">Enviando Correos</span>');
            },
            success: function (data) {
                console.log(data);
                if (data.exito == 1) {
                    crear_alerta('success', 'Éxito', 'El correo fue enviado con éxito');
                } else if (data.exito == 2) {
                    crear_alerta('error', 'Ocurrió un error', 'Favor verificar que los correos sean válidos.');
                } else if (data.exito == 3) {
                    crear_alerta('error', 'Ocurrió un error', 'Favor verificar los datos del usuario.');
                } else {
                    crear_alerta('error', 'Ocurrió un error', 'No se ha podido enviar el correo.');
                }
                wait.close();
            }
        });        
    });


    $(document).on('change','#txt_fecha_fin',function(){
        var fecha_fin = $(this).val();
        if ( fecha_fin != ""){
            
            var fecha_array     = fecha_fin.split('-');
            var mes             = "";
            var year            = "";
            var dia             = "01";

            var date            = new Date(fecha_array[1]+"-"+fecha_array[0]+"-"+fecha_array[2]);
            var ultimoDia       = new Date(date.getFullYear(), date.getMonth() + 1, 0);
     
            var mes     = ultimoDia.getMonth() + 2;
            


            if ( mes == "13"){
                var mes     = "01";
                var year    = ultimoDia.getFullYear() + 1;
            } else{
                var year    = ultimoDia.getFullYear();
            }
            
           
            var nueva_fecha     = dia+"-"+('00' + mes).slice(-2)+"-"+year;


            $("#txt_fecha_sobre").val(nueva_fecha);
        } else {
            $("#txt_fecha_sobre").val("");
        }

    });

    $(".modal_impresion").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
        },
        beforeClose: function () {

        }
    }); 

    function aplicarDatatable(idTabla) {
        $('#' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 20,
            "bLengthChange": false,
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }

});