$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');

    $('select').select2({placeholder: 'Seleccione una opción'});

    $("#slcCliente").select2({
        placeholder: "Buscar Cliente",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_contratos/procesos/get_clientes_servicio',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cliente,
                        'text': item.cliente_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });




    $(".soloNumeros").numeric();
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
                //minDate: 0
    });

    $(".btn-close").live('click', function () {

        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });


    var id_bod;
    var id_cat;
    var id_prod;

    $("#frm-servicio").validate({
        ignore: [],
        rules: {
            slcCliente: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#tbServicios .trServicio').length == 0) {
                crear_alerta('error', 'Servicios', 'Debe seleccionar al menos un servicio.');
                return false;
            }

            form.submit();
        }
    });


    //Calculo de la URL PATH

    var row = 0;
    if ($('#tbServicios .trServicio').length > 0) {
        row = $("#tbServicios .trServicio").length;
    }
    $("#btnAgregar").click(function () {

        var fechaContrato = $("#txtFechaContrato").val();
        var slcServicio = $("#slcServicio").val();
        var slcServicioTxt = $("#slcServicio option:selected").text();
        var slcPeriodo = $("#slcPeriodo").val();
        var slcPeriodoTxt = $("#slcPeriodo option:selected").text();

        if (fechaContrato == '' || slcServicio == '' || slcPeriodo == '') {
            crear_alerta('error', 'Servicios por cliente', 'Debe completar todos los campos. (Fecha de contrato, Servicio, Período de contrato)');
            return false;
        }

        if ($(".slcServicio option[value='" + slcServicio + "']:selected").length > 0) {
            crear_alerta('error', 'Servicios por cliente', 'El servicio ya fue ingresado.');
            return false;
        }

        var slcServicioHtml = getOpcionesSelect("slcServicio");
        var slcPeriodoHtml = getOpcionesSelect("slcPeriodo");

        slcServicioHtml = slcServicioHtml.replace(/"/g, "'");
        slcPeriodoHtml = slcPeriodoHtml.replace(/"/g, "'");

        var html = '';

        html += '<tr id="tr_' + row + '" class="trServicio" data-id="' + row + '">';

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + slcServicioTxt + '" readonly="readonly"/>';
        html += '<select id="slcServicio_' + row + '" data-id="' + row + '" name="servicios[]" style="display:none;" class="slcServicio select-edit">' + slcServicioHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtFechaContrato_' + row + '" name="fechasContrato[]" class="txtFechas text tables-input-show tables-input fechaContrato" value="' + fechaContrato + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + slcPeriodoTxt + '" readonly="readonly"/>';
        html += '<select id="slcPeriodo_' + row + '" data-id="' + row + '" name="periodoContratos[]" style="display:none;" class="select-edit">' + slcPeriodoHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<button type="button" class="btn btn-primary btn-mini btnGuardarProd" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;"><input type="hidden" value="6" id="txtest">Guardar</button>';
        html += '<button type="button" class="btn btn-primary btn-mini btnEditProd" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;"><input type="hidden" value="6" id="txtest">Editar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelProd" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
        html += '</td>';

        html += '</tr>';

        var oTable = $('#tblServicios').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbServicios").append(html);
        aplidarDataTable('#tblServicios');

        row = row + 1;        
        
        //$("#txtFechaContrato").val('');
        $("#slcServicio option:selected").removeAttr('selected');
        $("#slcServicio").select2({placeholder: "Seleccione una opción"});
        $("#slcPeriodo option:selected").removeAttr('selected');
        $("#slcPeriodo").select2({placeholder: "Seleccione una opción"});
    });//En of function agregar

    $(".btnEditProd").live('click', function () {
        var parent = $(this).parent().parent();

        $("#" + parent[0].id + " .select-text").hide();

        $("#" + parent[0].id + " .select-edit").select2({placeholder: "Seleccione una opción"});
        $("#" + parent[0].id + " .select2-container").css('width', '100%');
        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');

        $("#" + parent[0].id + " .txtFechas").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
                    //minDate: 0
        });

        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarProd").show();
    });

    //Guardar
    $(".btnGuardarProd").live('click', function () {
        var parent = $(this).parent().parent();

        var id_parent = $("#" + parent[0].id).data('id');

        var fechaContrato = $("#txtFechaContrato_" + id_parent).val();
        var slcServicio = $("#slcServicio_" + id_parent).val();
        var slcServicioTxt = $("#slcServicio_" + id_parent + " option:selected").text();
        var slcPeriodo = $("#slcPeriodo_" + id_parent).val();
        var slcPeriodoTxt = $("#slcPeriodo_" + id_parent + " option:selected").text();

        if (fechaContrato == '') {
            crear_alerta('error', 'Servicio por Cliente', 'Debe ingresar una fecha de contrato válida.');
            return false;
        }

        if (slcServicio == '') {
            crear_alerta('error', 'Servicio por Cliente', 'Debe ingresar un servicio.');
            return false;
        }

        var existe = 0;
        $("#tbServicios > tr").each(function () {
            var dataId = $(this).attr('data-id');
            var slcServicioExistentes = $(this).find('.slcServicio').val();
            if (id_parent != dataId) {
                if (slcServicioExistentes == slcServicio) {
                    existe = 1;
                }
            }
        });

        if (existe > 0) {
            crear_alerta('error', 'Servicios por cliente', 'El servicio ya fue ingresado.');
            return false;
        }

        if (slcPeriodo == '') {
            crear_alerta('error', 'Servicio por Cliente', 'Debe ingresar el período del contrato.');
            return false;
        }

        $("#" + parent[0].id + " .select-edit").each(function () {
            var select_id = $(this).attr('id');
            var valor = $("#" + select_id).val();
            var text = $("#" + select_id + " option:selected").text();
            if (valor != '') {
                $("#" + select_id).prev().val(text);
            } else {
                $("#" + select_id).prev().val('');
            }
            $("#" + select_id).prev().show();
        });

        $("#" + parent[0].id + " .select-edit").select2('destroy');
        $("#" + parent[0].id + " .select-edit").hide();


        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');
        $(this).hide();
        $("#" + parent[0].id + " .btnEditProd").show();

    });


    //Eliminar Producto
    $(".btnDelProd").live("click", function () {
        var parent = $(this).parent().parent();

        var oTable = $('#tblPlanes').dataTable();

        oTable.fnDeleteRow(parent[0]);
    });
});

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        //console.log($(this).attr('selected'));
        //console.log(this);
        opciones += this.outerHTML;
    });

    return opciones;
}

function cerrar_modal() {
    //alert('asdasd');
    jQuery.fancybox.close();
}

function aplidarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": true,
        "bInfo": false,
        "bSort": false,
        "bLengthChange": false,
        "bFilter": false
    });
}
