$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');

    $('select').select2({placeholder: 'Seleccione una opción'});

    $(".soloNumeros").numeric();
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#slc_cliente").select2({
        placeholder:'Buscar clientes',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'modulo_contratos/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente,
                    evaluar_plan:true
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo+" - "+item.nombre,
                    });
                });
                return {
                    results: myResults
                };
		    } 
        }
    });  

    $("#txtFechaInicio").change(function (){
        if ( $(this).val().substr(0,2) != "01" ){
            var fecha = $(this).val().substr(2);
            $(this).val("01"+fecha);
            crear_alerta('info', 'Fecha de corte inical', "La fecha inicio debe ser el primero de cada mes.");
        } 

        var facha_inicio    = $(this).val();
        var fecha_array     = facha_inicio.split('-');
        var date            = new Date(fecha_array[1]+"-"+fecha_array[0]+"-"+fecha_array[2]);
        var ultimoDia       = new Date(date.getFullYear(), date.getMonth() + 1, 0);
     
        var dia     = ultimoDia.getDate();
        var mes     = ultimoDia.getMonth() + 1;
        var year    = ultimoDia.getFullYear();
        var hasta   = ('00' + dia).slice(-2) + "-" + ('00' + mes).slice(-2) + "-" + year; 
        
        $("#txtFechaFin").val(hasta);

        var meses   = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
        $("#txtFechaFactura").val($(this).val());
        $("#txt_periodo").val(meses[ultimoDia.getMonth()] + "-" + year);      
    });

    $(".btn-close").live('click', function () {
        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    $("#frm-servicio").validate({
        ignore: [],
        rules: {
            slcCliente: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#tbServicios .trServicio').length == 0) {
                crear_alerta('error', 'Servicios', 'Debe seleccionar al menos un servicio.');
                return false;
            }

            form.submit();
        }
    });

    $("#slcServicio").change(function () {
        var servicio = $(this).val();
        if (servicio > 0) {

            $.ajax({
                url: window.gSateliteWhite.baseUrl('modulo_contratos/procesos/get_planes_servicio'),
                data: {servicio: servicio},
                type: "post",
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $("#slcPlanes").html(result);
                    $("#slcPlanes").select2({placeholder: "Seleccione una opción"});
                }
            });
        } else {
            $("#slcPlanes").html('');
            $("#slcPlanes").select2({placeholder: "Seleccione una opción"});
        }
    });

    $("#btnProcesar").click(function () {
        var fechaInicio         = $("#txtFechaInicio").val();
        var fechaFin            = $("#txtFechaFin").val();
        var fechaFactura        = $("#txtFechaFactura").val();
        var slcServicio         = ($("#slcServicio").val() > 0)?$("#slcServicio").val():'';
        var slcPlanes           = ($("#slcPlanes").val() > 0)?$("#slcPlanes").val():'';
        var slcTipoFactura      = ($("#slcTipoFactura").val() > 0)?$("#slcTipoFactura").val():'';
        var nombreTipoFactura   = ($("#slcTipoFactura option:selected").text() != "")?$("#slcTipoFactura option:selected").text():"";
        var periodo             = $("#txt_periodo").val();
        var slc_cliente         = $("#slc_cliente").val();
        var regla_cuotas        = $("#txt_regla_cuotas").val();
       

        if (fechaInicio == '') {
            $("#txtFechaInicio").focus();
            crear_alerta('error', 'Aviso', 'Favor ingrese una fecha de corte inicial.');
            return false;
        }

        if ( fechaFin == '' ) {
            $("#txtFechaFin").focus();
            crear_alerta('error', 'Aviso', 'Favor ingrese una fecha de corte final.');
            return false;
        }

        if (fechaFactura == '') {
            $("#fechaFactura").focus();
            crear_alerta('error', 'Aviso', 'Favor ingrese una fecha de factura');
            return false;
        }

        if (slcServicio == '') {
            crear_alerta('error', 'Aviso', 'Favor seleccione un servicio');
            return false;
        }

        if (slcTipoFactura == '') {
            crear_alerta('error', 'Aviso', 'Favor seleccione un tipo de factura');
            return false;
        }

        if (regla_cuotas == 0 && slc_cliente == "") {
            crear_alerta('error', 'Aviso', 'Seleccione un cliente o habilite regla validación de 90 días ( Quitar regla de validación aplicara solo para un cliente).');
            return false;
        }

        if (!validarPeriodo(fechaInicio, fechaFin)) {
            crear_alerta('info', 'Aviso', 'Verifique el período seleccionado.');
            return false;
        }



        $(".btn_autorizar").css("display", "none");
        $(".btn_impresion").css("display", "none");

        $.ajax({
            url: window.gSateliteWhite.baseUrl('modulo_contratos/procesos/procesar_facturas'),
            data: {
                fecha_inicio: fechaInicio,
                fecha_fin:fechaFin,
                fecha_factura:fechaFactura,
                servicio:slcServicio,
                plan:slcPlanes,
                tipo_factura:slcTipoFactura,
                nombreTipoFactura:nombreTipoFactura,
                periodo:periodo,
                slc_cliente:slc_cliente,
                regla_cuotas:regla_cuotas
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                if (obj.resultado == 1) {
                    $("#dv_contenedor_clientes").html(obj.html);
                    $("#dv_contenedor_clientes").show("slide", {
                      direction: 'left'
                    }, 500);
                    $(".btn_autorizar").css("display", "block");
                } else {
                    //$("#slcTipoFactura option").removeAttr("selected");
                    //$('#slcTipoFactura').select2({placeholder: "Seleccione una opción"});
                   // $("#slcTipoFactura").select2("{placeholder:Seleccione una opción}");
                    $(".btn_autorizar").css("display", "none");
                    $(".btn_impresion").css("display", "none");
                    $("#dv_contenedor_clientes").html("");
                    $("#dv_contenedor_clientes").show("slide", {
                      direction: 'left'
                    }, 500);
                    crear_alerta('info', 'Procesamiento de facturas', obj.mensaje);
                }
                wait.close();
            }
        });
    });

    $("#btn_autorizar").click(function () {
        $('#tbl_clientes').dataTable().fnDestroy();
        var form = $('#form_factura');
        $.ajax({
                type: "POST",
                url: form.attr( 'action' ),
                data: form.serialize(),
                beforeSend: function () {
                wait.start();
            },
                success: function( response ) {
                $(".btn_autorizar").css("display", "none");
                $(".btn_impresion").css("display", "block");
                var obj = jQuery.parseJSON(response);
                $("#dv_contenedor_clientes").html(obj.html);
                $("#dv_contenedor_clientes").show("slide", {
                    direction: 'left'
            }, 500);
            wait.close();
            }
        });
    });


    $("#imprimir_modal").click(function(){
        event.preventDefault();

        var error = false;

        if ( $("#txt_correlativo_inicial").val() == "" ) {
            crear_alerta("error","Alerta",'El campo "desde" es obligatorio.');
            $("#txt_correlativo_inicial").focus();
            error = true;
            return false;
        }

        if ( $("#txt_correlativo_final").val() == "") {
            crear_alerta("error","Alerta",'El campo "hasta" es obligatorio.');
            $("#txt_correlativo_final").focus();
            error = true;
            return false;
        }

        if ( error == false ) {
            var correlativo_inicial = parseInt($("#txt_correlativo_inicial").val());
            var correlativo_final = parseInt($("#txt_correlativo_final").val());

            if ( correlativo_inicial < $("#txt_correlativo_inicial_fac").val() ) {
                crear_alerta("error","Alerta",'El campo "hasta" debe estar entre ' + $("#txt_correlativo_inicial_fac").val() + ' y ' + $("#txt_correlativo_final_fac").val() + '.');
                $("#txt_correlativo_inicial").focus();
                error = true;
                return false;
            }
    
            if ( correlativo_final > $("#txt_correlativo_final_fac").val() ) {
                crear_alerta("error","Alerta",'El campo "hasta" debe estar entre ' + $("#txt_correlativo_inicial_fac").val() + ' y ' + $("#txt_correlativo_final_fac").val() + '.');
                $("#txt_correlativo_final").focus();
                error = true;
                return false;
            }
    
            if ( correlativo_inicial > correlativo_final ) {
                crear_alerta("error","Alerta",'El campo "hasta" debe ser mayor al campo final.');
                $("#txt_correlativo_final").focus();
                error = true;
                return false;
            }
    
            if ( (correlativo_final - correlativo_inicial) > 100 ) {
                crear_alerta("info","Alerta",'No se pueden imprimir mas de 100 facturas.');
                error = true;
                return false;
            }
    
            if ( error == false ) {
                var factura_inicial =  $("#txt_factura_inicial").val();
                var factura_final   =  $("#txt_factura_final").val(); 
                var facturas_in     =  $("#txt_facturas_todas").val(); 

                $("#txt_factura_ini").val(factura_inicial);
                $("#txt_factura_fin").val(factura_final);
                $("#txt_facturas_in").val(facturas_in);
                
                $("#frm_impresion_masiva").submit();
                $("#txt_correlativo_inicial").val("");
                $("#txt_correlativo_final").val("");

            }
        }
    });


    $(".modal_impresion").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
        },
        beforeClose: function () {

        }
    }); 

    $("#cancelar_modal").click(function (){
        $("#txt_correlativo_inicial").val("");
        $("#txt_correlativo_final").val("");
    });


    $("#btn_impresion_modal").click(function (){
        var inicio  = $("#txt_correlativo_inicial_fac").val();
        var fin     = $("#txt_correlativo_final_fac").val();
        $("#span_impresion").text("Impresión: (" +inicio + "-" + fin +")");
    });

    $(".rango_impresion").keyup(function(){
        var inicio          = ($("#txt_correlativo_inicial").val());
        var fin             = ($("#txt_correlativo_final").val());

        var rango_inicio    = $("#txt_correlativo_inicial_fac").val();
        var rango_fin       = $("#txt_correlativo_final_fac").val();

        if (inicio == ""){
            inicio = 0;
        }

        if (fin == ""){
            fin = 0;
        }

        if ( parseInt(inicio) == 0 || parseInt(fin) == 0){ 
            var total   = 0;
        } else {
            var total   = ( parseInt(fin) - parseInt(inicio) + 1  );
        }

        $("#span_impresion").text("Impresión: " + total + " (" + rango_inicio + "-" + rango_fin + ")");
        
    });

    $("#chk_regla_cuotas").change( function() {
        if ($(this).is(":checked") === true) {
            $("#txt_regla_cuotas").val("1");
        } else {
            $("#txt_regla_cuotas").val("0");
        }
    });

    $("#slc_cliente").change( function() {
        if ( $(this).val() != "" ) {
            get_servicio_cliente( $(this).val() );
        } 
    });

    function get_servicio_cliente( cliente ){
        $.ajax({
            url: window.gSateliteWhite.baseUrl('modulo_contratos/procesos/get_servicio_cliente'),
            data: {cliente: cliente},
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                wait.close();
                if (result != ""){
                    var codigo = parseInt(result);
                    $("#slcServicio").val(codigo);
                    $("#slcServicio").select2();
                }
            }
        });
    }
    

});

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        opciones += this.outerHTML;
    });

    return opciones;
}

function cerrar_modal() {
    jQuery.fancybox.close();
    $("#txt_correlativo_inicial").val("");
    $("#txt_correlativo_final").val("");
}