$(document).ready(function () {
    $("select").select2();

    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    //Cargar Planes segun Servicio
    $("#slcServicio").change(function () {
        var servicio = $(this).val();
        if (servicio > 0) {
            $.ajax({
                url: window.gSateliteWhite.baseUrl('modulo_contratos/procesos/get_planes_servicio'),
                data: {servicio: servicio},
                type: "post",
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $("#slcPlanes").html(result);
                    $("#slcPlanes").select2({placeholder: "Seleccione una opción"});
                }
            });
        } else {
            $("#slcPlanes").html('');
            $("#slcPlanes").select2({placeholder: "Seleccione una opción"});
        }
    });
    
    //Boton Consultar
    $("#btn_consultar").click(function(){
        var fechaInicio_corte   = $("#txt_fecha_corte_inicio").val();
        var fechaFin_corte      = $("#txt_fecha_corte_fin").val();
        var slcServicio     = ($("#slcServicio").val() > 0) ? $("#slcServicio").val() : '';
        var slcPlanes       = ($("#slcPlanes").val() > 0) ? $("#slcServicio").val() : '';
        var slcTipoFactura  = ($("#slcTipoFactura").val() > 0) ? $("#slcTipoFactura").val() : '';
        var respuesta = false;
        if (fechaInicio_corte == "" && fechaFin_corte == ""){
            crear_alerta('error', 'Aviso', 'Favor seleccione al menos un periodo.');
            return false;
        }
        if (fechaInicio_corte != ''){  
            if(fechaFin_corte == ''){
                crear_alerta('error', 'Aviso', 'Favor ingrese fecha fin de fecha corte');
                return false;
            }
            respuesta = validar_fechas(fechaInicio_corte,fechaFin_corte,"corte");
            if(respuesta == false) {
                return false;
            }
        }
        if(fechaFin_corte != ''){
            if( fechaInicio_corte == ''){
                crear_alerta('error', 'Aviso', 'Favor ingrese fecha inicio de corte');
                return false;
            }
            respuesta = validar_fechas(fechaInicio_corte,fechaFin_corte,"corte");
            if(respuesta == false){
                return false;
            }
        }    
        $.ajax({
            url: window.gSateliteWhite.baseUrl('modulo_contratos/procesos/anulacion_facturas'),
            type: "post",
            data: {
                servicio: slcServicio,
                plan: slcPlanes,
                tipo_factura: slcTipoFactura,
                fecha_inicio_corte: fechaInicio_corte,
                fecha_fin_corte: fechaFin_corte
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor_clientes").html(obj.html);
                $("#dv_contenedor_clientes").show("slide", {
                    direction: 'left'
                }, 500);
                $("#btn_anular_masivo").css("display", "block");
                wait.close();
            }
        });  
    });    

    function validar_fechas(fecha_ini, fecha_fin, mensaje){
        var result = true;
        if(fecha_ini == ''){
            crear_alerta('error', 'Aviso', 'Favor ingrese una fecha de '+mensaje+' inicial.');
            result = false;
        }
        if(fecha_fin == ''){
            crear_alerta('error', 'Aviso', 'Favor ingrese una fecha de '+mensaje+' final.');
            result = false;
        }
        if(!validarPeriodo(fecha_ini, fecha_fin)) {
            crear_alerta('info', 'Aviso', 'Verifique el período seleccionado.');
            result = false;
        }
        return result;
    }

    $(document).on("click",".ver",function(){
        var factura = $(this).attr("id");
        var numero_factura = $(this).data("numero"); 
        cargar_detalle( factura,numero_factura );
    });

    $(document).on("click",".anular",function(){
        var factura = $(this).attr("id");
        var numero_factura = $(this).data("numero"); 
        $("#titulo_anular").html("Anular factura "+numero_factura);
        $("#txt_factura_inicio").val(factura);
    });

    $(".ver").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
        },
        beforeClose: function () {
        }
    }); 

    $(".anular").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
        },
        beforeClose: function () {
        }
    }); 

    $(".anulacion_masiva").fancybox({
        width: '60%',
        height: 'auto',
        autoSize: false,
        'closeBtn': false,
        closeClick: false,
        type: 'inline',
        helpers: {
            overlay: {closeClick: false} // prevents closing when clicking OUTSIDE fancybox 
        },
        beforeLoad: function () {
        },
        beforeClose: function () {
        }
    }); 

    function cerrar_modal() {
        jQuery.fancybox.close();
    }

    //Al dar click en "Seleccionar Todos"
    $(document).on('click', '#checkh', function(){
        if($(this).is(":checked")){
            $(".chkAnular").each(function() {
                var id = $(this).data('id');
                $("#chkAnular_" + id).prop('checked', true);
                $("#anular_" + id).val(1);
            });
        } else {
            $(".chkAnular").each(function() {
                var id = $(this).data('id');
                $("#chkAnular_" + id).prop('checked', false);
                $("#anular_" + id).val(0);
            });
        }
    }); 

    //Click en cada checkbox
    $(document).on('click', '.chkAnular', function(){
        var id = $(this).data('id');
        if($(this).is(":checked")){
            $("#anular_" + id).val(1);
        } else {
            $("#anular_" + id).val(0);
        }
    }); 

    function cargar_detalle( ver_detalle_factura,numero_factura ){
        $.ajax({
            url: window.gSateliteWhite.baseUrl('modulo_contratos/procesos/ver_detalle_factura'),
            data: {
                ver_detalle_factura: ver_detalle_factura   
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                $("#titulo_detalle").html("Detale de factura "+numero_factura);
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor_detalles").html(obj.html);
                wait.close();
            }
        });
    }

    $("#anular_modal").click(function(){
        event.preventDefault();
        if ( $("#txt_mensaje").val() != "" ) {
            var descripcion     = $("#txt_mensaje").val();
            var factura_inicio  = [$("#txt_factura_inicio").val()];
            $.ajax({
                url: window.gSateliteWhite.baseUrl('modulo_contratos/procesos/anular_factura'),
                type: "post",
                data: {
                    descripcion: descripcion,
                    factura_inicio: factura_inicio,
                    ajax: 1
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    cerrar_modal();
                    $("#txt_mensaje").text("");
                    $("#tr_"+factura_inicio).remove();
                    crear_alerta('success', 'Anulación  de facturas', 'La anulación se llevo acabo con éxito.');  
                    wait.close();
                }
            });
        }else{
            crear_alerta('error', 'Aviso', 'Favor agregue una descripción.');            
        }
    });

    $(document).on("click","#cancelar_anular_modal",function(){
        $("#descripcion").val('');
        $("#txt_mensaje_anulacion").val('');
        $.fancybox.close();
    });

    $("#btn_anular_masivo").click(function(){
        if ($('#tbl_facturas >tbody .tr_facturas').length > 0){
            $( "#btn_anulacion_masiva" ).trigger( "click" );
        } else {
            crear_alerta('info', 'Aviso', 'No se encontraron datos.');   
        }
    });

    $("#anular_masivo_modal").click(function(){
        var validas = 0;
        $(".se_anula").each(function() {
            var valor = $(this).val();
            validas = validas + parseInt(valor);
        });        
        if (parseInt(validas) > 0) {
            if ($("#txt_mensaje_anulacion").val() != "" ) {
                $("#descripcion").val($("#txt_mensaje_anulacion").val());
                var oTabla = $("#tbl_facturas").dataTable();
                oTabla.fnDestroy();
                wait.start();
                $("#form_factura").submit();
            } else {
                crear_alerta('error', 'Aviso', 'Favor agregue una descripción.');
            }
        } else {
            crear_alerta('error', 'Aviso', 'Debe seleccionar al menos una factura.');
            $.fancybox.close();
        }
    });

    //Para mostrar detalles de la factura
    $("a").click(function() {
        $(".linker2").fancybox({
            'width'  : 900, 
            'onStart': function() { 
                $("#divform2").css("display","block"); 
            },            
            'onClosed': function() { 
                $("#divform2").css("display","none"); 
            }
        });
    }); 

    // //Inicializador de fancy box
    $(function(){
        $(".linker2").fancybox({
            'width'  : 900,  
            'onStart': function() { 
                $("#divform2").css("display","block"); 
            },            
            'onClosed': function() { 
                $("#divform2").css("display","none"); 
            }
        });
    });

}); //End Document Ready

//Para mostrar detalle de cada factura
function clicker2(id2) {
    var contenido='';
    var jqXHR = $.ajax({
        dataType    : 'json',
        type        : "POST",
        cache       : false,
        url         : window.gSateliteWhite.baseUrl('facturacion/consultas/anular_factura'),
        data        : {factura:id2},
        success     : function(data) {
            $("#divform2").empty();
            $("#divform2").append(data.resultado);
            mostrar_fancy_box(); 
            $('#boton_anular').hide();
            $('#anular_form').hide();
        }
    }).done(function() { 
        $("#divform2").append(contenido);
    }).fail(function(jqXHR, textStatus){
    });; 
}

function mostrar_fancy_box(valor){
    $.fancybox( $("#divform2" + valor).html(), {
        'width'  : 900,
        'onStart': function() { 
            $("#divform2"+valor).css("display","block"); 
        },   
        'onClosed': function() { 
            $("#divform2"+valor).css("display","none"); 
        }
    });    
}

// });
/*CODIGO OBSOLETO*/

// $(".txtFechas").datepicker('destroy');

/*BOTON CONSULTAR*/
// if ( fechaInicio  == "" && fechaFin == "" && fechaInicio_corte == "" && fechaFin_corte == "" && slcServicio == "" && slcPlanes == "" && slcTipoFactura == "" ) {
        //     crear_alerta('error', 'Aviso', 'Favor ingrese al menos un campo.');
        //     return false;
        // }        
        // if (fechaInicio != '') {
            // if ( fechaFin == '') {
            //     crear_alerta('error', 'Aviso', 'Favor ingrese fecha fin de facturación');
            //     return false;
            // }
            // if ( fechaInicio_corte != "" || fechaFin_corte != "") {
            //     crear_alerta('error', 'Aviso', 'La búsqueda debe ser solo por fecha Corte o fecha de facturación');
            //     $("#txt_fecha_corte_inicio").val("");
            //     $("#txt_fecha_corte_fin").val("");
            //     return false;
            // } 
            // respuesta = validar_fechas(fechaInicio,fechaFin,"facturación");
            // if ( respuesta == false ) {
            //     return false;
            // }
        // }
        // if (fechaFin != '') {
            // if ( fechaInicio == '') {
            //     crear_alerta('error', 'Aviso', 'Favor ingrese fecha inicial de facturación');
            //     return false;
            // }
            // if ( fechaInicio_corte != "" || fechaFin_corte != "") {
            //     crear_alerta('error', 'Aviso', 'La búsqueda debe ser solo por fecha Corte o fecha de facturación');
            //     $("#txt_fecha_corte_inicio").val("");
            //     $("#txt_fecha_corte_fin").val("");
            //     return false;
            // } 
            // respuesta = validar_fechas(fechaInicio,fechaFin,"facturación");
            // if ( respuesta == false ) {
            //     return false;
            // }
        // }
        // if ( fechaInicio != "" || fechaFin != "") {
            //     crear_alerta('error', 'Aviso', 'La búsqueda debe ser solo por fecha corte o fecha de facturación');
            //     $("#txtFechaInicio").val("");
            //     $("#txtFechaFin").val("");
            //     return false;
            // } 
            // if ( fechaInicio != "" || fechaFin != "") {
            //     crear_alerta('error', 'Aviso', 'La búsqueda debe ser solo por fecha Corte o fecha de facturación');
            //     $("#txtFechaInicio").val("");
            //     $("#txtFechaFin").val("");
            //     return false;
            // } 