$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');

    $("#tipo").select2({placeholder: 'Seleccione una opción'});
    $("#estado").select2({placeholder: 'Seleccione una opción'});
    $("#costo").numeric();

    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
   

    $('#form_cliente').validate({
        ignore: [],
        rules: {
            fecha_desde: {required: true},
            nombre: {required: true},
            costo: {required: true, min: 1},
            tipo: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ( $('#tipo').val() == 2 && $("#fecha_hasta").val() == '' ){
                crear_alerta('error', 'Planes', 'La promociones necesitan un afecha límite.');
                $("#fecha_hasta").focus();
                return false;
            }
            
            if ( $("#fecha_hasta").val() != '') {
                if ( !validarPeriodo($("#fecha_desde").val(), $("#fecha_hasta").val()) ) {
                    crear_alerta('error', 'Planes', 'Verifique el período de las fechas.');
                    return false;
                }
            }


            form.submit();
        }
    });

});
