$(document).ready(function(){

	$("#slccategoria").select2({
        placeholder:'Buscar categoría',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'registro_academico/mantenimientos/consultar_categoria',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (categoria) {
              return {
                  categoria: categoria
              };
            },
            results: function (data) {
              var myResults = [];
              $.each(data, function (index, item) {
                  myResults.push({
                      'id': item.tia_id,
                      'text': (item.tia_codigo+' - '+item.tia_nombre)
                  });
              });
              return {
                  results: myResults
              };
              $('#slccategoria_error').text('');
          } 
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });


    function validar_campos() {
      var error = false;
      if ( $("#txt_nombre").val() == "" ) {
         $("#txt_nombre_error").text();
         error = true;
      }

      if ( $("#slccategoria").val() == "" ) {
        $("#slccategoria_error").text();
        error = true;
      }

      if ( $("#txt_costo").val() == "" ) {
        $("#txt_costo_error").text();
        error = true;
      }

      if ( error == false ) {
          verificar(1);
      }
    }

    $("#txt_nombre").focusout(function() {
      if( $(this).val() != "" ) {
        verificar(0);
      }
    });

    $(".enviar").click(function() {
      validar_campos();
    });


    function verificar(enviar) {
        var nombre = $("#txt_nombre").val();
        var cargo = $("#txt_cargo").val();
        $.ajax({
              dataType: 'json',
              type: 'POST',
              url: urlj+'modulo_contratos/catalogos/verificar_cargo',
              data: {nombre:nombre, cargo: cargo},
              success: function(data){
              if(data.length > 0){
                  crear_alerta('error', 'Nombre único', 'El nombre del cargo ya fue creado.');
                  $("#txt_nombre").val('');
              }else{
                  if (enviar == 1){
                    $("#form_cargo").submit();
                  }
              }
          }
      });
    }

});