var pathArray = window.location.pathname.split( '/' );
var urlj = url_base_proyecto;
$(document).ready(function(){
    $("#acciones").hide();
    $(".fecha_ptda").datepicker({
        dateFormat: 'dd-mm-yy',
        changeMonth: true,
        changeYear: true
    });
    $(".fecha_ptda").mask("99-99-9999");
    $(".fecha_ptda").attr('placeholder',"dd-mm-yyyy");

    $("select").select2();

    $(document).on('change', '#txt_fecha_inicio, #txt_fecha_fin', function () {
        if ($("#txt_fecha_inicio").val() != '' && $("#txt_fecha_fin").val() !='') {
            verifica_fecha($("#txt_fecha_inicio").val(), $("#txt_fecha_fin").val());
        }
    });

    $("#buscar").click(function(event) {
        $("#acciones").hide();
        var fecha_ini = $("#txt_fecha_inicio").val();
        var fecha_fin = $("#txt_fecha_fin").val();
        var tipo = $("#slc_tipo").val();
        var proceso_partida = $("#slc_proceso_partida").val();
        var procesos = ($.isArray(proceso_partida)) ? proceso_partida.toString() : "";
        if (fecha_ini != "" && fecha_fin != "") {
            if (verifica_fecha(fecha_ini, fecha_fin)) {
                $.ajax({
                    url: urlj + 'modulo_contabilidad/reportes/lista_partidas_defecto/1',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        fecha_ini:  fecha_ini, 
                        fecha_fin: fecha_fin, 
                        tipo: tipo,
                        tipo_rep: "",
                        proceso_partida: procesos
                    },
                    beforeSend: function() {
                        wait.start();
                    },
                    success: function(data) {
                        console.log(data);
                        $("#datagried").html(data.tabla);
                        if (data.filas > 0) {
                            $("#tipo").val(tipo);
                            $("#fecha_ini").val(fecha_ini);
                            $("#fecha_fin").val(fecha_fin);
                            $("#proceso_partida").val(procesos);
                            $("#acciones").show();
                        }
                        wait.close();
                    }
              });
          }
        } else {
            crear_alerta("error", "Atención", "Ambas fechas son requeridas");
            return false;
        }
    });

}); // END jQuery

function verifica_fecha(fecha_ini, fecha_fin){
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if(Date.parse(fecha_i) > Date.parse(fecha_f)){
        crear_alerta("error", "Atención", "Verifique las fechas del período");
        return false;
    } else {
        return true;
    }
}

 
