var meses = {'Enero': '01','Febrero': '02','Marzo': '03','Abril': '04','Mayo': '05','Junio': '06','Julio': '07','Agosto': '08','Septiembre': '09','Octubre': '10','Noviembre': '11','Diciembre': '12'};    
var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;

$(document).ready(function(){
    $("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
    $("#pdf, #export_excel").hide();
    $("#slc_centro_costo").select2();

    $("#slc_centro_costo").change(function(event) { 
        if ( $(this).val() != "") { 
          var txt_centro_costo = $("#slc_centro_costo option:selected").text();
          $("#txt_centro_costo").val(txt_centro_costo);
        } else {
          $("#txt_centro_costo").val("");
        }
      });

    $("#buscar").click(function(event) {
        var fecha_ini ='';
        var fecha_fin ='';
        if ($("#a_detalle").val() == 2) {
            var fecha_txt = $("#month_date").val();
            if(fecha_txt == '') {
                crear_alerta('error', 'Atención', 'Verifique los campos requeridos.');
                return false;
            }
            var fecha = fecha_txt.split('-');
            var mes = meses[fecha[0]];
            var ultimo = ult_dia(mes,fecha[1]);
            fecha_ini = fecha[1] + '-' + mes + '-01';
            fecha_fin = fecha[1] + '-' + mes + '-' + ultimo;
            $('#fecha_inicio').val(fecha_ini);
            $('#fecha_fin').val(fecha_fin);
        } else {
            if ($("#fecha_inicio").val() == '' || $("#fecha_fin").val() == '') {
                crear_alerta('error', 'Error', 'Debe completar los filtros de búsqueda');
                return false;
            } 
            fecha_ini = $("#fecha_inicio").val();
            fecha_fin = $("#fecha_fin").val();
        }
        if (fecha_ini != '' && fecha_fin != '') {
            var slc_centro_costo= $("#slc_centro_costo").val();
            var txt_centro_costo= $("#slc_centro_costo option:selected").text();
            verifica_fecha(fecha_ini, fecha_fin);
            if($("#fecha_fin_error").text()==''){
                wait.start();
                $.ajax({
                    url: 'consultar_libro_mayor',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        fecha_ini:  fecha_ini, 
                        fecha_fin: fecha_fin, 
                        a_detalle:$("#a_detalle").val(),
                        slc_centro_costo:slc_centro_costo,
                        txt_centro_costo:txt_centro_costo
                    },                        
                    success: function(json){
                        wait.close();
                        $('#carga_datos').html(json.html);
                        $("#libro_mayor").show('slide');
                        if(Number(json.respuesta)==1){
                            $('#pdf, #export_excel').hide();
                        }else{
                            $('#pdf, #export_excel').show();
                        }
                    }
                });
            }
        } else {
            crear_alerta('error', 'Error', 'Debe completar los filtros de búsqueda');
        }
    });

    function verifica_fecha(fecha_ini, fecha_fin){
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
            $("#fecha_fin").addClass('error');
            $("#fecha_fin_error").text("Verifique las fechas del período");
            return false;
        }

        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
            $("#fecha_fin").removeClass('error');
            $("#fecha_fin_error").text('');
            return true;
        }
    }

    function ult_dia(mes, anio) {
    if (mes.charAt(0) == '0') {
        mes = mes.charAt(1);
    }
    mes = parseInt(mes);
    anio = parseInt(anio);
    switch (mes) {
        case 1 : case 3 : case 5 : case 7 : case 8 : case 10 : case 12 : return 31;
        case 2 : return (anio % 4 == 0) ? 29 : 28;
    }
    return 30;
}

}); // END jQuery

 
