var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;

$(document).ready(function(){

    $(".datepicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("body").on("change", "#fecha_inicio, #fecha_fin", function(){
        var valor = $(this).val();
        if($.trim(valor) != ''){
            validar_fecha_inicio_fin('fecha_inicio', 'fecha_fin', 'Verifique las fechas del período');
        }
    })

    $('#btn_consultar').click(function() {
        $("#print_actions").css('display','none');
        var fecha_ini = $("#fecha_inicio").val();
        var fecha_fin = $("#fecha_fin").val();
        if (fecha_ini != '' && fecha_fin != '') {
            validar_fecha_inicio_fin('fecha_inicio', 'fecha_fin', 'Verifique las fechas del período');
            $.ajax({
                dataType: 'text',
                type: 'POST',
                url: urlj + 'modulo_contabilidad/reportes/reporte_centro_costos/1',
                data: {
                    fecha_ini: fecha_ini,
                    fecha_fin: fecha_fin,
                    tipo_reporte: ''
                },
                beforeSend: function() {
                    wait.start();
                },
                success: function(data){
                    var oTabla = $("#tblListado").dataTable();                       
                    oTabla.fnDestroy();
                    $("#dv_contenedor_listado").html(data);
                    aplidarDataTable('tblListado');
                    $("#hdn_fe_ini").val(fecha_ini);
                    $("#hdn_fe_fin").val(fecha_fin);
                    $("#print_actions").css('display','');
                    wait.close();
                }
            });
        } else {
            crear_alerta('error','Alerta','Ambas fechas son Requeridas');
            return false;
        }            
    });

}); // END jQuery


function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "aaSorting": [],
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}