$(document).ready(function () {
    $('select').select2();

    $(".calendario").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'dd-mm-yy',
    });
    $(".calendario").mask("99-99-9999");
    
    $("#btnConsultar").click(function() {
        var tem_slcTipoFacturatext = '';
        var tem_slcSerieFacturatext = '';
        var periodo         = $("#txt_periodo").val(); 
        var periodoHasta    = $("#txt_periodo_hasta").val();
        var tipofactura     = $("#slcTipoFactura").val();//ids                           
        var seriefactura    = $("#slcSerieFactura").val();//ids   
        var idsucursal      = $("#slcSucursal").val();                    
        var idsucursaltext  = $("#slcSucursal option:selected").text();

        $("#hperiodo").val(periodo);
        $("#hperiodo_hasta").val(periodoHasta);
        $("#hslcTipoFactura").val(tipofactura);
        $("#slcTipoFactura option").each(function (key, value) {
            if($(this).is(':selected')){                    
                if(key ==1){
                    tem_slcTipoFacturatext += $(this).html();    
                }else{
                    tem_slcTipoFacturatext += ' , ' + $(this).html();    
                }
                
            }
        })
        $('#hslcTipoFacturatext').val(tem_slcTipoFacturatext);        
        $("#hslcSerieFactura").val(seriefactura);
        $("#slcSerieFactura option").each(function (key, value) {
            if($(this).is(':selected')){                
                    if(key == 1){
                        tem_slcSerieFacturatext += $(this).html();
                    }else{
                        tem_slcSerieFacturatext += ' , ' + $(this).html();    
                    }
                
            }
        })
        $('#hslcSerieFacturatext').val(tem_slcSerieFacturatext);
        $('#hslcSucursal').val(idsucursal);                        
        $('#hslcSucursaltext').val(idsucursaltext);                        
        
        if(periodo != '' && periodoHasta != ''){
            if (!verifica_fecha(periodo,periodoHasta)) {
                return false;
            }
            $.ajax({
              dataType: 'text',
              type: 'POST',          
              url: urlj + 'modulo_contabilidad/reportes/reporte_libro_ventas_al_contribuyente/1',
              data: {periodo: periodo, hasta: periodoHasta, idstipofactura : tipofactura, idsseriefactura : seriefactura, idsucursal: idsucursal},
              beforeSend: function () {
                wait.start();
              },
              success: function (data) {
                //var oTable = $('#tblListado').dataTable();
                //oTable.fnDestroy();
                $("#dv_contenedor_listado").html(data);
                aplidarDataTable('tblListado');

                $("#csv").css("display", "");
                $("#pdf").css("display", "");
                $("#excel").css("display", "");                
                wait.close();            
              }                       
            });
        }else{            
            crear_alerta('error', 'Campos requeridos', 'Período es requerido.');
        }                
    });
        
    //Aplicar estilo a los select a algunos tab de ficha general
    $("#slcTipoFactura, #slcSerieFactura").select2();    
    
    $("#slcTipoFactura").change(function() {
        var idtipofactura = $('#slcTipoFactura').val();

        
        if(idtipofactura){
            $.ajax({
                dataType: 'text',
                type: 'POST',          
                url: urlj + 'modulo_contabilidad/reportes/ajax_serie_factura',
                data: {idtipofactura: idtipofactura},
                beforeSend: function () {
                wait.start();
                },
                success: function (data) {                
                $('#slcSerieFactura').html(data);
                wait.close();            
                }
            });
        }else{
            $('#slcSerieFactura').html('');
            $('#slcSerieFactura').select2('destroy');
            $('#slcSerieFactura').select2();
        }
    });

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "aaSorting": [],
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin){
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if(Date.parse(fecha_i) > Date.parse(fecha_f)){
        crear_alerta('error', 'Atención', 'Verifique las fechas del período');
        return false;
    } else {
        return true;
    }
}