$(document).ready(function () {
    $('select').select2();
    
    $(".calendario").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'dd-mm-yy',
        // onClose: function(dateText, inst) { 
        //         $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        // }
    });
    $(".calendario").mask("99-99-9999");
    // Ocultar el calendario para solo mostrar el mes
    // $(".calendario").focus(function () {
    //     $(".ui-datepicker-calendar").hide();
    //     $("#ui-datepicker-div").position({
    //         my: "center top",
    //         at: "center bottom",
    //         of: $(this)
    //     });
    // });

    $("body").on("change", "#txt_desde, #txt_hasta", function(){
        if (!(verifica_fecha($('#txt_desde').val(), $('#txt_hasta').val()))) {
            $('#txt_desde').val('');
        }
    });
    
    $("#btnConsultar").click(function() {
        var desde     = $("#txt_desde").val();
        var hasta     = $("#txt_hasta").val();        
        var proveedor = $("#slcProveedor").val();
        var sucursal  = $("#slcSucursal").val(); 
        var tif       = $("#slcTif").val(); 
        tif = ($.isArray(tif)) ? tif : "";
                
        $("#hdesde").val(desde);
        $("#hhasta").val(hasta);
        $("#hslcProveedor").val(proveedor);

        if (tif != '') {
            $("#hslcTif").val($("#slcTif").val());
        }else{
            $("#hslcTif").html('');
        }
        $('#hslcProveedortext').val($("#slcProveedor option:selected").text());
        $("#hslcSucursal").val(sucursal);
        $('#hslcSucursaltext').val($("#slcSucursal option:selected").text());

        if(desde != '' && hasta != ''){
            $.ajax({
                dataType: 'text',
                type: 'POST',          
                url: urlj + 'modulo_contabilidad/reportes/reporte_libro_compras/1',
                data: {
                    desde: desde, 
                    hasta: hasta, 
                    proveedor: proveedor, 
                    sucursal: sucursal,
                    tif: tif
                },              
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    //var oTable = $('#tblListado').dataTable();
                    //oTable.fnDestroy();
                    $("#dv_contenedor_listado").html(data);
                    aplidarDataTable('tblListado');
                    $("#csv").css("display", "");
                    $("#pdf").css("display", "");
                    $("#excel").css("display", "");
                    //$('#cuenta').html(data.options);                
                    //$('#cuenta').select2();            
                    wait.close();            
                }                       
            });
        }else{            
            crear_alerta('error', 'Campos requeridos', 'Período es requerido.');
        }                
    });
        
    //Aplicar estilo a los select a algunos tab de ficha general
    $("#slcProveedor, #slcSucursal").select2();    
    
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "aaSorting": [],
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Fechas','Verifique las fechas del período');
        return false;
    }else{
        return true;
    }
}