jQuery(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');
    $('select').select2();

    get_years(2000);


    $("#year").change(function(event) {
        selected = $(this).val();
        inicio = parseInt(selected) - 10;
        if(inicio<2000){
            get_years(inicio, selected);
        }
    });


    $("#slcrenta").change(function(event) {
        selected    = $(this).val();
        $("#txt_renta").val(selected);
    });


    $("#ver_detalle").click(function (event){
        var year = $("#year").val();
        var empleado = $("#slcEmpleado").val();     
        if( year > 0){
            consultarAjax(year, empleado);
        }else{
            crear_alerta('error','Error', 'Debe seleccionar la información a filtrar');
        }
    });

   
    $("#excel_en").click(function(event){
        event.preventDefault();
        tipo=$(this).attr('value');
        $("#tipo_reporte").val(tipo)
        $("#excel").trigger('click');
    });

    $("#exportar").val(0);

    $(".exportar").click(function(event){
        event.preventDefault();
        if($("#exportar").val()==1){            
            $("#frm-report").submit();
        }else{
            crear_alerta('error','Información', 'Debe seleccionar la información a filtrar');
        }
    });

    if ( $("#slcrenta").val() != "" ) {
        // $('#slcrenta').prop('disabled', true);
        $("#slcrenta").select2();
        $("#txt_renta").val(  $("#slcrenta").val() );
    }     
    

}); // End jQuery


function get_years(inicio=null, selected=null){
    if(inicio == null || parseInt(inicio) < 0){
        inicio = 2000; 
    }
    var fin = new Date().getFullYear();
    var options = "<option value='0 '></option>";
    for(var year = inicio ; year <= fin; year++){
        var sel_attr = '';
        if(selected != null && selected == year){
            sel_attr = 'selected="selected"';
        }
        options += "<option value='"+year+"' "+sel_attr+" >"+ year +"</option>";
    }
    document.getElementById("year").innerHTML = options;
    if(selected==null){
        $("#year option:last").attr('selected', 'selected');
    }
    $("#year").select2();
}

function consultarAjax(year=null, empleado=null) {
    wait.start();
    var txt_renta = $("#txt_renta").val();
    // if ( txt_renta == "" ) {
    //     wait.close();
    //     crear_alerta('error', 'Error', 'Seleccione la renta');
    //     return false;
    // }    
    $("#contenedor_consulta").hide("slide", {
        direction: 'right'
    }, 400, function () { // Después de ocultar div enviar el ajax
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj+'modulo_contabilidad/reportes/renta',
            data: {year: year, empleado: empleado,txt_renta: txt_renta},
            success: function (data) {
                $("#contenedor_consulta").html(data.resultado);
                wait.close();
                $("#ver_detalle").removeAttr('disabled');
                $("#exportar").val(1);

                $("#filtro_year").val(data.year);
                $("#filtro_empleado").val(data.empleado);
                $("#filtro_txt_renta").val(data.renta);                

                $("#contenedor_consulta").show("slide", {
                    direction: 'left'
                }, 500);
            },
            error: function (xhr, status, error) {
                wait.close();
                crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
            }
        });
    });
}