$(document).ready(function () {

    var meses = {
        'Enero': '01',
        'Febrero': '02',
        'Marzo': '03',
        'Abril': '04',
        'Mayo': '05',
        'Junio': '06',
        'Julio': '07',
        'Agosto': '08',
        'Septiembre': '09',
        'Octubre': '10',
        'Noviembre': '11',
        'Diciembre': '12'
    };

    $(".datePicker").datepicker({
        closeText: 'Seleccionar',
        prevText: '<Ant',
        nextText: 'Sig>',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'MM-yy',
        onClose: function (dateText, inst) {
            $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
    });

    $(".datepicker").mask("mm-yyyy");

    // Ocultar el calendario para solo mostrar el mes
    $(".datePicker").focus(function () {
        $(".ui-datepicker-calendar").hide();
        $("#ui-datepicker-div").position({
            my: "center top",
            at: "center bottom",
            of: $(this)
        });
    });

    $("#btn_consultar").click(function (event) {
        var txt_mes = $("#txt_mes").val();

        if (txt_mes == "") {
            crear_alerta('error', 'Período', 'Favor seleccionar un período');
            return false;
        }
        var fecha = txt_mes.split('-');
        var mes = meses[fecha[0]];
        var ultimo = ult_dia(mes, fecha[1]);
        var fecha_ini = fecha[1] + '-' + mes + '-01';
        var fecha_fin = fecha[1] + '-' + mes + '-' + ultimo;

        $("#fecha_ini").val(fecha_ini);
        $("#fecha_fin").val(fecha_fin);

        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj + 'modulo_contabilidad/reportes/pago_cuenta',
            data: {
                tipo_reporte: "",
                fecha_ini: fecha_ini,
                fecha_fin: fecha_fin,
                txt_mes: txt_mes
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                console.log(data.html);
                $("#contenedor_consulta").html(data.html);
                $("#contenedor_consulta").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            },
            error: function (xhr, status, error) {
                console.log(data.html);
                wait.close();
                crear_alerta('error', 'Error', 'Se interrumpio debido a un problema al realizar la operación');
            }
        });
    });

    $("#frmGeneral").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error', 'Campos necesarios', 'Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form) {
            var txt_mes = $("#txt_mes").val();

            if (txt_mes == "") {
                crear_alerta('error', 'Período', 'Favor seleccionar un período');
                return false;
            }

            form.submit();
        }
    });

});

function ult_dia(mes, anio) {
    if (mes.charAt(0) == '0') {
        mes = mes.charAt(1);
    }
    mes = parseInt(mes);
    anio = parseInt(anio);
    switch (mes) {
        case 1: case 3: case 5: case 7: case 8: case 10: case 12: return 31;
        case 2: return (anio % 4 == 0) ? 29 : 28;
    }
    return 30;
}