$(document).ready(function () {
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');

    $('select').select2({placeholder: 'Seleccione una opción'});
    
    
    $("#btnGenerar").click(function(){
        var periodo = "";       
        var fec_ini = "";       
        var fec_fin = "";       
        var tipoTransaccion = $("#slcTipoTransaccion").val();
        if (tipoTransaccion == 1 || tipoTransaccion == 12 || tipoTransaccion == 13 || tipoTransaccion == 15) {
            if (!($("#txt_periodo").val() != "")) {
                crear_alerta('error','Período','Debe definir el período a generar');
                return false;
            }
            periodo = $("#txt_periodo").val();
        }
        if (tipoTransaccion == 3 || tipoTransaccion == 14) {
            if (!($("#txt_desde").val() != "" && $("#txt_hasta").val() != "")) {
                crear_alerta('error','Período','Debe definir el período a generar');
                return false;
            }
            fec_ini = $("#txt_desde").val();
            fec_fin = $("#txt_hasta").val();
            var dias = cuenta_dias(fec_ini, fec_fin);
            if (dias > 15) {
                crear_alerta('error','Período','El período a generar es demasiado grande.');
                return false;
            }
        }
        $.ajax({
            url:urlj + 'modulo_contabilidad/procesos/generar_partidas_masivas',
            type:'POST',
            data:{tipo_proceso:tipoTransaccion},
            dataType:'json',
            beforeSend:function(){
              wait.start();  
            },
            success:function(response){
                wait.close();
                //crear_alerta('success','Partidas Generadas', "Se generaron " + response.url);
                fnGenerarPartidas(response.url, periodo, fec_ini, fec_fin);
            }
        });
    });


    $(".calendario").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'mm-yy',
        onClose: function(dateText, inst) { 
                $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
    });

    $(".calendario_dia").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    // Ocultar el calendario para solo mostrar el mes
    $(".calendario").focus(function () {
        $(".ui-datepicker-calendar").hide();
        $("#ui-datepicker-div").position({
            my: "center top",
            at: "center bottom",
            of: $(this)
        });
    });

    $("#slcTipoTransaccion").change(function(){
        if ($(this).val() == 1 || $(this).val() == 12 || $(this).val() == 13 || $(this).val() == 15) {
            $("#periodo_consolidado").show();
            $("#periodo_detallado").hide();
        } else if ($(this).val() == 3 || $(this).val() == 14) {
            $("#periodo_detallado").show();
            $("#periodo_consolidado").hide();
        } else {
            $("#txt_periodo").val("");
            $("#periodo_consolidado").hide();
            $("#periodo_detallado").hide();
        }
    });

    $("body").on("change", "#txt_desde, #txt_hasta", function(){
        if (!(verifica_fecha($('#txt_desde').val(), $('#txt_hasta').val()))) {
            $('#txt_desde').val('');
        }
    });


});

function fnGenerarPartidas(urlProceso, periodo = "", fecha_ini = "", fecha_fin = ""){
    if(urlProceso != ''){
         $.ajax({
            url:urlj + urlProceso,
            type:'POST',
            data:{
                url: '',
                periodo: periodo,
                fecha_ini: fecha_ini,
                fecha_fin: fecha_fin
            },
            dataType:'json',
            beforeSend:function(){
                wait.start();  
            },
            success:function(response){
                wait.close();
                crear_alerta('success','Partidas Generadas', "Se generaron " + response.cantidad_partidas);
                $("#txtTotalPartidas").val(response.cantidad_partidas);
            }
        });
    }
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Período','Verifique las fechas del período');
        return false;
    }else{
        return true;
    }
}

function cuenta_dias(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    var dif = Date.parse(fecha_f) - Date.parse(fecha_i); 
    var dia = (Math.floor(dif / 86400000)) + 1; 
    return dia;
}