var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;

$(document).ready(function(){
  $("#slc_centro_costo").select2();
    $("input[name^='fecha']").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        closeText: 'seleccionar',
        onClose: function (dateText, inst) {
            $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
        //minDate: 0
    });
    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder',"mm-yyyy");
    $("#pdf, #excel").hide();

    $("#buscar").click(function (event) {
        if ($("#fecha_inicio").val() != '' && $("#fecha_fin").val() != '') {
            var fecha_ini = $("#fecha_inicio").val();
            var fecha_fin = $("#fecha_fin").val();
            var slc_centro_costo = $("#slc_centro_costo").val();
            var txt_centro_costo = $("#slc_centro_costo option:selected").text();
            verifica_fecha(fecha_ini, fecha_fin);
            if ($("#fecha_fin_error").text() == '') {
                wait.start();
                $.ajax({
                    url: urlj + 'modulo_contabilidad/reportes/generar_comparativo_balance_general',
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        txtFecha_desde: fecha_ini,
                        txtFecha_hasta: fecha_fin,
                        idreporte: 1,
                        slc_centro_costo: slc_centro_costo,
                        txt_centro_costo: txt_centro_costo
                    },
                    success: function (json) {
                        wait.close();
                        $('#activos').html(json.html);
                        $("#activos_pasivos").show('slide');
                        $("#activos_pasivos1").show('slide');
                        if (Number(json.respuesta) == 1) {
                            $('#pdf, #excel').hide();
                        } else {
                            $('#pdf, #excel').show();
                        }
                    }

                });
            }
        } else {
            crear_alerta('error', 'Error', 'Debe completar los filtros de búsqueda');
        }

    });

function verifica_fecha(fecha_ini, fecha_fin){
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
          $("#fecha_fin").addClass('error');
          $("#fecha_fin_error").text("Verifique las fechas del período");
          return false;
        }

        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
          $("#fecha_fin").removeClass('error');
          $("#fecha_fin_error").text('');
          return true;
        }
    }

}); // END jQuery

function rango_fechas(fecha) { 
    var fechas = '';
    var fecha_inicio = '';
    var fecha_fin = '';
    var array_fecha = [];

    fechas = fecha.split("-");

    fecha_inicio = fechas[1] + "-" + fechas[0]+"-01"

    fecha_fin = new Date(fechas[1], fechas[0], 0);

    //fecha_fin = fecha_fin.getFullYear() + "-" + fecha_fin.getMonth() + "-" + fecha_fin.getDate();
    fecha_fin = $.datepicker.formatDate('yy-mm-dd', fecha_fin);

    array_fecha[0] = fecha_inicio;
    array_fecha[1] = fecha_fin;
    // console.log(fecha_inicio);
    // console.log(fecha_fin);
    return array_fecha;

}

function reporte_balance_general(fechas) {
    var tabla = ''
    $.ajax({
        url: urlj + 'modulo_contabilidad/reportes/generar_balance_comprobacion',
        type: 'POST',
        dataType: 'json',
        async: false,
        data: {
            txtFecha_desde: fechas[0],
            txtFecha_hasta: fechas[1],
            idreporte: 1
        },
        success: function (json) {
            tabla = json.html;
            $('#tabla_uno').val(json.html);
        }
    });//fin ajax uno
    
    return tabla;
}

function reporte_resultado_acumulado(fechas) {
    var tabla = ''
    $.ajax({
        url: urlj + 'modulo_contabilidad/reportes/generar_estado_resultado',
        type: 'POST',
        dataType: 'json',
        async: false,
        data: {
            txtFecha_desde: fechas[0],
            txtFecha_hasta: fechas[1],
            idreporte: 0
        },
        success: function (json) {
            tabla = json.html;
            $('#tabla_dos').val(json.html);
        }

    });//fin ajax dos

    return tabla;
}
 
