$(document).ready(function(){

    window.gSateliteWhite.jsSelect();
    $('#datagried').dataTable({"sPaginationType": "full_numbers"});
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    var urlj = url_base_proyecto;
    $("#pdf").hide();
    $("#excel").hide();
    
    $("#buscar").click(function() {
        wait.start();
        var fecha_hasta = $("#txtFechaDesde").val();
        var fecha_desde = $("#txtFechaHasta").val();
        var caja        = $("#slcCaja").val();

        if (fecha_desde == "" || fecha_hasta == "") {
            wait.close();
            crear_alerta("error", "AVISO", "No deje ningun campo vacio.");
        } else {
            wait.start();
            $("#contenedor").hide("slide", {
                direction: 'right'
            }, 400, function () { //despues de ocultar div enviar el ajax
                $.ajax({
                    type: 'post',
                    url: urlj+'modulo_contabilidad/reportes/detalles_cheques_por_caja_chica',
                    data: {
                        fecha_desde: fecha_desde,
                        fecha_hasta: fecha_hasta,
                        caja: caja
                    },
                    success: function (data) {
                        wait.close();
                        $('button[name="tipo_reporte"]').removeAttr('disabled');
                        var oTable = $('#datagried').dataTable();
                        oTable.fnDestroy();
                        
                        $("#contenedor").html(data);
                        $("#contenedor").removeAttr('style');
                        $('#datagried').dataTable({
                            "iDisplayLength":10,
                            "bAutoWidth": false,
                            "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
                            'oLanguage':{
                                'sLengthMenu': 'Mostrando _MENU_ entradas'
                            }
                        });
                        $("#exportar").val(1);
                        $('#datagried').css('width', '100%');
                        $("#datagried_length").css('width','25%');
                        $("select[name='datagried_length']").css('width','25%');
                        $("select[name='datagried_length']").select2();
                    }
                });
            });

            $("#pdf").show();
            $("#excel").show();
        }
    });

});