$(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $(".datePicker").datepicker({
		showButtonPanel: true,
		changeMonth: true,
		changeYear: true,
		dateFormat: 'dd-mm-yy',
		monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
		dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
		nextText: "Siguiente",
		prevText: "Anterior",
		closeText: 'Cerrar',
		currentText: 'Hoy'
	});
    
	$(".datePicker").mask("99-99-9999");
    $("#reporte_botones").hide();

    $("#slcProveedor").select2();

    $("#slcProductos").select2({
        placeholder: "Nombre o código del Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/mantenimiento/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.codigo+' - '+item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };

            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        event.preventDefault();
        var fecha_inicio = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var proveedor = $("#slcProveedor").val();
        var producto = $("#slcProductos").val();
        //var ordenCompra = $("#slcOrdenesCompra").val();
    
        $.ajax({
            url: window.gSateliteWhite.baseUrl('modulo_compras/reportes/rpt_ordenes_compra_pendientes'),
            type: "post",
            dataType: 'json',
            data: {
                fecha_inicio: fecha_inicio,
                fecha_fin: fecha_fin,
                proveedor: proveedor,
                producto: producto,
                //orden_compra: orden_compra,
                tipo_reporte: "" 
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (obj) {
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                $("#reporte_botones").show();
                wait.close();
            }
        });
    });

    $("#imprimir_factura").live("click", function(){

        $("#frm_rpt_ordenes_compra_pendientes").attr('action','imprimir_rpt_ordenes_compra_pendientes')
        var tipo = 'excel';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
  
        if(!$("#frm_rpt_ordenes_compra_pendientes").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
  
        $("#tipo_reporte").val(tipo);
        $("#frm_rpt_ordenes_compra_pendientes").submit();
  
      })
  
      $("#imprimir_factura_pdf").live("click", function(){

        $("#frm_rpt_ordenes_compra_pendientes").attr('action','imprimir_rpt_ordenes_compra_pendientes')
        var tipo = 'pdf';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
  
        if(!$("#frm_rpt_ordenes_compra_pendientes").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
  
        $("#tipo_reporte").val(tipo);
        $("#frm_rpt_ordenes_compra_pendientes").submit();
      })

    $("#frm_rpt_ordenes_compra_pendientes").validate({
        rules: {
            txtFechaIni:{ required:false },
            txtFechaFin:{ required:false }
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            form.submit();
        }
    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}