$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");

    $("#form-impuestos-proveedores").validate({
        ignore:"",
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $("body").on("change", "#txtFechaIni, #txtFechaFin", function(){
        if (!(verifica_fecha($('#txtFechaIni').val(), $('#txtFechaFin').val()))) {
            $('#txtFechaFin').val('');
        }
    });
    

    //PDF o Excel
    $(".print").live('click',function(event){
        var tipo = $(this).val();
        $("#rpt_tipo").val(tipo);
        $("#form-impuestos-proveedores").submit();
    })

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var desde     = $("#txtFechaIni").val();
        var hasta     = $("#txtFechaFin").val();
        var proveedor = $('#slcProveedor').val();
        var ret       = $('#slcRet').val();
        if(!$("#form-impuestos-proveedores").valid()){
            crear_alerta('error', 'Alerta', 'Campos con * son requeridos.');
            return false;
        }
        $("#dv_contenedor_reg").hide('slide', {
            direction:'right'
        }, 400, function(){
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('modulo_compras/reportes/generar_reporte_retenciones/1'),
                data:{txtFechaIni:desde,txtFechaFin:hasta,slcProveedor:proveedor,slcRet:ret},
                beforeSend:function(){
                    wait.start();
                },
                success:function(result){
                    $('#encabezado').show();
                    $("#dv_contenedor_reg").html(result);
                    aplidarDataTable('datagried')
                    $(".btn-info").show();
                    wait.close();
                    $("#dv_contenedor_reg").show("slide", {
                        direction: 'left'
                    }, 500);
                }
            });
        });
    });
   
}); //fin jquery

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}    

aplidarDataTable('datagried');

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Fechas','Verifique las fechas del período');
        return false;
    }else{
        return true;
    }
}