$(document).ready(function () {
    $('select option[value=0]').text('Todos');
    
    gSateliteWhite.jsSelect();

    $("#reporte").validate({
        ignore: "",
        rules: {
            slcProveedor: {required: true},
            slcRetaceo: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){

            var proveedor = ($("#slcProveedor").val() > 0) ? $("#slcProveedor").val() : "";
            var proveedorText = $("#slcProveedor option:selected").text();
           
            $("#filtro_proveedor").val(proveedor+"#"+proveedorText);

            var retaceo = ($("#slcRetaceo").val() > 0) ? $("#slcRetaceo").val() : "";
            var retaceoText = $("#slcRetaceo option:selected").text();
           
            $("#filtro_retaceo").val(retaceo+"#"+retaceoText);

            if ( proveedor == "") {
                crear_alerta('error', 'Reporte de retaceo', 'Seleccione un proveedor por favor');
                return false;
            }

            if ( retaceo == "") {
                crear_alerta('error', 'Reporte de retaceo', 'Seleccione un número de retaceo por favor');
                return false;
            }

            form.submit();
        }
    });
   
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    /*Busqueda*/
    $("#btnConsultar").click(function (event) {
        event.preventDefault();
        var proveedor = $("#slcProveedor").val();
        var retaceo = $("#slcRetaceo").val();

        if ( proveedor == "") {
            crear_alerta('error', 'Reporte de retaceo', 'Seleccione un proveedor por favor');
            return false;
        }

        if ( retaceo == "") {
            crear_alerta('error', 'Reporte de retaceo', 'Seleccione un número de retaceo por favor');
            return false;
        }

        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('modulo_compras/reportes/reporte_retaceo/1'),
                        data: {retaceo: retaceo, proveedor: proveedor},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            var proveedor = ($("#slcProveedor").val() > 0) ? $("#slcProveedor").val() : "";
                            var proveedorText = $("#slcProveedor option:selected").text();

                            var retaceo = ($("#slcRetaceo").val() > 0) ? $("#slcRetaceo").val() : "";
                            var retaceoText = $("#slcRetaceo option:selected").text();

                            $("#filtro_proveedor").val(proveedor+"#"+proveedorText);
                            $("#filtro_retaceo").val(proveedor+"#"+proveedorText);

                         
                            var oTable = $('#tblListado').dataTable();
                            oTable.fnDestroy(); 

                            $("#tbContenedorListado").html(result);
                            aplidarDataTable('tblListado');

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);
                        }
                    });
                }
        );
    });

});


function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

$("#slcProveedor").change(function (){
    if ( $("#slcProveedor").val() == "") {
        $("#slcRetaceo").select2('data',null);
        $("#slcRetaceo").empty();
        $("#slcRetaceo").select2("disable");
    } else {
        var proveedor = $(this).val();
        $.ajax({
            url: urlj + 'modulo_compras/reportes/get_retaceo_docucumento',
            data:{proveedor:proveedor},
            type: 'POST',
            dataType: 'json',
            success: function(data){
                $("#slcRetaceo").html(data);
                $("#slcRetaceo").select2();
                $('select option[value="0"]').text('');
                $('select option[value="0"]').val('');
                $('select').select2({placeholder: 'Seleccione una opción'});

                $("#slcRetaceo").select2("enable");
            }
        });
    }
});  


