$(document).ready(function () {
    $('select option[value=0]').text('Todos');
    gSateliteWhite.jsSelect();
    
     $("#reporte").validate({
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true},
            txtNumeroProducto: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            if ( !validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val()) ) {
                crear_alerta('error', 'Reporte de productos más comprados', 'Verifique el período de las fechas.');
                return false;
            }

            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val( $("#txtFechaFin").val());
            
            $("#filtro_NumeroProducto").val( $("#txtNumeroProducto").val());

            var categoria = ($("#slcCategoria").val() > 0) ? $("#slcCategoria").val() : "";
            var categoriaText = $("#slcCategoria option:selected").text();

            $("#filtro_categoria").val(categoria+"#"+categoriaText);
         
            form.submit();
        }
    });


    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");

    /*Busqueda*/
    $("#btnConsultar").click(function () {

        var categoria = ($("#slcCategoria").val() > 0) ? $("#slcCategoria").val() : "";

        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        var numeroProducto = $("#txtNumeroProducto").val();

       if (fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error', 'Reporte de productos más comprados', 'Fechas son obligatorias.');
            return false;
        }

        if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Reporte de productos más comprados', 'Verifique el período de las fechas.');
                return false;
        }

        if (numeroProducto == ''){
            crear_alerta('error', 'Reporte de productos más comprados', 'Ingrese una cantidad de productos.');
            return false;
        }

        if (numeroProducto < 1){
            crear_alerta('error', 'Reporte de productos más comprados', 'Ingrese una cantidad mayor a cero.');
            return false;
        }


        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('modulo_compras/reportes/reporte_producto_mas_comprado/1'),
                        data: {numeroProducto: numeroProducto, fecha_ini: fecha_ini, fecha_fin: fecha_fin, categoria: categoria},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();

                            var categoria = ($("#slcCategoria").val() > 0) ? $("#slcCategoria").val() : "";
                            var categoriaText = $("#slcCategoria option:selected").text(); 
                            
                            var fecha_ini = $("#txtFechaIni").val();
                            var fecha_fin = $("#txtFechaFin").val();

                            var numeroProducto = $("#txtNumeroProducto").val();

                            $("#filtro_categoria").val(categoria+"#"+categoriaText);
                            
                            $("#filtro_inicio").val(fecha_ini);
                            $("#filtro_fin").val(fecha_fin);

                            $("#filtro_NumeroProducto").val(numeroProducto);

                            var oTable = $('#tblListado').dataTable();
                            oTable.fnDestroy(); 

                            $("#tbContenedorListado").html(result);
                            aplidarDataTable('tblListado');

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);

                        }
                    });
                }
        );
    });


    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
