$(document).ready(function () {

    $("#chk_proceso").iButton({
        'labelOn': 'Sin Salida',
        'labelOff': 'Sin Entrada'
    });
    $("input[name^='fecha']").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        //minDate: 0
    });
    
    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");

    $("#fecha_inicio,#fecha_fin").change(function(event) {  validar_fecha_inicio_fin('fecha_inicio','fecha_fin','La fecha de desde debe ser menor a la fecha hasta'); });


    $('#dependencia option[value="0"]').text('');
    $('#dependencia option[value="0"]').val('');

    $('#slcProveedor').select2({placeholder: 'Seleccione una opción'});
    $('#slcTipoDocumento').select2({placeholder: 'Seleccione una opción'});
    
    $("#btnConsultar").click(function() {
        var slcProveedor = $("#slcProveedor").val();
        var slcTipoFactura = $("#slcTipoDocumento").val();
        var fecha_inicio = $("#fecha_inicio").val();
        var fecha_fin = $("#fecha_fin").val();                
        $("#hslcproveedor").val(slcProveedor);
        $('#hslcproveedortext').val($("#slcProveedor option:selected").text());
        $("#htipodocumento").val(slcTipoFactura);
        $('#htipodocumentotext').val($("#slcTipoDocumento option:selected").text());        
        $("#hfechainicio").val(fecha_inicio);
        $("#hfechafin").val(fecha_fin);
        var valor_proceso = ($("#chk_proceso").attr('checked')) ? 1:0; //1=sin salida, 0=sin entrada
        $("#chkProceso").val(valor_proceso);
        if(fecha_inicio !='' && fecha_fin!=''){
            $.ajax({
                dataType: 'text',
                type: 'POST',          
                url: urlj + 'modulo_compras/reportes/reporte_doc_proveedor_sin_salida/1',
                data: {slcProveedor: slcProveedor, slcTipoDocumento: slcTipoFactura, fecha_inicio: fecha_inicio, fecha_fin: fecha_fin, chkProceso:valor_proceso},
                beforeSend: function () {
                  wait.start();
              },
            success: function (data) {
              //var oTable = $('#tblListado').dataTable();
              //oTable.fnDestroy();
              $("#dv_contenedor_listado").html(data);
              aplidarDataTable('tblListado');

              $("#pdf").css("display", "");
              $("#excel").css("display", "");

              //$('#cuenta').html(data.options);
              
              //$('#cuenta').select2();            
              wait.close();            
            }                       
          });
        }else{            
          crear_alerta('error', 'Campos requeridos', 'Campos con asterisco son requeridos');
        }                
    });
        
    //Aplicar estilo a los select a algunos tab de ficha general
    $("#slcTipoConstruccion, #slcDepartamento, #slcMunicipio").select2();    
    
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "aaSorting": [],
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}