 var busqueda_categoria = "";
$(document).ready(function () {
    $('select option[value=0]').text('Todos');
    gSateliteWhite.jsSelect();
   
    $("#reporte").validate({
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Reporte por producto','Favor ingrese los campos requeridos');
        },
        submitHandler: function (form){
            if ( !validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val()) ) {
                crear_alerta('error', 'Reporte por producto', 'Verifique el período de fechas.');
                return false;
            }

            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val( $("#txtFechaFin").val());

            var categoria = $("#slcCategoria").val();
            if ( categoria != "" ) {
                var categoriaText = $("#slcCategoria").select2('data').text;
            }else{
                var categoriaText = "Todos";
            }

            var producto = $("#slcProducto").val();
            if ( producto != "" ) {
                var productoText = $("#slcProducto").select2('data').text;
            }else{
                var productoText = "Todos";
            }
           
            $("#filtro_categoria").val(categoria+"#"+categoriaText);
            $("#filtro_producto").val(producto+"#"+productoText);
         
            form.submit();
        }
    });

   
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        event.preventDefault();
        var categoria = $("#slcCategoria").val();
        var producto = $("#slcProducto").val();
        
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        if (fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error', 'Reporte por producto', 'Fechas son obligatorias.');
            return false;
        }

        if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Reporte por producto', 'Verifique el período de fechas.');
                return false;
        }

        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('modulo_compras/reportes/reporte_compras_producto/1'),
                        data: {fecha_ini: fecha_ini, fecha_fin: fecha_fin, categoria: categoria, producto: producto},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            
                            var categoria = $("#slcCategoria").val();
                            if ( categoria != "" ) {
                                var categoriaText = $("#slcCategoria").select2('data').text;
                            }else{
                                var categoriaText = "Todos";
                            }

                            var producto = $("#slcProducto").val();
                            if ( producto != "" ) {
                                var productoText = $("#slcProducto").select2('data').text;
                            }else{
                                var productoText = "Todos";
                            }

                            $("#filtro_Categoria").val(categoria+"#"+categoriaText);
                            $("#filtro_Producto").val(producto+"#"+productoText);
                            
                            var fecha_ini = $("#txtFechaIni").val();
                            var fecha_fin = $("#txtFechaFin").val();

                            $("#filtro_fin").val(fecha_fin);
                            $("#filtro_inicio").val(fecha_ini);

                            var oTable = $('#tblListado').dataTable();
                            oTable.fnDestroy(); 

                            $("#tbContenedorListado").html(result);
                            aplidarDataTable('tblListado');

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);
                        },
                        complete: function( ){
                            sumar();    
                        }
                    });
                }
        );
    });


    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });

    $(document).on('click', '.paginate_button', function () {
        sumar();
    });


});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}

function sumar() {
    suma = 0;
    celda = "";
    $('#tblListado tr.dato').each(function(){ 
        celda = $(this).find('td').eq(9).text();
        celda = celda.substring(1);
        celda = celda.split(',').join('');       
        suma += parseFloat( celda ||0,10 );
    })
    suma = suma.toFixed(2);
    $("#total").text("$"+suma);
}

$("#slcCategoria").select2({
          placeholder:'Buscar categorias',
          minimumInputLength: 3,
          ajax: {
              url:urlj+'modulo_compras/reportes/consultar_categorias',
              dataType: 'json',
              type: 'POST',
              delay: 250,
              data: function (categoria) {
                return {
                    categoria: categoria
                };
              },
              results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.tia_id,
                        'text': (item.tia_codigo+"-"+item.tia_nombre)
                    });
                });
                return {
                    results: myResults
                };
				
            } 
          }
});  

$("#slcProducto").select2({
          placeholder:'Buscar productos',
          minimumInputLength: 3,
          ajax: {
              
              url:urlj+'modulo_compras/reportes/consultar_articulos/articulo',
              dataType: 'json',
              type: 'POST',
              delay: 250,
              data: function (articulo) {
                return {
                    articulo: articulo,
                    categoria: $("#slcCategoria").val()
                };
              },
              results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    var nombre = '';
                    if ( item.art_sinonimo!= null && item.art_sinonimo!='') {
                        nombre = item.art_nombre + ' (' + item.art_sinonimo + ')';
                    } else {
                        nombre = item.art_nombre;
                    }
                    myResults.push({
                        'id': item.art_id,
                        'text': (item.art_codigo+"-"+nombre)
                    });
                });
                return {
                    results: myResults
                };
				
            } 
          }
});  

$("#slcCategoria").change(function (){
    busqueda_categoria= $("#slcCategoria").val();
    $("#slcProducto").select2('data',null);
});  

