$(document).ready(function () {
	var nombre_reporte = "Comparativo de cotizaciones";
    $("select").select2();

    $(".datePicker").datepicker({
		showButtonPanel: true,
		changeMonth: true,
		changeYear: true,
		dateFormat: 'dd-mm-yy',
		monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
		dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
		nextText: "Siguiente",
		prevText: "Anterior",
		closeText: 'Cerrar',
		currentText: 'Hoy'
	});
    $(".datePicker").mask("99-99-9999");

    $("#frm_reporte").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var slc_requiciones     = $("#slc_requiciones").val();
          
            if (slc_requiciones == "") {
                crear_alerta('error', nombre_reporte, 'Por favor seleccione una requisición.');
                return false;
            } 
    
            form.submit();
        }
    });

    $(".fechas").on("change", function () {
        var txtFechaIni = $("#txtFechaIni").val();
        var txtFechaFin = $("#txtFechaFin").val();    
        
        if ( txtFechaIni != "" && txtFechaFin != "") {
            if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
                crear_alerta('error', nombre_reporte, 'Verifique el período de fechas.');
                $("#txtFechaFin").val("");
                return false;
            } else {
                $.ajax({
                    url: window.gSateliteWhite.baseUrl('modulo_compras/reportes/get_requisiciones'),
                    data: {
                        txtFechaIni: txtFechaIni,
                        txtFechaFin: txtFechaFin 
                    },
                    type: "post",
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (result) {
                        wait.close();
                        $("#slc_requiciones").html(result);
                    }
                });
            }
		}
    });

    $("#btn_consultar").on("click", function () {
        event.preventDefault();
    
        var slc_requiciones     = $("#slc_requiciones").val();
          
        if (slc_requiciones == "") {
            crear_alerta('error', nombre_reporte, 'Por favor seleccione una requisición.');
            return false;
        } 

        $.ajax({
            url: window.gSateliteWhite.baseUrl('modulo_compras/reportes/comparativo_cotizaciones'),
            data: {
            	slc_requiciones			: slc_requiciones,
                tipo_reporte: ""    
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
            	wait.close();
            	//$('#tbl_table').dataTable().fnDestroy();
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
        		
        		// aplicar_datatable("#tbl_table");
        		
            }
        });

    });

});

function aplicar_datatable(id){
    $(id).dataTable({
        //"sPaginationType": "full_numbers",
        "bFilter": true,
        "bJQueryUI": false,
        "bAutoWidth": true,
        "iDisplayLength": 5,        
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}