jQuery(document).ready(function () {
    $('#slcPersoneria, #slcActividadEco').select2();

    $("#ver_detalle").click(function (event){
        var personeria = $("#slcPersoneria").val();
        var actividad = $("#slcActividadEco").val();
     
        consultarAjax(personeria, actividad);
    });
   
    $("#excel_en").click(function(event){
        event.preventDefault();
        tipo=$(this).attr('value');
        $("#tipo_reporte").val(tipo)
        $("#excel").trigger('click');
    });

    $("#exportar").val(0);
    $(".exportar").click(function(event){
        event.preventDefault();
        if($("#exportar").val()==1){
            $("#frm-report").submit();
        }else{
            crear_alerta('error','Información', 'Debe seleccionar la información a filtrar');
        }
    });

}); // End jQuery

function consultarAjax(personeria=null, actividad=null) {
    wait.start();
    $("#tblProveedores").hide("slide", {
        direction: 'right'
    }, 400, function () { // Después de ocultar div enviar el ajax
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj+'modulo_compras/reportes/proveedores',
            data: {personeria: personeria, actividad: actividad},
            success: function (data) {
                var obj = jQuery.parseJSON( data );
                             
                var oTable = $('#tblProveedores').dataTable();
                oTable.fnDestroy(); 
                
                $("#tbContenedorProveedores").html(data.resultado);

                aplicarDataTable('tblProveedores');

                wait.close();
                $("#ver_detalle").removeAttr('disabled');
                $("#exportar").val(1);

                $("#filtro_personeria").val(data.personeria);
                $("#filtro_actividad").val(data.actividad);

                $("#tblProveedores").show("slide", {
                    direction: 'left'
                }, 500);
            },
            error: function (xhr, status, error) {
                wait.close();
                console.log(xhr);
                console.log(status);
                console.log(error);
                crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
            }
        });
    });
}

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
