var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;

$(document).ready(function() {
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    $("#proveedor").select2({placeholder: "Seleccione"});

    // Buscar producto por codigo
    $("#producto").select2({
        placeholder: "Nombre o código del Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/mantenimiento/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    tipo: $("#tipo_general_combo").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.codigo+' - '+item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };

            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });


    $("#btn_consultar").click(function () {
        $("#div_exportar").css('display','none');
        event.preventDefault();
        var txtFechaIni      = $("#txtFechaIni").val();
        var txtFechaFin      = $("#txtFechaFin").val();
        var producto         = $("#producto").val();
        var proveedor        = $("#proveedor").val();
        if ( txtFechaIni == "" || txtFechaFin == "") {
            crear_alerta('error', 'Reporte de Precios de Ventas', 'Por favor ingrese el rango de fechas.');
            $("#txtFechaIni").val("");
            return false;
        }
        if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
            crear_alerta('error', 'Reporte de Precios de Ventas', 'Verifique el período de fechas.');
            return false;
        }
        wait.start();
        $.ajax({
            url: urlj+'modulo_compras/reportes/precios_compras_dpv',
            type: 'POST',
            data: {
                txtFechaIni: txtFechaIni,
                txtFechaFin: txtFechaFin,
                producto:    producto,
                proveedor:   proveedor, 
                tipo_reporte: ""
            },
            success:function(data) {
                var obj = jQuery.parseJSON(data);
                $("#dv_contenedor").html(obj.html);
                $("#div_exportar").css('display','');
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                
                wait.close();
            }
        });


    });

    $("#frm_reporte").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var txtFechaIni         = $("#txtFechaIni").val();
            var txtFechaFin         = $("#txtFechaFin").val();

            // var respuesta = false;

            if ( txtFechaIni == "" || txtFechaFin == "") {
                crear_alerta('error', 'Reporte de Precios de Compras', 'Por favor ingrese el rango de fechas.');
                $("#txtFechaIni").val("");
                $("#slc_estado").val("");
                return false;
            }

            if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
                crear_alerta('error', 'Reporte de Precios de Compras', 'Verifique el período de fechas.');
                return false;
            }

            form.submit();
        }
    });
});
