$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    $("#slcBodega").select2();

    $("#form-impuestos-proveedores").validate({
        ignore:"",
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    

    //PDF o Excel
    $(".print").live('click',function(event){
        var tipo = $(this).val();
        $("#rpt_tipo").val(tipo);
        $("#form-impuestos-proveedores").submit();
    })

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var desde     = $("#txtFechaIni").val();
        var hasta     = $("#txtFechaFin").val();
        var proveedor = $('#slcProveedor').val();
        var impuesto  = $('#slcImpuesto').val();

        if(!$("#form-impuestos-proveedores").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }

        $("#dv_contenedor_reg").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('modulo_compras/reportes/generar_reporte_impuestos/1'),
                   data:{txtFechaIni:desde,txtFechaFin:hasta,slcProveedor:proveedor,slcImpuesto:impuesto},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                        $('#encabezado').show();
                        $("#dv_contenedor_reg").html(result);
                        aplidarDataTable('datagried')
                        $(".btn-info").show();
                        wait.close();
                        $("#dv_contenedor_reg").show("slide", {
                           direction: 'left'
                        }, 500);
                   }
                });
            }
        );

   });
   
}); //fin jquery

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}    
aplidarDataTable('datagried');