$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $("#slcCaja").select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#txtFechaIni,#txtFechaFin").change(function(event) {  validar_fecha_inicio_fin('txtFechaIni','txtFechaFin','La fecha de desde debe ser menor a la fecha hasta'); });
    var estados = '';
    //Validaciones de filtros
    $("#frm-listado").validate({
        ignore:"",
        rules: {
            // txtFechaIni:{ required:true},
            // txtFechaFin:{ required:true},
            slcCaja:{ required:true, min: 1},
            slcCorte:{ required:true}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });


    //PDF o Excel
    $(".print").live('click',function(event){
        var tipo = $(this).val();
        $("#rpt_tipo").val(tipo);
        $("#frm-listado").submit();
    })

    //Búsqueda
    $("#btnConsultar").click(function(){
        var caja = ($.trim($("#slcCaja").val()) > 0) ? $("#slcCaja").val() : "";
        var slcCorte = $("#slcCorte").val();
        //console.log(slcCorte);
        if(!$("#frm-listado").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        $("#dv_contenedor_reg").hide('slide',{ direction:'right' }, 400,function(){
            $.ajax({
                type:'post',
                url:window.gSateliteWhite.baseUrl('modulo_compras/reportes/consolidado_caja_chica/1'),
                data:{
                    caja: caja,
                    slcCorte: slcCorte
                },
                beforeSend:function(){
                    wait.start();
                },
                success:function(result){
                        //$('#rpt_txtFechaIni').val(fecha_ini);
                        //$('#rpt_txtFechaFin').val(fecha_fin);
                        $('#rpt_caja').val(caja);
                        $('#caja_name').val($('#slcCaja option:selected').text());
                        $('#encabezado').show();
                        $("#dv_contenedor_reg").html(result);
                    //    aplidarDataTable('datagried')
                        $("#control").show();
                        wait.close();
                        $(".btn-info").show(500);
                        $("#dv_contenedor_reg").show("slide", {
                           direction: 'left'
                        }, 500);
                   }
                });
            }
        );

    });

$("#slcCaja").change(function(event) {
    cargar_cortes();
});

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
aplidarDataTable('datagried');

function  cargar_cortes() {

    url_ajax = window.satelite.base_url('modulo_compras/reportes/filtrar_corte_caja');
     $.ajax({
         url: url_ajax,
         type: 'POST',
         dataType: 'json',
         data: {
             slcCaja: $("#slcCaja").val()
         },
         beforeSend: function () {
             wait.start('Cargando cortes...');
         },
         error: function (xhr, status, error){
          exportarError(xhr.responseText);
          wait.close();
      },
      success: function (json) {
          $("#slcCorte").html(json.options);
          $("#slcCorte").select2();
          wait.close();

      }
  });
}