$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $("#slcCliente").select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#txtFechaIni,#txtFechaFin").change(function(event) {  validar_fecha_inicio_fin('txtFechaIni','txtFechaFin','La fecha de desde debe ser menor a la fecha hasta'); });
    var estados = '';
    //Validaciones de filtros
    $("#frm-listado").validate({
        ignore:"",
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true},
            // slcProducto: {required:true},
            slcCotizacion: {required:true}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });


    $(document).on('change','#slcCotizacion',function(){
        var cot = $(this).val();
        if (cot != "") {
            $.ajax({
                type:'post',
                dataType: 'json',
                url:window.gSateliteWhite.baseUrl('modulo_compras/reportes/get_cot'),
                data:{
                    cot : cot
                },
                beforeSend:function(){
                    wait.start();
                },
                success:function(data){
                    wait.close();
                    $('#slcProducto').html(data.opc);
                }
            });
        }else{
            $('#slcProducto').html('<option value=""></option>');
            $("#slcProducto").select2({placeholder: 'Seleccione un Producto'});
        }
    });
  

    //PDF o Excel
    $(".print").live('click',function(event){
        var tipo = $(this).val();
        $("#rpt_tipo").val(tipo);
        //$("#frm-listado").submit();
    })

    //Búsqueda
    $("#btnConsultar").click(function(){
        var fecha_ini     = $("#txtFechaIni").val();
        var fecha_fin     = $("#txtFechaFin").val();
        var producto      = $("#slcProducto").val();
        var cot           = $("#slcCotizacion").val();

        if(!$("#frm-listado").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }

        $("#dv_contenedor_reg").hide('slide',{direction:'right'}, 400,function(){
            $.ajax({
                type:'post',
                url:window.gSateliteWhite.baseUrl('modulo_compras/reportes/get_comparativo_cotizaciones'),
                data:{
                    rpt_txtFechaIni :fecha_ini,
                    rpt_txtFechaFin :fecha_fin,
                    rpt_producto    :producto,
                    rpt_cotizacion  :cot
                },
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                        $('#rpt_txtFechaIni').val(fecha_ini);
                        $('#rpt_txtFechaFin').val(fecha_fin);
                        $('#rpt_producto').val(producto);
                        $('#rpt_cotizacion').val(cot);
                        $('#encabezado').show();
                        $("#dv_contenedor_reg").html(result);
                        $("#control").show();
                        wait.close();
                        $(".btn-info").show(500);
                        $("#dv_contenedor_reg").show("slide", {
                           direction: 'left'
                        }, 500);
                   }
                });
            }
        );

    });
    
});

