$(document).ready(function(){
    $("#pdf").hide();
    window.gSateliteWhite.jsSelect();
    $('#datagried').dataTable({"sPaginationType": "full_numbers"});
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");

    var urlj = url_base_proyecto;
    $("#pdf").hide();
    $("#excel").hide();
    
    $("#buscar").click(function() {
        wait.start();
        var fecha_desde = $("#txtFechaDesde").val();
        var fecha_hasta = $("#txtFechaHasta").val();
        var caja        = $("#slcCaja").val();
        var slcCorte    = $("#slcCorte").val();

        if (fecha_desde != '' && fecha_hasta != '') {
            if (!validarPeriodo(fecha_desde, fecha_hasta)) {
                wait.close();
                crear_alerta('error', 'AVISO', 'Verifique el período de las fechas.');
                return false;
            }
        }
        if (slcCorte == "" || slcCorte == null || caja == "" || caja == null) {
            wait.close();
            crear_alerta("error", "AVISO", "Revise los campos obligatorios.");
        } else {
            wait.start();
            $("#contenedor").hide("slide", {
                direction: 'right'
            }, 400, function () { //despues de ocultar div enviar el ajax
                $.ajax({
                    type: 'post',
                    url: urlj+'modulo_compras/reportes/detalles_cheques_por_caja_chica',
                    data: {
                        fecha_desde: fecha_desde,
                        fecha_hasta: fecha_hasta,
                        caja:        caja,
                        slcCorte:    slcCorte
                    },
                    success: function (data) {
                        wait.close();
                        $('button[name="tipo_reporte"]').removeAttr('disabled');
                        var oTable = $('#datagried').dataTable();
                        oTable.fnDestroy();
                                                
                        $("#contenedor").removeAttr('style');
                        $("#contenedor").html(data);
                        $('#datagried').dataTable({
                            "iDisplayLength":10,
                            "bAutoWidth": false,
                            "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
                            'oLanguage':{
                                'sLengthMenu': 'Mostrando _MENU_ entradas'
                            }
                        });
                        $("#exportar").val(1);
                        $('#datagried').css('width', '100%');
                        $("#datagried_length").css('width','25%');
                        $("select[name='datagried_length']").css('width','25%');
                        $("select[name='datagried_length']").select2();
                    }
                });
            });

            $("#pdf").show();
            $("#excel").show();
        }
    });
    
    $("#slcCaja").change(function(event) {
        cargar_cortes();
    });

});

function  cargar_cortes() {

    url_ajax = window.satelite.base_url('modulo_compras/reportes/filtrar_corte_caja');
     $.ajax({
         url: url_ajax,
         type: 'POST',
         dataType: 'json',
         data: {
             slcCaja: $("#slcCaja").val()             
         },
         beforeSend: function () {
             wait.start('Cargando cortes...');
         },
         error: function (xhr, status, error){
          exportarError(xhr.responseText);
          wait.close();
      },
      success: function (json) {
          $("#slcCorte").html(json.options);
          $("#slcCorte").select2();
          wait.close();

      }
  });
}