var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;

$(document).ready(function () {
	
	$("#slcRequisicion").select2();


	$(".datePicker").datepicker({
		showButtonPanel: true,
		changeMonth: true,
		changeYear: true,
		dateFormat: 'dd-mm-yy',
		monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
		dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
		nextText: "Siguiente",
		prevText: "Anterior",
		closeText: 'Cerrar',
		currentText: 'Hoy'
	});
	$(".datePicker").mask("99-99-9999");


	$("#btn_consultar").click(function () {
		event.preventDefault();
		$("#excel").css("display", "none");//ocultar los botones
		$("#pdf").css("display", "none");

		var txtFechaIni = $("#txtFechaIni").val();
		var txtFechaFin = $("#txtFechaFin").val();
		var requix    	= $("#slcRequisicion").val();
		var text    	= $("#slcRequisicion option:selected").text(); 

		if ( txtFechaIni == "" || txtFechaFin == "") {
			crear_alerta('error', 'Rep. de Análisis de Cotizaciones', 'Por favor ingrese el rango de fechas.');
			return false;
		}

		if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
			crear_alerta('error', 'Rep. de Análisis de Cotizaciones', 'Verifique el período de fechas.');
			return false;
		}

		if ( requix == "") {
			crear_alerta('error', 'Rep. de Análisis de Cotizaciones', 'Por favor ingrese una requisición.');
			return false;
		}

		$("#h_fecha_ini").val(txtFechaIni);
		$("#h_fecha_fin").val(txtFechaFin);
		$("#h_requix_id").val(requix);
		$("#h_requix_text").val(text);

		$.ajax({
			dataType: 'text',
			type: 'POST',
			url: urlj+'modulo_compras/reportes/analisis_cotizacion_compra/1',
			data: {
				txtFechaIni: 	txtFechaIni,
				txtFechaFin: 	txtFechaFin,
				tipo_reporte: 	"",
				requix:			requix
			},
			beforeSend: function () {
				wait.start();
			},
			success:function(data) {
				var obj = jQuery.parseJSON(data);
				$("#dv_contenedor").html(obj.html);
				$("#dv_contenedor").show("slide", {
					direction: 'left'
				}, 500);
				if (obj.rows>0) {
					$("#excel").css("display", "");
					$("#pdf").css("display", "");
				}
				wait.close();
			}
		});
	});

});//end document.ready
