$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder:"Seleccione una opción"});
     
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    
    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var caja = $("#slcCaja").val();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var estado = $("#slcCorte").val();
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Ordenes de Compra','Verifique el período de las fechas.');
                return false;
            }
        }
        $("#dv_contenedor_periodo").hide('slide',{ direction:'right' }, 400, function(){
            $.ajax({
                type: 'post',
                url: urlj + 'modulo_compras/procesos/periodo_caja_chica',
                data:{
                    caja: caja,
                    estado: estado,
                    fecha_ini: fecha_ini,
                    fecha_fin: fecha_fin
                },
                beforeSend:function(){
                    wait.start();
                },
                success:function(result){
                    wait.close();
                    var oTabla = $("#tblPeriodo").dataTable();
                    oTabla.fnDestroy();
                    $("#tbContenedorPeriodo").html(result);
                    $("#dv_contenedor_periodo").show("slide", { direction: 'left' }, 500);
                    aplidarDataTable('tblPeriodo');
                }
            });
        });
    });

   $("#btnConsultar").trigger('click');

   $(".adesactivar").mouseover(function(event) {
      var id = $(this).data('id');
        $("#id_periodo").val(id);
   });

}); //End jQuery


  function desactivar_periodo() {
    id_pcc = $("#id_periodo").val();
    observacion = $("#obs_desactivar").val();
      if(observacion!=''){
        $("#obs_desactivar_error").text('');
        wait.start('Espere un momento...procesando la información');
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj+'modulo_compras/procesos/desactivar_periodo_caja',
            data: {'observacion': observacion, 'id_pcc': id_pcc},
            success: function (data) {
                if (data.exito > 0) {
                    location.reload();
                } else {
                    wait.close();
                    crear_alerta('error', 'Error', 'Ocurrió un error al desactivar el período');
                }
            }
        });
      }else{
        $("#obs_desactivar_error").text('Campo requerido');
      }
  }

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        
        "aaSorting" : [],

        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}
