$(document).ready(function () {
    //gSateliteWhite.jsSelect();
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder:"Seleccione una opción"});
     
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    
    /*Busqueda*/
   $("#btnConsultar").click(function(){
       
       var estado       = $("#slcEstado").val();
       var fecha_ini    = $("#txtFechaIni").val();
       var fecha_fin    = $("#txtFechaFin").val();
       var slc_sucusal  = $("#slc_sucusal").val();
       
       if(fecha_ini !='' && fecha_fin != ''){
           if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Ordenes de Compra','Verifique el período de las fechas.');
               return false;
           }
       }

       $("#dv_contenedor_ordenes_comp").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('modulo_compras/procesos/ordenes_compra/1'),
                   data:{estado:estado,fecha_ini:fecha_ini,fecha_fin:fecha_fin,slc_sucusal:slc_sucusal},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                       wait.close();
                       var oTabla = $("#tblOrdenesComp").dataTable();
                       
                       oTabla.fnDestroy();
                       $("#tbContenedorOrdenesComp").html(result);
                       
                       $("#dv_contenedor_ordenes_comp").show("slide", {
			 direction: 'left'
                        }, 500);
                       aplidarDataTable('tblOrdenesComp');
                   }
                });
            }
        );
   });

   $("#btnConsultar").click();
   
   $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width:'100%',
            closeBtn: true
        });
    });

  $("#div_detalles").css({'padding':'5px', 'overflow-x': 'auto', 'margin-left': '0px', 'text-align':'center'});

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        },
        "aaSorting": []
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}