/**
*Descripcion: Validacion del formulario nota abono pendiente
*@authoe: Nelson Soriano
*@since:  15-12-2018
**/
$(document).ready(function (){
    $("#monto_nota").numeric();  
    var por_pagar = parseFloat($('#por_pagar_nota').val()); 
    $("#frm-nota").validate({
        ignore: [],
        rules: {
            documento_nota: {required: true},
            fecha_creacion: {required: true},
            monto_nota:     {required: true,validarMonto: true},
            orden_nota:     {required: true}
        },
        messages:{
            monto_nota:     {required: 'Campo Monto es requerido',validarMonto: 'El valor del monto debe ser mayor a 0 y menor o igual al monto por pagar  '},
            orden_nota:     {required: 'Campo orden es requedido'}
        },
        errorPlacement: function (error, element) {
           error.insertAfter( element );
        },
        submitHandler: function (form) {
            form.submit();
        }
    });
    jQuery.validator.addMethod("validarMonto", function(value, element) {
        if (element.value > por_pagar ) {
            return false;
        }else if(element.value == 0){
            return false;
        }else{
            return true;}
  });
  
    $(".btn-close").click(function () {

        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    }); 

    $('#monto_nota').keyup(function(){
        var por_pagar = parseFloat($('#por_pagar_nota').val());
        var inicial   = $('#por_pagar_nota').data('options').pagar;
        var decimales = $('#por_pagar_nota').data('options').decimaless;
        var abono     = parseFloat($('#monto_nota').val());
        if (abono > 0 ) {
            por_pagar  = inicial;
            if (abono <= por_pagar) {
            cantida    = por_pagar - abono;
            cantidad   = cantida.toFixed(decimales);
            $('#por_pagar_nota').val(cantidad);
            }else{
                $('#por_pagar_nota').val(inicial);
            }
        }else{
             $('#por_pagar_nota').val(inicial);
        }
        
    }); 
    
});

function cerrar_modal() {
    parent.jQuery.fancybox.close();
}