(function(){
  // Endpoints
  const UPLOAD_URL      = urlj + "modulo_compras/procesos/uploadGeneralFile";
  const REVERT_URL      = urlj + "modulo_compras/procesos/deleteGeneralFile";
  const PROCESS_URL     = urlj + "modulo_compras/procesos/procesarJson";
  const PROCESS_ONE_URL = urlj + "modulo_compras/procesos/saveJsonDte";
  const VERIFY_ONE_URL  = urlj + "modulo_compras/procesos/verifyBodyDte";
  const CREATE_ART_URL  = urlj + "modulo_compras/procesos/createArticulo";

  // Espera y alertas
  function tryWaitStart(){ try{ if(window.wait && typeof wait.start==='function') wait.start(); }catch(_){} }
  function tryWaitClose(){ try{ if(window.wait && typeof wait.close==='function') wait.close(); }catch(_){} }
  function alertSuccess(t,m){ try{ if(window.crear_alerta) crear_alerta('success', t||'Éxito',    m||''); }catch(_){} }
  function alertWarning(t,m){ try{ if(window.crear_alerta) crear_alerta('warning', t||'Atención', m||''); }catch(_){} }
  function alertError(t,m){   try{ if(window.crear_alerta) crear_alerta('error',   t||'Error',    m||''); }catch(_){} }

  // Estilo base
  if (!document.getElementById('dpv-soft-disabled-style')){
    document.head.insertAdjacentHTML('beforeend', `
      <style id="dpv-soft-disabled-style">
        .btnc.is-soft-disabled, .btnc[disabled]{ opacity:.55; filter:grayscale(.4); cursor:not-allowed !important; }
        .chip-msg{display:inline-block;margin-left:8px;padding:3px 8px;border-radius:12px;background:#f5f5f5;color:#666;font-weight:600}
        tr.is-selected{background:#f8fbff}
      </style>
    `);
  }

  // Mapas
  const artMap = Object.create(null);
  const artMapsByDoc = Object.create(null);

  // Cache DOM
  const $tbody       = $("#tbody"),
        $statusText  = $("#status-text"),
        $statusPill  = $("#status-pill"),
        $error       = $("#error"),
        $drop        = $("#uploader"),
        $foundTotal  = $("#found-total");

  const $reviewCard  = $("#review-card");
  const $reviewTotal = $("#review-total");
  const $tbodyAll    = $("#tbody-all");
  const $btnBack     = $("#btn-back");
  const $btnProcSel  = $("#btn-proc-selected");
  const $chkAll      = $("#chk-all");
  const $btnProcAll  = $("#btn-proc-all"); // opcional si existe en HTML

  // Estado
  let tempName = null;
  let pond = null;
  let isProcessing = false;
  let tempDeleted = false;
  let hasProcessed = false;
  let idleTimer = null;
  const IDLE_MS = 15 * 60 * 1000;

  // Clave documento
  function getDocKey(row){
    return (
      row?.documento?.identificacion?.codigoGeneracion ||
      row?.codigo ||
      JSON.stringify(row?.documento?.identificacion || {})
    );
  }

  let allRows = [];

  // Utils
  function humanBytes(n){
    if(!n&&n!==0) return "";
    const u=['B','KB','MB','GB','TB']; let i=0;
    while(n>=1024&&i<u.length-1){n/=1024;i++;}
    return n.toFixed(1)+' '+u[i];
  }
  function clearError(){ $error.addClass("hidden").text(""); }
  function showError(m){ $error.text(m).removeClass("hidden"); alertError('Error', m); }
  function setReady(ok){ $("#btn-process").prop("disabled", !ok); }
  function esc(s){ return String(s==null?'':s).replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/"/g,'&quot;'); }
  function setHeaderTotal(n){ $foundTotal.text(n==null||n==="" ? "" : `(${n})`); }
  function setReviewTotal(n){ $reviewTotal.text(!n ? "" : `(${n})`); }

  function showMainCards(show){
    const $cards = $(".zipbox-grid > .zipbox-card").not("#review-card");
    if (show){ $cards.removeClass("hidden"); $reviewCard.addClass("hidden"); }
    else { $cards.addClass("hidden"); $reviewCard.removeClass("hidden"); }
  }

  function cleanupTemp(){
    if (!tempName || tempDeleted) return;
    tempDeleted = true;
    const payload = JSON.stringify({ NombreTemporal: tempName });
    try{
      if (navigator.sendBeacon) {
        const blob = new Blob([payload], {type:'application/json'});
        navigator.sendBeacon(REVERT_URL, blob);
      } else {
        fetch(REVERT_URL, { method:'POST', headers:{'Content-Type':'application/json'}, body: payload, keepalive: true }).catch(()=>{});
      }
    } catch(e) {}
  }

  function resetUI(){
    setReady(false);
    document.getElementById('input_name').value = "";
    $statusText.text("Sin archivo");
    $statusPill.addClass("hidden").text("");
    setHeaderTotal("");
    $tbody.html('<tr><td colspan="3" class="muted" style="text-align:center;padding:24px">No hay facturas aún. Carga un archivo.</td></tr>');
    allRows = [];
    for (const k in artMap) delete artMap[k];
    for (const k in artMapsByDoc) delete artMapsByDoc[k];
    $tbodyAll.html('<tr><td colspan="5" class="muted" style="text-align:center;padding:24px">No hay facturas para mostrar.</td></tr>');
    setReviewTotal("");
    if ($chkAll && $chkAll.length) $chkAll.prop("checked", false);
    showMainCards(true);
  }

  function startIdleWatch(){
    stopIdleWatch();
    if (!tempName || hasProcessed) return;
    idleTimer = setTimeout(function(){
      if (tempName && !hasProcessed) {
        showError("Archivo temporal eliminado por inactividad (15 min).");
        cleanupTemp();
        try { pond.removeFiles(); } catch(e){}
        tempName = null;
        resetUI();
        alertWarning('Inactividad', 'Tu archivo temporal fue eliminado.');
      }
    }, IDLE_MS);
  }
  function stopIdleWatch(){ if (idleTimer) { clearTimeout(idleTimer); idleTimer = null; } }
  function bumpIdle(){ if (!tempName || hasProcessed) return; startIdleWatch(); }
  ['click','keydown','mousemove','touchstart','wheel','scroll','focus'].forEach(ev=>{ window.addEventListener(ev, bumpIdle, {passive:true}); });

  // Lista pequeña
  function appendRow(row){
    if (!row) return;
    allRows.push(row);
    if ($tbody.find('td[colspan]').length) $tbody.empty();
    const tr = `
      <tr>
        <td title="${esc(row.codigo)}">${esc(row.codigo)}</td>
        <td><span class="chip">${esc(row.tipo)}</span></td>
        <td>${esc(row.proveedor ?? '—')}</td>
      </tr>`;
    $tbody.append(tr);
  }

  // Parseo robusto
  function extractFirstBalancedJson(s){
    const startIdx = s.search(/[{\[]/); if (startIdx === -1) return null;
    let i=startIdx, stack=[], inStr=false, escp=false;
    for(; i<s.length; i++){
      const ch=s[i];
      if(inStr){ if(escp){escp=false;continue;} if(ch=="\\"){escp=true;continue;} if(ch=='"') inStr=false; continue; }
      if(ch=='"'){inStr=true;continue;}
      if(ch=='{'||ch=='[') stack.push(ch);
      else if(ch=='}'||ch==']'){
        const o=stack.pop();
        if(!o||(o=='{'&&ch!='}')||(o=='['&&ch!=']')) break;
        if(!stack.length) return s.slice(startIdx,i+1);
      }
    }
    return null;
  }
  function safeParseAny(input){
    if (input==null) throw new Error("Respuesta vacía");
    if (typeof input === "object") return { value: input, json: JSON.stringify(input) };
    let txt = String(input).replace(/^\uFEFF/, "").trim();
    if ((txt.startsWith("{") && txt.endsWith("}")) || (txt.startsWith("[") && txt.endsWith("]"))) {
      return { value: JSON.parse(txt), json: txt };
    }
    const block = extractFirstBalancedJson(txt);
    if (block) { return { value: JSON.parse(block), json: block }; }
    const candidates = txt.split(/\r?\n/).map(s=>s.trim()).filter(Boolean);
    for (const c of candidates) { try { return { value: JSON.parse(c), json: c }; } catch {} }
    throw new Error("No se pudo limpiar/parsear la respuesta.");
  }

  // Helpers fila
  function buildEditUrl(dpvId){
    return urlj + "modulo_compras/procesos/editar_doc_proveedor/" + dpvId + "/0/1";
  }

  function addEditBtn($tr, dpvId){
    if(!dpvId) return;
    const $rowBtns = $tr.find('.btnrow');
    if(!$rowBtns.length) return;
    let $a = $rowBtns.find('.btn-edit-dpv');
    if (!$a.length){
      $a = $('<a>', { class: 'btnc btn-xs btn-outline-primary btn-edit-dpv', target: '_blank', text: 'Editar' });
      $rowBtns.append($a);
    }
    $a.attr('href', buildEditUrl(dpvId)).prop('disabled', false).removeClass('is-soft-disabled');
  }

  function disableRowActions($tr){
    $tr.find('.btn-verify').prop('disabled', true).addClass('is-soft-disabled');
    const $proc = $tr.find('.btn-proc');
    if ($proc.length){
      $proc.prop('disabled', true).addClass('is-soft-disabled').text('Hecho');
    } else {
      $tr.find('.btnrow').append('<button class="btnc btn-xs is-soft-disabled" disabled>Hecho</button>');
    }
  }

  function actionsHtmlForRow(r){
    const noSellado = !!r.noSellado;
    const dpvId = r.existeDpv ? Number(r.existeDpv) : null;
    if (noSellado){
      return `
        <div class="btnrow">
          <button class="btnc btn-verify btn-xs btn-outline-success is-soft-disabled" type="button" disabled>Verificar</button>
          <button class="btnc btn-proc   btn-xs btn-outline-primary is-soft-disabled" type="button" disabled>Procesar</button>
          <span class="chip-msg" title="${esc(r.msg || 'Documento no sellado')}">No sellado</span>
        </div>`;
    }
    if (dpvId){
      return `
        <div class="btnrow">
          <button class="btnc btn-verify btn-xs btn-outline-success is-soft-disabled" type="button" disabled>Verificar</button>
          <button class="btnc btn-xs is-soft-disabled" type="button" disabled>Hecho</button>
          <a class="btnc btn-xs btn-outline-primary btn-edit-dpv" target="_blank" href="${buildEditUrl(dpvId)}">Editar</a>
        </div>`;
    }
    return `
      <div class="btnrow">
        <button class="btnc btn-verify btn-xs btn-outline-success"   type="button">Verificar</button>
        <button class="btnc btn-proc   btn-xs btn-outline-primary"   type="button">Procesar</button>
      </div>`;
  }

  // Streaming
  async function procesarEnStreaming(nombreTemporal){
    if (isProcessing) return;
    isProcessing = true;
    clearError();
    $statusText.text("Procesando…");
    // tryWaitStart();
    hasProcessed = true;
    stopIdleWatch();

    try{
      const fd = new FormData();
      fd.append("NombreTemporal", nombreTemporal);
      const res = await fetch(PROCESS_URL, { method:"POST", body: fd });
      if (!res.ok || !res.body) throw new Error("Respuesta HTTP inválida");

      $tbody.html('<tr><td colspan="3" class="muted" style="text-align:center;padding:24px">Procesando…</td></tr>');
      allRows = [];
      setReviewTotal("");
      $tbodyAll.html('<tr><td colspan="5" class="muted" style="text-align:center;padding:24px">Cargando…</td></tr>');

      const reader  = res.body.getReader();
      const decoder = new TextDecoder();
      let buffer    = "";

      while (true) {
        const {done, value} = await reader.read();
        if (done) break;
        buffer += decoder.decode(value, {stream:true});
        const parts = buffer.split("\n");
        buffer = parts.pop();
        for (let line of parts) {
          if (!line.trim()) continue;
          line = line.replace(/^\uFEFF/, '').replace(/^data:\s*/, '').trim();
          const maybe = extractFirstBalancedJson(line);
          if (!maybe) continue;
          let obj; try { obj = JSON.parse(maybe); } catch(e){ continue; }
          if (obj.row) {
            appendRow(obj.row);
          } else if (obj.procesados) {
            setHeaderTotal(obj.procesados);
            $statusText.text(obj.procesados);
          } else if (obj.evento) {
            $statusText.html(obj.evento);
          } else if (obj.ok) {
            if (typeof obj.total !== "undefined") setHeaderTotal(obj.total);
            $statusText.html('<span style="color:#0E77A8">Procesamiento finalizado</span>');
            setReady(true);
            alertSuccess('Inicialización completa', `Se encontraron ${obj.total ?? allRows.length} documentos.`);
          } else if (obj.error) {
            showError(obj.error);
          }
        }
      }

      if (buffer.trim()) {
        try {
          const last = JSON.parse(buffer.replace(/^\uFEFF/,'').replace(/^data:\s*/,'').trim());
          if (last.row) appendRow(last.row);
          if (last.ok) {
            if (typeof last.total !== "undefined") setHeaderTotal(last.total);
            $statusText.html('<span style="color:#0E77A8">Procesamiento finalizado</span>');
            setReady(true);
            alertSuccess('Inicialización completa', `Se encontraron ${last.total ?? allRows.length} documentos.`);
          }
        } catch(e){}
      }

      if (!$tbody.find("tr").length) {
        $tbody.html('<tr><td colspan="3" class="muted" style="text-align:center;padding:24px">No se encontraron DTE válidos.</td></tr>');
        alertWarning('Sin resultados', 'No se encontraron DTE válidos en el archivo.');
      }
    } catch(e){
      showError(e.message || "Error de red al procesar el archivo");
      $tbody.html('<tr><td colspan="3" class="muted" style="text-align:center;padding:24px">No se encontraron DTE válidos.</td></tr>');
    } finally {
      isProcessing = false;
      /*tryWaitClose();*/
    }
  }

  // Tabla grande
  function renderReviewTable(){
    if (!allRows.length){
      $tbodyAll.html('<tr><td colspan="5" class="muted" style="text-align:center;padding:24px">No hay facturas para mostrar.</td></tr>');
      setReviewTotal("");
      if ($chkAll && $chkAll.length) $chkAll.prop("checked", false);
      return;
    }
    let html = "";
    allRows.forEach((r, idx) => {
      const dpvId     = r.existeDpv ? Number(r.existeDpv) : 0;
      const noSellado = !!r.noSellado;
      const msg       = r.msg ? String(r.msg) : '';
      const selectable = !noSellado && !dpvId;
      html += `
        <tr data-index="${idx}"
            data-dpv="${dpvId||''}"
            data-nosellado="${noSellado?1:0}"
            data-msg="${esc(msg)}">
          <td><input type="checkbox" class="chk-row" ${selectable?'':'disabled'}></td>
          <td title="${esc(r.codigo)}">${esc(r.codigo)}</td>
          <td><span class="chip">${esc(r.tipo)}</span></td>
          <td>${esc(r.proveedor ?? "—")}</td>
          <td class="col-actions">
            ${actionsHtmlForRow(r)}
          </td>
        </tr>`;
    });
    $tbodyAll.html(html);
    setReviewTotal(allRows.length);
    if ($chkAll && $chkAll.length) $chkAll.prop("checked", false);
  }

  // Limpieza wrappers tema
  (function removeThemeWrappers(){
    const $rawInput = $('#pondFile');
    if (window.jQuery && $.uniform && typeof $.uniform.restore === 'function') { $.uniform.restore('#pondFile'); }
    const $fake = $rawInput.closest('.uploader');
    if ($fake.length) { $fake.after($rawInput); $fake.remove(); }
    $rawInput.attr('style','');
  })();

  // FilePond
  FilePond.registerPlugin(FilePondPluginFileValidateType);
  pond = FilePond.create(document.querySelector("#pondFile"), {
    credits:false,
    allowMultiple:false,
    allowFileTypeValidation:false,
    maxFiles:1,
    labelIdle: 'Arrastra y suelta o <span class="filepond--label-action">Selecciona un archivo</span><br><small>ZIP o RAR con uno o varios <b>JSON de DTE</b> dentro de una carpeta</small>',
    labelFileProcessingError: 'Archivo inválido',
    server:{
      process:{ url: UPLOAD_URL, method:'POST', ondata: (fd) => fd, onload: (t) => safeParseAny(t).json, onerror: (e) => showError("Error al subir: " + e) },
      revert:{
        url: REVERT_URL, method:'POST', headers: { 'Content-Type':'application/json' },
        onload: (r) => r, onerror: (e) => showError("Error al revertir: " + e),
        data: (uniqueFileId) => {
          try{
            const pondFile = FilePond.find(uniqueFileId);
            const sid = safeParseAny(pondFile.serverId).value;
            return JSON.stringify({ NombreTemporal: sid.NombreTemporal });
          }catch{ return null; }
        }
      }
    },
    onaddfile: ()=>{ $statusText.text("Preparando archivo…"); clearError(); /*tryWaitStart();*/ },
    onprocessfileprogress: (file, progress) => { $statusText.text(`Subiendo… ${Math.round(progress*100)}%`); },
    onprocessfile: (error, file) => {
      /*tryWaitClose();*/
      if(error){ showError("Archivo inválido o error al subir."); return; }
      try{
        const sid = safeParseAny(file.serverId).value;
        tempName = sid.NombreTemporal; tempDeleted = false; hasProcessed = false;
        document.getElementById('input_name').value = tempName;
        const size = humanBytes(file.fileSize);
        $statusText.html(`Subido: ${sid.NombreReal || file.filename} (${size}). Pulsa <b>INICIALIZAR</b> para procesar.`);
        $statusPill.removeClass("hidden").text(sid.NombreReal || file.filename);
        startIdleWatch();
        alertSuccess('Archivo cargado', 'Listo para inicializar.');
      }catch{ showError("Respuesta inesperada del servidor."); }
    }
  });

  // DnD
  document.addEventListener('dragenter', ()=> $drop.addClass('is-over'));
  document.addEventListener('dragleave', ()=> $drop.removeClass('is-over'));
  document.addEventListener('drop', ()=> $drop.removeClass('is-over'));

  // Botones principales
  $("#btn-reset").on("click", function(){
    if(!tempName){ showError("Primero sube un archivo."); return; }
    procesarEnStreaming(tempName);
  });

  $("#btn-process").on("click", function(){
    if (!allRows.length){
      showError("No hay facturas para revisar. Asegúrate de haber presionado INICIALIZAR y que el procesamiento haya finalizado.");
      return;
    }
    clearError();
    renderReviewTable();
    showMainCards(false);
  });

  $("#btn-cancel").on("click", function(){
    clearError(); stopIdleWatch(); cleanupTemp();
    try { pond.removeFiles(); } catch(e){}
    tempName=null; hasProcessed=false; resetUI();
    alertWarning('Carga cancelada', 'Se eliminó el archivo temporal y se reinició la vista.');
  });

  // Vista grande
  if ($btnBack && $btnBack.length){ $btnBack.on("click", function(){ showMainCards(true); }); }

  // Seleccionar todos (solo habilitados)
  if ($chkAll && $chkAll.length){
    $chkAll.on("change", function(){
      const checked = $(this).is(":checked");
      $tbodyAll.find('.chk-row').each(function(){
        if (!this.disabled){
          this.checked = checked;
          $(this).closest('tr').toggleClass('is-selected', checked);
        }
      });
    });
  }
  // Marca visual por fila
  $tbodyAll.on('change', '.chk-row', function(){
    $(this).closest('tr').toggleClass('is-selected', this.checked);
  });

  // Ver detalle
  $tbodyAll.on("click", ".btn-view", function(){
    const idx = $(this).closest("tr").data("index");
    const r = allRows[idx];
    alert(`Código: ${r.codigo}\nTipo: ${r.tipo}\nProveedor: ${r.proveedor ?? '—'}\nTotal/Detalle: ${r.detalle ?? '—'}`);
  });

  // Conteo pendientes por fila
  function countUnresolvedForRow(row){
    const cuerpo = (row && row.documento && row.documento.cuerpoDocumento) || [];
    const dkey   = getDocKey(row);
    const docMap = artMapsByDoc[dkey] || {};
    let missing = 0;
    for (const it of cuerpo){
      const num = Number(it.numItem);
      if (!docMap[num]) missing++;
    }
    return missing;
  }

  // Procesar 1
  $tbodyAll.on("click", ".btn-proc", async function(){
    const $btn = $(this);
    const $tr  = $btn.closest('tr');
    const idx  = $tr.data("index");
    const r    = allRows[idx];
    const isNoSeal = Number($tr.data('nosellado')) === 1 || !!r.noSellado;
    const dpvId    = Number($tr.data('dpv')) || (r.existeDpv ? Number(r.existeDpv) : 0);

    if (isNoSeal){ alertWarning('Documento no sellado', ($tr.data('msg') || r.msg || 'No es posible procesar este DTE.')); return; }
    if (dpvId){ window.open(buildEditUrl(dpvId), '_blank'); return; }

    try{
      const missing = countUnresolvedForRow(r);
      if (missing > 0){
        const ok = await Swal.fire({
          icon: 'warning',
          title: '¿Continuar sin resolver todo?',
          html: `<p><b>${missing}</b> producto(s) aún no están creados o seleccionados.</p><p>Puedes pulsar <b>Verificar</b> para resolverlos ahora.</p>`,
          showCancelButton: true,
          confirmButtonText: 'Sí, procesar de todos modos',
          cancelButtonText: 'Cancelar'
        }).then(r => r.isConfirmed);
        if (!ok) return;
      }

      $btn.prop("disabled", true).text("Procesando…");
      tryWaitStart();

      const dkey   = getDocKey(r);
      const docMap = artMapsByDoc[dkey] || {};
      const payload = { NombreTemporal: tempName || $("#input_name").val(), dte: r, documento: r.documento || null, artMap: docMap };

      const res  = await fetch(PROCESS_ONE_URL, {
        method: "POST",
        headers: { "Content-Type": "application/json", "X-Requested-With": "XMLHttpRequest" },
        credentials: "same-origin",
        body: JSON.stringify(payload)
      });

      const raw  = await res.text();
      let data; try { data = JSON.parse(raw); } catch { throw new Error(raw || "Respuesta no es JSON"); }
      if (!res.ok || !data || data.ok !== true) { throw new Error((data && data.error) ? data.error : `HTTP ${res.status}`); }

      $tr.addClass('processed'); disableRowActions($tr); addEditBtn($tr, data.dpv_id);
      alertSuccess('Documento guardado', `DPV #${data.dpv_id || ''} procesado correctamente.`);
    } catch(e){
      alertError('Error al procesar', e.message || String(e));
      $btn.prop("disabled", false).text("Procesar");
    } finally{ tryWaitClose(); }
  });

  // Procesar TODOS (opcional: reutiliza seleccionados)
  if ($btnProcAll && $btnProcAll.length){
    $btnProcAll.on("click", function(){
      if ($chkAll && $chkAll.length){
        $chkAll.prop('checked', true).trigger('change');
      } else {
        // fallback: marcar habilitados
        $tbodyAll.find('.chk-row:not(:disabled)').prop('checked', true).trigger('change');
      }
      $btnProcSel.trigger('click');
    });
  }

  // Procesar SELECCIONADOS con validación única
  if ($btnProcSel && $btnProcSel.length){
    $btnProcSel.on("click", async function(){
      const $rows = $tbodyAll.find('tr').has('.chk-row:checked');
      if (!$rows.length){ alertWarning('Sin selección', 'No hay filas seleccionadas.'); return; }

      let totalSel=0, noseal=0, existed=0, verificados=0, sinVerificar=0;
      const meta = [];

      for (const el of $rows.toArray()){
        const $tr = $(el);
        const idx = $tr.data("index");
        const r   = allRows[idx];
        const isNoSeal = Number($tr.data('nosellado')) === 1 || !!r.noSellado;
        const dpvId    = Number($tr.data('dpv')) || (r.existeDpv ? Number(r.existeDpv) : 0);
        const missing  = countUnresolvedForRow(r);
        meta.push({ $tr, r, isNoSeal, dpvId, missing });
        totalSel++;
        if (isNoSeal) noseal++;
        else if (dpvId) existed++;
        else if (missing > 0) sinVerificar++;
        else verificados++;
      }

      const procesables = totalSel - noseal - existed;
      if (procesables <= 0){
        alertWarning('Nada que procesar', `Seleccionados: ${totalSel} | No sellado: ${noseal} | Ya existe: ${existed}`);
        return;
      }

      let allowUnverified = false;
      if (sinVerificar > 0){
        const res = await Swal.fire({
          icon: 'warning',
          title: 'Revisión antes de procesar',
          html: `
            <div style="text-align:center">
              <p><b>Seleccionados:</b> ${totalSel}</p>
              <p><b>Listos (verificados):</b> ${verificados}</p>
              <p><b>Sin verificar:</b> ${sinVerificar}</p>
              ${noseal ? `<p><b>No sellado (omitidos):</b> ${noseal}</p>` : ''}
              ${existed ? `<p><b>Ya existen (omitidos):</b> ${existed}</p>` : ''}
              <hr><p>¿Cómo quieres continuar?</p>
            </div>
          `,
          showCancelButton: true,
          showDenyButton: true,
          denyButtonText: 'Procesar todo (incluye sin verificar)',
          confirmButtonText: 'Procesar solo verificados',
          cancelButtonText: 'Cancelar',
          reverseButtons: true
        });
        if (res.isDismissed) return;
        allowUnverified = res.isDenied;
      }

      let okCount=0, errCount=0, skipCount=0, skippedUnverified=0;

      try{
        $(this).prop("disabled", true).text("Procesando…");
        tryWaitStart();

        for (const it of meta){
          const { $tr, r, isNoSeal, dpvId, missing } = it;
          if (isNoSeal){ skipCount++; continue; }
          if (dpvId){   skipCount++; continue; }
          if (missing > 0 && !allowUnverified){ skipCount++; skippedUnverified++; continue; }

          const dkey   = getDocKey(r);
          const docMap = artMapsByDoc[dkey] || {};
          const payload = { NombreTemporal: tempName || $("#input_name").val(), dte: r, documento: r.documento || null, artMap: docMap };

          try{
            const res  = await fetch(PROCESS_ONE_URL, {
              method: "POST",
              headers: { "Content-Type": "application/json", "X-Requested-With": "XMLHttpRequest" },
              credentials: "same-origin",
              body: JSON.stringify(payload)
            });

            const raw  = await res.text();
            let data; try { data = JSON.parse(raw); } catch { throw new Error(raw || "Respuesta no es JSON"); }
            if (!res.ok || !data || data.ok !== true) { throw new Error((data && data.error) ? data.error : `HTTP ${res.status}`); }

            $tr.addClass('processed'); disableRowActions($tr); addEditBtn($tr, data.dpv_id);
            okCount++;
          } catch(_){
            errCount++;
          }
        }

        $(this).text("Procesar seleccionados");
        const extras = [];
        if (noseal)  extras.push(`No sellado: ${noseal}`);
        if (existed) extras.push(`Ya existe: ${existed}`);
        if (skippedUnverified) extras.push(`Omitidos sin verificar: ${skippedUnverified}`);
        const msg = `Ok: ${okCount}` + (skipCount?` | Omitidos: ${skipCount}`:'') + (errCount?` | Errores: ${errCount}`:'') + (extras.length? ` | ${extras.join(' | ')}` : '');
        if (errCount===0) alertSuccess('Procesamiento en lote', msg);
        else alertWarning('Procesamiento en lote', msg);
      } catch(e){
        alertError('Error en lote', e.message || String(e));
      } finally {
        $(this).prop("disabled", false);
        tryWaitClose();
      }
    });
  }

  // Borrado al salir
  function onLeave(){ cleanupTemp(); }
  window.addEventListener('pagehide', onLeave, {capture:true});
  window.addEventListener('beforeunload', onLeave);

  // Modal verificación
  async function openVerifyModal(row){
    const payload = { documento: row.documento || null };
    tryWaitStart();
    const res  = await fetch(VERIFY_ONE_URL, {
      method: "POST",
      headers: { "Content-Type": "application/json", "X-Requested-With": "XMLHttpRequest" },
      credentials: "same-origin",
      body: JSON.stringify(payload)
    });

    const raw  = await res.text();
    let data; try { data = JSON.parse(raw); } catch { tryWaitClose(); throw new Error(raw || "Respuesta no es JSON"); }

    if (!res.ok) { tryWaitClose(); throw new Error(`HTTP ${res.status}`); }
    const hasOk = Object.prototype.hasOwnProperty.call(data, 'ok');
    if (hasOk && data.ok !== true) { tryWaitClose(); throw new Error(data.error || "Operación no exitosa"); }

    const html = data.html || (data.data && data.data.html) || "";
    if (!html) { tryWaitClose(); throw new Error("La respuesta no trae 'html'"); }

    await Swal.fire({
      title: 'Revisión del documento',
      html: html,
      width: '75rem',
      focusConfirm: false,
      showConfirmButton: false,
      showCloseButton: true,
      customClass: { title: 'swal2-title-sm', popup: 'swal2-top-modal' },
      didOpen: (modal) => {
        tryWaitClose();
        attachVerifyModalHandlers(modal, row);
        $(modal).find(".sel-candidato").css('width','220px').select2({ width: 'style', dropdownParent: $(modal) });

        const dkey = getDocKey(row);
        if (!artMapsByDoc[dkey]) artMapsByDoc[dkey] = Object.create(null);

        $(modal).find('tbody tr').each(function(){
          const num  = Number($(this).data('num'));
          const aid  = Number($(this).find('.badge-match').data('art-id'));
          if (aid) { artMapsByDoc[dkey][num] = aid; $(this).addClass('bg-success'); }
        });

        const docMap = artMapsByDoc[dkey];
        $(modal).find('tbody tr').each(function(){
          const $tr  = $(this);
          const num  = Number($tr.data('num'));
          const sel  = $tr.find('.sel-candidato');
          if (!sel.length) return;
          const pre = docMap[num];
          if (!pre) return;
          if (sel.find(`option[value="${pre}"]`).length){
            sel.val(String(pre)).trigger('change', [{silent:true}]);
          }
        });
      }
    });
    tryWaitClose();
  }

  function attachVerifyModalHandlers(modal, row){
    const dkey = getDocKey(row);
    if (!artMapsByDoc[dkey]) artMapsByDoc[dkey] = Object.create(null);
    const docMap = artMapsByDoc[dkey];

    $(modal).on('change', '.sel-candidato', function (e, meta) {
      const $tr    = $(this).closest('tr');
      const num    = Number($tr.data('num'));
      const val    = Number($(this).val());
      const silent = !!(meta && meta.silent === true);
      if (val) { docMap[num] = val; $tr.addClass('bg-success'); if (!silent) alertSuccess('Seleccionado', 'Se asignó el producto al ítem.'); }
      else { delete docMap[num]; $tr.removeClass('bg-success'); if (!silent) alertWarning('Sin selección', 'Se desasignó el producto del ítem.'); }
    });

    $(modal).on('click', '.btn-crear-producto', async function(){
      const $btn = $(this);
      const $tr  = $btn.closest('tr');
      const num  = Number($tr.data('num'));
      const payload = {
        nombre: $btn.data('def-name')   || $tr.children().eq(2).text().trim(),
        codigo: $btn.data('def-code')   || $tr.children().eq(1).text().trim(),
        tipo:   $btn.data('tipo-name'),
        medida: String($btn.data('def-medida') || $tr.children().eq(3).text().trim()),
        precio: String($btn.data('def-precio') || $tr.children().eq(4).text().trim()),
        prov_id: Number($btn.data('prov-id')) || null
      };
      if (!payload.nombre){ Swal.fire({icon:'warning',text:'Falta nombre'}); return; }

      try{
        $btn.prop('disabled', true).text('Creando…');
        tryWaitStart();
        const res = await fetch(CREATE_ART_URL, {
          method:'POST', headers:{'Content-Type':'application/json','X-Requested-With':'XMLHttpRequest'},
          credentials:'same-origin', body: JSON.stringify(payload)
        });
        const js = await res.json().catch(()=>({}));
        if (!res.ok || !js || js.ok !== true || !js.art_id){ throw new Error((js && js.error) || `HTTP ${res.status}`); }
        docMap[num] = Number(js.art_id);
        $tr.addClass('bg-success');
        alertSuccess('Producto creado', 'Se vinculó al ítem automáticamente.');
        await Swal.close();
        await openVerifyModal(row);
      } catch(e){
        Swal.fire({icon:'error', text: e.message || String(e)});
        alertError('Error al crear producto', e.message || String(e));
        $btn.prop('disabled', false).text('Crear nuevo');
      } finally{ tryWaitClose(); }
    });

    $(modal).on('change', '#chk-create-all', function(){
      const checked = $(this).is(':checked');
      $(modal).find('.chk-to-create').prop('checked', checked);
    });

    $(modal).on('click', '#btn-crear-seleccionados', async function(){
      const $btn = $(this);
      const $rows = $(modal).find('tbody tr').filter(function(){
        return $(this).find('.chk-to-create').is(':checked') && $(this).find('.btn-crear-producto').length > 0;
      });
      if (!$rows.length){
        Swal.fire({icon:'info', text:'No hay filas seleccionadas para crear.'});
        alertWarning('Sin selección', 'No hay filas marcadas para crear.');
        return;
      }

      try{
        $btn.prop('disabled', true).text('Creando…');
        tryWaitStart();
        let ok=0, err=0;
        for (const el of $rows.toArray()){
          const $tr  = $(el);
          const num  = Number($tr.data('num'));
          const $b   = $tr.find('.btn-crear-producto');
          const payload = {
            nombre: $b.data('def-name')   || $tr.children().eq(2).text().trim(),
            codigo: $b.data('def-code')   || $tr.children().eq(1).text().trim(),
            tipo:   $btn.data('tipo-name'),
            medida: String($b.data('def-medida') || $tr.children().eq(3).text().trim()),
            precio: String($b.data('def-precio') || $tr.children().eq(4).text().trim()),
            prov_id: Number($b.data('prov-id')) || null
          };
          if (!payload.nombre) continue;

          try{
            const res = await fetch(CREATE_ART_URL, {
              method:'POST', headers:{'Content-Type':'application/json','X-Requested-With':'XMLHttpRequest'},
              credentials:'same-origin', body: JSON.stringify(payload)
            });
            const js = await res.json().catch(()=>({}));
            if (!res.ok || !js || js.ok !== true || !js.art_id){ $tr.addClass('bg-danger'); err++; continue; }
            docMap[num] = Number(js.art_id);
            $tr.addClass('bg-success');
            $tr.find('.chk-to-create').prop('checked', false).prop('disabled', true);
            $tr.find('.btn-crear-producto, .sel-candidato').prop('disabled', true);
            ok++;
          } catch(_){ $tr.addClass('bg-danger'); err++; }
        }

        await Swal.close();
        await openVerifyModal(row);
        if (err===0) alertSuccess('Creación masiva', `Se crearon ${ok} producto(s).`);
        else alertWarning('Creación masiva', `Creados: ${ok} | Errores: ${err}`);
      } catch(e){
        Swal.fire({icon:'error', title:'Error en creación masiva', text: e.message || String(e)});
        alertError('Error en creación masiva', e.message || String(e));
      } finally{
        $btn.prop('disabled', false).text('Crear seleccionados');
        tryWaitClose();
      }
    });
  }

  // Abrir modal verificar
  $tbodyAll.on("click", ".btn-verify", async function(){
    const $btn = $(this);
    const $tr  = $btn.closest("tr");
    const idx  = $tr.data("index");
    const r    = allRows[idx];

    const isNoSeal = Number($tr.data('nosellado')) === 1 || !!r.noSellado;
    const dpvId    = Number($tr.data('dpv')) || (r.existeDpv ? Number(r.existeDpv) : 0);
    if (isNoSeal){ alertWarning('Documento no sellado', ($tr.data('msg') || r.msg || 'No es posible verificar este DTE.')); return; }
    if (dpvId){ alertWarning('Documento ya registrado', 'Este DTE ya fue ingresado. Usa el botón “Editar”.'); return; }

    try{
      $btn.prop("disabled", true).text("Verificando…");
      await openVerifyModal(r);
      tryWaitClose();
    } catch(e){
      Swal.fire({ icon: 'error', title: 'Error', text: (e && e.message) ? e.message : String(e) });
      alertError('Error al abrir verificación', e.message || String(e));
      tryWaitClose();
    } finally { $btn.prop("disabled", false).text("Verificar"); }
  });

})();
