var cantidad_decimales = ($.trim($("#decimales").val()) != "" && parseInt($("#decimales").val()) > 0) ? parseInt($("#decimales").val()) : 2;
$(document).ready(function () {
    
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});
    $(".soloNumeros").numeric('.');
    $(".select-edit").select2('destroy');
    $(".select-edit").hide();

    $("#chkAfectaInventario").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnAfectaInv").val(1);
            } else {
                $("#hdnAfectaInv").val(0);
            }
        }
    });


    /********Retaceo Consolidado*************/
    $("#chkAplicarPeso").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnAplicarPeso").val(1); 
                $(".porcRetaceo").prop('disabled', 'true');
                //limpio los txt retaceo de productos
                $(".porcRetaceo").val('');
                $("#txtTotalRetaceoPorc").val('0.0000');
                $(".peso").prop('disabled', null);
            } else {
                $(".peso").prop('disabled', 'true');
                $(".porcRetaceo").prop('disabled', null);  
                //limpio los txt peso de productos
                $(".peso").val('');  
                $("#txtTotalPesoPorc").val('0.0000');
                $("#hdnAplicarPeso").val(0);
            }
        }
    });
    /********Fin Retaceo Consolidado*************/

    $(".btn-close").live('click', function () {

        var iframe = $(this).data('iframe');
        alerta_confirm_ajax(cerrar_modal, iframe, 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        maxDate: 0,
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#frm-retaceo").validate({
        ignore: [],
        rules: {
            txtNumRetaceo: {required: true},
            txtPoliza: {required: true},
            txtAduana: {required: true},
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        invalidHandler: function (form, validator) {
            var errors = validator.numberOfInvalids();
            if (errors) {
                var primerElemento = validator.errorList[0].element;
                var posiciones = primerElemento.offsetTop;
                $("html, body").animate({scrollTop: posiciones}, 1000);
            }
        },
        submitHandler: function (form) {
            if ($('#tbGastos tr').length == 0) {
                crear_alerta('error', 'Gastos', 'Debe ingresar al menos un gasto.');
                return false;
            }

            var aplicaPeso = $("#chkAplicarPeso").is(":checked");
            var error = 0;
            if (aplicaPeso) {
                $(".peso").each(function(){
                if($.trim($(this).val()) == ''){
                    error = 1;
                }
            })
            }
            
            

            var totalRetaceoPorc = $("#txtTotalRetaceoPorc").val();
            if ((totalRetaceoPorc < 100 || totalRetaceoPorc > 100) && !aplicaPeso) {
                crear_alerta('error', 'Retaceo', 'El porcentaje total debe ser 100%');
                $("html, body").animate({scrollTop: $("#txtTotalRetaceoPorc").offsetTop}, 1000);
                return false;
            }
            if(error == 1){
                crear_alerta('error', 'Peso', 'Debe especificar el peso.');
                return false;
            }

            form.submit();
        }
    });

    // calculos de retaceo
    $(".porcRetaceo").live("keyup", function () {
        var valor = $(this).val();
        calcularTotalRetaceo();
    });
    // calculos de retaceo por peso
    $(".peso").live("keyup", function () {
        var valor = parseFloat($(this).val());
        total = 0;
        $('.peso').each(function(){
            total += (!isNaN(parseFloat($(this).val())))?parseFloat($(this).val()):0;
        });

        if ((!isNaN(valor)) && (valor != 0) && (total >0)) {
        $("#txtTotalPesoPorc").val(total);
        calcularTotalRetaceo();
        }
       
    });

    $("#slcProveedor").change(function () {
        var proveedor = $(this).val();
        $("#slcDocumento").html('');
        $("#slcDocumento").select2();
        if ($.trim(proveedor) != '' && parseInt(proveedor) > 0) {
            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_documentos_proveedor',
                data: {proveedor: proveedor},
                type: 'POST',
                dataType: 'json',
                success: function (data) {
                    $("#slcDocumento").html(data.documentos);
                    $("#slcDocumento option[value='0']").text('');
                    $("#slcDocumento option[value='0']").val('');
                    $("#slcDocumento").select2({placeholder: "Seleccione una opción"});
                }
            });
            // *************************************************************** \\
            $("#txtOtroNoDoc").attr("disabled", true);
        } else {
            $("#txtOtroNoDoc").attr("disabled", false);
        }
    });

    $("#slcDocumento").change(function () {
        var documento = $(this).val();
        $("#txtMonto").html('');
        if ($.trim(documento) != '' && parseInt(documento) > 0) {
            wait.start();
            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_monto_detalle_dpv/1',
                data: {documento: documento},
                type: 'POST',
                dataType: 'json',
                success: function (data) {
                    $("#txtMonto").val(number_format(data, cantidad_decimales,'.',''));
                    wait.close();
                }
            });
        }
    });

    var row = 0;
    if ($('#tbGastos tr').length > 0) {
        row = $("#tbGastos tr").length;
    }

    $("#agregar").click(function () {
        var gasto               = $("#slcGastos").val();
        var gastoText           = $("#slcGastos option:selected").text();
        var gastoHtml           = getOpcionesSelect("slcGastos");
        var gastoPorc           = $("#slcGastos option:selected").data('porcentaje');
        var proveedor           = (parseInt($('#slcProveedor').val()) > 0) ? parseInt($('#slcProveedor').val()) : '';
        var proveedorHtml       = getOpcionesSelect("slcProveedor");
        var proveedorText       = ($('  #slcProveedor').val() > 0) ? $('#slcProveedor option:selected').text() : "";
        var documento           = (parseInt($('#slcDocumento').val() > 0)) ? parseInt($('#slcDocumento').val()) : '';
        var documentoText       = $('#slcDocumento option:selected').text();
        var documentoHtml       = getOpcionesSelect("slcDocumento");
        var monto               = $('#txtMonto').val();
        var otroNoDoc           = $('#txtOtroNoDoc').val();
        var productos_txt       = "";
        var productos_id        = "";
        var codigosx            = '';
        var contador_productos  = 0;
        var detalle_documento   = "";
        
        if (!parseInt(documento) > 0 && $.trim(otroNoDoc) != "") {
            documentoText = otroNoDoc;
        }

        if ($("#tbProductos").length > 0) {
            $("#slc_productos  :selected").each(function (i,sel) {
                productos_txt       += $(sel).text() + "</br>";
                productos_id        += $(sel).attr("id") + ",";
                detalle_documento   += $(sel).data("detalle") + ",";
                codigosx            += $(sel).data("keyx")+ ",";
                contador_productos++;
            });
            
            if ( contador_productos == 0 ) {
                $("#slc_productos option").each(function (i,sel) {
                    productos_txt       += $(sel).text() + "</br>";
                    productos_id        += $(sel).attr("id") + ",";
                    detalle_documento   += $(sel).data("detalle") + ",";
                    codigosx            += $(sel).data("keyx")+ ",";
                    contador_productos++;
                });
            }
        }
        //alert(detalle_documento);
        detalle_documento   = detalle_documento.slice(0,-1);
        productos_id        = productos_id.slice(0,-1);
        codigosx            = codigosx.slice(0,-1);

        var html = '';

        if (gasto == '' || monto == '') {
            crear_alerta('error', 'Detalle de Gastos', 'Debe completar los campos requeridos.');
            return false;
        }

        //if ($("#tr_" + gasto + proveedor + documento).length > 0) {
        if ($("#tr_" + documento).length > 0) {
            crear_alerta('error', 'Detalle de Gastos', 'Ese registro ya fue ingresado.');
            return false;
        }

        /*if (proveedor > 0 && documento == '') {
            crear_alerta('error', 'Detalle de Gastos', 'Debe seleccionar un documento del proveedor.');
            return false;
        }*/

        var totalGastos     = parseFloat($("#txtTotalGastos").val().replace(/,/g, ""));
        var totalRegistros  = parseFloat($("#txtTotalProdcutos").val().replace(/,/g, ""));


        totalGastos += parseFloat(monto);

        if (totalGastos >= totalRegistros) {
            crear_alerta('info', 'Detalle de Gastos', 'El monto total de gastos debe ser menor al total del los productos ($' + number_format(totalRegistros, cantidad_decimales, '.',',') + ')');
            //return false;
        }
        if ($("#tr_" + gasto + proveedor + documento).length > 0) {
            crear_alerta('error', 'Detalle de Gastos', 'El gasto ya fue agregado.');
            return false;
        }

        //monto = number_format(monto, 2);

        html += '<tr id="tr_' + gasto + proveedor + documento +'" data-id="' + row + '">';

        html += '<td>';
        html += '<input type="text" class="text tables-input selects-text porcentajeGastos" data-porcentaje="' + gastoPorc + '" value="' + gastoText + '" readonly="readonly"/>';
        html += '<select id="slcGastos_' + row + '" name="gastos[]" data-id="' + row + '" style="display:none;" class="selects-edit">' + gastoHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input selects-text" value="' + proveedorText + '" readonly="readonly"/>';
        html += '<select id="slcProveedor_' + row + '" data-dep="slcDocumento_' + row + '" name="proveedores[]" data-id="' + row + '" style="display:none;" class="selects-edit proveedores">' + proveedorHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input selects-text" value="' + documentoText + '" readonly="readonly"/>';
        html += '<select id="slcDocumento_' + row + '" name="documentos[]" data-id="' + row + '" style="display:none;" class="selects-edit proveedores">' + documentoHtml + '</select>';
        html += '<input type="hidden" id="slcOtroNoDoc_' + row + '" name="OtroNodocumentos[]" data-id="' + row + '" value="' + $.trim(otroNoDoc) + '">';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtMonto_' + row + '" name="montos[]" class="text tables-input-show tables-input soloNumeros montosGastos" extras="." value="' + number_format(monto, cantidad_decimales, '.','') + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += productos_txt;
        html += '<input type="hidden" class="gastos_cantidad_productos" id="txt_cantidadproductos_' + row + '" name="txt_cantidadproductos[]" value="'+contador_productos+'"/>';
        html += '<input type="hidden" class="gastos_productos" id="txt_productos_' + row + '" name="txt_productos[]" value="'+productos_id+'"/>';
         html += '<input type="hidden" class="gastos_productos_x" id="txt_productos_x' + row + '" name="txt_productosx[]" value="'+codigosx+'"/>';
        html += '<input type="hidden" id="txt_detalles_docs_' + row + '" name="txt_detalles_docs[]" value="'+detalle_documento+'"/>';
        html += '</td>';

        html += '<td>';
        ///html += '<button type="button" class="btn btn-primary btn-mini btnGuardarProd" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;"><input type="hidden" value="6" id="txtest">Guardar</button>';
        //html += '<button type="button" class="btn btn-primary btn-mini btnEditProd" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;"><input type="hidden" value="6" id="txtest">Editar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelGst" style="float:left;height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
        html += '</td>';

        $("#tblGastos").append(html);

        $('#slcGastos option:selected').removeAttr('selected');
        $('#slcGastos').select2({placeholder: "Seleccione una opción"});
        $('#slcProveedor option:selected').removeAttr('selected');
        $('#slcProveedor').select2({placeholder: "Seleccione una opción"});
        $('#slcDocumento option:selected').removeAttr('selected');
        $('#slcDocumento').select2({placeholder: "Seleccione una opción"});
        $('#txtMonto').val('');
        $('#txtOtroNoDoc').attr('disabled', false);
        $('#txtOtroNoDoc').val('');

        row = row + 1;
        //Se actualiza el total
        calcularTotalGastos();
        //calcularTotalRetaceo();
        actualizar_porcentaje();

        $('#slc_productos option:selected').removeAttr('selected');
        $('#slc_productos').select2({placeholder: "Seleccione una opción"});
    });//En of function agregar

    //Eliminar Gasto
    $(".btnDelGst").live("click", function () {
        var parent = $(this).parent().parent();

        $("#" + parent[0].id).remove().delay(300);

        //Se actualizan los totales
        calcularTotalGastos();
        //calcularTotalRetaceo();
        actualizar_porcentaje();

    });

    //Carpeta de Anexos
    var anx = 0;
    var folder_anx_temp = $('#carpeta_temporal').attr('value');
    var ruta_anx = urlj + 'inicio/guardar_gral/' + folder_anx_temp;
    new FUload('btnAnexo', ruta_anx, {
        start: function (file) {
            wait.start();
        },
        sucess: function (data) {
            wait.close();

            if ($.trim(data) !== "") {

                var a_exten = $.trim(data).split('.');

                var exten = "." + a_exten[(a_exten.length - 1)];
                // verifica existencia del mismo documento en la carpeta.
                var preview = "<tr id='preview" + anx + "' style='display:none;' class='preview_documento'>";
                if (a_exten[(a_exten.length - 1)] === 'png' || a_exten[(a_exten.length - 1)] === 'jpg' || a_exten[(a_exten.length - 1)] === 'jpeg' || a_exten[(a_exten.length - 1)] === 'pdf') {
                    preview += "<td><a  title=\"Ver Anexo\" class='ver_en_modal fancybox-buttons' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                } else {
                    preview += "<td><a target='_blank' title=\"Ver Anexo\" class='' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                }

                preview += "<img id='pre" + anx + "' src='' width='88' height='88' class='imagen_documento verAnexo'></a></td>";
                preview += "<td><input maxlength='75' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc[]' value='" + $.trim(data).replace(exten, '') + "'><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc" + anx + "'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                //preview+="<td><input maxlength='50' readonly='readonly' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc"+i+"' value='"+$.trim(data).replace(exten,'')+"'><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc"+i+"'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                preview += "<td style='vertical-align:middle !important; width:30px !important;'><img  style='display:none;' src='" + urlj + "media/editar_documento.png" + "' title='Editar' value='titulo_doc" + anx + "' class='editar_documento'/></td>";
                preview += "<td style='background:#E1E7F0!important;'><a href=\"javascript: void(0);\" title=\"Eliminar Anexo\" class='eliminar_imagen' id='delete" + anx + "' custom='' custom_id=''><img class='quitar_documento' src='" + urlj + "media/eliminar_documento.png" + "' title='Eliminar documento'></a></div>";
                preview += "<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></td></tr>";

                $("#previews").append(preview).show(300);
                $("#awesome_form").append("<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></div>");
                $("#preview" + anx).fadeIn(400);

                //document.getElementById('pre'+i).src=base+"media/imagenes/sistema/pdf.png";
                document.getElementById('pre' + anx).src = urlj + "media/imagenes/sistema/" + a_exten[(a_exten.length - 1)] + ".png";
                document.getElementById('ruta' + anx).value = $.trim(data);
                document.getElementById('delete' + anx).custom = $.trim(data);
                document.getElementById('delete' + anx).custom_id = i;
                valor = document.getElementById('pre' + anx).src;

                // $('input[name=titulo_doc'+i+']').focus();
                // nombre_doc=$('input[name=titulo_doc'+i+']').val();

                anx++;
                $(".eliminar_imagen, .verAnexo").tooltip();
            } else { //el formato es incorrecto
                crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
            }
        }
    });

    $(".eliminar_imagen").live("click", function (event) {
        event.preventDefault();

        url = this.custom;
        id_key = this.custom_id;
        id = this.id;
        $.ajax({
            type: 'POST',
            url: urlj + 'inicio/eliminar_imagen_gral/' + folder_anx_temp,
            data: {url: url},
            success: function (data) {
                $("#ruta" + id_key).val("");
                $("#" + id).parent().parent().remove().delay(300);
            }
        });
    });

    $(".delete_anexo").live('click', function (event) {
        event.preventDefault();
        var anexo = $(this).data('anexo');
        $("#anexo_" + anexo).remove().delay(500);
    });

    $(".verAnexo").fancybox({
        openEffect: 'elastic',
        closeEffect: 'elastic',
        href: $(this).attr('href'),
        type: 'iframe',
        helpers: {
            title: {
                type: 'inside'
            }
        }
    });

    //Modal de Prorrateos
    $(".prorrateosModal").fancybox({
        width: '90%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        //closeBtn: false,
        //hideOnOverlayClick: true,
        helpers: {
            //overlay: {closeClick: false} // prevents closing when clicking OUTSIDE fancybox 
        },
        beforeLoad: function () {
            var prod = $(this.element[0]).attr('data-prod');
            $("#slcProrrateo_" + prod).select2({placeholder: "Seleccione una opción"});
            $("#slcProrrateo_" + prod).select2('disable');
            $("#slcCentroCosto_" + prod).select2({placeholder: "Seleccione una opción"});
        },
        beforeClose: function () {

        }
    });

    $(".selectorProrrateo").live('change', function () {

        var slcElementoHijo = $(this).data('centro');
        var prorrateo = $(this).val();
        var prod = $(this).data('prod');

        $("#tbProrrateo_" + prod).html('');
        if (prorrateo != '') {
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {prorrateo: prorrateo},
                url: urlj + 'modulo_compras/procesos/get_detalle_prorrateo',
                success: function (data) {
                    $("#" + slcElementoHijo).html(data.opciones);
                    $("#" + slcElementoHijo + " option[value='0']").text('');
                    $("#" + slcElementoHijo + " option[value='0']").val('');
                    $("#" + slcElementoHijo).select2({placeholder: 'Seleccione una opción'});
                }
            });
        }
    });

    $(".selectorCentroCostos").live('change', function () {

        var centro = $(this).val();
        var porcentaje = 0;
        var prod = $(this).data('prod');

        if (centro > 0) {
            porcentaje = $("#" + this.id + " option:selected").data('porcentaje');
            $("#txtPorcentaje_" + prod).val(porcentaje);
        } else {
            $("#txtPorcentaje_" + prod).val('');
        }
    });

    $(".btnAgregarCentroCosto").live('click', function () {
        var html = '';
        var prod = $(this).data('prod');

        var centro_costo = $("#slcCentroCosto_" + prod).val();
        var centro_costo_nombre = $("#slcCentroCosto_" + prod + " option:selected").text();
        var porcentaje = $("#txtPorcentaje_" + prod).val();
        var cuenta_contable = $("#slcCentroCosto_" + prod + " option:selected").data('cuenta');


        var totalProd = parseFloat($("#tr_" + prod).find('.totalProductos').val());


        var total = (porcentaje / 100) * totalProd;

        if (centro_costo == '' && porcentaje == '') {
            crear_alerta('error', 'Prorrateo', 'Debe completar todos los campos.');
            return false;
        }

        var idTr = "tr_cec_" + centro_costo;

        if ($("#" + idTr).length > 0) {
            crear_alerta('error', 'Prorrateo', 'El centro de costo ya fue ingresado.');
            return false;
        }

        var totalPorc = 0;
        $("#tbProrrateo_" + prod + " > tr .porcentajeCentroCos").each(function () {
            var valor = $(this).val();
            valor = parseFloat(valor);
            totalPorc += valor;
        });

        if (totalPorc > 100) {
            crear_alerta('error', 'Prorrateo', 'El porcentaje no debe ser mayor al 100%');
            return false;
        }

        html += '<tr id="' + idTr + '" data-id="' + centro_costo + '" data-prod="' + prod + '"><td>';
        html += '<input type="hidden" name="centroCostos_' + prod + '[]" id="hdnCentroCosto_' + centro_costo + '" value="' + centro_costo + '"/>';
        html += centro_costo_nombre + '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input" value="' + cuenta_contable + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtPorcentaje_' + centro_costo + '" name="porcentajesCec_' + prod + '[]" class="text tables-input-show tables-input porcentajeCentroCos" value="' + porcentaje + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input totalCentroCos" id="txtTotalCec_' + centro_costo + '" name="totalCec_' + prod + '[]" value="' + number_format(total, cantidad_decimales, '.','') + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<button type="button" class="btn btn-primary btn-mini btnGuardarCec" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;">Guardar</button>';
        html += '<button type="button" class="btn btn-primary btn-mini btnEditCec" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;">Editar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelCec" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;">Eliminar</button>';
        html += '</td>';

        html += '</tr>';

        $("#tbProrrateo_" + prod).append(html);

        $("#slcCentroCosto_" + prod + " option:selected").removeAttr('selected');
        $("#slcCentroCosto_" + prod).select2({placeholder: "Seleccione una opción"});
        $("#txtPorcentaje_" + prod).val('');
    });

    $(".btnEditCec").live('click', function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id + " .select-text").hide();

        $("#" + parent[0].id + " .select-edit").select2();
        $("#" + parent[0].id + " .select2-container").css('width', '100%');
        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');

        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarCec").show();
    });

    //Guardar 
    $(".btnGuardarCec").live('click', function () {
        var parent      = $(this).parent().parent();
        var tbody       = $(this).parent().parent().parent();
        var id_parent   = $("#" + parent[0].id).data('id');
        var prod        = $("#" + parent[0].id).data('prod');

        var totalProd   = parseFloat($("#tr_" + prod).find('.totalProductos').val());

        var txtPorcentaje = $("#txtPorcentaje_" + id_parent).val();

        var total       = 0;

        if (txtPorcentaje == '' || txtPorcentaje == 0) {
            crear_alerta('error', 'Prorrateo', 'Debe ingresar un porcentaje válido');
            return false;
        }

        //$("#" + parent[0].id + " .select-edit").select2('destroy');
        //$("#" + parent[0].id + " .select-edit").hide();
        var totalPorc   = 0;
        $("#" + tbody[0].id + " > tr .porcentajeCentroCos").each(function () {
            var valor   = $(this).val();
            valor       = parseFloat(valor);
            totalPorc   += valor;
        });

        if (totalPorc > 100) {
            crear_alerta('error', 'Prorrateo', 'El porcentaje no debe ser mayor al 100%');
            return false;
        }

        total = (txtPorcentaje / 100) * totalProd;
        $("#txtTotalCec_" + id_parent).val(number_format(total, cantidad_decimales, '.',''));

        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');
        $(this).hide();
        $("#" + parent[0].id + " .btnEditCec").show();
    });

    //Eliminar Producto
    $(".btnDelCec").live("click", function () {
        var parent = $(this).parent().parent();

        $("#" + parent[0].id).remove().delay(300);
    });

    $(".btnGuardarPro").live('click', function () {
        jQuery.fancybox.close();
    });
});

function reestablecerAnexo() {
    $('#txtTituloAnexoDoc').val('');
    $("#txtTituloAnexoDoc").attr('readonly', 'readonly');
    $("#txtTituloAnexoDoc").removeAttr('style');
    $("#del_anexo").attr('href', '#');
    $("#link_anexo").attr('href', '#');
    $("#ruta_temporal").val('');
    $("#titulo_temporal").val('');
    $("#link_anexo, #del_anexo ").hide('slow');
    $("#btnAnexoDoc").show('slow');

}

function generarTotal() {

    var total = 0
    $(".txtUniReprog").each(function () {

        var valor = $(this).val();

        if (valor == "") {
            total += 0;
        } else {
            total += parseFloat(valor);
        }
    });

    total = parseFloat(total).toFixed(0);
    $("[id$=TxtTotalUniReprog]").val(total);

    $(".txtUniReprog").each(function () {

        var valor = $(this).val();

        if (valor == "") {
            valor = 0;
        }

        var Trparent = $(this).parent().parent();

        var txtPorcent = Trparent.find(".txtPorcReprog")
        total = parseFloat(total);
        var porcentaje = (valor / total) * 100;

        txtPorcent.attr("valor", porcentaje);
        txtPorcent.val(parseFloat(porcentaje).toFixed(1) + "%");
    });

    totalPorcent = 0;

    $(".txtPorcReprog").each(function () {

        var valor = $(this).attr("valor");
        if (valor == "") {
            totalPorcent += 0;
        } else {
            totalPorcent += parseFloat(valor);
        }
    });

    totalPorcent = parseFloat(totalPorcent).toFixed(1);
    $("[id$=TxtTotalRprog]").val(totalPorcent + "%");
}


function getOpcionesSelect(idElemento) {

    var opciones = "";
    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        opciones += this.outerHTML;
        
    });

    return opciones;
}

function calcularTotalRetaceo() {
    var TotalPorcRetaceo    = 0;
    var TotalRetaceo        = 0;
    var totalGastos         = parseFloat($("#txtTotalGastos").val().replace(/,/g, ""));
    var totalFactura        = (!isNaN(parseFloat($("#txtTotalProdcutos").val().replace(/,/g, ""))))?parseFloat($("#txtTotalProdcutos").val().replace(/,/g, "")):0;

    var totalRetaceo        = totalGastos + totalFactura;
    if ($("#tbProductos").length > 0) {
        $("#tbProductos > tr").each(function () {
            var producto        = $(this).attr('id');
            var retaceo         = 0;
            var porcentaje      = parseFloat($(this).find('.porcRetaceo').data('porcentaje'));
            var precio_unitario = parseFloat($(this).find('.preciosUnidades').val());
            var cantidad        = parseFloat($(this).find('.cantidadProducto').val());
            var peso            = (!isNaN(parseFloat($(this).find('.peso').val())))?parseFloat($(this).find('.peso').val()):0;


            // Evaluamos los gastos por el codigo del producto
            tieneGasto = get_gasto(producto);
            var esPeso = false;
            if ($('#chkAplicarPeso').is(':checked')){
                pesoSum        = (!isNaN(parseFloat($('#txtTotalPesoPorc').val())))?parseFloat($('#txtTotalPesoPorc').val()):0.00;
                
                porcentaje     = (!isNaN(porcentaje))?(peso / pesoSum):0;
                $(this).find('.porcRetaceo').val(number_format(porcentaje,cantidad_decimales, '.', ''));
                esPeso = true;

            }else{
                porcentaje = (isNaN(parseFloat($(this).find('.porcRetaceo').val())))?0:parseFloat($(this).find('.porcRetaceo').val());
            }


            if ((tieneGasto > 0) && (porcentaje >0)) {      
                if (esPeso) {
                    col1       = tieneGasto * porcentaje;
                }else{
                    col1        = tieneGasto * (porcentaje / 100);
                }          
                
                $(this).find('.retaceoX').val(number_format(col1, cantidad_decimales,'.',''));
                col2        = col1 / cantidad;
                $(this).find('.incrementoX').val(number_format(col2, cantidad_decimales,'.',''));
                //Precio final
                precio_final = col2 + precio_unitario;
                retaceo      = precio_final * cantidad;

                $(this).find('.retaceoProducto').val(number_format(retaceo, cantidad_decimales, '.', ''));
                $(this).find('.preciosFinales').val(number_format(precio_final, cantidad_decimales, '.', ''));
            
                TotalPorcRetaceo += porcentaje;
                TotalRetaceo     += retaceo;

            }else{
            
            var montoGasto  = ((porcentaje / 100) * tieneGasto) / cantidad;
            var precio_final= precio_unitario + montoGasto;

            retaceo         = (cantidad * precio_final);

            $(this).find('.retaceoProducto').val(number_format(retaceo, cantidad_decimales, '.', ''));
            $(this).find('.preciosFinales').val(number_format(precio_final, cantidad_decimales, '.', ''));
            

            $(this).find('.retaceoX').val(number_format(0.00));            
            $(this).find('.incrementoX').val(number_format(0.00));

            TotalPorcRetaceo += porcentaje;
            TotalRetaceo     += retaceo;
            
            }     
            var idProducto   = $(this).find('.productoDetalle').val();
            calcularProrrateos(idProducto, retaceo);       
        });

        //Total = number_format(subTotal, 2);
    }
    

    if (number_format(TotalPorcRetaceo, cantidad_decimales, '.','') < 100 || number_format(TotalPorcRetaceo, cantidad_decimales, '.','') > 100) {
        //alert(TotalPorcRetaceo);
        $("#txtTotalRetaceoPorc").addClass('error');
    } else {
        $("#txtTotalRetaceoPorc").removeClass('error');
    }

    //$("#txtTotalRetaceoPorc").val(number_format(TotalPorcRetaceo, cantidad_decimales,'.', ''));
    $("#txtTotalRetaceo").val(number_format(TotalRetaceo, cantidad_decimales,'.', ''));


    if (number_format(TotalPorcRetaceo, cantidad_decimales, '.','') < 100 || number_format(TotalPorcRetaceo, cantidad_decimales, '.','') > 100) {
        //alert(TotalPorcRetaceo);
        $("#txtTotalRetaceoPorc").addClass('error');
    } else {
        $("#txtTotalRetaceoPorc").removeClass('error');
    }

    $("#txtTotalRetaceoPorc").val(number_format(TotalPorcRetaceo, cantidad_decimales,'.', ''));
    $("#txtTotalRetaceo").val(number_format(TotalRetaceo, cantidad_decimales,'.', ''));
}

function get_gasto(articulo){
    var total = 0.00;
    $('.gastos_productos_x').each(function(){       
        var id_aplica = $(this).val().split(',');
        var gasto     = parseFloat($(this).closest('tr').find('.montosGastos').val());
        numero        = id_aplica.length;
        for (var i = 0; i < id_aplica.length; i++) {
            if (articulo == id_aplica[i]) {
                total += gasto;
            }     
        } 


    })
    return total;
}

function calcularTotalGastos() {
    var Total = 0;
    if ($("#tbGastos").length > 0) {
        var subTotal = 0;
        $("#tbGastos tr").each(function () {
            var monto = $(this).find('.montosGastos').val();
            subTotal += parseFloat(monto.replace(/,/g, ""));

        });

        Total = number_format(subTotal, cantidad_decimales);
    }

    $("#txtTotalGastos").val(number_format(Total, cantidad_decimales));
}

function cerrar_modal(iframe) {
    if (iframe == 1) {
        parent.jQuery.fancybox.close();
    } else {
        jQuery.fancybox.close();
    }
}

function getModalProrrateo(idProducto) {

    var slcProrrateos = $('#slcProrrateos').html();

    var html = "";
    //Inicio
    html += '<div id="modalProrrateo_' + idProducto + '" style="display: none;">';

    html += '<div class="box">';
    html += '<div class="title"><h4><span></span></h4></div>';
    html += '<div class="content">';

    html += '<div class="form-row row-fluid">';
    //Elemento Select Padre

    html += '<div class="span12" style="margin-bottom: 20px;"><div class="row-fluid"><label class="form-label span3" id="">Tabla:<b style="color:orange;">*</b></label><div class="span7 controls">';
    html += '<select id="slcProrrateo_' + idProducto + '" data-prod="' + idProducto + '" data-centro="slcCentroCosto_' + idProducto + '" class="nostyle selectorProrrateo">' + slcProrrateos + '</select>';
    html += '</div></div></div>';

    //Elemento Centro costo
    html += '<div class="span5"><div class="row-fluid"><label class="form-label span3" id="">Centro de Costo: <b style="color:orange;">*</b></label><div class="span6 controls">';
    html += '<select id="slcCentroCosto_' + idProducto + '" data-prod="' + idProducto + '" data-sector="txtPorcentaje_' + idProducto + '" class="nostyle selectorCentroCostos"></select>';
    html += '</div></div></div>';

    //Elemento Porcentaje
    html += '<div class="span5"><div class="row-fluid"><label class="form-label span3" id="">Porcentaje<b style="color:orange;">*</b></label><div class="span6 controls">';
    html += '<input type="text" id="txtPorcentaje_' + idProducto + '" data-prod="' + idProducto + '" class="text cantidadProducto soloNumeros" extras="." value=""/>';
    html += '</div></div></div>';

    html += '<div class="span2"><div class="row-fluid"><div class="span6 controls">';
    html += '<button type="button" class="btn btn-info btn-primary btnAgregarCentroCosto" data-prod="' + idProducto + '" style="float: right;height: 30px;margin-top: 5px;">Agregar</button>';
    html += '</div></div></div>';

    //Tabla
    html += '<div class="span12" style="overflow-x: scroll;padding: 10px 0px 0px 5px;margin-bottom: 2%;">';
    html += '<div class="contenedor">';
    html += '<table class="responsive table table-bordered contenedor" id="tblProrrateo_' + idProducto + '">';
    html += '<thead><tr><td>Centro de Costo</td><td>Cuenta</td><td>Porcentaje</td><td>Total($)</td><td>Acciones</td></tr></thead>';
    html += '<tbody id="tbProrrateo_' + idProducto + '"></tbody>';
    html += '</table>';

    html += '</div>';

    //Acciones
    html += '<div class="form-actions" style="text-align: center;">';
    html += '<button type="button" class="btn btn-success btnGuardarPro" id="btnGuardarPro_' + idProducto + '" value="1" style="margin-right: 10px;"><span class="icon16 icomoon-icon-checkmark white"></span>Guardar</button>';
    html += '<a onclicks="javascript:$.fancybox.close();" class="btn btn-danger btn-close" id=""><span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar</a>';
    html += '</div>';

    html += '</div>';
    html += '</div>';
    //End
    html += '</div>';

    html = html.replace(/\n/g, "");

    return html;
}

function calcularProrrateos(idProd, TotalProd) {

    if ($("#tbProrrateo_" + idProd).length > 0) {

        $("#tbProrrateo_" + idProd + " > tr").each(function () {
            var idTr = $(this).attr('id');
            var porcentaje = parseFloat($("#" + idTr).find('.porcentajeCentroCos').val());
            var totalFila = (porcentaje / 100) * TotalProd;
            $("#" + idTr).find('.totalCentroCos').val(number_format(totalFila, cantidad_decimales, '.',''));
        });
    }
}

function actualizar_porcentaje() {
    //se debere recalcular el porcentaje.
    var totalGastos     = parseFloat($("#txtTotalGastos").val().replace(/,/g, ""));
    var totalFactura    = parseFloat($("#txtTotalProdcutos").val().replace(/,/g, ""));
    var global_retaceo  = totalGastos +totalFactura;

    if ( $("#tbProductos > tr").length > 0 ) {
        $("#tbProductos > tr").each(function () {          
            var idProducto              = $(this).find('.productoDetalle').val();
            var sub_total               = parseFloat($(this).find('.subtotalProductos').val().replace(/,/g, ""));
            var cant_pro                = parseFloat($(this).find('.cantidadProducto').val().replace(/,/g, "")); 
            var porcentaje              = parseFloat($(this).find('.porcRetaceo').val());
            var total_retaceo_temporal  = totalFactura;
            var retaceo_producto        = sub_total;
          
            if ($("#tbGastos > tr").length > 0) {
                $( "#tbGastos >  tr" ).each(function() {
                    var array_productos     = $(this).find('.gastos_productos').val();
                    var productos           = array_productos.split(',');
                    var cantidad_productos  = parseInt($(this).find('.gastos_cantidad_productos').val());
                    var monto_gastos        = parseFloat($(this).find('.montosGastos').val());                    
                    var cant_prod_option    = $("#slc_productos option").size();  
                    total_retaceo_temporal += monto_gastos;

                    if (parseInt(cant_prod_option) != parseInt(cantidad_productos)) {
                        $.each(productos, function(index, value) {
                            if (idProducto == value) {                            
                                retaceo_producto += (monto_gastos/cantidad_productos);
                            }
                            porcentaje = (retaceo_producto/total_retaceo_temporal) * 100;
                        });
                    } else {              
                        retaceo_producto += ((monto_gastos*porcentaje)/100);
                    }    
                });              
            }

            new_precio_unitario = parseFloat(retaceo_producto / cant_pro);
            $(this).find('.porcRetaceo').val( number_format(porcentaje, cantidad_decimales, '.', '') );
            $(this).find('.retaceoProducto').val( number_format(retaceo_producto, cantidad_decimales, '.', '') );
            $(this).find('.preciosFinales').val( number_format(new_precio_unitario, cantidad_decimales, '.', '') );
                
        });
        $('#txtTotalRetaceo').val( number_format(global_retaceo, cantidad_decimales, '.', '') );
    }
}