$(document).ready(function () {
    //URL PATH
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    $('select').select2({placeholder: 'Seleccione una opción'});

    $("#slcCheque").change(function(event) {
        var cheque = $(this).val();
        var caja = $("#id_caja").val();
        var lcc = $("#id_lcc").val();
        var tipo = $("#tipo_frm").val();
        var primerCheque = 0;

        if($("#cheque_first").length>0){
            primerCheque = $("#cheque_first").val();
        }
        if(cheque>0){
            $("#txtNumDoc").removeAttr('readonly');
            wait.start('Obteniendo montos...');
            $.ajax({
                async: true,
                url: urlj+'modulo_compras/procesos/get_monto_disponible',
                type: "POST",
                dataType: "json",
                data: {cheque: cheque, caja: caja, lcc: lcc, vMonto: 1, primerCheque: primerCheque, tipo: tipo},
                success: function(data) {
                    if(data!=''){
                        if(data.flag==0){
                            crear_alerta('error', 'Reintegro de caja chica', 'El monto del cheque no logra cubrir el monto necesario para los comprobantes.');			        	
                            $("#slcCheque option:first").attr('selected', 'selected');
                            $('#slcCheque').select2({placeholder:"Seleccione una opción"});
                            $("#montoCheque").text("");
                            $("#montoDisponible").text("");
                            $("#montoAsignado").text("");
                        }else{
                            $("#montoCheque").text(number_format(data.che_monto, data.decimales));
                            $("#monto").val(number_format(data.che_monto, data.decimales));
                            $("#montoDisponible").text(number_format(data.monto, data.decimales));
                            //var total = parseFloat(data.che_monto) + parseFloat(data.monto);
                            $("#montoAsignado").text(number_format(data.asignado, data.decimales));
                        }
                    }else{
                        $("#montoCheque").text("");
                        $("#montoDisponible").text("");
                        $("#montoAsignado").text("");
                    }
                    wait.close();
                },
                error: function(data) {
                    wait.close();
                    crear_alerta("info","Obtener montos","No fue posible obtener los montos correspondientes.");
                }
            });
        }else{
            $("#montoCheque").text("");
            $("#montoDisponible").text("");
            $("#montoAsignado").text("");
        }
    });

    $("#slcTransferencias").change(function(event) {
        var nota = $(this).val();
        var caja = $("#id_caja").val();
        var lcc = $("#id_lcc").val();
        var tipo = $("#tipo_frm").val();
        var primerCheque = 0;
        if($("#cheque_first").length>0){
            primerCheque = $("#cheque_first").val();
        }
        if(nota > 0){
            $("#txtNumDoc").removeAttr('readonly');////////////////////////////////////////
            wait.start('Obteniendo montos...');
            $.ajax({
                async: true,
                url: urlj+'modulo_compras/procesos/get_monto_nota_disponible',
                type: "POST",
                dataType: "json",
                data: {
                    nota: nota, 
                    caja: caja,
                    lcc: lcc, 
                    vMonto: 1, 
                    primerCheque: primerCheque, 
                    tipo: tipo
                },
                success: function(data) {
                    if(data!=''){
                        if(data.flag==0){
                            crear_alerta('error', 'Reintegro de caja chica', 'El monto del cheque no logra cubrir el monto necesario para los comprobantes.');                      
                            $("#slcCheque option:first").attr('selected', 'selected');
                            $('#slcCheque').select2({placeholder:"Seleccione una opción"});
                            $("#montoNota").text("");
                            $("#montoDisponible").text("");
                            $("#montoAsignado").text("");
                        }else{
                            $("#montoNota").text(number_format(data.nta_monto, data.decimales));
                            $("#montoNta").val(number_format(data.nta_monto, data.decimales));
                            $("#montoDisponible").text(number_format(data.monto, data.decimales));
                            $("#montoAsignado").text(number_format(data.asignado, data.decimales));
                        }
                    }else{
                        $("#montoNta").val("");
                        $("#montoNota").text("");
                        $("#montoDisponible").text("");
                        $("#montoAsignado").text("");
                    }
                },
                error: function(data) {
                    wait.close();
                    crear_alerta("info","Obtener montos","No fue posible obtener los montos correspondientes.");
                }
            });
            wait.close();
        }else{
            $("#montoNta").val("");
            $("#montoNota").text("");
            $("#montoDisponible").text("");
            $("#montoAsignado").text("");
        }
    });

    $("#chkTipoReintegro").iButton({
        'labelOn':  'Transferencia',
        'labelOff': 'Por Cheque',
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnTipoReintegro").val(1);
                $("#slcCheque").val('').trigger('change');
                $("#reintegro_cheque").hide();
                $("#reintegro_nota").show();
            } else {
                $("#hdnTipoReintegro").val(0);
                $("#slcTransferencias").val('').trigger('change');
                $("#reintegro_cheque").show();
                $("#reintegro_nota").hide();
            }
        }
    });


    $("#frm-reintegroCaja").validate({
        ignore: "", 
        rules:{
            slcCheque:{
                required:function() {
                    return $("#hdnTipoReintegro").val() == 0
                }
            },
            slcTransferencias:{
                required:function() {
                    return $("#hdnTipoReintegro").val() == 1
                }
            }

        }, 
        messages: { 
        	slcCheque: "Campo requerido",
            slcTransferencias: "Campo requerido"
        },
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').html(error);
        },
        submitHandler: function(form){  
            form.submit();   
        } 
    });


	$("#cancelar").click(function(event){
        alerta_confirm_ajax(regresar,data,'Confirmar eliminar registro','Los datos que insertaste no han sido guardados. ¿Éstas seguro que quieres regresar a la lista?');
	});

}); // End jQuery

function regresar(){
  id=$("#id_lcc").val();
  window.location.href=urlj+'modulo_compras/procesos/grid_reintegro_caja/'+id;
}