var global_proyecto     = $("#slcProyecto").val();
var global_presupuesto  = $("#slc_presupuesto").val();   
var global_general      = $("#slc_actividad_general").val();
var global_especifico   = $("#slc_actividad_espeficifica").val();
$(document).ready(function () {
    calcularTotales();
    $("#info_area").hide();
    if ($("#editar_orc").length > 0) {
        var psp_slct = $('#slc_presupuesto option:selected').data('area');
        if (typeof psp_slct != 'undefined') {
            $("#nombre_area").val(psp_slct);            
            $("#info_area").show();
        }
    }
    $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
    $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
    $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
    // envio de requisicion con ajax
    $('#slcRequisicion').change(function(){
        var id = $('#slcRequisicion').val();
        if (id>0) {
            if ($('#slcRequisicion').data('requisicion')===1) {
                alerta_confirm(window.gSateliteWhite.baseUrl('modulo_compras/procesos/agregar_orden_compra/'+id),"Los Cambios realizados no se Guardaran", "¿Esta seguro que desea Cambiar de Requisicion?");
            }else{
                window.location.href = window.gSateliteWhite.baseUrl('modulo_compras/procesos/agregar_orden_compra/'+id);
            }
        }
    });
    ////////////////EDITAR////////////////
    $('#slcRequisicion2').change(function(){
        var id = $('#slcRequisicion2').val();
        $.ajax({
            type: 'POST',
            url: window.gSateliteWhite.baseUrl('modulo_compras/procesos/editar_orden_compra_datos_rxi'),
            dataType: 'json',
            data: {
                'id': id
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                wait.close();
                $('#slcPrioridad').html(data.datos_prioridad);
                $('#slcPrioridad').select2();
                $('#slcTipo').html(data.tipo);
                $('#slcTipo').select2();
                $('#slcProyecto').html(data.proyectos);
                $('#slcProyecto').select2();
                $('#slcProveedor').select2("val", "");
                $('#tbProductos').html(data.tabla);
            },
            error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            }
        });
    });
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    // Ocultar categoria
    $("#div-categorias").hide();
    $("body").on("change","#tbProductos tr input[type='text']", function(event) {
        id = $(this).parent().parent().data('id');
        valor_calculo = $("#txtSubtotal_"+id).val(); 
        $("#txtSuma_"+id).val(valor_calculo);
    });

    $('select').select2({placeholder: 'Seleccione una opción'});
    $(".soloNumeros").numeric();
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        minDate: 0
    });

    $(".detalle_fanc").click(function() {
        aplicar_fancy();
    });

    //Carga impuesto modal
    $('#detalle_impuesto').on('click', '#btn_agregar_impuesto_modal', function () {
        event.preventDefault();
        var impuesto = $("#slc_impuestos_modal").val();
        var repetido = false;
        if ( $('#datagried tbody tr').length == 0 ){
            crear_alerta("error","Productos y/o Servicios","Por favor agregue productos o servicios.");
            return false;
        }
        if (impuesto == ""){
            crear_alerta("error","Impuestos","Por favor seleccione un impuesto.");
            return false;
        }
        if ( $('#tabla_impuesto tbody tr').length == 0 ){
            $("#grid_impuesto").html("");
        }
        $( "#tabla_impuesto tbody tr" ).each(function( index ) {
            if ( $(this).attr("id") == "impuesto_"+impuesto && $(this).hasClass("quitar_impuesto") == false ){
                crear_alerta("error","Impuesto","Impuesto ya fue agregado.");
                repetido = true;
                return false;
            }
        });
        if (repetido == true){
            return false;
        }
        var porcentaje  = $("#slc_impuestos_modal option:selected").data("porcentaje");
        var tipo        = $("#slc_impuestos_modal option:selected").data("type");
        var nombre      = $('#slc_impuestos_modal option:selected').text();
        var monto       = calcular_impuestos_retenciones(porcentaje,tipo);
        table   = '<tr id="impuesto_'+impuesto+'" class="nuevo_impuesto" data-impuesto="'+impuesto+'" data-porcentaje="'+porcentaje+'">'+
                            '<td>'+nombre+'</td>'+
                            '<td>'+number_format(porcentaje, 0)+'</td>'+
                            '<td>'+number_format(monto, 2)+'</td>'+
                            '<td><button type="button" class="btn btn-danger btn-mini btn_borrar_impuestos" style="float:left; height:30px;width:50px;">Eliminar</button></td>'+
                            '</tr>';
        $("#grid_impuesto").append(table);
        $("#slc_impuestos_modal option:selected").removeAttr('selected');
        $("#slc_impuestos_modal").select2();
    });

    //eliminar impuesto
    $('#tabla_impuesto tbody').on('click', '.btn_borrar_impuestos', function () {
        $(this).parent().parent().css("display","none");
        $(this).parent().parent().addClass("quitar_impuesto");
        if ( $('#tabla_impuesto tbody tr').length == 0 ){
            $("#grid_impuesto").html('<td style="text-align: center;" colspan="4">No se encontraron registros</td>');
        }
    });

    //Se cargan impuestos en modal
    $("#btn_detalle_impuesto").on('click',function(){
        $("#slc_impuestos_modal option:selected").removeAttr('selected');
        $("#slc_impuestos_modal").select2();
        var arreglo = [];
        $(".precios_sumar").each(function(e){
            var correlativo = $(this).data('correlativo');
            var producto = $(this).data('prod');
            var tabla = $("#tr_"+producto);;
            var htmlImpuestos = $("#lnkImpuestos_" + correlativo).attr('data-html');
            var cantidad_fila = $("#txtCantidad_" + correlativo).val();        
            $("#slcMultiCargos").html(htmlImpuestos);
            $("#slcMultiCargos").select2();
            //Datos
            var suma = parseFloat($(this).val());            
            var impuesto_por_array = [];
            var impuesto_array = $("#slcMultiCargos").val();
            var tipo_array = [];

            $("#slcMultiCargos option:selected").each(function () {
                var porcentajeImpuesto = $(this).data('porcentaje');
                impuesto_por_array.push(porcentajeImpuesto);                
                var tipo = $(this).data('type');
                tipo_array.push(tipo);
            });            
            $("#slcMultiCargos").html("");    
            if (impuesto_array != null) {
                impuesto_array.forEach(function(value, index, arr){
                    var nombre_temp = $("#slc_impuestos_modal option[value='"+value+"']").text();//obtiene el nombre del impuesto
                    var cantidad_anterior = (arreglo[value])?arreglo[value].monto:0;//obtiene la cantidad existente en el arreglo
                    if ( tipo_array[index] == 1) {
                        var impuesto_monto = parseFloat(suma*(impuesto_por_array[index]/100)); //suma los porcentajes
                    } else {
                        var impuesto_monto = parseFloat( (impuesto_por_array[index])) * parseFloat(cantidad_fila); //suma los porcentajes
                    }
                    if ( typeof arreglo[value] === "undefined"){
                        arreglo[value] = {
                            valor: value,
                            nombre: nombre_temp,
                            porcentaje: impuesto_por_array[index],
                            monto: impuesto_monto
                        };
                    } else {
                        var new_impuesto_monto = impuesto_monto + arreglo[value]["monto"];
                        arreglo[value] = {
                            valor: value,
                            nombre: nombre_temp,
                            porcentaje:  impuesto_por_array[index],
                            monto: new_impuesto_monto
                        };
                    }
                });
            }
        });
        if(arreglo.length > 0){
            var table = '';
            $("#grid_impuesto").html('');
            arreglo.forEach(function(value, index, arr){
                table =    '<tr id="impuesto_'+value.valor+'" data-impuesto="'+value.valor+'" data-porcentaje="'+value.porcentaje+'">'+
                            '<td>'+value.nombre+'</td>'+
                            '<td>'+number_format(value.porcentaje, 2)+'</td>'+
                            '<td>'+number_format(value.monto, $("#hdnDecimal").val() )+'</td>'+
                            '<td><button type="button" class="btn btn-danger btn-mini btn_borrar_impuestos" style="float:left; height:30px;width:50px;">Eliminar</button></td>'+
                            '</tr>';
                $("#grid_impuesto").append(table);
            });
        } else{
            $("#grid_impuesto").html('<td style="text-align: center;" colspan="4">No se encontraron registros</td>');
        }
    });

    // Guardar impuestos
    $('#detalle_impuesto').on('click', '#guardar_modal_impuesto', function () {
        var imp_add          = [];
        var imp_del          = [];
        $( "#tabla_impuesto tbody tr" ).each(function( index ) {
            var id          = $(this).data("impuesto");
            var porcentaje  = $(this).data("porcentaje");
            if ($(this).hasClass("quitar_impuesto")) {
               imp_del.push(id);
            }
            if($(this).hasClass("nuevo_impuesto")) {
                imp_add.push(id);
            }
        });
        if (imp_del.length > 0 || imp_add.length > 0) {
            $(".precios_sumar").each(function(e) {
                var correlativo = $(this).data('correlativo');
                agregar_nuevo_calculos(correlativo,imp_add,imp_del);
            });
            crear_alerta("info","Impuesto","Se realizaron cambios en los productos y/o servicios.");
        }
        $.fancybox.close();
    });

    $("#slcProveedor").change(function(){
        if($(this).val()>0){
            condicion = $("#slcProveedor option:selected").attr('cod');
            desc      = $("#slcProveedor option:selected").attr('detalle');
            if(condicion>0){
                $("#slcCondicionPago option[value="+condicion+"]").attr('selected', 'selected');
                $("#slcCondicionPago").select2();
            }else{
                $("#slcCondicionPago").attr('placeholder', 'Seleccione una opción');
                $("#slcCondicionPago option:first").attr('selected', 'selected');
                $("#slcCondicionPago").select2();
            }
            if (desc.length>0) {
                $('#detalle_condicion').val(desc);
                $('#detalle_con').css('display','block');
            }else{
                 $('#detalle_condicion').val('');
                 $('#detalle_con').css('display','none');
            }
        }else{
            $("#slcCondicionPago").attr('placeholder', 'Seleccione una opción');
            $("#slcCondicionPago option:first").attr('selected', 'selected');
            $("#slcCondicionPago").select2();
            $('#detalle_condicion').val('');
            $('#detalle_con').css('display','none');
        }
        traer_detalle_condicion($(this).val());
    });

    function traer_detalle_condicion(id){

    }

    $(".btn-close").live('click', function () {
        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    var id_bod;
    var id_cat;
    var id_prod;
    $("#frm-orden").validate({
        ignore: [],
        rules: {
            fecha: {required: true},
            //txtDescripcion: {required: true},
            // slcArea: {required: true},////// SE ELIMINO CONDICION 7/MAY/21
            slcTipo: {required: true},
            slcProveedor: {required: true},
            // txtFechaEntrega: {required: true},
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#datagried tr').length <= 1) {
                crear_alerta('error', 'Productos', 'Debe seleccionar al menos un producto');
                return false;
            }
            var vacio = 0;
            $("#datagried tr .cantidadProducto").each(function () {
                var ctdad = $(this).val();
                if (parseFloat(ctdad) <= 0 || ctdad == '') {
                    vacio++;
                }
            });
            if (vacio > 0) {
                crear_alerta('error', 'Productos', 'Debe asignar una cantidad a todos los productos');
                return false;
            }
            var error = false;
            $("#datagried tr .preciosUnidades").each(function () {
                var valor = $(this).val();
                if (valor == 0 || valor == '') {
                    error = true;
                    return false;
                }
            });
            if (error) {
                crear_alerta('error', 'Productos', 'Debe asignarle un precio a todos los productos');
                return false;
            }
            if ( $("#slc_presupuesto").val() != "" ) {
                if ( $("#slc_actividad_espeficifica").val() == "" ) {
                    crear_alerta('error', 'Actividad específica', 'Seleccione una actividad específica');
                    return false;
                }   
            }
            var aprobar_presupuesto = evaluar_presupuesto($("#slc_presupuesto").val()); 
            if ( aprobar_presupuesto == false) {
                return false;
            }
            quitar_atributo();
            wait.start();
            form.submit();
        }
    });


    $(".positive").numeric({negative: false}, function () {
        alert("No negative values");
        this.value = "";
        this.focus();
    });

    $(".positive").live("keyup", function () {
        if ($(this).val() <= 0.0) {
            campo = $(this).attr("id");
            $(this).addClass('error');
            $('#validar_' + campo).text('La cantidad debe ser mayor a cero');
        }
    });

    $("#documento").blur(function () {
        var doc_numero = $(this).val();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/gestion_productos/validar_documento',
            data: {id: doc_numero},
            success: function (data) {
                if (data.drop != null) {
                    crear_alerta("info", "Aviso", "Por favor elija otro número de documento.");
                    $("#documento").focus().val('');
                }
            }
        });
    });

    $("#editar").live("click", function () {
        event.preventDefault();
        id_row = $(this).attr('name');
        var nuevo_cant = 1
        do {
            nuevo_cant = prompt("Ingrese nuevo valor de cantidad(Mayor a cero)", "1");

        } while ((nuevo_cant <= 0 || String(parseFloat(nuevo_cant)) == "NaN") && (nuevo_cant != null));
        if (nuevo_cant != null) {
            document.getElementById('cantidadl' + id_row + '').innerHTML = nuevo_cant;
            $('#cantidadi' + id_row + '').val(nuevo_cant);
        }
    });

    $("#remove").live("click", function () {
        $(this).parents("tr").remove();
    });//Fin de eliminar

    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    //Calculo de la URL PATH

    $("#slcBodega").change(function () {
        var bodega = $('#slcBodega').val();
        var tipoReq = $("#slcTipo").val();
        if (bodega > 0 && tipoReq > 0) {
            cargar_categorias(bodega, tipoReq);
        } else {
            $("#div-categorias").html('');
            $("#slcProductos").html('');
            $("#slcProductos").select2('destroy').select2();
            $("#datagried tbody").html('');
        }
    });

    $("#slcTipo").change(function () {
        var tipoReq = $("#slcTipo").val();
        if (tipoReq > 0) {
            if (tipoReq == 3) {
                $("#div-categorias").show();
            }
            cargar_categorias(tipoReq);
            bloquear_select_ajax();
        } else {
            $("#div-categorias").html('');
            $("#datagried tbody").html('');
            bloquear_select_ajax();
        }
    });
    $('#slcTipo').trigger('change');

    $(".dinamic").live('change', function () {
        var tipoReq = $("#slcTipo").val();
        if (tipoReq == 1) {
            menor = Number($(this).attr('id')) + 2;
            bodega = 1;//$('#slcBodega').val();
            padre = $("select[class='dinamic']").last().val();
            $(".dinamic").each(function (index, el) {
                if ($(el).attr('id') > menor) {
                    $(el).parent('div').siblings('label').remove();
                    $(el).siblings('select').remove();
                    $(el).parent('div').parent('div').parent('div').remove();
                    $(el).remove();
                }
            });
            $(".plus:last").remove();
            $(this).next().append('<button class="btn plus">+</button>');
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {padre: padre},
                success: function (data) {
                    producto = data.producto;
                    impuestos = data.impuestos;
                    $("#slcProductos").html(producto);
                    $("#slcProductos option[value='0']").text('');
                    $("#slcProductos option[value='0']").val('');
                    $("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                    $("#slcMedidas").html('');
                    $("#slcMedidas").select2();
                    $("#slcImpuestos").html(impuestos);
                    $("#slcImpuestos").select2({placeholder: 'Seleccione una opción'});
                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });
                }
            });
        } else if (tipoReq == 2) {
            menor = Number($(this).attr('id')) + 2;
            padre = $("select[class='dinamic']").last().val();
            $(".dinamic").each(function (index, el) {
                if ($(el).attr('id') > menor) {
                    $(el).parent('div').siblings('label').remove();
                    $(el).siblings('select').remove();
                    $(el).parent('div').parent('div').parent('div').remove();
                    $(el).remove();

                }
            });
            $(".plus:last").remove();
            $(this).next().append('<button class="btn plus">+</button>');
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {padre: padre, servicio: 1},
                success: function (data) {
                    servicios = data.producto;
                    impuestos = data.impuestos;
                    $("#slcProductos").html(servicios);
                    $("#slcProductos option[value='0']").text('');
                    $("#slcProductos option[value='0']").val('');
                    $("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                    $("#slcImpuestos").html(impuestos);
                    $("#slcImpuestos").select2();
                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });
                }
            });

        } else if (tipoReq == 3) {

            var categoria = $(this).val();
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_activos_tipo',
                data: {tipo_activo: categoria},
                success: function (data) {
                    producto = data.activos;
                    $("#slcProductos").html(producto);
                    $("#slcProductos option[value='0']").text('');
                    $("#slcProductos option[value='0']").val('');
                    $("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                }
            });

            $.ajax({
                dataType: 'json',
                type: 'post',
                //data: {producto: product},
                url: urlj + 'modulo_compras/procesos/get_impuestos',
                success: function (data) {
                    $("#dvImpuestos").show();
                    $("#slcImpuestos").html(data.impuestos);
                    $("#slcImpuestos").select2();
                }
            });
        }
        bloquear_select_ajax();
    });

    $(".plus").live('click', function (event) {
        var tipoReq = $("#slcTipo").val();
        event.preventDefault();
        bodega = 1;//$('#slcBodega').val();
        padre = $("select[class*='dinamic']").last().val();

        if (tipoReq == 1) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {padre: padre},
                success: function (data) {
                    categoria = data.drop;
                    producto = data.producto;
                    $i = 0;
                    $(".plus").last().remove();
                    if (categoria.length > 0) {
                        numero = $('#div-categorias select').last().length + 1;
                        linea = $("#div-categorias").append(''
                                + '<div class="span7" style="margin-bottom: 10px;">'
                                + '<div class="row-fluid">'
                                + '<label class="form-label span3">Categoría:</label>'
                                + '<div class="span6 controls">'
                                + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                                + '</div></div></div>');
                        linea2 = $('select[class="dinamic"]').last().html();
                        nueva = linea2.replace(/#/g, numero);
                        $('#div-categorias').append(nueva);
                        $('select[class="dinamic"]').last().html(categoria);
                        $('select[class="dinamic"] option[value="0"]').last().text('');
                        $('select[class="dinamic"] option[value="0"]').last().val('');

                        $('select[class="dinamic"]').last().select2({placeholder: "Seleccione una opción"});
                        $("#slcProductos").html(producto);
                        $("#slcMedidas").html('');
                        $("#slcMedidas").select2();
                    } else {
                        $("#slcProductos").html(producto);
                        $("#slcMedidas").html('');
                        $("#slcMedidas").select2();
                        $.pnotify({
                            type: 'info',
                            title: 'Aviso',
                            text: 'No se encontraron mas dependencias.',
                            icon: 'ui-icon ui-icon-info',
                            opacity: 0.95,
                            history: false,
                            sticker: false
                        });
                    }

                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });


                }
            });
        } else if (tipoReq == 2) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {padre: padre, servicios: 1},
                success: function (data) {
                    categoria = data.drop;
                    servicios = data.servicios;
                    $i = 0;
                    $(".plus").last().remove();
                    if (categoria.length > 0) {
                        numero = $('#div-categorias select').last().length + 1;
                        linea = $("#div-categorias").append(''
                                + '<div class="span7">'
                                + '<div class="row-fluid">'
                                + '<label class="form-label span3">Categoría:</label>'
                                + '<div class="span6 controls">'
                                + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                                + '</div></div></div>');
                        linea2 = $('select[class="dinamic"]').last().html();
                        nueva = linea2.replace(/#/g, numero);
                        $('#div-categorias').append(nueva);
                        $('select[class="dinamic"]').last().html(categoria);
                        $('select[class="dinamic"]').last().select2();
                        $("#slcProductos").html(servicios);
                    } else {
                        $("#slcProductos").html(servicios);
                        $.pnotify({
                            type: 'info',
                            title: 'Aviso',
                            text: 'No se encontraron mas dependencias.',
                            icon: 'ui-icon ui-icon-info',
                            opacity: 0.95,
                            history: false,
                            sticker: false
                        });
                    }

                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });
                }
            });
        }
    });

    $("#slcProductos").change(function () {
        $("#productos_cantidad").hide();
        $("#productos_null").hide();
        var tipoReq = $("#slcTipo").val();
        product = $('#slcProductos').val();
        if (tipoReq == 1) {
            $("#slcMedidas").html('');
            $("#slcMedidas").select2();
            $("#dvCantidades").show();
            //Se obtienen los detalles del producto
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {producto: product},
                url: urlj + 'modulo_compras/procesos/get_detalles_producto',
                success: function (data) {
                    $("#dvMedidas").show();
                    $("#slcMedidas").html(data.medidas);
                    $("#slcMedidas option[value='0']").text('');
                    $("#slcMedidas option[value='0']").val('');
                    $("#slcMedidas").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else if (tipoReq == 2) {
            $("#slcMedidas").html('');
            $("#slcMedidas").select2('destroy');
            $("#dvMedidas").hide();
            $("#dvCantidades").hide();
            $("#cantidad").val(1);
        } else if (tipoReq == 3) {
            $("#slcMedidas").html('');
            $("#slcMedidas").select2('destroy');
            $("#dvMedidas").hide();
            $("#dvCantidades").hide();
            $("#cantidad").val(1);
        }
    });

    $("#categoria").change(function () {
        $("#categoria option:selected").each(function () {
            bodega = $('#bodega').val();
            categoria = $('#categoria').val();
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/gestion_productos/get_productos_xcat',
                data: {bodega_sel: bodega, categoria_sel: categoria},
                success: function (data) {
                    $("#slcProductos").html(data.drop);
                }
            });
            $('#slcProductos')
                    .find('option')
                    .remove()
                    .end()
                    .append('<option>Seleccione una opción</option>')
                    ;

            $("#slcProductos").select2('destroy').select2();
            $('#cantidad').val('');
        });
    }); //end of function categoria

    var row = 0;
    if ($('#datagried tr').length > 0) {
        row = $("#datagried tr").length;
    }
    $("#agregar").click(function () {
        event.preventDefault();       
        if ( $("#articulo_presupuesto").val() == 0  && $("#slcProducto_ajx").val() != "") {
            var producto_tmp = $("#slcProducto_ajx").select2('data').text;
            crear_alerta("info", "Producto/ servicio", '"'+producto_tmp+'"'+' no esta disponible para la partida o rubro seleccionado');            
            $('.dinamic option:selected').removeAttr('selected');
            $('select[class="dinamic"]').last().select2({placeholder: 'Seleccione una opción'});
            limpiar_select_producto();
        }
        $("#cabezera").show();
        var tipoReq = $("#slcTipo").val();
        var cantidad = $('#cantidad').val();
        var producto = ($("#slcProductos").val() > 0) ? $("#slcProductos").val() : $("#slcProducto_ajx").val();
        //var producto = $('#slcProductos').val();
        var precio = $("#txtPrecio").val();
        var descuento = ($("#txtDescuento").val() != '') ? $("#txtDescuento").val() : 0.00;
        var impuestos = ($("#slcImpuestos").val() != '' && $("#slcImpuestos").val() != null) ? $("#slcImpuestos").val() : '';
        var medidas = $('#slcMedidas').val();
        var medidasHtml = "";
        var descripcionProd = $('#txtDescripcionProd').val();
        //var codigoProducto = $('#slcProductos option:selected').data('codigo');
        //var nombreArticulo = $('#slcProductos option:selected').data('nombre');
        var nombreMedida = "";
        var codigo_producto = '';
        var nombre_producto_text = '';
        if(!($("#slcProductos").val() > 0)){
            nombre_producto = $("#slcProducto_ajx").next().find('.select2-choice span').text();
            nombre_producto_array = nombre_producto.split(' - ');
            codigo_producto = nombre_producto_array[0];
            nombre_producto_text = nombre_producto_array[1];
        }
        var codigoProducto = codigo_producto != '' ? codigo_producto : $('#slcProductos option:selected').data('codigo');
        var nombreArticulo = nombre_producto_text != '' ? nombre_producto_text : $('#slcProductos option:selected').data('nombre');

        //Se realizan las validaciones en base al tipo de Orden
        if (tipoReq == 1) {
            if (cantidad == '' || !parseInt(medidas) || !parseInt(producto) || precio == '') {
                crear_alerta('info', 'Productos', 'Debe especificar las características del producto');
                return false;
            } else if (descuento > 100) {
                crear_alerta('info', 'Productos', 'El porcentaje del descuento no puede superar al 100%');
                return false;
            } else if (parseFloat(precio) == 0 || parseFloat(cantidad) == 0) {
                crear_alerta('info', 'Productos', 'Debe ingresar un valor mayor a cero.');
                return false;
            }
            medidasHtml = $("#slcMedidas").html();
            nombreMedida = $("#slcMedidas option:selected").text();
        } else if (tipoReq == 2) {
            if (cantidad == '' || !parseInt(producto) || precio == '') {
                crear_alerta('info', 'Servicio', 'Debe especificar las características del servicio');
                return false;
            } else if (descuento > 100) {
                crear_alerta('info', 'Productos', 'El porcentaje del descuento no puede superar al 100%');
                return false;
            }
            //medidas = 23;
        } else if (tipoReq == 3) {
            if (cantidad == '' || !parseInt(producto) || precio == '') {
                crear_alerta('info', 'Activo Fijo', 'Debe especificar las características del activo fijo');
                return false;
            } else if (descuento > 100) {
                crear_alerta('info', 'Productos', 'El porcentaje del descuento no puede superar al 100%');
                return false;
            }
        } else if (tipoReq == 4) {
            if (cantidad == '' || !(parseInt(producto)) || !(parseInt(medidas)) || precio == '') {
                crear_alerta('info', 'Activo Fijo', 'Debe especificar las características del producto o servicio');
                return false;
            } else if (descuento > 100) {
                crear_alerta('info', 'Productos', 'El porcentaje del descuento no puede superar al 100%');
                return false;
            }
        } else {
            crear_alerta('info', 'Orden de Compra', 'Debe especificar el tipo de orden.');
            return false;
        }

        var slcImpuestosHtml = getOpcionesSelect("slcImpuestos");

        slcImpuestosHtml = slcImpuestosHtml.replace(/"/g, "'");
        var subtotalNeto = cantidad * precio;
        var descuentoMonto = subtotalNeto * (descuento / 100);
        var subTotal = subtotalNeto - descuentoMonto;
        var totalImpuestos = parseFloat(calcularGastosMultiSelect("slcImpuestos", "data-porcentaje", subTotal, cantidad));
        var TotalProducto = subTotal + totalImpuestos;
        var html = '';

        if ($("#tr_" + producto).length > 0) {
            crear_alerta('error', 'Orden de compra', 'El producto ya fue ingresado.');
            return false;
        }

        var requisicion = $("#slcRequisicion").val();
        html += '<tr id="tr_' + producto + '" data-id="' + row + '">';
        html += '<input type="hidden" name="conversion[]" id="hdnConversion_' + row + '" value="' + medidas + '"/>';
        html += '<input type="hidden" name="productos[]" id="hdnProducto_' + row + '" value="' + producto + '"/>';
        html += '<input type="hidden" name="cantidades[]" id="cantidadi' + row + '" value="' + cantidad + '"/>';
        html += '<input type="hidden" name="precios[]" id="hdnPrecio_' + row + '" value="' + precio + '"/>';
        html += '<input type="hidden" name="impuestos[]" id="hdnImpuestos_' + row + '" value="' + impuestos + '"/>';
        // html += '<input type="hidden" name="impuestosPorc[]" id="impuestosPorc' + row + '" value="' + impuestos + '"/>';
        html += '<input type="hidden" name="descuentos[]" id="hdnDescuento_' + row + '" value="' + descuento + '"/>';
        // html += '<label id="dato_prod_cod_' + row + '">' + codigoProducto + '</label></td>';
        html += '<td><label id="dato_prod_nom_' + row + '">' + codigoProducto + '-' + nombreArticulo + '</label></td>';
        html += '<td><input type="text" class="text tables-input-show tables-input selects-text" name="newdescripcionProd[]" id="descripcionProd_' + row + '" value="' + descripcionProd + '" readonly="readonly"/></td>';

        //Se formatean los montos
        //cantidad = number_format(cantidad, 2);
        precio = number_format(precio, $("#hdnDecimal").val(),".","" );
        totalImpuestos = number_format(totalImpuestos, $("#hdnDecimal").val(),".","");
        subTotal = number_format(subTotal, $("#hdnDecimal").val(),".","");
        TotalProducto = number_format(TotalProducto, $("#hdnDecimal").val(),".","");

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + nombreMedida + '" readonly="readonly"/>';
        html += '<select id="slcMedidas_' + row + '" data-id="' + row + '" style="display:none;" class="select-edit">' + medidasHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtCantidad_' + row + '" class="text tables-input-show tables-input cantidadProducto soloNumeros" value="' + cantidad + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtPrecioUnitario_' + row + '" class="text tables-input-show tables-input soloNumeros preciosUnidades" extras="." value="' + precio + '" readonly="readonly"/>';
        html += '<input type="hidden" data-prod ="'+producto+'" data-correlativo ="' + row + '" id="txtSuma_' + row + '" class="precios_sumar"  value="' + subtotalNeto + '"/>';
        html += '</td>';

        html += '<td>';
        html += '<a href="#modalSelect" id="lnkImpuestos_' + row + '" data-tipo="1" data-input="txtImpuesto_' + row + '" data-etiqueta="Impuestos" data-html="' + slcImpuestosHtml + '" data-id="' + row + '" data-hidden="hdnImpuestos_' + row + '" class="icon-table multiSelectModal"><span class="icon16 icomoon-icon-list-view"></span></a>'
        html += '<input type="text" id="txtImpuesto_' + row + '" name="impuestosProducto[]" class="text tables-input soloNumeros input-table impuestosProducto" extras="." value="' + totalImpuestos + '" readonly="readonly"/>';
        html += '</td>';
        html += '<td>';
        // html += '<input type="text" id="txtDescuento_' + row + '" class="text tables-input-show tables-input soloNumeros descuentosProducto" extras="." value="' + descuento + '" readonly="readonly"/>';
        html += '$<input type="text" id="txtDescMonto_' + row + '"  class="soloDecimales desc_det desc_mon tables-input tables-input-show" extras="."  maxlength="10"  style="width:34%!important;" value="0.00" decimales="2" data-row="' + row + '">&nbsp;/&nbsp;';
        html += '<input type="text" id="txtDescuento_' + row + '" data-hidden="hdnDescuento_' + row + '" class="text input-requisicion tables-input-show soloDecimales descuentosProducto desc_por tables-input" extras="." decimales="' + $("#hdnDecimal").val() + '"  maxlength="5" data-row="' + row + '" value="' + descuento + '" style="width:34%!important;" >%';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtSubtotal_' + row + '" name="subtotalesProducto[]" class="text tables-input subtotalProductos" extras="." value="' + subTotal + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtTotal_' + row + '" name="totalesProducto[]" class="text tables-input totalProductos" extras="." value="' + TotalProducto + '" readonly="readonly"/>';
        html += '</td>';

        if (!requisicion > 0) {
            html += '<td>';
            html += '<button type="button" class="btn btn-primary btn-mini btnGuardarProd" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;"><input type="hidden" value="6" id="txtest">Guardar</button>'
            html += '<button type="button" class="btn btn-primary btn-mini btnEditProd" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;"><input type="hidden" value="6" id="txtest">Editar</button>';
            html += '<button type="button" class="btn btn-danger btn-mini btnDelProd" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
            html += '</td>';
        }

        $("#datagried").append(html);
        $('.desc_por').trigger('keyup');

        if ($('#datagried tr').length > 0)
        {
            $('#datagried').removeClass('error');
            $('#validar_datagried').text('');
        }

        limpiar_filtro_categorias();
        $("#cantidad").val('');
        $("#txtDescuento").val('');
        $("#txtPrecio").val('');
        $("#txtUltimoPrecio").val('');
        // $('#slcProductos option:selected').removeAttr('selected');
        // $('#slcProductos').select2();
        $('#slcMedidas option:selected').removeAttr('selected');
        $('#slcMedidas').select2();
        $('#slcImpuestos option:selected').removeAttr('selected');
        $('#slcImpuestos').select2();

        row = row + 1;
        limpiar_select_producto();
        $('#txtDescripcionProd').val('');
        //Se actualizan los totales
        calcularTotales();
    });//En of function agregar

    $(".btnEditProd").live('click', function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');
        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarProd").show();
    });

    $("#txtPrecio").live('keyup', function(event) {
           verificar_ultima_entrada();
    });
    //Guardar 
    $(".btnGuardarProd").live('click', function () {
        var parent = $(this).parent().parent();
        var id_parent = $("#" + parent[0].id).data('id');
        var txtCantidad = $("#txtCantidad_" + id_parent).val().replace(/,/g, "");
        var txtPrecio = $("#txtPrecioUnitario_" + id_parent).val().replace(/,/g, "");
        var txtDescuento = $("#txtDescuento_" + id_parent).val().replace(/,/g, "");
        
        if (txtCantidad == '' || txtCantidad == 0) {
            crear_alerta('error', 'Orden de compra', 'Debe ingresar una cantidad válida');
            return false;
        }

        if (txtPrecio == '' || txtPrecio == 0) {
            crear_alerta('error', 'Orden de compra', 'Debe ingresar un precio válido');
            return false;
        }

        if (txtDescuento > 100) {
            crear_alerta('error', 'Orden de compra', 'El porcentaje del descuento no puede superar al 100%');
            return false;
        }

        $("#cantidadi" + id_parent).val(txtCantidad);
        $("#hdnPrecio_" + id_parent).val(txtPrecio);

        var descuentos = parseFloat(($.trim($("#" + parent[0].id).find('.descuentosProducto').val()) != "")?$("#" + parent[0].id).find('.descuentosProducto').val():0);
        var subtotalNeto = txtCantidad * txtPrecio;
        var montoDescuento = (descuentos / 100) * subtotalNeto;
        var subTotal = subtotalNeto - montoDescuento;
        var htmlImpuestos = $("#lnkImpuestos_" + id_parent).data('html');

        $("#slcMultiCargos").html(htmlImpuestos);

        var montoImpuestos = parseFloat(calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subTotal,txtCantidad));

        parseFloat($("#" + parent[0].id).find('.impuestosProducto ').val(number_format(montoImpuestos, 2)));

        $("#slcMultiCargos").html('');

        $("#txtPrecioUnitario_" + id_parent).val(number_format(txtPrecio, 2));
        $("#txtDescuento_" + id_parent).val(number_format(txtDescuento, 2));

        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');
        $(this).hide();
        $("#" + parent[0].id + " .btnEditProd").show();
        //Se actualizan los totales
        calcularTotalFila(parent[0].id);
        calcularTotales();
    });


    //Eliminar Producto
    $(".btnDelProd").live("click", function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id).remove().delay(300);
        //Se actualizan los totales
        calcularTotales();
    });

    $(".ModalPrecio").fancybox({
        width: '50%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad:function() {
            wait.start('Buscando precio ...');
            var  url_ajax = window.satelite.base_url('modulo_compras/procesos/get_precio_ultima_entrada');
            var id_articulo = $(this.element[0]).data("artcode");
            var unidad_medida = $(this.element[0]).data("unidadcode");
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    id_articulo: id_articulo,
                    unidad_medida: unidad_medida
                },
                error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                },
                success: function (json) {
                    var ult_precio = 0.00;
                    $("#nombreProveedor").append(json.proveedor);
                    if (!isNaN(Math.abs(json.sar_precio))) {
                        ult_precio = Math.abs(json.sar_precio);
                        ult_precio = ult_precio*(json.cva_conversion/json.defecto);
                    }
                    $("#ultimoPrecio").append('$'+ult_precio);
                }
            });
            wait.close();
        },
        beforeClose: function() {
            $("#nombreProveedor").html("");
            $("#ultimoPrecio").html("");
        }
    });

    //Modal de Multiselects
    $(".multiSelectModal").fancybox({
        width: '75%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            //var id = $(this.element[0]).attr('data-id');
            var etiqueta = $(this.element[0]).attr('data-etiqueta');
            var html = $(this.element[0]).attr('data-html');
            $("#hdnElementoOculto").val($(this.element[0]).attr('id'));
            $("#lblSelect").text(etiqueta + ':');
            $("#slcMultiCargos").html(html);
            $("#slcMultiCargos").select2();
        },
        beforeClose: function () {
            $("#hdnElementoOculto").val('');
            $("#lblSelect").text('');
            $("#slcMultiCargos").html('');
            $("#slcMultiCargos").select2('destroy');
        }
    });

    //Modal del detalle de impuestos
    // $(".impuestosModal").fancybox({
    //     width: '75%',
    //     height: 'auto',
    //     autoSize: false,
    //     closeClick: false,
    //     type: 'inline',
    //     beforeLoad: function () {
    //
    //         var html = '';
    //
    //         $("#tbProductos tr").each(function () {
    //             var id_parent = $(this).data('id');
    //             var producto = $("#dato_prod_nom_" + id_parent).text();
    //             var htmlImpuestos = $("#lnkImpuestos_" + id_parent).attr('data-html');
    //
    //             var cantidad = $("#txtCantidad_" + id_parent).val().replace(/,/g, "");
    //             var precio = $("#txtPrecioUnitario_" + id_parent).val().replace(/,/g, "");
    //
    //             var subTotal = precio * cantidad;
    //
    //             $("#slcMultiCargos").html(htmlImpuestos);
    //             var rowspan = $("#slcMultiCargos option:selected").length;
    //             //console.log($("#slcMultiCargos option:selected"));
    //
    //             html += '<tr>';
    //             html += '<td style="text-align:center;">';
    //             html += producto;
    //             html += '</td>';
    //
    //             html += '<td style="padding: 0px;">';
    //             html += '<table class="responsive table table-bordered" style="margin: 0px;">';
    //             html += '<thead><tr><th style="width:50%;">Impuesto</th><th style="width:50%;">Monto</th></tr></thead>';
    //             html += '<tbody>';
    //             $("#slcMultiCargos option:selected").each(function () {
    //
    //                 var nombreImpuesto = $(this).text();
    //                 var porcentajeImpuesto = $(this).data('porcentaje');
    //
    //
    //                 var montoImpuesto = subTotal * (porcentajeImpuesto / 100);
    //
    //                 html += '<tr>';
    //                 html += '<td>' + nombreImpuesto + '</td>';
    //                 html += '<td>' + number_format(montoImpuesto, 2) + '</td>';
    //                 html += '</tr>';
    //
    //             });
    //             html += '</tbody>';
    //             html += '</table>';
    //             html += '</td>';
    //             html += '</tr>';
    //         });
    //
    //         $("#tbImpuestos").html(html);
    //         $("#slcMultiCargos").html('');
    //     },
    //     beforeClose: function () {
    //         $("#tbImpuestos").html('');
    //     }
    // });

    $("#btnGuardarSelect").click(function () {
        var idLink = $("#hdnElementoOculto").val();
        var idSeleccionados = $("#slcMultiCargos").val();
        var idHidden = $("#" + idLink).attr('data-hidden');
        var idInput = $("#" + idLink).attr('data-input');
        $("#" + idHidden).val(idSeleccionados);
        var opciones = "";//$("#slcMultiCargos").html();
        $("#slcMultiCargos option").each(function () {
            if (!$(this).attr('selected')) {
                $(this).removeAttr('selected');
            } else {
                $(this).attr('selected', 'selected');
            }
            opciones += this.outerHTML;
        });
        $("#" + idLink).attr('data-html', opciones);
        var parent = $("#" + idLink).parent().parent();
        var precio = parseFloat(parent.find('.preciosUnidades').val().replace(/,/g, ""));
        var cantidad = parseFloat(parent.find('.cantidadProducto').val().replace(/,/g, ""));
        var descuento = (parent.find('.descuentosProducto ').val() != '') ? parseFloat(parent.find('.descuentosProducto ').val().replace(/,/g, "")) : 0.00;
        var subtotalNeto = precio * cantidad;
        var monto_descuento = (descuento / 100) * subtotalNeto;
        var subtotal = subtotalNeto - monto_descuento;//parent.find('.subtotalProductos').val();
        var montoSubtotal = calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subtotal,cantidad);

        $("#" + idInput).val( number_format(montoSubtotal, $("#hdnDecimal").val() ));

        calcularTotalFila(parent[0].id);
        //Se actualizan los totales
        calcularTotales();

        $.fancybox.close();
    });

    //Calculo cuando es desde una requisicion
    $(".input-cantidad").live('keyup',function() {
        var valor = parseFloat($(this).val());
        var inputHidden = $(this).data('hidden');
        $("#" + inputHidden).val(valor);

       var parent = $(this).parent().parent();
       $("#" + parent[0].id).find('.input-requisicion').trigger("keyup");

    });
    $(".input-requisicion").live('keyup', function () {
        var parent = $(this).closest('tr');
        var idtr = $(this).closest('tr').attr('id');
        var id_parent = $(this).closest('tr').data('id');
        var valor = parseFloat($(this).val());
        var inputHidden = $(this).data('hidden');
        $("#" + inputHidden).val(valor);

        // var id_parent = $("#" + parent).data('id');
        // console.log(parent);        
        // console.log(id_parent);
        // console.log(valor);        
        // console.log(inputHidden);       

        var cantidad = parseFloat(parent.find('.cantidadProducto').val().replace(/,/g, ""));
        var precio = parseFloat(parent.find('.preciosUnidades').val().replace(/,/g, ""));
        var subtotal = number_format(parseFloat(cantidad * precio), 2);

        parent.find('.subtotalProductos').val(subtotal);

        //Impuestos
        var htmlImpuestos = $("#lnkImpuestos_" + id_parent).attr('data-html');
        $("#slcMultiCargos").html(htmlImpuestos);
        var montoImpuestos = parseFloat(calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subtotal).replace(/,/g, ""));
        parseFloat($("#" + id_parent).find('.impuestosProducto').val(number_format(montoImpuestos, 2)));
        $("#slcMultiCargos").html('');

        $("#cantidadi" + id_parent).val(cantidad);
        $("#hdnPrecio_" + id_parent).val(precio);

        if ($(this).hasClass('descuentosProducto')) {
            if (valor > 100) {
                crear_alerta('error', 'Orden de Compra', 'El descuento no puede superar al 100%');
                $(this).val(100.00);
            }
        }

        calcularTotalFila(idtr);
        calcularTotales();
    });


    $("#registrar_solicitud").click(function () {
        if ($('#datagried tr').length <= 1 || $('#descripcion_req').val().trim() == '' || $('#fecha').val() == '' || $('#documento').val() == '') {
            //alert("Debe haber agregado al menos un producto y descripción!"); //Deshabilitado mientras provisional de requisiciones UTE
            if ($('#datagried tr').length <= 1) {
                $('#datagried').addClass('error');
                $('#validar_datagried').text('Debe seleccionar al menos un producto');
            }

            if ($("#descripcion_req").val() == '') {
                $('#descripcion_req').addClass('error');
                $('#validar_descripcion_req').text('Campo requerido');
            }
            /*if ($('#documento').val() == '') {
             //$('#documento').addClass('error');
             $('#validar_documento').text('Campo requerido');
             }*/
            if ($('#bodega').val() == '') {
                //$('#documento').addClass('error');
                $('#validar_bodega').text('Campo requerido');
            }

        } else {
            var aprobar_presupuesto = evaluar_presupuesto(); 
            if ( aprobar_presupuesto == false) {
                return false;
            }
            $("#fecha").prop('disabled', false);
            $("#documento").prop('disabled', false);
            quitar_atributo();
            $("#frm").submit();
        }
    });

    $('body').on('focus', '.desc_por', function() {
        this.select();
    });

    $('body').on('focus', '.desc_mon', function() {
        this.select();
    });

    $('body').on('keyup', '.desc_por', function() {
        var porc = $(this).val();
        var row = $(this).data('row');
        var unit = $('#txtPrecioUnitario_' + row).val();
        var cant = $('#txtCantidad_' + row).val();
        if (porc != '' && porc > 0) {
            $('#txtDescMonto_' + row).val(0.00);
            if (unit != '' && unit > 0) {
                valor = round_number((porc / 100) * (unit * cant));
                $('#txtDescMonto_' + row).val(valor);
            }
        } else {
            $('#txtDescMonto_' + row).val(0.00);
        }
    });

    $('body').on('blur', '.desc_por', function() {
        var val = $(this).val();
        if (val == '') {
            $(this).val(0.00);
        }
    });

    $('body').on('keyup', '.desc_mon', function() {
        var val = $(this).val();
        var row = $(this).data('row');
        var unit = $('#txtPrecioUnitario_' + row).val();
        var cant = $('#txtCantidad_' + row).val();
        var total = unit * cant;
        if (val != '') {
            $('#txtDescuento_' + row).val('');
            if (total > 0) {
                valor = round_number(((val * 100) / total),6);
                $('#txtDescuento_' + row).val(valor);
            }
        } else {
            $('#txtDescuento_' + row).val(0.00);
        }
    });

    $('body').on('blur', '.desc_mon', function() {
        var row = $(this).data('row');
        $('#txtDescuento_' + row).trigger('keyup');
    });

    $("#slcProducto_ajx").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_compras/procesos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    servicio: $("#slcTipo").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.codigo+' - '+item.prod_nombre
                    });
                });

                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#slcProducto_ajx").live("change", function (e) {
        var valor               = $(this).val();
        var actividad_especifica= $("#slc_actividad_espeficifica").val();
        //return false;
        if ($.trim(valor) != "") {
            $.ajax({
                url: urlj + 'modulo_compras/procesos/cargar_impuestos_ajax',
                type: 'POST',
                dataType: 'json',
                data: {producto: valor},
                success: function (data) {
                    if ($.trim(data.impuesto) != "") {
                        $("#slcImpuestos").html(data.impuesto);
                        $("#slcImpuestos").select2({placeholder: 'Seleccione una opción'});
                    }
                }
            });

            if (actividad_especifica != "") {
                var especifico  = $("#slc_actividad_espeficifica").val();
                var presupuesto = $("#slc_presupuesto").val();
                validacion_articulo_aprobado(valor,especifico,presupuesto);
            }

        } else {
            $("#slcImpuestos").html('<option value=""></option>');
            $("#slcImpuestos").select2({placeholder: 'Seleccione una opción'});
        }
    });

    function validacion_articulo_aprobado(valor,especifico,presupuesto) {
        $.ajax({
            dataType: 'json',
            type: 'post',
            data: {
                producto: valor,
                especifico: especifico,
                presupuesto: presupuesto
            },
            url: urlj + 'modulo_compras/procesos/articulo_aprobado',
            success: function (data) {
                $("#articulo_presupuesto").val(data.aprobacion);
                if ( $("#articulo_presupuesto").val() == 0  && $("#slcProducto_ajx").val() != "") {
                    var producto_tmp = $("#slcProducto_ajx").select2('data').text;
                    crear_alerta("info", "Producto/ servicio", '"'+producto_tmp+'"'+' no esta disponible para la partida o rubro seleccionado');            
                    $('.dinamic option:selected').removeAttr('selected');
                    $('select[class="dinamic"]').last().select2({placeholder: 'Seleccione una opción'});
                    limpiar_select_producto();
                }
            }
        });
    }

    function limpiar_select_producto(){
        categoria_tip = typeof $("select[class='dinamic']").last().val() !== 'undefined' ?  $("select[class='dinamic']").last().val() : '';

        if($.trim(categoria_tip) != ''){
            $('#slcProductos option:selected').removeAttr('selected');
            $("#slcProductos").select2({placeholder: 'Seleccione una opción'});
            $("#slcProducto_ajx + .select2-container ").hide();
            $("#slcProducto_ajx").select2('data', null);
        } else{
            $("#slcProductos").html('<option value=""></option>');
            $("#slcProductos").select2('destroy');
            $("#slcProductos").hide();

            $("#slcProducto_ajx").val('');
            $("#slcProducto_ajx").select2('data', null);
            $("#slcProducto_ajx + .select2-container").show();
        }
    }

    function bloquear_select_ajax(){
        categoria_tip = typeof $("select[class='dinamic']").last().val() !== 'undefined' ?  $("select[class='dinamic']").last().val() : '';
        var tipoReq = $("#slcTipo").val();

        if (tipoReq > 0) {
            if($.trim(categoria_tip) != ''){

                $('#slcProductos option:selected').removeAttr('selected');
                $('#slcProductos').select2();
                $("#slcProducto_ajx").select2('disable');
                $("#slcProducto_ajx + .select2-container ").hide();
                $("#slcProducto_ajx").select2('data', null);
            } else{
                $("#slcProductos").html('<option value=""></option>');
                $("#slcProductos").select2('destroy');
                $("#slcProductos").hide();

                $("#slcProducto_ajx").val('');
                $("#slcProducto_ajx").select2('data', null);
                $("#slcProducto_ajx + .select2-container").show();
                $("#slcProducto_ajx").select2('enable');
            }
        } else {
            if($.trim(categoria_tip) != ''){
                $('#slcProductos option:selected').removeAttr('selected');
                $('#slcProductos').select2();
                $("#slcProducto_ajx").select2('disable');
                $("#slcProducto_ajx + .select2-container ").hide();
                $("#slcProducto_ajx").select2('data', null);
            } else{
                $("#slcProductos").html('<option value=""></option>');
                $("#slcProductos").select2('destroy');
                $("#slcProductos").hide();

                $("#slcProducto_ajx").val('');
                $("#slcProducto_ajx").select2('data', null);
                $("#slcProducto_ajx + .select2-container").show();
                $("#slcProducto_ajx").select2('disable');
            }
        }

    }

    $("#slcProducto_ajx").live("change", function (e) {
        var tipoProd = $("#slcTipo").val();
        var aplicaProduccion = $("#slcProduccion").val();
        product = $(this).val();
        cliente = ($('#slcCliente').val() > 0) ? $('#slcCliente').val() : 0 ;
        $("#txtPrecio").val('');
        $("#txtUltimoPrecio").val('');

        if (tipoProd == 1 && product > 0) {
            $("#slcMedidas").html('');
            $("#slcMedidas").select2();
            $("#slcPrecios").html('');
            $("#hdnProducto").data('imagen', '');
            $("#hdnProducto").data('ruta', '');
            //Se obtienen los detalles del producto
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {producto: product, cliente: cliente, servicio: tipoProd, aplicaProduccion: aplicaProduccion},
                url: urlj + 'cotizaciones/cotizaciones/get_detalles_producto',
                beforeSend: function () {
                    wait.start('Espere unos segundos... buscando detalles del producto.');
                },
                success: function (data) {
                    wait.close();
                    $("#dvMedidas").show();
                    $("#slcMedidas").html(data.medidas);
                    $("#slcMedidas option[value='0']").text('');
                    $("#slcMedidas option[value='0']").val('');
                    $("#slcMedidas").select2({placeholder: 'Seleccione una opción'});
                    $("#slcPrecios").html(data.rango_precios);

                    $("#txtDescripcion").val(data.producto.descripcion);
                    $("#hdnProducto").data('imagen', data.producto.foto);
                    $("#hdnProducto").data('ruta', data.producto.ruta);
                    $("#hdnProducto").data('caracteristicas', data.caracteristicas);
                    //console.log('aca cargan las caracteristicas del producto para mostrar');

                    $("#slcImpuestos").html(data.impuestos);
                    $("#slcImpuestos").select2();

                    if(data.select_tipo_lista.length > 30){
                        $("#div_detall_tlp_add").css("display","");
                    }else{
                        $("#div_detall_tlp_add").css("display","none");
                    }

                    $("#detall_tlp_add").html(data.select_tipo_lista);
                    $("#detall_tlp_add").select2();
                }
            });
        } else if (tipoProd == 2 && product > 0) {
            //$("#slcMedidas").html('');
            //$("#slcMedidas").select2('destroy');
            //$("#dvMedidas").hide();

            //Se obtienen los detalles del producto
            //primero se obtine todos los datos y luego se aplica los cambios a los selects correspondientes
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {producto: product, cliente: cliente, servicio: tipoProd, aplicaProduccion: aplicaProduccion},
                url: urlj + 'cotizaciones/cotizaciones/get_detalles_producto',
                success: function (data) {
                    $("#slcPrecios").html(data.rango_precios);
                                $("#dvMedidas").show();
                    $("#slcMedidas").html(data.medidas);
                    $("#slcMedidas option[value='0']").text('');
                    $("#slcMedidas option[value='0']").val('');
                    $("#slcMedidas").select2({placeholder: 'Seleccione una opción'});
            $("#cantidad").val(1);

            $("#slcPrecios").html('');
            $("#hdnProducto").data('imagen', '');
            $("#hdnProducto").data('ruta', '');
                }
            });
        } else if (tipoProd == 4 && product > 0) {
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {producto: product, cliente: cliente, servicio: tipoProd, aplicaProduccion: aplicaProduccion},
                url: urlj + 'cotizaciones/cotizaciones/get_detalles_producto',
                beforeSend: function () {
                    wait.start('Espere unos segundos... buscando detalles del producto.');
                },
                success: function (data) {
                    $("#dvMedidas").show();
                    $("#slcMedidas").html(data.medidas);
                    $("#slcMedidas option[value='0']").text('');
                    $("#slcMedidas option[value='0']").val('');
                    $("#slcMedidas").select2({placeholder: 'Seleccione una opción'});
                    $("#slcPrecios").html(data.rango_precios);
                    if (data.producto.tipo_producto == 1) {
                        $("#cantidad").val(1);
                        $("#slcPrecios").html('');
                        $("#hdnProducto").data('imagen', '');
                        $("#hdnProducto").data('ruta', '');
                    } else {
                        $("#txtDescripcion").val(data.producto.descripcion);
                        $("#hdnProducto").data('imagen', data.producto.foto);
                        $("#hdnProducto").data('ruta', data.producto.ruta);
                        $("#hdnProducto").data('caracteristicas', data.caracteristicas);
                        $("#slcImpuestos").html(data.impuestos);
                        $("#slcImpuestos").select2();
                        if(data.select_tipo_lista.length > 30){
                            $("#div_detall_tlp_add").css("display","");
                        }else{
                            $("#div_detall_tlp_add").css("display","none");
                        }
                        $("#detall_tlp_add").html(data.select_tipo_lista);
                        $("#detall_tlp_add").select2();
                    }
                    console.log(typeof data.producto.tipo_producto);
                console.log(data.producto.tipo_producto == 1);
                    wait.close();
                }
            });
        }
    })
    limpiar_select_producto();

    // Agregar nuevo producto desde Orden de Compra
    $("body").on("click", ".mNuevoProducto", function() {
        event.preventDefault();
        var mNuevoProducto = $(this);
        var Invalida = 0;
        //Se obtienen los detalles del producto
        $.ajax({
            dataType: 'json',
            type: 'post',
            url: urlj + 'modulo_compras/procesos/get_permisos_padre_prod',
            async: false,
            success: function (data) {
                if (data.permiso == 1) {
                    Invalida = 1;
                }
            }
        });

        if (Invalida === 1) {
            var url = mNuevoProducto.attr('href');
            $.fancybox({
                'href': url,
                type: 'iframe',
                width:'100%',
                closeBtn: true,
                height: '100%'
            });
        } else {
            crear_alerta('error', 'Permiso', 'Debe tener permiso de Agregar Nuevo Producto');
        }

    });

    $( "#txtDescuento" ).keyup(function() {
        if ( $("#txtDescuento").val() != "" ) {
            descuento( $("#cantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),1);
        } else if ( $("#txtDescuento_monetario").val() != "" ) {
            descuento( $("#cantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),2);
        }
    });

    $( "#txtDescuento_monetario" ).keyup(function() {
        descuento( $("#cantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),2);
    });
    
    $( "#cantidad" ).keyup(function() {
        if ( $("#txtDescuento").val() != "" ) {
            descuento( $("#cantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),1);
        } else if ( $("#txtDescuento_monetario").val() != "" ) {
            descuento( $("#cantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),2);
        }
    });
    
    $( "#txtPrecio" ).keyup(function() {
        if ( $("#txtDescuento").val() != "" ) {
            descuento( $("#cantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),1);
        } else if ( $("#txtDescuento_monetario").val() != "" ) {
            descuento( $("#cantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),2);
        }
    });

    //valor,valor,input,input, valor.
    function descuento( cantidad, precio, porcentaje, valor , tipo) {
        //tipo 1 = obtener el valor des un porcentaje;
        //tipo 2 = obtener el porcentaje de un valor;
        if ( cantidad != "" || precio != ""){
            var sub_total = parseFloat( cantidad ) * parseFloat( precio ) ;
            if ( tipo == 1) {
                if ( porcentaje.val() != "") {
                    var new_calculo = ( parseFloat(sub_total) * parseFloat(porcentaje.val()) )/100 ;
                    if ( parseFloat(porcentaje.val()) >= 100 ) {
                        crear_alerta("error","Descuento","Descuento debe ser menor al 100%.");
                        porcentaje.val("");
                        valor.val("");
                    } else {
                        valor.val( number_format( new_calculo, $("#hdnDecimal").val() ) );
                    }
                } else {
                    valor.val("");
                }
            } else {
                if ( valor.val() != "") {
                    var new_calculo = ( parseFloat(valor.val()) ) * 100 /parseFloat(sub_total);
                    if (parseFloat(new_calculo) >= 100 ) {
                        crear_alerta("error","Descuento","Descuento debe ser menor al 100%.");
                        porcentaje.val("");
                        valor.val("");
                    } else {
                        porcentaje.val( number_format( new_calculo, $("#hdnDecimal").val() ) );
                    }
                } else {
                    porcentaje.val("");
                }
            }
        } 
    }

    $("#slcProyecto").change(function (){
        var proyecto = $(this).val();
        if ( $("#datagried tbody tr").length > 0 ) {
            var mensaje = 'Al cambiar el proyecto seleccionado, se quitarán los productos agregados/servicios agregados, ¿desea continuar?';
            var titulo = 'Confirmar cambiar detalle';
            alerta_confirm_ajax(consulta_proyecto, proyecto, titulo, mensaje,  cancelar_consulta_proyecto, global_proyecto);
            return false;
        }
        consulta_proyecto(proyecto);
    });

    $("#slc_presupuesto").change(function (){
        var presupuesto = $(this).val();
        var area = $('#slc_presupuesto option:selected').data('area');
        $("#nombre_area").val(area);
        if ( $("#datagried tbody tr").length > 0 ) {
            var mensaje = 'Al cambiar el presupuesto seleccionado, se quitarán los productos agregados/servicios agregados, ¿desea continuar?';
            var titulo = 'Confirmar cambiar detalle';
            alerta_confirm_ajax(consulta_presupuesto, presupuesto, titulo, mensaje,  cancelar_consulta_presupuesto, global_presupuesto);
            return false;
        }
        consulta_presupuesto(presupuesto);
    });

    $("#slc_actividad_general").change(function (){
        var general     = $(this).val();
        if ( $("#datagried tbody tr").length > 0 ) {
            var mensaje = 'Al cambiar el actividad general seleccionado, se quitarán los productos agregados/servicios agregados, ¿desea continuar?';
            var titulo = 'Confirmar cambiar detalle';
            alerta_confirm_ajax(consulta_general, general, titulo, mensaje,  cancelar_consulta_general, global_general);
            return false;
        }
        consulta_general(general);
    });

    $("#slc_actividad_espeficifica").change(function (){
        var especifica = $(this).val();
        if ( $("#datagried tbody tr").length > 0 ) {
            var mensaje = 'Al cambiar la Pda. Presup. o Rubro, se quitarán los productos agregados/servicios agregados, ¿desea continuar?';
            var titulo = 'Confirmar cambiar detalle';
            alerta_confirm_ajax(consulta_especifica, especifica, titulo, mensaje,  cancelar_consulta_especifica, global_especifico);
            return false;
        }
        consulta_especifica(especifica);    
    });

    if ( $("#slc_actividad_espeficifica").val() != "" ) {
        var mensual_disponible = $("#slc_actividad_espeficifica option:selected").data('monto_disponible_mensual');
        $("#disponible_compras").val("$"+mensual_disponible);
    }   

    evaluar_cotizacion();

}); // fin document ready

function cargar_categorias(tipoOrden, edicion) {

    $("#div-categorias").html('');
    $("#slcProductos").html('');
    $("#slcProductos").select2('destroy').select2();
    if (edicion == '') {
        $("#datagried tbody").html('');
    }

    if (tipoOrden) {
        tipoOrden = parseInt(tipoOrden);
        switch (tipoOrden) {
            case 1:
                $("#dvImpuestos").show();
                $("#slcMedidas").html('');
                $("#dvMedidas").show();
                $("#slcMedidas").select2();
                $("#lblProducto").html('Producto:<b class="orange">*<b/>');
                $("#div-categorias").hide();
                break;
            case 2:
                //$("#dvImpuestos").hide();
                $("#slcMedidas").html('');
                //$("#dvMedidas").hide();
                //$("#slcMedidas").select2();
                $("#lblProducto").html('Producto/Servicio:<b class="orange">*<b/>');
                $("#div-categorias").hide();
                break;
            case 3:
                $("#slcMedidas").html('');
                $("#slcMedidas").select2('destroy');
                $("#dvMedidas").hide();
                $("#lblProducto").html('Producto/Servicio:<b class="orange">*<b/>');
                //$("#dvImpuestos").hide();
                //$("#slcImpuestos").select2('destroy');
                //$("#slcImpuestos").html('');
                $("#div-categorias").show();
                break;
        }

        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'modulo_compras/procesos/get_categorias_productos',
            data: {tipo: tipoOrden},
            success: function (data) {
                //$("#departamento").html(data.drop);

                $("#div-categorias").html(''
                        + '<div class="span7">'
                        + '<div class="row-fluid">'
                        + '<label class="form-label span3">Categoría<b class="orange">*</b>:</label>'
                        + '<div class="span6 controls">'
                        + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                        + '</div></div></div>');
                $(".dinamic").html(data.categoria);
                $('.dinamic option[value="0"]').text('');
                $('.dinamic option[value="0"]').val('');
                $('.dinamic').select2({placeholder: "Seleccione una opción"});
                producto = data.producto;
                $("#slcProductos").html(producto);
                $('#slcProductos option[value="0"]').text('');
                $('#slcProductos option[value="0"]').val('');
               // $("#slcProductos").select2('destroy').select2({placeholder: "Seleccione una opción"});
            }
        });
    }
}

function calcularGastosMultiSelect(idElemento, nombreAtributo, subTotalString, cantidad) {
    cantidad = typeof cantidad !== 'undefined' ?  cantidad : null;
    var total = 0;
    var subTotal = subTotalString.toString().replace("$", '').replace(/,/g, "");
    subTotal = parseFloat(subTotal);
    $("#" + idElemento + " option:selected").each(function () {
        var porcentaje = $(this).attr(nombreAtributo);
        if(cantidad != null){
            var tipo = $(this).attr('data-type');
            if(tipo != 0){
                porcentaje = parseFloat(parseFloat(porcentaje) / 100);
                total = parseFloat(total) + (porcentaje * parseFloat(subTotal));
            } else{
                porcentaje = parseFloat(parseFloat(porcentaje) * cantidad );
                total = parseFloat(total) + (porcentaje);
            }
        } else{
            porcentaje = parseFloat(parseFloat(porcentaje) / 100);
            total = parseFloat(total) + (porcentaje * parseFloat(subTotal));
        }
    });
    return number_format(total, 4);
}

function calcularTotalFila(idFila) {

    var impuestos = parseFloat($("#" + idFila).find('.impuestosProducto').val().replace(/,/g, ""));
    var descuentos = parseFloat($("#" + idFila).find('.descuentosProducto').val().replace(/,/g, ""));
    var cantidad = parseFloat($("#" + idFila).find('.cantidadProducto').val().replace(/,/g, ""));
    var precio = parseFloat($("#" + idFila).find('.preciosUnidades').val().replace(/,/g, ""));
    var data_id = $("#" + idFila).data('id');
    var subtotalNeto = (cantidad * precio);

    var montoDescuento = (descuentos / 100) * subtotalNeto;
    var subTotal = (subtotalNeto - montoDescuento);

    var total = subTotal + impuestos;
    parseFloat($("#" + idFila).find('.subtotalProductos').val(number_format(subTotal, $("#hdnDecimal").val() )));
    $("#" + idFila).find('.totalProductos').val(number_format(total, $("#hdnDecimal").val() ));
}


function calcularTotales() {
    if ($("#tbProductos").length > 0) {

        var totalSuma = 0.00;
        var totalDescuentos = 0.00;
        var totalImpuestos = 0.00;
        var totalSubtotal = 0.00;
        var totalGeneral = 0.00;

        $("#tbProductos tr").each(function () {
            var cantidad = parseFloat($(this).find('.cantidadProducto').val().replace(/,/g, ""));
            var precio = parseFloat($(this).find('.preciosUnidades').val().replace(/,/g, ""));
            var impuesto = parseFloat($(this).find('.impuestosProducto').val().replace(/,/g, ""));
            var descuento = parseFloat($(this).find('.descuentosProducto').val().replace(/,/g, ""));
            var subtotalNeto = (cantidad * precio);
            descuento_porc = (descuento / 100);
            descuento_total = (subtotalNeto) * descuento_porc;
            //descuento_total = descuento * cantidad;
            totalSuma += subtotalNeto;
            totalImpuestos += impuesto;
            totalDescuentos += descuento_total;
            totalSubtotal += (subtotalNeto - descuento_total);

        });
        totalGeneral = totalSubtotal + totalImpuestos;
        $("#txtSumaGeneral").val(number_format(totalSuma, 2));
        $("#txtDescuentoGeneral").val(number_format(totalDescuentos, 2));
        $("#txtSubtotalGeneral").val(number_format(totalSubtotal, 2));
        $("#txtImpuestosGeneral").val(number_format(totalImpuestos, 2));
        if (isNaN(totalGeneral)) {
            totalGeneral = 0.00;
        }else{
            totalGeneral = totalGeneral;
        }
        $("#txtTotalGeneral").val(round_number(totalGeneral));
    }
}

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        //console.log($(this).attr('selected'));
        //console.log(this);
        opciones += this.outerHTML;
    });

    return opciones;
}

function cerrar_modal() {
    //alert('asdasd');
    jQuery.fancybox.close();
}

function limpiar_filtro_categorias() {
    menor = Number($(".dinamic:first").attr('id')) + 2;

    $(".dinamic").each(function (index, el) {
        if ($(el).attr('id') > menor) {
            $(el).parent('div').siblings('label').remove();
            $(el).siblings('select').remove();
            $(el).parent('div').parent('div').parent('div').remove();
            $(el).remove();
        }
    });
    $(".plus:last").remove();
    $(".dinamic:first option:selected").removeAttr('selected');
    $(".dinamic:first").next().append('<button class="btn plus">+</button>');
    $(".dinamic:first").select2({placeholder: 'Seleccione una opción'});
}

function verificar_ultima_entrada() {
    precio_lista = $("#txtPrecio").val();
    id_articulo = ($("#slcProductos").val() > 0) ? $("#slcProductos").val() : $("#slcProducto_ajx").val();
    unidad_medida = $("#slcMedidas option:selected").data('mep');


    if (unidad_medida > 0  && precio_lista > 0)
    {
        url_ajax = window.satelite.base_url('facturacion/entradas/get_valor_ultima_entrada');
        $.ajax({
            url: url_ajax,
            type: 'POST',
            dataType: 'json',
            data: {
                precio_lista: precio_lista,
                id_articulo: id_articulo,
                unidad_medida: unidad_medida
            },
            error: function (xhr, status, error){
                exportarError(xhr.responseText);
            },
            success: function (json) {
                $("#txtUltimoPrecio").val(round_number(json.ultima_compra));
            }
        });
    }
}

function aplicar_fancy() {
    $(".detalle_fanc").fancybox({
        width: '35%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {

        },
        beforeClose: function () {

        }
    });
}

function calcular_impuestos_retenciones(porcentaje,tipo){
    var total = 0; 
    if (typeof tipo === "undefined") {
        tipo = 1;
    }
  
    if(tipo == 1){
        $(".precios_sumar").each(function(e){
            if ( $.isNumeric($(this).val()) ){
                total += (( parseFloat($(this).val()) * parseFloat(porcentaje) )/100);
            }
        });
    } else {
        $(".cantidadProducto").each(function(e){
            if ( $.isNumeric($(this).val()) ){
                total += (( parseFloat($(this).val()) * parseFloat(porcentaje) ));
            }
        });
    }

    return number_format(total, 2, '.', '');
}

function agregar_nuevo_calculos(id,impuestos_add,impuestos_del){
    var html = $("#lnkImpuestos_"+id).attr('data-html');
    $("#slcMultiCargos").html(html);
    $("#slcMultiCargos").select2();
    var actuales = $("#slcMultiCargos").val();

    if (impuestos_del.length > 0 && actuales != null) {
        impuestos_del.forEach(function(x) {
            var b = actuales.indexOf(x.toString());
            if (b >= 0) {
                actuales.splice(b,1);
            }
        });
    }

if (impuestos_add.length > 0) {
  if (actuales == null) {
    actuales = [];
  }
  impuestos_add.forEach(function(x) {
    var b = actuales.indexOf(x.toString());
    if (b < 0) {
      actuales.push(x.toString());
    }
  });
 
}
 $("#slcMultiCargos").val(actuales);
   $("#slcMultiCargos").select2();
  var idInput = $("#lnkImpuestos_"+id).data('input');
  $("#hdnImpuestos_"+id).val(actuales);

//console.log($("#slcMultiCargos").val());

  var opciones = "";//$("#slcMultiCargos").html();

  $("#slcMultiCargos option").each(function () {

      if (!$(this).attr('selected')) {
          $(this).removeAttr('selected');
      } else {
          $(this).attr('selected', 'selected');
      }
      opciones += this.outerHTML;
  });
  //console.log(opciones);
  $("#lnkImpuestos_"+id).attr('data-html', opciones);
  //console.log(opciones);
  var parent = $("#lnkImpuestos_"+id).parent().parent();

  var precio = parseFloat(parent.find('.preciosUnidades').val().replace(/,/g, ""));
  var cantidad = parseFloat(parent.find('.cantidadProducto').val().replace(/,/g, ""));
  var descuento = (parent.find('.descuentosProducto ').val() != '') ? parseFloat(parent.find('.descuentosProducto ').val().replace(/,/g, "")) : 0.00;
  var subtotalNeto = precio * cantidad;
  var monto_descuento = (descuento / 100) * subtotalNeto;
  var subtotal = subtotalNeto - monto_descuento;//parent.find('.subtotalProductos').val();

  var montoSubtotal = calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subtotal,cantidad);

  $("#" + idInput).val(montoSubtotal);

  calcularTotalFila(parent[0].id);
  //Se actualizan los totales
  calcularTotales();
  $("#slcMultiCargos").html('');
  $("#slcMultiCargos").select2();
}

function evaluar_presupuesto(actividad_especifica) {
    var monto_disponible    =  parseFloat($("#slc_actividad_espeficifica option:selected").data("monto_disponible"));
    var total_gasto         =  number_format($("#txtTotalGeneral").val(),"2",".",""); 
    var total_gasto         =  parseFloat( total_gasto ); 
    var aprobado            = true;
    
    if (total_gasto > monto_disponible && actividad_especifica != "" && $("#sobre_giro").val() == 0 ) {
        aprobado = false;
        crear_alerta('error', 'Presupuesto', 'El monto total de la orden de compra sobrepasa el presupuesto asignado ($'+number_format(monto_disponible,"2",".",",")+')'); 
    }

    return aprobado;
}

function quitar_atributo() {
    $("#slcProyecto").removeAttr("disabled");
    $("#slc_presupuesto").removeAttr("disabled");
    $("#slc_actividad_general").removeAttr("disabled");
    $("#slc_actividad_espeficifica").removeAttr("disabled");
}

function consulta_proyecto(proyecto,){
    $("#datagried tbody").html('');
    calcularTotales();

    global_proyecto = proyecto;
    if ( proyecto != "" ) {
        $.ajax({
            dataType: 'text',
            type: 'post',
            data: {proyecto: proyecto},
            url: urlj + 'modulo_compras/procesos/get_presupuestoxproyecto',
            success: function (data) {
                $("#slc_presupuesto").html("");
                $("#slc_presupuesto").html(data);
                $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
            }
        });
    } else {
        $("#slc_presupuesto").html('<option value=""></option>');
        $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});

        $("#slc_presupuesto").html('<option value=""></option>');
        $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
        $("#slc_presupuesto").trigger("change");
        $("#slc_actividad_general").html('<option value=""></option>');
        $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});

        $("#slc_actividad_espeficifica").html('<option value=""></option>');
        $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
    }
    $("#disponible_compras").val("");
}

function cancelar_consulta_proyecto(global_proyecto){
    $('#slcProyecto').val(global_proyecto);
    $('#slcProyecto').select2();
}

function consulta_presupuesto(presupuesto){ 
    $("#datagried tbody").html('');
    calcularTotales();
    global_presupuesto = presupuesto;
    if (presupuesto != "") {
        $("#info_area").show();
        $.ajax({
            dataType: 'text',
            type: 'post',
            data: {presupuesto: presupuesto},
            url: urlj + 'modulo_compras/procesos/get_actividades_generalesxpresupusto',
            success: function (data) {
                $("#slc_actividad_general").html("");
                $("#slc_actividad_general").html(data);
                $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
            }
        });
    } else {
        $("#slc_actividad_general").html('<option value=""></option>');
        $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
        $("#info_area").hide();
        $("#slc_actividad_espeficifica").html('<option value=""></option>');
        $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
    }
    $("#disponible_compras").val("");
}

function cancelar_consulta_presupuesto(presupuesto){
    $('#slc_presupuesto').val(presupuesto);
    $('#slc_presupuesto').select2();
    $('#slc_presupuesto').trigger('change');
}

function consulta_general(general){  
    $("#datagried tbody").html('');
    calcularTotales();

    if ( $("#fecha").val() == "" ) {
        var d = new Date();
        var strDate = ('0' + d.getDate()).slice(-2) + "-" + ('0' + (d.getMonth()+1))  + "-" + d.getFullYear();
        $("#fecha").val(strDate);
    }
    
    global_general  = general;
    var presupuesto = $("#slc_presupuesto").val();
    var fecha       = $("#fecha").val();
    if ( general != "" ) {
        $.ajax({
            dataType: 'text',
            type: 'post',
            data: {general: general,presupuesto:presupuesto,fecha:fecha},
            url: urlj + 'modulo_compras/procesos/get_actividades_especificas_x_actividad_general',
            success: function (data) {
                $("#slc_actividad_espeficifica").html("");
                $("#slc_actividad_espeficifica").html(data);
                $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
            }
        });
    }  else {
        $("#slc_actividad_espeficifica").html('<option value=""></option>');
        $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
    }
    $("#disponible_compras").val("");
}

function cancelar_consulta_general(general){
    $('#slc_actividad_general').val(general);
    $('#slc_actividad_general').select2();
}

function consulta_especifica(especifica){  
    $("#datagried tbody").html('');
    calcularTotales();
    
    global_especifico  = especifica;
    if ( especifica != "") {
        var mensual_disponible = $("#slc_actividad_espeficifica option:selected").data('monto_disponible_mensual');
        $("#disponible_compras").val("$"+mensual_disponible);
    } else{
        $("#disponible_compras").val("");
    }    
}

function cancelar_consulta_especifica(especifica){
    $('#slc_actividad_espeficifica').val(especifica);
    $('#slc_actividad_espeficifica').select2();
}

function evaluar_cotizacion(){
    if ( $("#cotizacion_text").val() > 0 ) {
        $("#slcProyecto").prop('disabled', true);
        $("#slcProyecto").select2();
        $("#slc_presupuesto").prop('disabled', true);
        $("#slc_presupuesto").select2();
        $("#slc_actividad_general").prop('disabled', true);
        $("#slc_actividad_general").select2();
        $("#slc_actividad_espeficifica").prop('disabled', true);
        $("#slc_actividad_espeficifica").select2();
    }
}