$(document).ready(function () {
    //Calculo de la URL PATH
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    $('select').select2({placeholder: 'Seleccione una opción'});
    $(".select-edit").select2('destroy');
    $(".select-edit").hide();

    $(".soloNumeros").numeric('.');

    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#chkAfectaInventario").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnAfectaInv").val(1);
            } else {
                $("#hdnAfectaInv").val(0);
            }
        }
    });

    $("#txtFechaDoc").change(function () {
        var fecha_doc = $(this).val();
        var dias_proveedor = $("#slcProveedor option:selected").data('dias');
        if (fecha_doc != '' && dias_proveedor != '') {

            var fecha_selected = new Date($.datepicker.parseDate('dd-mm-yy', fecha_doc));
            fecha_selected.setDate(fecha_selected.getDate() + dias_proveedor);

            $("#txtFechaVencimiento").datepicker('setDate', fecha_selected);
        } else {
            $("#txtFechaVencimiento").val();
        }
    });

    $(".btn-close").live('click', function () {

        var iframe = $(this).data('iframe');

        alerta_confirm_ajax(cerrar_modal, iframe, 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    var id_bod;
    var id_cat;
    var id_prod;

    $("#frm-docProveedor").validate({
        ignore: [],
        rules: {
            slcProveedor: {required: true},
            slcTipoPago: {required: true},
            slcTipoDocumento: {required: true},
            txtSerieDoc: {required: true},
            txtNumDoc: {required: true},
            txtFechaDoc: {required: true},
            txtFechaConta: {required: true},
            txtFechaVencimiento: {required: true},
            slcTipo: {required: true},
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        invalidHandler: function (form, validator) {
            var errors = validator.numberOfInvalids();
            if (errors) {
                var primerElemento = validator.errorList[0].element;

                var posiciones = primerElemento.offsetTop;

                //console.log(primerElemento.id);
                $("html, body").animate({scrollTop: posiciones}, 1000);
            }
        },
        submitHandler: function (form) {
            if ($('#datagried tr').length <= 1) {
                crear_alerta('error', 'Productos', 'Debe seleccionar al menos un producto');
                return false;
            }

            $("#datagried tr .preciosUnidades").each(function () {
                var valor = $(this).val();
                if (valor == 0 || valor == '') {
                    crear_alerta('error', 'Productos', 'Debe asignarle un precio a todos los productos');
                    return false;
                }
            });

            form.submit();
        }
    });


    $(".positive").numeric({negative: false}, function () {
        alert("No negative values");
        this.value = "";
        this.focus();
    });

    $(".positive").live("focusout", function () {
        if ($(this).val() <= 0.0) {
            campo = $(this).attr("id");
            $(this).addClass('error');
            //document.getElementById('validar_'+campo+'').innerHTML='La cantidad debe ser mayor a uno';
            $('#validar_' + campo).text('La cantidad debe ser mayor a uno');
        }
    });

    $("#documento").blur(function () {
        var doc_numero = $(this).val();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/gestion_productos/validar_documento',
            data: {id: doc_numero},
            success: function (data) {
                if (data.drop != null) {
                    crear_alerta("info", "Aviso", "Por favor elija otro número de documento.");
                    $("#documento").focus().val('');
                }
            }
        });
    });

    $("#slcProveedor").change(function () {
        var proveedor = $(this).val();
        $("#slcDocAfecta").html('');
        $("#slcDocAfecta").select2();
        if (proveedor != '') {
            var fecha_doc = $("#txtFechaDoc").val();
            var dias_proveedor = $("#slcProveedor option:selected").data('dias');
            if (fecha_doc != '' && dias_proveedor != '') {

                var fecha_selected = new Date($.datepicker.parseDate('dd-mm-yy', fecha_doc));
                fecha_selected.setDate(fecha_selected.getDate() + dias_proveedor);

                $("#txtFechaVencimiento").datepicker('setDate', fecha_selected);
            } else {
                $("#txtFechaVencimiento").val();
            }

            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_documentos_proveedor',
                data: {proveedor: proveedor},
                type: 'POST',
                dataType: 'json',
                success: function (data) {
                    $("#slcDocAfecta").html(data.documentos);
                    $("#slcDocAfecta option[value='0']").text('');
                    $("#slcDocAfecta option[value='0']").val('');
                    $("#slcDocAfecta").select2({placeholder: "Seleccione una opción"});
                }
            });
        }
    });

    $(".selectorBodega").change(function () {
        var bodega = $(this).val();
        var idSector = $(this).data('sector');
        $("#" + idSector).html('');
        $("#" + idSector).select2();
        if (bodega != '') {
            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_sector_bodega',
                data: {bodega: bodega},
                type: 'POST',
                dataType: 'json',
                success: function (data) {
                    $("#" + idSector).html(data.sectores);
                    $("#" + idSector + " option[value='0']").text('');
                    $("#" + idSector + " option[value='0']").val('');
                    $("#" + idSector).select2({placeholder: 'Seleccione una opción'});
                }
            });
        }
    });

    $("#txtNumDocs").focusout(function () {
        var proveedor = $("#slcProveedor").val();
        var documento = $(this).val();
        if (proveedor != '' && documento != '') {
            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_documentos_proveedor',
                data: {proveedor: proveedor, numDocumento: documento},
                type: 'POST',
                dataType: 'json',
                success: function (data) {
                    data = parseFloat(data);
                    if (data > 0) {
                        $("#txtNumDoc").val('');                        
                        crear_alerta('info', 'Número de Documento', 'El número de documento ' +documento+' ya ha sido ingresado.');
                    }
                }
            });
        }
    });

     $("#btnCrear").mouseover(function (event) {
        return false;
        var proveedor = $("#slcProveedor").val();
        var documento = $("#txtNumDoc").val();

        if(proveedor != '' && documento!=''){
            wait.start();
            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_documentos_proveedor',
                data: {proveedor: proveedor, numDocumento: documento},
                type: 'POST',
                //dataType: 'json',
                success: function (data) {
                    data = parseFloat(data);
                    if (data > 0) {
                       crear_alerta('info', 'Número de Documento', 'El número de documento ' +documento+' ya ha sido ingresado.');
                       $("#txtNumDoc").val('');
                    }
                    wait.close();
                }
            });
        }else{
            crear_alerta('error', 'Error', 'Debe llenar los campos correspondientes');
        }
        
    });

    $("#btnCrear").click(function (event) {
        event.preventDefault();
        var proveedor = $("#slcProveedor").val();
        var documento = $("#txtNumDoc").val();
        if ($("#frm-docProveedor").valid()) {
            wait.start();
            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_documentos_proveedor',
                data: {proveedor: proveedor, numDocumento: documento},
                type: 'POST',
                dataType: 'json',
                success: function (data) {
                    data = parseFloat(data);
                    if (data > 0) {
                        $("#txtNumDoc").val('');
                        wait.close();
                        crear_alerta('info', 'Número de Documento', 'El número de documento ' +documento+' ya ha sido ingresado.');
                    } else {
                        $("#frm-docProveedor").submit();
                    }
                }
            });
        }
    });


    $("#editar").live("click", function () {
        event.preventDefault();
        //$(this).toggleClass('guardar editar');

        id_row = $(this).attr('name');

        var nuevo_cant = 1
        do {
            nuevo_cant = prompt("Ingrese nuevo valor de cantidad(Mayor a cero)", "1");

        } while ((nuevo_cant <= 0 || String(parseFloat(nuevo_cant)) == "NaN") && (nuevo_cant != null));

        if (nuevo_cant != null) {
            document.getElementById('cantidadl' + id_row + '').innerHTML = nuevo_cant;
            $('#cantidadi' + id_row + '').val(nuevo_cant);
        }

    });//Fin de editat

    $("#remove").live("click", function () {
        $(this).parents("tr").remove();
    });//Fin de eliminar

    $("#slcTipo").change(function () {
        //var bodega = $('#slcBodega').val();
        var tipoReq = $("#slcTipo").val();

        if (tipoReq > 0) {
            cargar_categorias(tipoReq);
        } else {
            $("#div-categorias").html('');
            $("#slcProductos").html('');
            $("#slcProductos").select2('destroy').select2();
            $("#datagried tbody").html('');
        }
    });

    $(".dinamic").live('change', function () {

        var tipoReq = $("#slcTipo").val();
        $("#slcImpuestos").html('');
        $("#slcImpuestos").select2();
        if (tipoReq == 1) {
            menor = Number($(this).attr('id')) + 2;
            bodega = 1;//$('#slcBodega').val();
            padre = $("select[class='dinamic']").last().val();
            $(".dinamic").each(function (index, el) {
                if ($(el).attr('id') > menor) {
                    $(el).parent('div').siblings('label').remove();
                    $(el).siblings('select').remove();
                    $(el).parent('div').parent('div').parent('div').remove();
                    $(el).remove();

                }
            });
            $(".plus:last").remove();
            $(this).next().append('<button class="btn plus">+</button>');
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {padre: padre},
                success: function (data) {
                    producto = data.producto;
                    impuestos = data.impuestos;
                    $("#slcProductos").html(producto);
                    $("#slcProductos option[value='0']").text('');
                    $("#slcProductos option[value='0']").val('');
                    $("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                    $("#slcMedidas").html('');
                    $("#slcMedidas").select2();
                    $("#slcImpuestos").html(impuestos);
                    $("#slcImpuestos").select2();

                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });
                }
            });
        } else if (tipoReq == 2) {
            menor = Number($(this).attr('id')) + 2;
            padre = $("select[class='dinamic']").last().val();
            $(".dinamic").each(function (index, el) {
                if ($(el).attr('id') > menor) {
                    $(el).parent('div').siblings('label').remove();
                    $(el).siblings('select').remove();
                    $(el).parent('div').parent('div').parent('div').remove();
                    $(el).remove();

                }
            });
            $(".plus:last").remove();
            $(this).next().append('<button class="btn plus">+</button>');
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {padre: padre, servicio: 1},
                success: function (data) {
                    servicios = data.producto;
                    impuestos = data.impuestos;
                    $("#slcProductos").html(servicios);
                    $("#slcProductos option[value='0']").text('');
                    $("#slcProductos option[value='0']").val('');
                    $("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                    $("#slcImpuestos").html(impuestos);
                    $("#slcImpuestos").select2();

                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });
                }
            });

        } else if (tipoReq == 3) {

            var categoria = $(this).val();
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_activos_tipo',
                data: {tipo_activo: categoria},
                success: function (data) {
                    producto = data.activos;
                    $("#slcProductos").html(producto);
                    $("#slcProductos option[value='0']").text('');
                    $("#slcProductos option[value='0']").val('');
                    $("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                }
            });

            $.ajax({
                dataType: 'json',
                type: 'post',
                //data: {producto: product},
                url: urlj + 'modulo_compras/procesos/get_impuestos',
                success: function (data) {
                    $("#dvImpuestos").show();
                    $("#slcImpuestos").html(data.impuestos);
                    $("#slcImpuestos").select2();
                }
            });
        }
    });

    $(".plus").live('click', function (event) {

        var tipoReq = $("#slcTipo").val();
        event.preventDefault();
        bodega = 1;//$('#slcBodega').val();
        padre = $("select[class*='dinamic']").last().val();

        if (tipoReq == 1) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {padre: padre},
                success: function (data) {
                    categoria = data.drop;
                    producto = data.producto;
                    $i = 0;
                    $(".plus").last().remove();
                    if (categoria.length > 0) {
                        numero = $('#div-categorias select').last().length + 1;
                        //<div class="form-row row-fluid"></div>
                        linea = $("#div-categorias").append(''
                                + '<div class="span7" style="margin-bottom: 10px;">'
                                + '<div class="row-fluid">'
                                + '<label class="form-label span3">Categoría:</label>'
                                + '<div class="span6 controls">'
                                + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                                + '</div></div></div>');
                        linea2 = $('select[class="dinamic"]').last().html();
                        nueva = linea2.replace(/#/g, numero);
                        $('#div-categorias').append(nueva);
                        $('select[class="dinamic"]').last().html(categoria);
                        $('select[class="dinamic"] option[value="0"]').last().text('');
                        $('select[class="dinamic"] option[value="0"]').last().val('');
                        $('select[class="dinamic"]').last().select2({placeholder: 'Seleccione una opción'});
                        $("#slcProductos").html(producto);
                        $("#slcProductos option[value='0']").text('');
                        $("#slcProductos option[value='0']").val('');
                        $("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                        $("#slcMedidas").html('');
                        $("#slcMedidas").select2();
                    } else {
                        $("#slcProductos").html(producto);
                        $("#slcMedidas").html('');
                        $("#slcMedidas").select2();
                        $.pnotify({
                            type: 'info',
                            title: 'Aviso',
                            text: 'No se encontraron mas dependencias.',
                            icon: 'ui-icon ui-icon-info',
                            opacity: 0.95,
                            history: false,
                            sticker: false
                        });
                    }

                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });


                }
            });
        } else if (tipoReq == 2) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {padre: padre, servicios: 1},
                success: function (data) {
                    categoria = data.drop;
                    servicios = data.servicios;
                    $i = 0;
                    $(".plus").last().remove();
                    if (categoria.length > 0) {
                        numero = $('#div-categorias select').last().length + 1;
                        linea = $("#div-categorias").append('<div class="form-row row-fluid">'
                                + '<div class="span7">'
                                + '<div class="row-fluid">'
                                + '<label class="form-label span3">Categoría:</label>'
                                + '<div class="span6 controls">'
                                + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                                + '</div></div></div></div>');
                        linea2 = $('select[class="dinamic"]').last().html();
                        nueva = linea2.replace(/#/g, numero);
                        $('#div-categorias').append(nueva);
                        $('select[class="dinamic"]').last().html(categoria);
                        $('select[class="dinamic"] option[value="0"]').last().text('');
                        $('select[class="dinamic"] option[value="0"]').last().val('');
                        $('select[class="dinamic"]').last().select2({placeholder: 'Seleccione una opción'});
                        $("#slcProductos").html(servicios);
                    } else {
                        $("#slcProductos").html(servicios);
                        $.pnotify({
                            type: 'info',
                            title: 'Aviso',
                            text: 'No se encontraron mas dependencias.',
                            icon: 'ui-icon ui-icon-info',
                            opacity: 0.95,
                            history: false,
                            sticker: false
                        });
                    }

                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });
                }
            });
        }
    });

    $("#slcProductos").change(function () {
        $("#productos_cantidad").hide();
        $("#productos_null").hide();
        var tipoReq = $("#slcTipo").val();
        product = $('#slcProductos').val();
        if (tipoReq == 1) {
            $("#slcMedidas").html('');
            $("#slcMedidas").select2();

            //Se obtienen los detalles del producto
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {producto: product},
                url: urlj + 'modulo_compras/procesos/get_detalles_producto',
                success: function (data) {
                    $("#dvMedidas").show();
                    $("#slcMedidas").html(data.medidas);
                    $("#slcMedidas option[value='0']").text('');
                    $("#slcMedidas option[value='0']").val('');
                    $("#slcMedidas").select2({placeholder: 'Seleccione una opción'});

                    //$("#dvImpuestos").show();
                    //$("#slcImpuestos").html(data.impuestos);
                    //$("#slcImpuestos option").attr('selected','selected');
                    //$("#slcImpuestos").select2();

                    $("#slcBodega").html(data.bodegas);
                    $("#slcBodega option[value='0']").text('');
                    $("#slcBodega option[value='0']").val('');
                    $("#slcBodega").select2({placeholder: 'Seleccione una opción'});

                    $("#slcSector").html(data.sectores);
                    $("#slcSector option[value='0']").text('');
                    $("#slcSector option[value='0']").val('');
                    $("#slcSector").select2({placeholder: 'Seleccione una opción'});

                }
            });
        } else if (tipoReq == 2) {
            $("#slcMedidas").html('');
            $("#slcMedidas").select2('destroy');
            $("#dvMedidas").hide();
            $("#txtCantidad").val(1);

            //Se obtienen los detalles del producto
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {producto: product},
                url: urlj + 'modulo_compras/procesos/get_detalles_producto',
                success: function (data) {
                    $("#slcBodega").html(data.bodegas);
                    $("#slcBodega option[value='0']").text('');
                    $("#slcBodega option[value='0']").val('');
                    $("#slcBodega").select2({placeholder: 'Seleccione una opción'});

                    $("#slcSector").html(data.sectores);
                    $("#slcSector option[value='0']").text('');
                    $("#slcSector option[value='0']").val('');
                    $("#slcSector").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else if (tipoReq == 3) {
            $("#slcMedidas").html('');
            $("#slcMedidas").select2('destroy');
            $("#dvMedidas").hide();
            $("#txtCantidad").val(1);
        }
    });

    $("#categoria").change(function () {
        $("#categoria option:selected").each(function () {
            bodega = $('#bodega').val();
            categoria = $('#categoria').val();

            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/gestion_productos/get_productos_xcat',
                data: {bodega_sel: bodega, categoria_sel: categoria},
                success: function (data) {
                    $("#slcProductos").html(data.drop);
                }
            });

            $('#slcProductos')
                    .find('option')
                    .remove()
                    .end()
                    .append('<option>Seleccione una opción</option>')
                    ;

            $("#slcProductos").select2('destroy').select2();

            $('#cantidad').val('');

        });
    }); //end of function categoria

    var row = 0;
    if ($('#datagried tr').length > 0) {
        row = $("#datagried tr").length;
    }
    $("#agregar").click(function () {
        $("#cabezera").show();

        var tipoReq = $("#slcTipo").val();
        var cantidad = $('#txtCantidad').val();
        var producto = $('#slcProductos').val();
        var precio = $("#txtPrecio").val();
        var tipo_venta = ($("#slcTipoVenta").val() != '' && $("#slcTipoVenta").val() != null) ? $("#slcTipoVenta").val() : '';
        var nombreTipoVenta = ($("#slcTipoVenta").val() != '' && $("#slcTipoVenta").val() != null) ? $("#slcTipoVenta option:selected").text() : '';
        var impuestos = ($("#slcImpuestos").val() != '' && $("#slcImpuestos").val() != null) ? $("#slcImpuestos").val() : '';
        var retenciones = ($("#slcRetenciones").val() != '' && $("#slcRetenciones").val() != null) ? $("#slcRetenciones").val() : '';
        var medidas = ($('#slcMedidas').val() != '' && $('#slcMedidas').val() != null) ? $('#slcMedidas').val() : '';
        var medidasHtml = "";
        var codigoProducto = $('#slcProductos option:selected').data('codigo');
        var nombreArticulo = $('#slcProductos option:selected').data('nombre');
        var nombreMedida = "";
        var bodegaProd = ($("#slcBodega").val() != '' && $("#slcBodega").val() != null) ? $("#slcBodega").val() : '';
        var sectorProd = ($("#slcSector").val() != '' && $("#slcSector").val() != null) ? $("#slcSector").val() : '';
        var nombreSectorProd = $("#slcSector option:selected").text();

        var ocultar = "";

        //Se realizan las validaciones en base al tipo de Orden
        if (tipoReq == 1) {
            if ((cantidad <= 0) || medidas == '' || producto == '' || precio == '') {
                crear_alerta('info', 'Productos', 'Debe especificar las características del producto');
                return false;
            }
            medidasHtml = $("#slcMedidas").html();
            nombreMedida = $("#slcMedidas option:selected").text();
        } else if (tipoReq == 2) {
            if (cantidad == '' || !parseInt(producto) || precio == '') {
                crear_alerta('info', 'Servicio', 'Debe especificar las características del servicio');
                return false;
            }
            ocultar = "display:none;";
        } else if (tipoReq == 3) {
            if (cantidad == '' || !parseInt(producto) || precio == '') {
                crear_alerta('info', 'Activo Fijo', 'Debe especificar las características del activo fijo');
                return false;
            }
            ocultar = "display:none;";
        } else {
            crear_alerta('info', 'Documento por Proveedor', 'Debe especificar el tipo de documento');
            return false;
        }

        var slcImpuestosHtml = getOpcionesSelect("slcImpuestos");
        var slcRetencionesHtml = getOpcionesSelect("slcRetenciones");
        var slcTipoVentaHtml = getOpcionesSelect("slcTipoVenta");
        var slcBodegaHtml = getOpcionesSelect("slcBodega");
        var slcSectorHtml = getOpcionesSelect("slcSector");

        slcImpuestosHtml = slcImpuestosHtml.replace(/"/g, "'");
        slcRetencionesHtml = slcRetencionesHtml.replace(/"/g, "'");
        slcTipoVentaHtml = slcTipoVentaHtml.replace(/"/g, "'");
        slcBodegaHtml = slcBodegaHtml.replace(/"/g, "'");
        slcSectorHtml = slcSectorHtml.replace(/"/g, "'");

        var subTotal = cantidad * precio;
        var totalImpuestos = parseFloat(calcularGastosMultiSelect("slcImpuestos", "data-porcentaje", subTotal));
        var totalRetenciones = parseFloat(calcularGastosMultiSelect("slcRetenciones", "data-porcentaje", precio));

        totalRetenciones = totalRetenciones * cantidad;

        var TotalProducto = (subTotal - totalRetenciones) + totalImpuestos;

        var html = '';
        var idTr = "tr_" + producto;


        if ($("#" + idTr).length > 0) {
            crear_alerta('error', 'Orden de compra', 'El producto ya fue ingresado.');
            return false;
        }

        var htmlModalProrrateo = "";

        htmlModalProrrateo = getModalProrrateo(producto);

        var orden_compra = $("#slcOrdenCompra").val();

        html += '<tr id="' + idTr + '" data-id="' + row + '"><td>';
        html += '<input type="hidden" name="conversion[]" id="hdnConversion_' + row + '" value="' + medidas + '"/>';
        html += '<input type="hidden" name="productos[]" id="hdnProducto_' + row + '" value="' + producto + '"/>';
        html += '<input type="hidden" name="prorrateos[]" id="hdnProrrateo_' + row + '" value="" class="Prorrateos"/>';
        html += '<input type="hidden" name="porcProrrateo[]" id="hdnPorcProrrateo_' + row + '" value="" class="prcProrateo"/>';
        html += '<input type="hidden" id="hdnHtmlProrrateo_' + row + '" value="" class="htmlProrrateo" data-table="" data-prorrateo="" data-detalles="" />';
        //html += '<input type="hidden" name="cantidades[]" id="hdnCantidad_' + row + '" value="' + cantidad + '"/>';
        //html += '<input type="hidden" name="precios[]" id="hdnPrecio_' + row + '" value="' + precio + '"/>';
        html += '<input type="hidden" name="retenciones[]" id="hdnRetenciones_' + row + '" value="' + retenciones + '"/>';
        html += '<input type="hidden" name="impuestos[]" id="hdnImpuestos_' + row + '" value="' + impuestos + '"/>';
        html += '<input type="hidden" name="descuentos[]" id="hdnDescuentos_' + row + '" value="0" class="descuentosProducto"/>';
        html += '<input type="hidden" name="bodegas[]" id="hdnBodega_' + row + '" value="' + bodegaProd + '"/>';
        html += '<input type="hidden" name="sectores[]" id="hdnSector_' + row + '" value="' + sectorProd + '"/>';

        html += '<label id="dato_prod_nom"/>' + codigoProducto + '</td>';
        html += '<td><label id="dato_prod_nom"/>' + nombreArticulo + '</td>';

        //Se formatean los montos
        cantidad = number_format(cantidad, 0);
        precio = number_format(precio, 2);
        totalImpuestos = number_format(totalImpuestos, 2);
        subTotal = number_format(subTotal, 2);
        TotalProducto = number_format(TotalProducto, 2);

        html += '<td>';
        html += '<input type="text" class="text tables-input selects-text" value="' + nombreMedida + '" readonly="readonly"/>';
        html += '<select id="slcMedidas_' + row + '" data-id="' + row + '" style="display:none;" class="selects-edit">' + medidasHtml + '</select>';
        html += '</td>';

        html += '<td style="' + ocultar + '">';
        html += '<a href="#modalBodegas" id="lnkSector_' + row + '" data-tipo="1" data-input="txtSector_' + row + '" data-etiqueta-padre="Bodega" data-etiqueta="Sector" data-html-padre="' + slcBodegaHtml + '" data-html="' + slcSectorHtml + '" data-id="' + row + '" data-hiddenPadre="hdnBodega_' + row + '" data-hidden="hdnSector_' + row + '" class="icon-table modalBodegas"><span class="icon16 icomoon-icon-list-view"></span></a>';
        html += '<input type="text" id="txtSector_' + row + '" class="text tables-input input-table" value="' + nombreSectorProd + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtCantidad_' + row + '" name="cantidades[]" class="text tables-input-show tables-input cantidadProducto" value="' + cantidad + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtPrecioUnitario_' + row + '" name="precios[]" class="text tables-input-show tables-input soloNumeros preciosUnidades" extras="." value="' + precio + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<a href="#modalSelect" id="lnkRetenciones_' + row + '" data-tipo="2" data-input="txtRetencion_' + row + '" data-etiqueta="Retenciones" data-html="' + slcRetencionesHtml + '" data-id="' + row + '" data-hidden="hdnRetenciones_' + row + '" class="icon-table multiSelectModal"><span class="icon16 icomoon-icon-list-view"></span></a>';
        html += '<input type="text" id="txtRetencion_' + row + '" name="retencionesProducto[]" class="text tables-input soloNumeros input-table retencionesProducto" extras="." value="' + totalRetenciones + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + nombreTipoVenta + '" readonly="readonly"/>';
        html += '<select id="slcTipoVenta_' + row + '" name="tiposVenta[]" data-id="' + row + '" style="display:none;" class="select-edit">' + slcTipoVentaHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<a href="#modalSelect" id="lnkImpuestos_' + row + '" data-tipo="1" data-input="txtImpuesto_' + row + '" data-etiqueta="Impuestos" data-html="' + slcImpuestosHtml + '" data-id="' + row + '" data-hidden="hdnImpuestos_' + row + '" class="icon-table multiSelectModal"><span class="icon16 icomoon-icon-list-view"></span></a>';
        html += '<input type="text" id="txtImpuesto_' + row + '" name="impuestosProducto[]" class="text tables-input soloNumeros input-table impuestosProducto" extras="." value="' + totalImpuestos + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtSubtotal_' + row + '" name="subtotalesProducto[]" class="text tables-input subtotalProductos" extras="." value="' + subTotal + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtTotal_' + row + '" name="totalesProducto[]" class="text tables-input totalProductos" extras="." value="' + TotalProducto + '" readonly="readonly"/>';
        html += '</td>';
        html += '<td>';
        if (!orden_compra > 0) {

            html += '<button type="button" class="btn btn-primary btn-mini btnGuardarProd" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;">Guardar</button>';
            html += '<button type="button" class="btn btn-primary btn-mini btnEditProd" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;">Editar</button>';
            html += '<button type="button" class="btn btn-danger btn-mini btnDelProd" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;">Eliminar</button>';
        }

        //if (tipoReq == 1) {
        html += '<a href="#modalProrrateo_' + producto + '" style="margin-left: 10px;" id="lnkProrrateo_' + row + '" data-id="' + row + '" data-prod="' + producto + '" class="icon-table prorrateosModal"><span class="icon16 icomoon-icon-list-view-2"></span></a>';

        html += htmlModalProrrateo;
        //}
        html += '</td>';

        html += '</tr>';

        $("#datagried").append(html);

        if ($('#datagried tr').length > 0)
        {
            $('#datagried').removeClass('error');
            $('#validar_datagried').text('');
        }


        limpiar_filtro_categorias();
        $("#txtCantidad").val('');
        $("#txtDescuento").val('');
        $("#txtPrecio").val('');
        $('#slcProductos option:selected').removeAttr('selected');
        $('#slcProductos').select2({placeholder: 'Seleccione una opción'});
        $('#slcMedidas option:selected').removeAttr('selected');
        $('#slcMedidas').select2({placeholder: 'Seleccione una opción'});
        $('#slcTipoVenta option:selected').removeAttr('selected');
        $('#slcTipoVenta').select2({placeholder: "Seleccione una opción"});
        $('#slcImpuestos option:selected').removeAttr('selected');
        $('#slcImpuestos').select2({placeholder: 'Seleccione una opción'});
        $('#slcRetenciones option:selected').removeAttr('selected');
        $('#slcRetenciones').select2({placeholder: 'Seleccione una opción'});
        $("#slcBodega option:selected").removeAttr('selected');
        $("#slcBodega").select2({placeholder: 'Seleccione una opción'});
        $("#slcSector option:selected").removeAttr('selected');
        $("#slcSector").select2({placeholder: 'Seleccione una opción'});

        row = row + 1;
        //Se actualizan los totales
        calcularTotales();
    });//En of function agregar

    $(".btnEditProd").live('click', function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id + " .select-text").hide();

        $("#" + parent[0].id + " .select-edit").select2();
        $("#" + parent[0].id + " .select2-container").css('width', '100%');
        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');

        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarProd").show();
    });

    //Guardar 
    $(".btnGuardarProd").live('click', function () {
        var parent = $(this).parent().parent();

        var id_parent = $("#" + parent[0].id).data('id');

        var txtCantidad = $("#txtCantidad_" + id_parent).val();
        var txtPrecio = $("#txtPrecioUnitario_" + id_parent).val();
        var txtDescuento = $("#txtDescuento_" + id_parent).val();

        if (txtCantidad == '' || txtCantidad == 0) {
            crear_alerta('error', 'Orden de compra', 'Debe ingresar una cantidad válida');
            return false;
        }

        if (txtPrecio == '' || txtPrecio == 0) {
            crear_alerta('error', 'Orden de compra', 'Debe ingresar un precio válido');
            return false;
        }

        $("#" + parent[0].id + " .select-edit").each(function () {
            var select_id = $(this).attr('id');
            var valor = $("#" + select_id).val();
            var text = $("#" + select_id + " option:selected").text();
            if (valor != '') {
                $("#" + select_id).prev().val(text);
            } else {
                $("#" + select_id).prev().val('');
            }
            $("#" + select_id).prev().show();
        });

        $("#" + parent[0].id + " .select-edit").select2('destroy');
        $("#" + parent[0].id + " .select-edit").hide();


        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');
        $(this).hide();
        $("#" + parent[0].id + " .btnEditProd").show();

        //Se calculan los totales de la fila
        calcularTotalFila(parent[0].id);
        calcularMontosMultiSelect(parent[0].id);
        //Se actualizan los totales
        calcularTotales();
    });


    //Eliminar Producto
    $(".btnDelProd").live("click", function () {
        var parent = $(this).parent().parent();

        $("#" + parent[0].id).remove().delay(300);

        //Se actualizan los totales
        calcularTotales();
    });

    //Modal de Multiselects
    $(".multiSelectModal").fancybox({
        width: '75%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            //var id = $(this.element[0]).attr('data-id');
            var etiqueta = $(this.element[0]).attr('data-etiqueta');
            var html = $(this.element[0]).attr('data-html');
            var id = $(this.element[0]).attr('id');
            $("#hdnElementoOculto").val(id);
            $("#lblSelect").text(etiqueta + ':');
            $("#slcMultiCargos").html(html);
            $("#slcMultiCargos").select2();
        },
        beforeClose: function () {
            $("#hdnElementoOculto").val('');
            $("#lblSelect").text('');
            $("#slcMultiCargos").html('');
            $("#slcMultiCargos").select2('destroy');
        }
    });


    //Modal de Prorrateos
    $(".prorrateosModal").fancybox({
        width: '90%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        //closeBtn: false,
        hideOnOverlayClick: true,
        helpers: {
            overlay: {closeClick: false} // prevents closing when clicking OUTSIDE fancybox 
        },
        beforeLoad: function () {
            var prod = $(this.element[0]).attr('data-prod');
            $("#slcProrrateo_" + prod).select2({placeholder: "Seleccione una opción"});
            $("#slcCentroCosto_" + prod).select2({placeholder: "Seleccione una opción"});
        },
        beforeClose: function () {

        }
    });

    $("#btnGuardarSelect").click(function () {
        var idLink = $("#hdnElementoOculto").val();

        var idSeleccionados = $("#slcMultiCargos").val();
        var idHidden = $("#" + idLink).attr('data-hidden');
        var idInput = $("#" + idLink).attr('data-input');
        var tipo = $("#" + idLink).attr('data-tipo');

        $("#" + idHidden).val(idSeleccionados);

        var opciones = "";//$("#slcMultiCargos").html();

        $("#slcMultiCargos option").each(function () {

            if (!$(this).attr('selected')) {
                $(this).removeAttr('selected');
            } else {
                $(this).attr('selected', 'selected');
            }
            //console.log($(this).attr('selected'));
            //console.log(this);
            opciones += this.outerHTML;
        });
        //console.log(opciones);
        $("#" + idLink).attr('data-html', opciones);

        var parent = $("#" + idLink).parent().parent();
        var cantidad = parent.find('.cantidadProducto').val().replace(/,/g, "");
        var subtotal = 0.00;//parent.find('.subtotalProductos').val();
        if (tipo == 1) {
            var subtotal = parent.find('.subtotalProductos').val().replace(/,/g, "");
        } else if (tipo == 2) {
            var subtotal = parent.find('.preciosUnidades').val().replace(/,/g, "");
        }
        var montoSubtotal = calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subtotal);

        if (tipo == 2) {
            montoSubtotal = montoSubtotal * cantidad;
        }

        $("#" + idInput).val(montoSubtotal);

        calcularTotalFila(parent[0].id);
        //Se actualizan los totales
        calcularTotales();

        $.fancybox.close();
    });

    //Modal de Sectores
    $(".modalBodegas").fancybox({
        width: '75%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            //var id = $(this.element[0]).attr('data-id');
            var etiqueta = $(this.element[0]).attr('data-etiqueta');
            var html = $(this.element[0]).attr('data-html');
            var etiqueta_padre = $(this.element[0]).attr('data-etiqueta-padre');
            var html_padre = $(this.element[0]).attr('data-html-padre');

            $("#hdnElementoOcultoSec").val($(this.element[0]).attr('id'));
            $("#lblSelectPadre").text(etiqueta_padre + ':');
            $("#slcOpcionesPadre").html(html_padre);
            $("#slcOpcionesPadre").select2({placeholder: "Seleccione una opción"});

            $("#lblSelectHijo").text(etiqueta + ':');
            $("#slcOpcionesHijo").html(html);
            $("#slcOpcionesHijo").select2({placeholder: "Seleccione una opción"});

        },
        beforeClose: function () {
            $("#hdnElementoOcultoSec").val('');
            $("#lblSelectPadre").text('');
            $("#slcOpcionesPadre").html('');
            $("#slcOpcionesPadre").select2('destroy');

            $("#lblSelectHijo").text('');
            $("#slcOpcionesHijo").html('');
            $("#slcOpcionesHijo").select2('destroy');
        }
    });

    $("#btnGuardarSelectSector").click(function () {
        var idLink = $("#hdnElementoOcultoSec").val();

        var idPadre = $("#slcOpcionesPadre").val();
        var idDependencia = $("#slcOpcionesHijo").val();
        var textoDependencia = $("#slcOpcionesHijo option:selected").text();
        var idHidden = $("#" + idLink).attr('data-hidden');
        var idHiddenPadre = $("#" + idLink).attr('data-hiddenPadre');
        var idInput = $("#" + idLink).attr('data-input');


        if (idPadre == '' || idDependencia == '') {
            //crear_alerta('error','Sectores','Debe completar todos los campos.');
        }

        $("#" + idHidden).val(idDependencia);
        $("#" + idHiddenPadre).val(idPadre);

        var opcionesPadre = "";
        var opcionesDependencia = "";

        opcionesPadre = getOpcionesSelect('slcOpcionesPadre');
        opcionesDependencia = getOpcionesSelect('slcOpcionesHijo');

        $("#" + idLink).attr('data-html-padre', opcionesPadre);
        $("#" + idLink).attr('data-html', opcionesDependencia);

        $("#" + idInput).val(textoDependencia);
        $.fancybox.close();
    });


    //Calculo cuando es desde una requisicion
    $(".input-requisicion").live('keyup', function () {
        var parent = $(this).parent().parent();

        var valor = parseFloat($(this).val());

        var inputHidden = $(this).data('hidden');

        $("#" + inputHidden).val(valor);

        var cantidad = parseFloat($("#" + parent[0].id).find('.cantidadProducto').val());
        var precio = parseFloat($("#" + parent[0].id).find('.preciosUnidades').val());

        var subtotal = number_format(parseFloat(cantidad * precio), 2);

        $("#" + parent[0].id).find('.subtotalProductos').val(subtotal);

        calcularTotalFila(parent[0].id);
        calcularTotales();
    });


    //Carpeta de Anexos
    var anx = 0;
    var folder_anx_temp = $('#carpeta_temporal').attr('value');
    var ruta_anx = urlj + 'inicio/guardar_gral/' + folder_anx_temp;
    new FUload('btnAnexo', ruta_anx, {
        start: function (file) {
            wait.start();
        },
        sucess: function (data) {
            wait.close();

            if ($.trim(data) !== "") {

                var a_exten = $.trim(data).split('.');

                var exten = "." + a_exten[(a_exten.length - 1)];
                // verifica existencia del mismo documento en la carpeta.
                var preview = "<tr id='preview" + anx + "' style='display:none;' class='preview_documento'>";
                if (a_exten[(a_exten.length - 1)] === 'png' || a_exten[(a_exten.length - 1)] === 'jpg' || a_exten[(a_exten.length - 1)] === 'jpeg' || a_exten[(a_exten.length - 1)] === 'pdf') {
                    preview += "<td><a  title=\"Ver Anexo\" class='ver_en_modal fancybox-buttons' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                } else {
                    preview += "<td><a target='_blank' title=\"Ver Anexo\" class='' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                }

                preview += "<img id='pre" + anx + "' src='' width='88' height='88' class='imagen_documento'></a></td>";
                preview += "<td><input maxlength='75' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc[]' value='" + $.trim(data).replace(exten, '') + "'><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc" + anx + "'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                //preview+="<td><input maxlength='50' readonly='readonly' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc"+i+"' value='"+$.trim(data).replace(exten,'')+"'><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc"+i+"'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                preview += "<td style='vertical-align:middle !important; width:30px !important;'><img  style='display:none;' src='" + urlj + "media/editar_documento.png" + "' title='Editar' value='titulo_doc" + anx + "' class='editar_documento'/></td>";
                preview += "<td style='background:#E1E7F0!important;'><a href=\"javascript: void(0);\" title=\"Eliminar Anexo\" class='eliminar_imagen' id='delete" + anx + "' custom='' custom_id=''><img class='quitar_documento' src='" + urlj + "media/eliminar_documento.png" + "' title='Eliminar documento'></a></div>";
                preview += "<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></td></tr>";

                $("#previews").append(preview).show(300);
                $("#awesome_form").append("<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></div>");
                $("#preview" + anx).fadeIn(400);

                //document.getElementById('pre'+i).src=base+"media/imagenes/sistema/pdf.png";
                document.getElementById('pre' + anx).src = urlj + "media/imagenes/sistema/" + a_exten[(a_exten.length - 1)] + ".png";
                document.getElementById('ruta' + anx).value = $.trim(data);
                document.getElementById('delete' + anx).custom = $.trim(data);
                document.getElementById('delete' + anx).custom_id = i;
                valor = document.getElementById('pre' + anx).src;

                // $('input[name=titulo_doc'+i+']').focus();
                // nombre_doc=$('input[name=titulo_doc'+i+']').val();

                anx++;
                $(".eliminar_imagen, .verAnexo").tooltip();
            } else { //el formato es incorrecto
                crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
            }
        }
    });

    $(".eliminar_imagen").live("click", function (event) {
        event.preventDefault();

        url = this.custom;
        id_key = this.custom_id;
        id = this.id;
        $.ajax({
            type: 'POST',
            url: urlj + 'inicio/eliminar_imagen_gral/' + folder_anx_temp,
            data: {url: url},
            success: function (data) {
                $("#ruta" + id_key).val("");
                $("#" + id).parent().parent().remove().delay(300);
            }
        });
    });

    $(".delete_anexo").live('click', function (event) {
        event.preventDefault();

        var anexo = $(this).data('anexo');

        $("#anexo_" + anexo).remove().delay(500);
    });

    $(".verAnexo").fancybox({
        openEffect: 'elastic',
        closeEffect: 'elastic',
        href: $(this).attr('href'),
        type: 'iframe',
        helpers: {
            title: {
                type: 'inside'
            }
        }
    });

    $(".selectorProrrateo").live('change', function () {

        var slcElementoHijo = $(this).data('centro');
        var prorrateo = $(this).val();
        var prod = $(this).data('prod');

        $("#tbProrrateo_" + prod).html('');
        if (prorrateo != '') {
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {prorrateo: prorrateo},
                url: urlj + 'modulo_compras/procesos/get_detalle_prorrateo',
                success: function (data) {
                    $("#" + slcElementoHijo).html(data.opciones);
                    $("#" + slcElementoHijo + " option[value='0']").text('');
                    $("#" + slcElementoHijo + " option[value='0']").val('');
                    $("#" + slcElementoHijo).select2({placeholder: 'Seleccione una opción'});
                }
            });
        }
    });

    $(".selectorCentroCostos").live('change', function () {

        var centro = $(this).val();
        var porcentaje = 0;
        var prod = $(this).data('prod');

        if (centro > 0) {
            porcentaje = $("#" + this.id + " option:selected").data('porcentaje');
            $("#txtPorcentaje_" + prod).val(porcentaje);
        } else {
            $("#txtPorcentaje_" + prod).val('');
        }
    });

    $(".btnAgregarCentroCosto").live('click', function () {
        var html = '';
        var prod = $(this).data('prod');

        var centro_costo = $("#slcCentroCosto_" + prod).val();
        var centro_costo_nombre = $("#slcCentroCosto_" + prod + " option:selected").text();
        var porcentaje = $("#txtPorcentaje_" + prod).val();
        var cuenta_contable = $("#slcCentroCosto_" + prod + " option:selected").data('cuenta');

        porcentaje = parseFloat(porcentaje);

        var totalProd = parseFloat($("#tr_" + prod).find('.totalProductos').val());


        var total = (porcentaje / 100) * totalProd;

        if (centro_costo_nombre == '' || porcentaje == '') {
            crear_alerta('error', 'Prorrateo', 'Debe completar todos los campos.');
            return false;
        }

        var idTr = "tr_cec_" + centro_costo;

        if ($("#" + idTr).length > 0) {
            crear_alerta('error', 'Prorrateo', 'El centro de costo ya fue ingresado.');
            return false;
        }

        var totalPorc = 0;
        $("#tbProrrateo_" + prod + " > tr .porcentajeCentroCos").each(function () {
            var valor = $(this).val();
            valor = parseFloat(valor);
            totalPorc += valor;
        });

        totalPorc = porcentaje + totalPorc;

        if (totalPorc > 100) {
            crear_alerta('error', 'Prorrateo', 'El porcentaje no debe ser mayor al 100%');
            return false;
        }

        html += '<tr id="' + idTr + '" data-id="' + centro_costo + '" data-prod="' + prod + '"><td>';
        html += '<input type="hidden" name="centroCostos_' + prod + '[]" id="hdnCentroCosto_' + centro_costo + '" value="' + centro_costo + '"/>';
        html += centro_costo_nombre + '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input" value="' + cuenta_contable + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtPorcentaje_' + centro_costo + '" name="porcentajesCec_' + prod + '[]" class="text tables-input-show tables-input porcentajeCentroCos" value="' + number_format(porcentaje, 2) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input totalCentroCos" id="txtTotalCec_' + centro_costo + '" name="totalCec_' + prod + '[]" value="' + number_format(total, 2) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<button type="button" class="btn btn-primary btn-mini btnGuardarCec" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;">Guardar</button>';
        html += '<button type="button" class="btn btn-primary btn-mini btnEditCec" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;">Editar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelCec" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;">Eliminar</button>';
        html += '</td>';

        html += '</tr>';

        $("#tbProrrateo_" + prod).append(html);

        $("#slcCentroCosto_" + prod + " option:selected").removeAttr('selected');
        $("#slcCentroCosto_" + prod).select2({placeholder: "Seleccione una opción"});
        $("#txtPorcentaje_" + prod).val('');
    });

    $(".btnEditCec").live('click', function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id + " .select-text").hide();

        $("#" + parent[0].id + " .select-edit").select2();
        $("#" + parent[0].id + " .select2-container").css('width', '100%');
        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');

        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarCec").show();
    });

    //Guardar 
    $(".btnGuardarCec").live('click', function () {
        var parent = $(this).parent().parent();
        var tbody = $(this).parent().parent().parent();
        var id_parent = $("#" + parent[0].id).data('id');
        var prod = $("#" + parent[0].id).data('prod');

        var totalProd = parseFloat($("#tr_" + prod).find('.totalProductos').val());

        var txtPorcentaje = $("#txtPorcentaje_" + id_parent).val();

        var total = 0;

        if (txtPorcentaje == '' || txtPorcentaje == 0) {
            crear_alerta('error', 'Prorrateo', 'Debe ingresar un porcentaje válido');
            return false;
        }

        //$("#" + parent[0].id + " .select-edit").select2('destroy');
        //$("#" + parent[0].id + " .select-edit").hide();
        var totalPorc = 0;
        $("#" + tbody[0].id + " > tr .porcentajeCentroCos").each(function () {
            var valor = $(this).val();
            valor = parseFloat(valor);
            totalPorc += valor;
        });

        if (totalPorc > 100) {
            crear_alerta('error', 'Prorrateo', 'El porcentaje no debe ser mayor al 100%');
            return false;
        }

        $("#txtPorcentaje_" + id_parent).val(number_format(txtPorcentaje, 2));
        total = (txtPorcentaje / 100) * totalProd;

        $("#txtTotalCec_" + id_parent).val(number_format(total, 2));

        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');
        $(this).hide();
        $("#" + parent[0].id + " .btnEditCec").show();
    });

    //Eliminar Producto
    $(".btnDelCec").live("click", function () {
        var parent = $(this).parent().parent();

        $("#" + parent[0].id).remove().delay(300);
    });

    $(".btnGuardarPro").live('click', function () {

        var prod = $(this).attr('data-prod');

        if ($("#slcProrrateo_" + prod).val() > 0) {
            var totalPorc = 0;
            $("#tblProrrateo_" + prod + " tr .porcentajeCentroCos").each(function () {
                var valor = $(this).val();
                valor = parseFloat(valor);
                totalPorc += valor;
            });

            if (totalPorc != 100) {
                crear_alerta('error', 'Prorrateo', 'El porcentaje debe ser igual 100%');
                return false;
            }
            jQuery.fancybox.close();
        } else {
            jQuery.fancybox.close();
        }
    });

    $("#registrar_solicitud").click(function () {
        if ($('#datagried tr').length <= 1 || $('#descripcion_req').val().trim() == '' || $('#fecha').val() == '' || $('#documento').val() == '') {
            //alert("Debe haber agregado al menos un producto y descripción!"); //Deshabilitado mientras provisional de requisiciones UTE
            if ($('#datagried tr').length <= 1) {
                $('#datagried').addClass('error');
                $('#validar_datagried').text('Debe seleccionar al menos un producto');
            }

            if ($("#descripcion_req").val() == '') {
                $('#descripcion_req').addClass('error');
                $('#validar_descripcion_req').text('Campo requerido');
            }
            /*if ($('#documento').val() == '') {
             //$('#documento').addClass('error');
             $('#validar_documento').text('Campo requerido');
             }*/
            if ($('#bodega').val() == '') {
                //$('#documento').addClass('error');
                $('#validar_bodega').text('Campo requerido');
            }

        } else {
            $("#fecha").prop('disabled', false);
            $("#documento").prop('disabled', false);
            $("#frm").submit();
        }
    });
});

function reestablecerAnexo() {
    $('#txtTituloAnexoDoc').val('');
    $("#txtTituloAnexoDoc").attr('readonly', 'readonly');
    $("#txtTituloAnexoDoc").removeAttr('style');
    $("#del_anexo").attr('href', '#');
    $("#link_anexo").attr('href', '#');
    $("#ruta_temporal").val('');
    $("#titulo_temporal").val('');
    $("#link_anexo, #del_anexo ").hide('slow');
    $("#btnAnexoDoc").show('slow');
}

function cargar_categorias(tipoOrden, edicion) {

    $("#div-categorias").html('');
    $("#slcProductos").html('');
    $("#slcProductos").select2('destroy').select2();
    if (edicion == '') {
        $("#datagried tbody").html('');
    }

    if (tipoOrden) {
        tipoOrden = parseInt(tipoOrden);
        switch (tipoOrden) {
            case 1:
                $("#dvImpuestos").show();
                $("#slcMedidas").html('');
                $("#dvMedidas").show();
                $("#slcMedidas").select2();
                $("#dvBodegas").show();
                $("#dvSectores").show();
                $("#thSector").show();
                break;
            case 2:
                $("#dvBodegas").hide();
                $("#dvSectores").hide();
                $("#slcMedidas").html('');
                $("#dvMedidas").hide();
                $("#slcMedidas").select2();
                $("#thSector").hide();
                break;
            case 3:
                $("#slcMedidas").html('');
                $("#slcMedidas").select2('destroy');
                $("#dvMedidas").hide();
                $("#dvBodegas").hide();
                $("#dvSectores").hide();
                $("#thSector").hide();
                break;
        }

        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'modulo_compras/procesos/get_categorias_productos',
            data: {tipo: tipoOrden},
            success: function (data) {
                //$("#departamento").html(data.drop);

                $("#div-categorias").html(
                        '<div class="span7" style="margin-bottom:10px;">'
                        + '<div class="row-fluid">'
                        + '<label class="form-label span3">Categoría:</label>'
                        + '<div class="span6 controls">'
                        + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                        + '</div></div></div>');
                $(".dinamic").html(data.categoria);
                $('.dinamic option[value="0"]').text('');
                $('.dinamic option[value="0"]').val('');
                $('.dinamic').select2({placeholder: "Seleccione una opción"});
                producto = data.producto;
                $("#slcProductos").html(producto);
                $('#slcProductos option[value="0"]').text('');
                $('#slcProductos option[value="0"]').val('');
                $("#slcProductos").select2('destroy').select2({placeholder: "Seleccione una opción"});
            }
        });
    }
}

function calcularGastosMultiSelect(idElemento, nombreAtributo, subTotalString) {
    var total = 0;
    var subTotal = subTotalString.toString().replace("$", '');

    subTotal = parseFloat(subTotal);
    $("#" + idElemento + " option:selected").each(function () {

        var porcentaje = $(this).attr(nombreAtributo);
        porcentaje = parseFloat(porcentaje) / 100;

        total += (porcentaje * subTotal);
    });
    return number_format(total, 2);
}

function calcularTotalFila(idFila) {

    var cantidad = parseFloat($("#" + idFila).find('.cantidadProducto').val());
    var precio = parseFloat($("#" + idFila).find('.preciosUnidades').val());
    var impuestos = parseFloat($("#" + idFila).find('.impuestosProducto').val());
    var descuentos = parseFloat($("#" + idFila).find('.descuentosProducto').val());
    var retenciones = parseFloat($("#" + idFila).find('.retencionesProducto').val());
    var subTotal = (cantidad * precio);//parseFloat($("#"+idFila).find('.subtotalProductos').val());

    descuentos = (descuentos > 0) ? descuentos : 0;

    var montoDescuento = (descuentos / 100) * subTotal;

    var total = (subTotal - montoDescuento - retenciones) + impuestos;

    $("#" + idFila).find('.subtotalProductos').val(number_format(subTotal, 2));

    $("#" + idFila).find('.totalProductos').val(number_format(total, 2));

    var producto = $("#" + idFila).find('[name="productos[]"]').val();

    calcularProrrateos(producto, total);
}


function calcularTotales() {
    if ($("#tbProductos").length > 0) {

        var totalSuma = 0.00;
        var totalDescuentos = 0.00;
        var totalImpuestos = 0.00;
        var totalSubtotal = 0.00;
        var totalGeneral = 0.00;
        var totalRetenciones = 0.00;

        $("#tbProductos > tr").each(function () {
            var cantidad = parseFloat($(this).find('.cantidadProducto').val());
            var precio = parseFloat($(this).find('.preciosUnidades').val());
            var impuesto = parseFloat($(this).find('.impuestosProducto').val());
            var descuento = ($(this).find('.descuentosProducto').val()) ? parseFloat($(this).find('.descuentosProducto').val()) : 0;
            var retencion = parseFloat($(this).find('.retencionesProducto').val());

            var descuento_porc = (descuento / 100);
            descuento = (precio) * descuento_porc;
            var descuento_total = descuento * cantidad;

            totalSuma += (cantidad * precio);
            totalImpuestos += impuesto;
            totalDescuentos += descuento_total;
            totalSubtotal += (cantidad * (precio - descuento));

            totalRetenciones += retencion;
        });

        totalGeneral = (totalSuma - totalDescuentos) + totalImpuestos;

        $("#txtSumaGeneral").val(number_format(totalSuma, 2));
        $("#txtDescuentoGeneral").val(number_format(totalDescuentos, 2));
        $("#txtRetencionGeneral").val(number_format(totalRetenciones, 2));
        $("#txtSubtotalGeneral").val(number_format(totalSubtotal, 2));
        $("#txtImpuestosGeneral").val(number_format(totalImpuestos, 2));
        $("#txtTotalGeneral").val(number_format(totalGeneral, 2));
    }
}

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }

        opciones += this.outerHTML;
    });

    return opciones;
}

function calcularMontosMultiSelect(idFila) {
    $("#" + idFila + " .multiSelectModal").each(function () {
        var html = $(this).data('html');
        var idInput = $(this).data('input');
        var tipo = $(this).data('tipo');
        var cantidad = parseFloat($("#" + idFila).find('.cantidadProducto').val().replace(/,/g, ""));
        var subTotal = 0;
        if (tipo == 1) {
            subTotal = parseFloat($("#" + idFila).find('.subtotalProductos').val().replace(/,/g, ""));
        } else {
            subTotal = parseFloat($("#" + idFila).find('.preciosUnidades').val().replace(/,/g, ""));
        }

        $("#slcMultiCargos").html(html);

        var montoSubtotal = calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subTotal);


        if (tipo == 2) {
            montoSubtotal = montoSubtotal * cantidad;
        }

        $("#" + idInput).val(number_format(montoSubtotal, 2));
    });

    $("#slcMultiCargos").html('');
}

function cerrar_modal(iframe) {
    if (iframe == 1) {
        parent.jQuery.fancybox.close();
    } else {
        jQuery.fancybox.close();
    }
}

function getModalProrrateo(idProducto) {

    var slcProrrateos = $('#slcProrrateos').html();

    var html = "";
    //Inicio
    html += '<div id="modalProrrateo_' + idProducto + '" style="display: none;">';

    html += '<div class="box">';
    html += '<div class="title"><h4><span></span></h4></div>';
    html += '<div class="content">';

    html += '<div class="form-row row-fluid">';
    //Elemento Select Padre

    html += '<div class="span12" style="margin-bottom: 20px;"><div class="row-fluid"><label class="form-label span3" id="">Tabla:<b style="color:orange;">*</b></label><div class="span7 controls">';
    html += '<select id="slcProrrateo_' + idProducto + '" data-prod="' + idProducto + '" data-centro="slcCentroCosto_' + idProducto + '" class="nostyle selectorProrrateo">' + slcProrrateos + '</select>';
    html += '</div></div></div>';

    //Elemento Centro costo
    html += '<div class="span5"><div class="row-fluid"><label class="form-label span3" id="">Centro de Costo: <b style="color:orange;">*</b></label><div class="span6 controls">';
    html += '<select id="slcCentroCosto_' + idProducto + '" data-prod="' + idProducto + '" data-sector="txtPorcentaje_' + idProducto + '" class="nostyle selectorCentroCostos"></select>';
    html += '</div></div></div>';

    //Elemento Porcentaje
    html += '<div class="span5"><div class="row-fluid"><label class="form-label span3" id="">Porcentaje<b style="color:orange;">*</b></label><div class="span6 controls">';
    html += '<input type="text" id="txtPorcentaje_' + idProducto + '" data-prod="' + idProducto + '" class="text cantidadProducto soloNumeros" extras="." value=""/>';
    html += '</div></div></div>';

    html += '<div class="span2"><div class="row-fluid"><div class="span6 controls">';
    html += '<button type="button" class="btn btn-info btn-primary btnAgregarCentroCosto" data-prod="' + idProducto + '" style="float: right;height: 30px;margin-top: 5px;">Agregar</button>';
    html += '</div></div></div>';

    //Tabla
    html += '<div class="span12" style="overflow-x: scroll;padding: 10px 0px 0px 5px;margin-bottom: 2%;">';
    html += '<div class="contenedor">';
    html += '<table class="responsive table table-bordered contenedor" id="tblProrrateo_' + idProducto + '">';
    html += '<thead><tr><td>Centro de Costo</td><td>Cuenta</td><td>Porcentaje</td><td>Total($)</td><td>Acciones</td></tr></thead>';
    html += '<tbody id="tbProrrateo_' + idProducto + '"></tbody>';
    html += '</table>';

    html += '</div>';

    //Acciones
    html += '<div class="form-actions" style="text-align: center;">';
    html += '<button type="button" class="btn btn-success btnGuardarPro" id="btnGuardarPro_' + idProducto + '" data-prod="' + idProducto + '" style="margin-right: 10px;"><span class="icon16 icomoon-icon-checkmark white"></span>Guardar</button>';
    //html += '<a onclicks="javascript:$.fancybox.close();" class="btn btn-danger btn-close" id=""><span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar</a>';
    html += '</div>';

    html += '</div>';
    html += '</div>';
    //End
    html += '</div>';

    html = html.replace(/\n/g, "");

    return html;
}

function calcularProrrateos(idProd, TotalProd) {

    if ($("#tbProrrateo_" + idProd).length > 0) {

        $("#tbProrrateo_" + idProd + " > tr").each(function () {
            var idTr = $(this).attr('id');
            var porcentaje = parseFloat($("#" + idTr).find('.porcentajeCentroCos').val());

            var totalFila = (porcentaje / 100) * TotalProd;

            $("#" + idTr).find('.totalCentroCos').val(number_format(totalFila, 2));
        });
    }
}

function limpiar_filtro_categorias() {
    menor = Number($(".dinamic:first").attr('id')) + 2;

    $(".dinamic").each(function (index, el) {
        if ($(el).attr('id') > menor) {
            $(el).parent('div').siblings('label').remove();
            $(el).siblings('select').remove();
            $(el).parent('div').parent('div').parent('div').remove();
            $(el).remove();
        }
    });
    $(".plus:last").remove();
    $(".dinamic:first option:selected").removeAttr('selected');
    $(".dinamic:first").next().append('<button class="btn plus">+</button>');
    $(".dinamic:first").select2({placeholder: 'Seleccione una opción'});
}