var global_proyecto     = $("#slcProyecto").val();
var global_presupuesto  = $("#slc_presupuesto").val();   
var global_general      = $("#slc_actividad_general").val();
var global_especifico   = $("#slc_actividad_espeficifica").val();
$(document).ready(function () {

    // enviar id orden de compras

    $('#slcOrdenCompra').change(function(){
        var id = $('#slcOrdenCompra').val();
        //url:window.gSateliteWhite.baseUrl('modulo_compras/procesos/agregar_orden_compra/'+id);
        
        if (id>0) {
            if ($('#slcOrdenCompra').data('orden')===1) {
                alerta_confirm(window.gSateliteWhite.baseUrl('modulo_compras/procesos/agregar_doc_proveedor/'+id),"Los Cambios realizados no se Guardaran", "¿Esta seguro que desea Cambiar de orden?");
                //wait.start();
            }else{
                wait.start();
                window.location.href = window.gSateliteWhite.baseUrl('modulo_compras/procesos/agregar_doc_proveedor/'+id);
            }            
        }
    });

    var glb_idprod      = "";//Id del producto del ultimo modal abierto
    var tabla_prorrateo = "";// variable global de prorrateo
    var $decimal_global = $("#hdnDecimal").val();
    //Calculo de la URL PATH
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    $('select').select2({placeholder: 'Seleccione una opción'});
    $(".select-edit").select2('destroy');
    $(".select-edit").hide();
    $("#div-categorias").hide();

    $(".soloNumeros").numeric('.');
    setTimeout(function () {
        $("#txtNumDoc").focus();
    }, 500);

    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $(".txtFechas").mask("99-99-9999");

    $(document).keydown(function(tecla) {
        if (tecla.keyCode == 13) {
            $('#agregar').trigger('click');
        }
    });

    $("#chkAfectaInventario").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        'resizeHandle': false,
        'resizeContainer': false,
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnAfectaInv").val(1);
            } else {
                $("#hdnAfectaInv").val(0);
            }
        }
    });

    $(".detalle_fanc").click(function() {
        aplicar_fancy();
    });

    //Carga impuesto modal
    $('#detalle_impuesto').on('click', '#btn_agregar_impuesto_modal', function () {
        event.preventDefault();

        var impuesto = $("#slc_impuestos_modal").val();
        var repetido = false;

        if ( $('#datagried tbody tr').length == 0 ){
            crear_alerta("error","Productos y/o Servicios","Por favor agregue productos o servicios.");
            return false;
        }

        if (impuesto == ""){
            crear_alerta("error","Impuestos","Por favor seleccione un impuesto.");
            return false;
        }

        if ( $('#tabla_impuesto tbody tr').length == 0 ){
            $("#grid_impuesto").html("");
        }

        $( "#tabla_impuesto tbody tr" ).each(function( index ) {
            if ( $(this).attr("id") == "impuesto_"+impuesto && $(this).hasClass("quitar_impuesto") == false ){
                crear_alerta("error","Impuesto","Impuesto ya fue agregado.");
                repetido = true;
                return false;
            }
        });

        if (repetido == true){
            return false;
        }

        var porcentaje  = $("#slc_impuestos_modal option:selected").data("porcentaje");
        var tipo        = $("#slc_impuestos_modal option:selected").data("type");
        var nombre      = $('#slc_impuestos_modal option:selected').text();
        var monto       = calcular_impuestos_retenciones(porcentaje,tipo);

        table   = '<tr id="impuesto_'+impuesto+'" class="nuevo_impuesto" data-impuesto="'+impuesto+'" data-porcentaje="'+porcentaje+'">'+
                            '<td>'+nombre+'</td>'+
                            '<td>'+number_format(porcentaje, 0)+'</td>'+
                            '<td>'+number_format(monto,$decimal_global,".","")+'</td>'+
                            '<td><button type="button" class="btn btn-danger btn-mini btn_borrar_impuestos" style="float:left; height:30px;width:50px;">Eliminar</button></td>'+
                            '</tr>';
        $("#grid_impuesto").append(table);
        $("#slc_impuestos_modal option:selected").removeAttr('selected');
        $("#slc_impuestos_modal").select2();
    });

    //eliminar impuesto
    $('#tabla_impuesto tbody').on('click', '.btn_borrar_impuestos', function () {
        $(this).parent().parent().css("display","none");
        $(this).parent().parent().addClass("quitar_impuesto");

        if ( $('#tabla_impuesto tbody tr').length == 0 ){
            $("#grid_impuesto").html('<td style="text-align: center;" colspan="4">No se encontraron registros</td>');
        }
    });

    //Se cargan impuestos en modal
    $("#btn_detalle_impuesto").on('click',function(){        
        $("#slc_impuestos_modal option:selected").removeAttr('selected');
        $("#slc_impuestos_modal").select2();

        var arreglo = [];
        $(".subtotalProductos").each(function(e){
            // Filtros
            var correlativo = $(this).data('correlativo');
            var producto = $(this).data('prod');
            var tabla = $("#tr_"+producto);
            var htmlImpuestos = $("#lnkImpuestos_" + correlativo).data('html');
            var cantidad_fila = $("#txtCantidad_" + correlativo).val();
            
            $("#slcMultiCargos").html(htmlImpuestos);
            $("#slcMultiCargos").select2();

            //Datos
            var suma = parseFloat($(this).val());
            var impuesto_por_array = [];
            var impuesto_array = $("#slcMultiCargos").val();
            var tipo_array = [];
            
            $("#slcMultiCargos option:selected").each(function () {
                var porcentajeImpuesto = $(this).data('porcentaje');
                impuesto_por_array.push(porcentajeImpuesto);
                
                var tipo = $(this).data('type');
                tipo_array.push(tipo);
            });
            $("#slcMultiCargos").html("");

            if (impuesto_array != null) {
              impuesto_array.forEach(function(value, index, arr){
                  var nombre_temp = $("#slc_impuestos_modal option[value='"+value+"']").text();//obtiene el nombre del impuesto
                  var cantidad_anterior = (arreglo[value])?arreglo[value].monto:0;//obtiene la cantidad existente en el arreglo
                  if ( tipo_array[index] == 1) {
                    var impuesto_monto = parseFloat(suma*(impuesto_por_array[index]/100)); //suma los porcentajes
                  } else {
                    var impuesto_monto = parseFloat( (impuesto_por_array[index])) * parseFloat(cantidad_fila); //suma los porcentajes
                  }
                  
                  if ( typeof arreglo[value] === "undefined"){
                    arreglo[value] = {
                        valor: value,
                        nombre: nombre_temp,
                        porcentaje: impuesto_por_array[index],
                        monto: impuesto_monto
                    };
                  } else {
                    var new_impuesto_monto = impuesto_monto + arreglo[value]["monto"];
                    arreglo[value] = {
                        valor: value,
                        nombre: nombre_temp,
                        porcentaje:  impuesto_por_array[index],
                        monto: new_impuesto_monto
                    };
                  }

              })
            }
        })
        if(arreglo.length > 0){
            var table = '';
            $("#grid_impuesto").html('');
            arreglo.forEach(function(value, index, arr){
                table =    '<tr id="impuesto_'+value.valor+'" data-impuesto="'+value.valor+'" data-porcentaje="'+value.porcentaje+'">'+
                            '<td>'+value.nombre+'</td>'+
                            '<td>'+number_format(value.porcentaje, 0)+'</td>'+
                            '<td>'+number_format(value.monto, $decimal_global,".","")+'</td>'+
                            '<td><button type="button" class="btn btn-danger btn-mini btn_borrar_impuestos" style="float:left; height:30px;width:50px;">Eliminar</button></td>'+
                            '</tr>';
                $("#grid_impuesto").append(table);
            })
        } else{
            $("#grid_impuesto").html('<td style="text-align: center;" colspan="4">No se encontraron registros</td>');
        }
    })

    // Guardar impuestos
    $('#detalle_impuesto').on('click', '#guardar_modal_impuesto', function () {
        var imp_add          = [];
        var imp_del          = [];
        $( "#tabla_impuesto tbody tr" ).each(function( index ) {
            var id          = $(this).data("impuesto");
            var porcentaje  = $(this).data("porcentaje");
            if ($(this).hasClass("quitar_impuesto")) {
               imp_del.push(id);
            }
            if($(this).hasClass("nuevo_impuesto")) {
                imp_add.push(id);
            }
        });
        if (imp_del.length > 0 || imp_add.length > 0) {
          $(".subtotalProductos").each(function(e) {
            var correlativo = $(this).data('correlativo');
            var item = "lnkImpuestos_"+correlativo;
            agregar_nuevo_calculos(correlativo,item,imp_add,imp_del);
          });
                  crear_alerta("info","Impuesto","Se realizaron cambios en los productos y/o servicios.");
        }
        $.fancybox.close();
    });

    //Carga retencion modal
    $('#detalle_retencion').on('click', '#btn_agregar_retencion_modal', function () {
        event.preventDefault();

        var impuesto = $("#slc_retenciones_modal").val();
        var repetido = false;

        if ( $('#datagried tbody tr').length == 0 ){
            crear_alerta("error","Productos y/o Servicios","Por favor agregue productos o servicios.");
            return false;
        }

        if (impuesto == ""){
            crear_alerta("error","Impuestos","Por favor seleccione un impuesto.");
            return false;
        }

        if ( $('#tabla_retencion tbody tr').length == 0 ){
            $("#grid_retencion").html("");
        }

        $( "#tabla_retencion tbody tr" ).each(function( index ) {
            if ( $(this).attr("id") == "impuesto_"+impuesto && $(this).hasClass("quitar_impuesto") == false ){
                crear_alerta("error","Retencion","Retencion ya fue agregado.");
                repetido = true;
                return false;
            }
        });

        if (repetido == true){
            return false;
        }

        var porcentaje  = $("#slc_retenciones_modal option:selected").attr("porcentaje");
        var nombre      = $('#slc_retenciones_modal option:selected').text();
        var monto       = calcular_impuestos_retenciones(porcentaje);

        table   = '<tr id="impuesto_'+impuesto+'" class="nuevo_impuesto" data-impuesto="'+impuesto+'" data-porcentaje="'+porcentaje+'">'+
                            '<td>'+nombre+'</td>'+
                            '<td>'+number_format(porcentaje, 0)+'</td>'+
                            '<td>'+number_format(monto,$decimal_global,".","")+'</td>'+
                            '<td><button type="button" class="btn btn-danger btn-mini btn_borrar_retencion" style="float:left; height:30px;width:50px;">Eliminar</button></td>'+
                            '</tr>';
        $("#grid_retencion").append(table);
        $("#slc_retenciones_modal option:selected").removeAttr('selected');
        $("#slc_retenciones_modal").select2();
    });

    //eliminar retencion
    $('#tabla_retencion tbody').on('click', '.btn_borrar_retencion', function () {
        $(this).parent().parent().css("display","none");
        $(this).parent().parent().addClass("quitar_impuesto");

        if ( $('#tabla_impuesto tbody tr').length == 0 ){
            $("#grid_impuesto").html('<td style="text-align: center;" colspan="4">No se encontraron registros</td>');
        }
    });

    //Se cargan retenciones en modal
    $("#btn_detalle_retencion").on('click',function(){
        $("#slc_retenciones_modal option:selected").removeAttr('selected');
        $("#slc_retenciones_modal").select2();

        var arreglo = [];
        $(".subtotalProductos").each(function(e){
            // Filtros
            var correlativo = $(this).data('correlativo');
            var producto = $(this).data('prod');
            var tabla = $("#tr_"+producto);;
            var htmlImpuestos = $("#lnkRetenciones_" + correlativo).data('html');
            $("#slcMultiCargos").html(htmlImpuestos);
            $("#slcMultiCargos").select2();

            //Datos
            var suma = parseFloat($(this).val());
            var impuesto_por_array = [];
            var impuesto_array = $("#slcMultiCargos").val();
            $("#slcMultiCargos option:selected").each(function () {
                var porcentajeImpuesto = $(this).data('porcentaje');
                impuesto_por_array.push(porcentajeImpuesto);
            });
            $("#slcMultiCargos").html("");

            if (impuesto_array != null) {
              impuesto_array.forEach(function(value, index, arr){
                  var nombre_temp = $("#slc_retenciones_modal option[value='"+value+"']").text();//obtiene el nombre del impuesto
                  var cantidad_anterior = (arreglo[value])?arreglo[value].monto:0;//obtiene la cantidad existente en el arreglo
                  var impuesto_monto = parseFloat(suma*(impuesto_por_array[index]/100)) + parseFloat(cantidad_anterior); //suma los porcentajes
                  arreglo[value] = {
                                      valor: value,
                                      nombre: nombre_temp,
                                      porcentaje: impuesto_por_array[index],
                                      monto: impuesto_monto
                                  };
              })
            }

        })
        if(arreglo.length > 0){
            var table = '';
            $("#grid_retencion").html('');
            arreglo.forEach(function(value, index, arr){
                table =    '<tr id="impuesto_'+value.valor+'" data-impuesto="'+value.valor+'" data-porcentaje="'+value.porcentaje+'">'+
                            '<td>'+value.nombre+'</td>'+
                            '<td>'+number_format(value.porcentaje, 0)+'</td>'+
                            '<td>'+number_format(value.monto,$decimal_global,".","")+'</td>'+
                            '<td><button type="button" class="btn btn-danger btn-mini btn_borrar_retencion" style="float:left; height:30px;width:50px;">Eliminar</button></td>'+
                            '</tr>';
                $("#grid_retencion").append(table);
            })
        } else{
            $("#grid_retencion").html('<td style="text-align: center;" colspan="4">No se encontraron registros</td>');
        }
    })

    // Guardar retenciones
    $('#detalle_retencion').on('click', '#guardar_modal_retencion', function () {
        var imp_add          = [];
        var imp_del          = [];
        $( "#tabla_retencion tbody tr" ).each(function( index ) {
            var id          = $(this).data("impuesto");
            var porcentaje  = $(this).data("porcentaje");
            if ($(this).hasClass("quitar_impuesto")) {
               imp_del.push(id);
            }
            if($(this).hasClass("nuevo_impuesto")) {
                imp_add.push(id);
            }
        });
        if (imp_del.length > 0 || imp_add.length > 0) {
          $(".subtotalProductos").each(function(e) {
            var correlativo = $(this).data('correlativo');
            var item = "lnkRetenciones_"+correlativo;
            agregar_nuevo_calculos(correlativo,item,imp_add,imp_del);
          });
                  crear_alerta("info","Retencion","Se realizaron cambios en los productos y/o servicios.");
        }
        $.fancybox.close();
    });


    $("#chkAfectaInventario").live('change', function(){
        var estado = $(this).is(':checked');
        if (estado) {
            $("#hdnAfectaInv").val(1);
        } else {
            $("#hdnAfectaInv").val(0);
        }
    })

    $("#txtFechaDoc").change(function () {
        var fecha_doc = $(this).val();
        var dias_proveedor = $("#slcProveedor option:selected").data('dias');
        if (fecha_doc != '' && dias_proveedor != '') {

            var fecha_selected = new Date($.datepicker.parseDate('dd-mm-yy', fecha_doc));
            fecha_selected.setDate(fecha_selected.getDate() + dias_proveedor);

            $("#txtFechaVencimiento").datepicker('setDate', fecha_selected);
        } else {
            $("#txtFechaVencimiento").val();
        }
    });

    $('body').on('focus', '#monto_nuevo', function() {
        this.select();
    });

    $('body').on('focus', '#descuento_nuevo', function() {
        this.select();
    });

    $('body').on('keyup', '#descuento_nuevo', function() {
        var porc = $(this).val();
        var row = $('#id_row').val();
        var unit = $('#txtPrecioUnitario_' + row).val();
        var cant = $('#txtCantidad_' + row).val();
        if (porc != '' && porc > 0) {
            $('#monto_nuevo').val(0.00);
            if (unit != '' && unit > 0) {
                if (porc > 100) {
                    crear_alerta('error', 'Descuento', 'El porcentaje no debe ser mayor a 100%');
                    $('#monto_nuevo').val(0.00);
                    $(this).val(0.00);
                    return false;
                } else {
                    valor = round_number((porc / 100) * (unit * cant));
                    $('#monto_nuevo').val(valor);
                }
            }
        } else {
            $('#monto_nuevo').val(0.00);
        }
    });

    $('body').on('keyup', '#monto_nuevo', function() {
        var val = $(this).val();
        var row = $('#id_row').val();
        var unit = $('#txtPrecioUnitario_' + row).val();
        var cant = $('#txtCantidad_' + row).val();
        var total = unit * cant;
        if (val != '') {
            $('#descuento_nuevo').val('');
            if (total > 0) {
                valor = round_number(((val * 100) / total),6);
                if (valor > 100) {
                    crear_alerta('error', 'Descuento', 'El porcentaje no debe ser mayor a 100%');
                    $('#descuento_nuevo').val(0.00);
                    $(this).val(0.00);
                    return false;
                } else {
                    $('#descuento_nuevo').val(valor);
                }
            }
        } else {
            $('#descuento_nuevo').val(0.00);
        }
    });

    $("#slcCajaChica").change(function(event) {
        caja = $(this).val();
        var isSobregiro = $('option:selected',this).data('sobregiro');
        total = $("#txtTotalGeneral").val();
        if(caja > 0 && parseFloat(total.replace(/,/g, "")) >0 ){
            var resp = jQuery.parseJSON(validar_caja(caja));
            if(parseFloat(resp.monto.replace(/,/g, "")) >= parseFloat(total.replace(/,/g, ""))){
                $("#monto_caja").val(resp.monto);
            }else{
                if (isSobregiro == 1) {
                    crear_alerta('info', 'Caja Permite Sobregiro', 'El monto de la caja chica es insuficiente.');
                }else{
                    crear_alerta('error', 'Error', 'El monto de la caja chica seleccionada es insuficiente.');
                }
            }
        }else{
            $("#id_lcc").val('');
            $("#monto_caja").val('');
        }
        lcc_id = $("#slcCajaChica option:selected").data('lcc');
        $("#id_lcc").val(lcc_id);
        $("#id_lcc").attr('value', lcc_id);
    });


    $(".btn-close").live('click', function () {
        var iframe = $(this).data('iframe');
        alerta_confirm_ajax(cerrar_modal, iframe, 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    var id_bod;
    var id_cat;
    var id_prod;

    $("#frm-docProveedor").validate({
        ignore: [],
        rules: {
            slcProveedor: {required: true},
            slcTipoPago: {required: true},
            slcTipoDocumento: {required: true},
            txtNumDoc: {required: true},
            txtSerieDoc: {required: true},
            txtFechaDoc: {required: true},
            txtFechaConta: {required: true},
            txtFechaDeclara: {required: true},
            txtFechaVencimiento: {required: true},
            slcTipo: {required: true},
            slcOrdenCompra : { required: false}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            $("#pes-generales").trigger('click');
        },
        invalidHandler: function (form, validator) {
            var errors = validator.numberOfInvalids();
            if (errors) {
                var primerElemento = validator.errorList[0].element;
                var posiciones = primerElemento.offsetTop;
                $("html, body").animate({scrollTop: posiciones}, 1000);
            }
        },
        submitHandler: function (form) {
            var flag = 0;
            var nota_cred = $("#id_nota_cred").val();
            var tipo_doc = $("#slcTipoDocumento").val();
            if (parseInt(tipo_doc) == parseInt(nota_cred)) {
                var afecta = $('#slcDocAfecta').val();
                if (afecta == "") {
                    crear_alerta('error', 'Nota de Crédito', 'Debe seleccionar el Documento que afectará');
                    $('#slcDocAfecta').select2('open');
                    return false;
                }
            }
            if ($('#datagried tr').length <= 1) {
                crear_alerta('error', 'Productos', 'Debe seleccionar al menos un producto');
                $("#pes-generales").trigger('click');
                return false;
            }
            $("#datagried tr .cantidades").each(function () {
                var ctdad = $(this).val();
                if (parseFloat(ctdad) <= 0 || ctdad == '') {
                    flag++;
                    crear_alerta('error', 'Productos', 'Debe asignar una cantidad a todos los productos');
                    return false;
                }
            });
            $("#datagried tr .preciosUnidades").each(function () {
                var valor = $(this).val();
                if (valor == 0 || valor == '') {
                    crear_alerta('error', 'Productos', 'Debe asignarle un precio a todos los productos');
                    flag++;
                    $("#pes-generales").trigger('click');
                    return false;
                }
            });
            var afectaInventario = $("#hdnAfectaInv").val();
            var error = 0;
            var errorSec = 0;
            var usa_sectores = $("#param_sectores").val();
            if($("#slcTipo").val()==1){
                //TIPO PRODUCTO
                $("#tbProductos tr").each(function () {
                    data_id = $(this).attr('data-id');
                    // ERROR DE PEDIR BODEGA SOLO SI TIENE FLAG art_inventario = 1 
                    if ($("#hdnBodega_" + data_id).val() == "" && $("#hdnInv_" + data_id).val() == 1) {
                        error++;
                    }
                    if ($("#hdnSector_" + data_id).val() == "" && usa_sectores > 0 && $("#hdnInv_" + data_id).val() == 1) {
                        errorSec++;
                    }
                });
            }
            if (error > 0 || errorSec > 0) {
                if (error > 0) {
                    crear_alerta('error', 'Productos', 'Debe asignar una bodega a todos los productos inventariables.');
                    $("#pes-generales").trigger('click');
                    return false;
                }
                if (errorSec > 0) {
                    crear_alerta('error', 'Productos', 'Debe asignar una bodega y un sector a todos los productos inventariables.');
                    $("#pes-generales").trigger('click');
                    return false;
                }
            }
            caja = $("#slcCajaChica").val();
            total = $("#txtTotalGeneral").val();
            var alerta_sobregiro = '';

            if(caja > 0 && parseFloat(total.replace(/,/g, "")) >0 ){
                var resp = jQuery.parseJSON(validar_caja(caja));                
                if(parseFloat(resp.monto.replace(/,/g, "")) >= parseFloat(total.replace(/,/g, ""))){
                     lcc_id = $("#slcCajaChica option:selected").data('lcc');
                    $("#id_lcc").val(lcc_id);
                    $("#id_lcc").attr('value', resp.lcc_id);
                    $("#monto_caja").val(resp.monto);
                     var isSobregiro = $('option:selected',this).data('sobregiro');
                }else {
                    if ($("#slcCajaChica option:selected").data('sobregiro') !=1) {
                        $("#slcCajaChica").focus();                        
                         crear_alerta('error', 'Error', 'El monto de la caja chica seleccionada es insuficiente.');
                         return false;
                    }else{
                        alerta_sobregiro = '<br>!El Sobregiro de la Caja Seleccionada Esta Activo!';
                    }                   
                }
            }
            $("#fecha").prop('disabled', false);
            $("#documento").prop('disabled', false);
            $("#txtFechaVencimiento").prop('disabled', false);
            
            if ( $("#slc_presupuesto").val() != "" ) {
                if ( $("#slc_actividad_espeficifica").val() == "" ) {
                    crear_alerta('error', 'Actividad específica', 'Seleccione una actividad específica');
                    return false;
                }   
            }

            var aprobar_presupuesto = evaluar_presupuesto($("#slc_presupuesto").val()); 
            if ( aprobar_presupuesto == false) {
                return false;
            }

            if (flag == 0) {
                alerta_confirm_ajax(enviar_formulario,1,'Confirmación de registro.','¿Desea guardar los cambios?'+alerta_sobregiro+'');
            }
        }
    });

    function enviar_formulario(){
        event.preventDefault();
        wait.start();
        $("#datagried tbody tr").each(function () {
            var id = $(this).data('id');
            if (typeof id != 'undefined' && $.isNumeric(id) && $("#txtCantidad_"+id).length > 0) {
                calcularTotalFila('tr_'+id);
            }
        });
        calcularTotales();
        $("#slcOrdenCompra").removeAttr("disabled");
        $("#slcCajaChica").removeAttr("disabled");
        quitar_atributo();
        $("#frm-docProveedor")[0].submit();
    }


    $(".positive").numeric({negative: false}, function () {
        if(parseFloat(this.value) < 0)
        {
            alert("No negative values");
            this.value = "";
            this.focus();
        }
    });

    $(".positive").live("focusout", function () {
        if ($(this).val() <= 0.0) {
            campo = $(this).attr("id");
            $(this).addClass('error');
            //document.getElementById('validar_'+campo+'').innerHTML='La cantidad debe ser mayor a uno';
            $('#validar_' + campo).text('La cantidad debe ser mayor a uno');
        }
    });

    $("#documento").blur(function () {
        var doc_numero = $(this).val();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/gestion_productos/validar_documento',
            data: {id: doc_numero},
            success: function (data) {
                if (data.drop != null) {
                    crear_alerta("info", "Aviso", "Por favor elija otro número de documento.");
                    $("#documento").focus().val('');
                }
            }
        });
    });

    $("#slcProveedor").change(function () {
        var proveedor = $(this).val();
        $("#slcDocAfecta").html('');
        $("#slcDocAfecta").select2();
        if (proveedor != '') {
            var fecha_doc = $("#txtFechaDoc").val();
            var dias_proveedor = $("#slcProveedor option:selected").data('dias');
            var condicion = $("#slcProveedor option:selected").attr('cod');
            $("#txt_nombre_proveedor").val( $("#slcProveedor option:selected").data('nombre') );
            if(condicion>0){
                $("#slcCondicionPago option[value="+condicion+"]").attr('selected', 'selected');
            }
            if (fecha_doc != '' && dias_proveedor != '') {
                var fecha_selected = new Date($.datepicker.parseDate('dd-mm-yy', fecha_doc));
                fecha_selected.setDate(fecha_selected.getDate() + dias_proveedor);
                $("#txtFechaVencimiento").datepicker('setDate', fecha_selected);
            } else {
                $("#txtFechaVencimiento").val();
            }
            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_documentos_proveedor',
                data: {proveedor: proveedor},
                type: 'POST',
                dataType: 'json',
                success: function (data) {
                    $("#slcDocAfecta").html(data.documentos);
                    $("#slcDocAfecta option[value='0']").text('');
                    $("#slcDocAfecta option[value='0']").val('');
                    $("#slcDocAfecta").select2({placeholder: "Seleccione una opción"});
                }
            });
            $.ajax({
                async: true,
                url: gSateliteWhite.baseUrl('modulo_compras/procesos/get_nrc_proveedor'),
                type: "POST",
                dataType: "json",
                data: {id: proveedor},
                success: function(data) {
                    if(data!=''){
                        $("#txtNrc").val(data);
                    }else{
                        $("#txtNrc").val("");
                    }
                    wait.close();
                },
                error: function(data) {
                    wait.close();
                    $("#txtNrc").val("");
                    //crear_alerta("info","Obtener NRC","El proveedor no posee NRC asignado.");
                }
            });
            validar_num_dpv();
        }else{
            $("#txtNrc").val("");
        }
    });

    $(".selectorBodega").change(function () {
        var bodega = $(this).val();
        var idSector = $(this).data('sector');
        $("#" + idSector).html('');
        $("#" + idSector).select2();
        if (bodega != '') {
            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_sector_bodega',
                data: {bodega: bodega},
                type: 'POST',
                dataType: 'json',
                success: function (data) {
                    $("#" + idSector).html(data.sectores);
                    $("#" + idSector + " option[value='0']").text('');
                    $("#" + idSector + " option[value='0']").val('');
                    $("#" + idSector).select2({placeholder: 'Seleccione una opción'});
                }
            });
        }
    });

    $("#txtNumDoc").focusout(function () {
        validar_num_dpv();
    });
    $("#txtNumDoc").blur(function() {
        validar_num_dpv();
    })


    $("#editar").live("click", function () {
        event.preventDefault();
        //$(this).toggleClass('guardar editar');

        id_row = $(this).attr('name');

        var nuevo_cant = 1
        do {
            nuevo_cant = prompt("Ingrese nuevo valor de cantidad(Mayor a cero)", "1");

        } while ((nuevo_cant <= 0 || String(parseFloat(nuevo_cant)) == "NaN") && (nuevo_cant != null));

        if (nuevo_cant != null) {
            document.getElementById('cantidadl' + id_row + '').innerHTML = nuevo_cant;
            $('#cantidadi' + id_row + '').val(nuevo_cant);
        }
    });//Fin de editar

    $("#remove").live("click", function () {
        $(this).parents("tr").remove();
    });//Fin de eliminar

    $("#slcTipo").change(function () {
        var tipoReq = $("#slcTipo").val();
        var n_filas = $("#tbProductos tr").length; 
        var orden_c = $('#slcOrdenCompra').val();
        var defecto_inventario = $('#prm_afecta_inventario_defecto').val();
        if (orden_c == "" && n_filas > 0) {
            alerta_confirm_ajax(borrar_grid,1,'¿Desea cambiar el tipo del documento?','Si usted cambia el tipo del documento, los ítems ya agregados serán removidos del detalle ');
        }
        if (tipoReq > 0) {
            if (tipoReq == 2) {
                $('#thSector').hide();
            } else {
                $('#thSector').show();
            }
            if(tipoReq==1 || tipoReq==4){
                $("#div_afecta").attr('style', '');
                setTimeout(function(){
                    $("#chkAfectaInventario").iButton('destroy');
                    $("#chkAfectaInventario").iButton({
                        labelOn: "SI", 
                        labelOff: "NO", 
                        'resizeHandle': false,
                        'resizeContainer': false
                    });
                    $("#chkAfectaInventario").iButton({
                        'labelOn': 'Si',
                        'labelOff': 'No',
                        'resizeHandle': false,
                        'resizeContainer': false,
                        change: function (element) {
                            if (element.is(':checked')) {
                                $("#hdnAfectaInv").val(1);
                            } else {
                                $("#hdnAfectaInv").val(0);
                            }
                        }
                    });
                    if (defecto_inventario > 0) {
                    $('#chkAfectaInventario').iButton('toggle', true);
                    }
                },50)
            }else{
                $("#div_afecta").attr('style', 'display:none;');
                $("#chkAfectaInventario").iButton('destroy');
                $("#chkAfectaInventario").iButton({
                    labelOn: "SI", 
                    labelOff: "NO", 
                    'resizeHandle': false, 
                    'resizeContainer': false
                });
                $('#chkAfectaInventario').iButton('toggle', false);
            }
            /***
            *Si la orden de compra es undefined entonces, al hacer change en el campo tipo limpia la tabla
            *los detalle de productos
            ***/
            var order_com = $('#slcOrdenCompra').val();
            if(typeof order_com == 'undefined'){
                $("#tbProductos").html('');
            }
            cargar_categorias(tipoReq);
            bloquear_select_ajax();
        } else {
            $("#div-categorias").html('');
            //$("#slcProductos").html('');
            //$("#slcProductos").select2('destroy').select2();
            $("#datagried tbody").html('');
            bloquear_select_ajax();

        }
    });
    $('#slcTipo').trigger('change');

    $(".dinamic").live('change', function () {

        var tipoReq = $("#slcTipo").val();
        $("#slcImpuestos").html('');
        $("#slcImpuestos").select2();
        if (tipoReq == 1) {
            menor = Number($(this).attr('id')) + 2;
            bodega = 1;//$('#slcBodega').val();
            padre = $("select[class='dinamic']").last().val();
            $(".dinamic").each(function (index, el) {
                if ($(el).attr('id') > menor) {
                    $(el).parent('div').siblings('label').remove();
                    $(el).siblings('select').remove();
                    $(el).parent('div').parent('div').parent('div').remove();
                    $(el).remove();

                }
            });
            $(".plus:last").remove();
            $(this).next().append('<button class="btn plus">+</button>');
            if(padre != ''){
                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                    data: {padre: padre},
                    success: function (data) {
                        producto = data.producto;
                        impuestos = data.impuestos;
                        $("#slcProductos").html(producto);
                        $("#slcProductos option[value='0']").text('');
                        $("#slcProductos option[value='0']").val('');
                        //$("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                        $("#slcMedidas").html('<option></option>');
                        $("#slcMedidas").select2({placeholder: "Seleccione una opción"});
                        $("#slcImpuestos").html(impuestos);
                        $("#slcImpuestos").select2();

                        $('.dinamic').each(function (index, el) {
                            $(this).attr('id', index);
                        });
                    }
                });
            }
        } else if (tipoReq == 2) {
            menor = Number($(this).attr('id')) + 2;
            padre = $("select[class='dinamic']").last().val();
            $(".dinamic").each(function (index, el) {
                if ($(el).attr('id') > menor) {
                    $(el).parent('div').siblings('label').remove();
                    $(el).siblings('select').remove();
                    $(el).parent('div').parent('div').parent('div').remove();
                    $(el).remove();

                }
            });
            $(".plus:last").remove();
            $(this).next().append('<button class="btn plus">+</button>');
            if(padre != ''){
                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                    data: {padre: padre, servicio: 1},
                    success: function (data) {
                        servicios = data.producto;
                        impuestos = data.impuestos;
                        $("#slcProductos").html(servicios);
                        $("#slcProductos option[value='0']").text('');
                        $("#slcProductos option[value='0']").val('');
                        //$("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                        $("#slcImpuestos").html(impuestos);
                        $("#slcImpuestos").select2();

                        $('.dinamic').each(function (index, el) {
                            $(this).attr('id', index);
                        });
                    }
                });
            }
        } else if (tipoReq == 3) {

            var categoria = $(this).val();
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_activos_tipo',
                data: {tipo_activo: categoria},
                success: function (data) {
                    producto = data.activos;
                    $("#slcProductos").html(producto);
                    $("#slcProductos option[value='0']").text('');
                    $("#slcProductos option[value='0']").val('');
                    //$("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                }
            });

            $.ajax({
                dataType: 'json',
                type: 'post',
                //data: {producto: product},
                url: urlj + 'modulo_compras/procesos/get_impuestos',
                success: function (data) {
                    $("#dvImpuestos").show();
                    $("#slcImpuestos").html(data.impuestos);
                    $("#slcImpuestos").select2();
                }
            });
        } else if(tipoReq == 4){
            menor = Number($(this).attr('id')) + 2;
            bodega = 1;//$('#slcBodega').val();
            padre = $("select[class='dinamic']").last().val();
            $(".dinamic").each(function (index, el) {
                if ($(el).attr('id') > menor) {
                    $(el).parent('div').siblings('label').remove();
                    $(el).siblings('select').remove();
                    $(el).parent('div').parent('div').parent('div').remove();
                    $(el).remove();

                }
            });
            $(".plus:last").remove();
            $(this).next().append('<button class="btn plus">+</button>');
            if(padre != ''){
                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                    data: {padre: padre, servicio: 2},
                    success: function (data) {
                        producto = data.producto;
                        impuestos = data.impuestos;
                        $("#slcProductos").html(producto);
                        $("#slcProductos option[value='0']").text('');
                        $("#slcProductos option[value='0']").val('');
                        //$("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                        $("#slcMedidas").html('<option></option>');
                        $("#slcMedidas").select2({placeholder: "Seleccione una opción"});
                        $("#slcImpuestos").html(impuestos);
                        $("#slcImpuestos").select2();

                        $('.dinamic').each(function (index, el) {
                            $(this).attr('id', index);
                        });
                    }
                });
            }
        }
        bloquear_select_ajax();
    });

    $(".plus").live('click', function (event) {

        var tipoReq = $("#slcTipo").val();
        event.preventDefault();
        bodega = 1;//$('#slcBodega').val();
        padre = $("select[class*='dinamic']").last().val();

        if (tipoReq == 1) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {padre: padre},
                success: function (data) {
                    categoria = data.drop;
                    producto = data.producto;
                    $i = 0;
                    $(".plus").last().remove();
                    if (categoria.length > 0) {
                        numero = $('#div-categorias select').last().length + 1;
                        //<div class="form-row row-fluid"></div>
                        linea = $("#div-categorias").append(''
                                + '<div class="span7" style="margin-bottom: 10px;">'
                                + '<div class="row-fluid">'
                                + '<label class="form-label span3">Categoría:</label>'
                                + '<div class="span6 controls">'
                                + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                                + '</div></div></div>');
                        linea2 = $('select[class="dinamic"]').last().html();
                        nueva = linea2.replace(/#/g, numero);
                        $('#div-categorias').append(nueva);
                        $('select[class="dinamic"]').last().html(categoria);
                        $('select[class="dinamic"] option[value="0"]').last().text('');
                        $('select[class="dinamic"] option[value="0"]').last().val('');
                        $('select[class="dinamic"]').last().select2({placeholder: 'Seleccione una opción'});
                        $("#slcProductos").html(producto);
                        $("#slcProductos option[value='0']").text('');
                        $("#slcProductos option[value='0']").val('');
                        $("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                        $("#slcMedidas").html('<option></option>');
                        $("#slcMedidas").select2({placeholder: "Seleccione una opción"});
                    } else {
                        $("#slcProductos").html(producto);
                        $("#slcMedidas").html('<option></option>');
                        $("#slcMedidas").select2({placeholder: "Seleccione una opción"});
                        $.pnotify({
                            type: 'info',
                            title: 'Aviso',
                            text: 'No se encontraron mas dependencias.',
                            icon: 'ui-icon ui-icon-info',
                            opacity: 0.95,
                            history: false,
                            sticker: false
                        });
                    }

                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });


                }
            });
        } else if (tipoReq == 2) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {padre: padre, servicios: 1},
                success: function (data) {
                    categoria = data.drop;
                    servicios = data.servicios;
                    $i = 0;
                    $(".plus").last().remove();
                    if (categoria.length > 0) {
                        numero = $('#div-categorias select').last().length + 1;
                        linea = $("#div-categorias").append('<div class="form-row row-fluid">'
                                + '<div class="span7">'
                                + '<div class="row-fluid">'
                                + '<label class="form-label span3">Categoría:</label>'
                                + '<div class="span6 controls">'
                                + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                                + '</div></div></div></div>');
                        linea2 = $('select[class="dinamic"]').last().html();
                        nueva = linea2.replace(/#/g, numero);
                        $('#div-categorias').append(nueva);
                        $('select[class="dinamic"]').last().html(categoria);
                        $('select[class="dinamic"] option[value="0"]').last().text('');
                        $('select[class="dinamic"] option[value="0"]').last().val('');
                        $('select[class="dinamic"]').last().select2({placeholder: 'Seleccione una opción'});
                        $("#slcProductos").html(servicios);
                    } else {
                        $("#slcProductos").html(servicios);
                        $.pnotify({
                            type: 'info',
                            title: 'Aviso',
                            text: 'No se encontraron mas dependencias.',
                            icon: 'ui-icon ui-icon-info',
                            opacity: 0.95,
                            history: false,
                            sticker: false
                        });
                    }

                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });
                }
            });
        }
    });

    $("#slcProductos").change(function () {
        $("#productos_cantidad").hide();
        $("#productos_null").hide();
        var tipoReq = $("#slcTipo").val();
        product = $('#slcProductos').val();

        $("#txtCantidad").val(1);
        $.ajax({
            dataType: 'json',
            type: 'post',
            data: {producto: product},
            url: urlj + 'modulo_compras/procesos/get_detalles_producto',
            success: function (data) {
                $("#slcMedidas").html(data.medidas);
                $("#slcMedidas option[value='0']").text('');
                $("#slcMedidas option[value='0']").val('');
                $("#slcMedidas").select2({placeholder: 'Seleccione una opción'});

                //$("#dvImpuestos").show();
                //$("#slcImpuestos").html(data.impuestos);
                //$("#slcImpuestos option").attr('selected','selected');
                //$("#slcImpuestos").select2();

                $("#slcBodega").html(data.bodegas);
                $("#slcBodega option[value='0']").text('');
                $("#slcBodega option[value='0']").val('');
                $("#slcBodega").select2({placeholder: 'Seleccione una opción'});

                $("#slcSector").html(data.sectores);
                $("#slcSector option[value='0']").text('');
                $("#slcSector option[value='0']").val('');
                $("#slcSector").select2({placeholder: 'Seleccione una opción'});
            }
        });        
    });

    $("#categoria").change(function () {
        $("#categoria option:selected").each(function () {
            bodega = $('#bodega').val();
            categoria = $('#categoria').val();
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/gestion_productos/get_productos_xcat',
                data: {bodega_sel: bodega, categoria_sel: categoria},
                success: function (data) {
                    $("#slcProductos").html(data.drop);
                }
            });
            $('#slcProductos')
                    .find('option')
                    .remove()
                    .end()
                    .append('<option>Seleccione una opción</option>')
                    ;

            $("#slcProductos").select2('destroy').select2();
            $('#cantidad').val('');
        });
    }); //end of function categoria

    var row = 0;
    if ($('#datagried tr').length > 0) {
        row = $("#datagried tr").length;
    }
    $("#agregar").click(function () {
        event.preventDefault();
        var usa_sectores = $("#param_sectores").val();
        if ( $("#articulo_presupuesto").val() == 0  && $("#slcProducto_ajx").val() != "") {
            var producto_tmp = $("#slcProducto_ajx").select2('data').text;
            crear_alerta("info", "Producto/ servicio", '"'+producto_tmp+'"'+' no esta disponible para la partida o rubro seleccionado');            
            $('.dinamic option:selected').removeAttr('selected');
            $('select[class="dinamic"]').last().select2({placeholder: 'Seleccione una opción'});
            limpiar_select_producto();
        }
        $("#cabezera").show();
        var contador_productos = $("#contador_productos").val();
        var tipoReq = $("#slcTipo").val();
        var cantidad = $('#txtCantidad').val();
        //var producto = $('#slcProductos').val();
        var producto = ($("#slcProductos").val() > 0) ? $("#slcProductos").val() : $("#slcProducto_ajx").val();
        var precio = $("#txtPrecio").val();
        var tipo_venta = ($("#slcTipoVenta").val() != '' && $("#slcTipoVenta").val() != null) ? $("#slcTipoVenta").val() : '';
        var nombreTipoVenta = ($("#slcTipoVenta").val() != '' && $("#slcTipoVenta").val() != null) ? $("#slcTipoVenta option:selected").text() : '';
        var impuestos = ($("#slcImpuestos").val() != '' && $("#slcImpuestos").val() != null) ? $("#slcImpuestos").val() : '';
        var retenciones = ($("#slcRetenciones").val() != '' && $("#slcRetenciones").val() != null) ? $("#slcRetenciones").val() : '';
        var medidas = ($('#slcMedidas').val() != '' && $('#slcMedidas').val() != null) ? $('#slcMedidas').val() : '';
        var medidasHtml = "";
        var descripcionProd = $('#txtDescripcionProd').val();
        var descuento = $("#txtDescuento").val();
        var monto_descuento = number_format($('#txtDescuento_monetario').val(),$("#hdnDecimal").val());
        var codigo_producto = '';
        var nombre_producto_text = '';
        if(!($("#slcProductos").val() > 0)){
            nombre_producto = $("#slcProducto_ajx").next().find('.select2-choice span').text();
            nombre_producto_array = nombre_producto.split(' - ');
            codigo_producto = nombre_producto_array[0];
            nombre_producto_text = nombre_producto_array[1];

        }
        var codigoProducto = codigo_producto != '' ? codigo_producto : $('#slcProductos option:selected').data('codigo');
        var nombreArticulo = nombre_producto_text != '' ? nombre_producto_text : $('#slcProductos option:selected').data('nombre');        
        var tipoProducto = $('#slcProductos option:selected').data('tipo');
        var valor_defecto = $('#slcMedidas option:selected').data('defecto');
        var valor_convertir = $('#slcMedidas option:selected').data('conv');
        var nombreMedida = "";
        var bodegaProd = ($("#slcBodega").val() != '' && $("#slcBodega").val() != null) ? $("#slcBodega").val() : '';
        var sectorProd = ($("#slcSector").val() != '' && $("#slcSector").val() != null) ? $("#slcSector").val() : '';
        var nombreSectorProd = $("#slcSector option:selected").text();
        var nombreBodegaProd = $("#slcBodega option:selected").text();
        var flagInventario = $('#hdnInventariable').val();
        var ocultar = "";

        //Se realizan las validaciones en base al tipo de Orden
        if (tipoReq == 1) {
            if ((cantidad <= 0) || medidas == '' || producto == '' || precio == '') {
                crear_alerta('info', 'Productos', 'Debe especificar las características del producto');
                //crear_alerta('danger', 'Productos', 'Bodega es requerida');
                //$('#slcBodega_error').html('Campo requerido');
                return false;
            }
            medidasHtml = $("#slcMedidas").html();
            nombreMedida = $("#slcMedidas option:selected").text();
        } else if (tipoReq == 2) {
            if (cantidad == '' || !parseInt(producto) || precio == '') {
                crear_alerta('info', 'Servicio', 'Debe especificar las características del servicio');
                return false;
            }
            ocultar = "display:none;";
        } else if (tipoReq == 3) {
            if (cantidad == '' || !parseInt(producto) || precio == '') {
                crear_alerta('info', 'Activo Fijo', 'Debe especificar las características del activo fijo');
                //$('#slcBodega_error').html('Campo requerido');
                return false;
            }
            // ocultar = "display:none;";
            medidasHtml = $("#slcMedidas").html();
            nombreMedida = $("#slcMedidas option:selected").text();
        } else if (tipoReq == 4){
            if(tipoProducto != 1){
                if ((cantidad <= 0) || medidas == '' || producto == '' || precio == '') {
                    crear_alerta('info', 'Productos', 'Debe especificar las características del producto');
                    //crear_alerta('danger', 'Productos', 'Bodega es requerida');
                    //$('#slcBodega_error').html('Campo requerido');
                    return false;
                }
            } else{
                if (cantidad == '' || !parseInt(producto) || precio == '') {
                    crear_alerta('info', 'Servicio', 'Debe especificar las características del servicio');
                    return false;
                }
            }

            medidasHtml = $("#slcMedidas").html();
            nombreMedida = $("#slcMedidas option:selected").text();
        } else{
            crear_alerta('info', 'Documento por Proveedor', 'Debe especificar el tipo de documento');
            return false;
        }

        if (precio == '' || precio <= 0) {
            crear_alerta('error', 'Atención', 'Precio del producto no puede ser cero.');
            return false;
        }

        var slcImpuestosHtml = getOpcionesSelect("slcImpuestos");
        var slcRetencionesHtml = getOpcionesSelect("slcRetenciones");
        var slcTipoVentaHtml = getOpcionesSelect("slcTipoVenta");
        var slcBodegaHtml = getOpcionesSelect("slcBodega");
        var slcSectorHtml = getOpcionesSelect("slcSector");

        slcImpuestosHtml = slcImpuestosHtml.replace(/"/g, "'");
        slcRetencionesHtml = slcRetencionesHtml.replace(/"/g, "'");
        slcTipoVentaHtml = slcTipoVentaHtml.replace(/"/g, "'");
        slcBodegaHtml = slcBodegaHtml.replace(/"/g, "'");
        slcSectorHtml = slcSectorHtml.replace(/"/g, "'");

        var subTotal = cantidad * precio;
        var descuento_total = number_format(((descuento/100)*(subTotal)), $("#hdnDecimal").val(), '.','');
        subTotal = subTotal - descuento_total;

        var totalImpuestos = parseFloat(calcularGastosMultiSelect("slcImpuestos", "data-porcentaje", subTotal, cantidad).toString().replace(",", ''));
        var totalRetenciones = parseFloat(calcularGastosMultiSelect("slcRetenciones", "data-porcentaje", subTotal));
        // totalRetenciones = totalRetenciones * cantidad;
        var TotalProducto = (subTotal - totalRetenciones) + totalImpuestos;

        var html = '';
        var idTr = "tr_" + row;
        var htmlModalProrrateo = "";

        htmlModalProrrateo = getModalProrrateo(row, producto);

        var orden_compra = $("#slcOrdenCompra").val();

        html += '<tr id="' + idTr + '" data-prod="' + producto + '" data-id="' + row + '" class="detalle_doc_proveedor">';
        html += '<input type="hidden" name="conversion[]" id="hdnConversion_' + row + '" value="' + medidas + '"/>';
        html += '<input type="hidden" name="conversionDefe[]" id="hdnConversionDef_' + row + '" value="' + valor_defecto + '"/>';
        html += '<input type="hidden" name="conversionConv[]" id="hdnConversionConv_' + row + '" value="' + valor_convertir + '"/>';
        html += '<input type="hidden" name="tipo_producto[]" value="' + tipoProducto + '"/>';
        html += '<input type="hidden" name="numero_correlativo[]" value="' + row + '"/>';

        html += '<input type="hidden" name="productos[]" id="hdnProducto_' + row + '" value="' + producto + '"/>';
        html += '<input type="hidden" name="prorrateos[]" id="hdnProrrateo_' + row + '" value="" class="Prorrateos"/>';
        html += '<input type="hidden" name="porcProrrateo[]" id="hdnPorcProrrateo_' + row + '" value="" class="prcProrateo"/>';
        html += '<input type="hidden" id="hdnHtmlProrrateo_' + row + '" value="" class="htmlProrrateo" data-table="" data-prorrateo="" data-detalles="" />';
        //html += '<input type="hidden" name="cantidades[]" id="hdnCantidad_' + row + '" value="' + cantidad + '"/>';
        //html += '<input type="hidden" name="precios[]" id="hdnPrecio_' + row + '" value="' + precio + '"/>';
        html += '<input type="hidden" name="retenciones[]" id="hdnRetenciones_' + row + '" value="' + retenciones + '"/>';
        html += '<input type="hidden" name="impuestos[]" id="hdnImpuestos_' + row + '" value="' + impuestos + '"/>';
        html += '<input type="hidden" name="bodegas[]" id="hdnBodega_' + row + '" value="' + bodegaProd + '"/>';
        html += '<input type="hidden" name="sectores[]" id="hdnSector_' + row + '" value="' + sectorProd + '"/>';
        html += '<input type="hidden" name="inventariable[]" id="hdnInv_' + row + '" value="' + flagInventario + '"/>';
        html += '<td><label id="dato_prod_nom_'+ row +'">' + codigoProducto + '-' + nombreArticulo+ '</label></td>';
        //html += '<td><label id="dato_prod_nom_'+ row +'">' + descripcionProd + '</label></td>';
        html += '<td><input type="text" class="text tables-input-show tables-input selects-text" name="descripcionProd[]" id="descripcionProd_' + row + '" value="' + descripcionProd + '" readonly="readonly"/></td>';

        //Se formatean los montos
        //cantidad = number_format(cantidad, 0);
        precio          = number_format(precio, $("#hdnDecimal").val(), '.','');
        totalImpuestos  = number_format(totalImpuestos, $("#hdnDecimal").val(), '.','');
        subTotal        = number_format(subTotal, $("#hdnDecimal").val(), '.','');
        TotalProducto   = number_format(TotalProducto, $("#hdnDecimal").val(), '.','');
        var ishid       = (usa_sectores > 0) ? 'text' : 'hidden';

        html += '<td>';
        html += '<input type="text" class="text tables-input selects-text" value="' + nombreMedida + '" readonly="readonly"/>';
        html += '<select id="slcMedidas_' + row + '" data-id="' + row + '" style="display:none;" class="selects-edit">' + medidasHtml + '</select>';
        html += '</td>';

        // BODEGA / SECTORES
        html += '<td style="' + ocultar + '">';
        html += '<a href="#modalBodegas" id="lnkSector_' + row + '" data-tipo="1" data-input="txtSector_' + row + '" data-inputBod="txtBodega_' + row + '" data-etiqueta-padre="Bodega" data-etiqueta="Sector" data-html-padre="' + slcBodegaHtml + '" data-html="' + slcSectorHtml + '" data-id="' + row + '" data-hiddenPadre="hdnBodega_' + row + '" data-hidden="hdnSector_' + row + '" class="icon-table modalBodegas"><span class="icon16 icomoon-icon-list-view"></span></a>';
        html += '<input type="text" id="txtBodega_' + row + '" class="text tables-input input-table" value="' + nombreBodegaProd + '" readonly="readonly"/>';
        html += '<input type="'+ishid+'" id="txtSector_' + row + '" class="text tables-input input-table" value="' + nombreSectorProd + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtCantidad_' + row + '" name="cantidades[]" class="text tables-input-show tables-input cantidadProducto cantidades" value="' + cantidad + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtPrecioUnitario_' + row + '" name="precios[]" class="text tables-input-show tables-input soloNumeros preciosUnidades" extras="." value="' + precio + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<a href="#modalSelect" id="lnkRetenciones_' + row + '" data-tipo="2" data-input="txtRetencion_' + row + '" data-etiqueta="Retenciones" data-html="' + slcRetencionesHtml + '" data-id="' + row + '" data-hidden="hdnRetenciones_' + row + '" class="icon-table multiSelectModal"><span class="icon16 icomoon-icon-list-view"></span></a>';
        html += '<input type="text" id="txtRetencion_' + row + '" name="retencionesProducto[]" class="text tables-input soloNumeros input-table retencionesProducto" extras="." value="' + number_format(totalRetenciones, $("#hdnDecimal").val(), '.','') + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + nombreTipoVenta + '" readonly="readonly"/>';
        html += '<select id="slcTipoVenta_' + row + '" name="tiposVenta[]" data-id="' + row + '" style="display:none;" class="select-edit">' + slcTipoVentaHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<a href="#modalDescuento" id="lnkDescuento_' + row + '" data-input="txtDescuento_' + row + '" data-etiqueta="Descuento" data-id="' + row + '" class="icon-table modal_descuento"><span class="icon16 icomoon-icon-list-view"></span></a>';
        //desc_det desc_mon tables-input-show
        html += '$<input type="text" id="txtMonto_' + row + '"  class="soloDecimales tables-input" extras="."  maxlength="19"  value="' + monto_descuento + '" decimales="2" data-row="' + row + '" readonly="readonly" style="width:33%!important;">&nbsp;/&nbsp;';
        html += '<input type="text" id="txtDescuento_' + row + '" name="descuento_producto[]" class="text tables-input soloNumeros  porcentaje" extras="." porcentaje="'+descuento+'" subtotal="'+(parseFloat(subTotal)+parseFloat(descuento_total))+'" value="' + descuento + '" readonly="readonly" style="text-align: right; width: 33%!important;"/>%';
        /* +++++ */
        html += '<input type="hidden" name="descuentos[]" id="hdnDescuentos_' + row + '" value="'+ descuento +'" class="descuentosProducto"/>';
        html += '<input type="hidden" name="descuentomonto[]" id="hdnDescuentosmonto_' + row + '" value="'+ monto_descuento +'" class="descuentosProducto"/>';
        html += '</td>';//tables-input  /* +++++ */

        html += '<td>';
        html += '<input type="text" id="txtSubtotal_' + row + '" name="subtotalesProducto[]" class="text tables-input subtotalProductos" extras="." value="' + subTotal + '" readonly="readonly" data-correlativo ="' + row + '" data-prod="' + producto + '"/>';
        html += '</td>';

        html += '<td>';
        html += '<a href="#modalSelect" id="lnkImpuestos_' + row + '" data-tipo="1" data-input="txtImpuesto_' + row + '" data-etiqueta="Impuestos" data-html="' + slcImpuestosHtml + '" data-id="' + row + '" data-hidden="hdnImpuestos_' + row + '" class="icon-table multiSelectModal"><span class="icon16 icomoon-icon-list-view"></span></a>';
        html += '<input type="text" id="txtImpuesto_' + row + '" name="impuestosProducto[]" class="text tables-input soloNumeros input-table impuestosProducto" extras="." value="' + totalImpuestos + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtTotal_' + row + '" name="totalesProducto[]" class="text tables-input totalProductos" extras="." value="' + TotalProducto + '" readonly="readonly"/>';
        html += '</td>';
        html += '<td>';
        if (!orden_compra > 0) {

            html += '<button type="button" class="btn btn-primary btn-mini btnGuardarProd" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;">Guardar</button>';
            html += '<button type="button" class="btn btn-primary btn-mini btnEditProd" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;">Editar</button>';
            html += '<button type="button" class="btn btn-danger btn-mini btnDelProd" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;">Eliminar</button>';
        }

        //if (tipoReq == 1) {
        html += '<a href="#modalProrrateo_' + row+ '" style="margin-left: 10px;" id="lnkProrrateo_' + row + '" data-id="' + row + '" data-contador="'+contador_productos+'" data-prod="' + producto + '" data-row="'+row+'" class="icon-table prorrateosModal"><span class="icon16 icomoon-icon-list-view-2"></span></a>';

        html += htmlModalProrrateo;
        //}
        html += '</td>';

        html += '</tr>';

        $("#datagried").append(html);
        $('.desc_por').trigger('keyup');
        $("#contador_productos").val(contador_productos+1);
        //Se ingresa la tabla del Prorrateo Preconfigurada
        precargar_prorrateo(producto, "", row);
        
        if ($('#datagried tr').length > 0)
        {
            $('#datagried').removeClass('error');
            $('#validar_datagried').text('');
        }


        limpiar_filtro_categorias();
        $("#txtCantidad").val('');
        $("#txtDescuento").val('');
        $("#txtPrecio").val('');
        $("#txtDescripcionProd").val('');        
        $('#hdnInventariable').val('');
        //$('#slcProductos').select2({placeholder: 'Seleccione una opción'});
        $('#slcMedidas option:selected').removeAttr('selected');
        $('#slcMedidas').select2({placeholder: 'Seleccione una opción'});
        $('#slcTipoVenta option:selected').removeAttr('selected');
        $('#slcTipoVenta').select2({placeholder: "Seleccione una opción"});
        $('#slcImpuestos option:selected').removeAttr('selected');
        $('#slcImpuestos').select2({placeholder: 'Seleccione una opción'});
        $('#slcRetenciones option:selected').removeAttr('selected');
        $('#slcRetenciones').select2({placeholder: 'Seleccione una opción'});
        // EN EL CASO DEL SUPER ROSARIO PIDIERON QUE LA BODEGA NO SE RESETEE
        if (!($("#reset_bod").length > 0 && $("#reset_bod").val() == 'super')) {
            $("#slcBodega option:selected").removeAttr('selected');
            $("#slcBodega").select2({placeholder: 'Seleccione una opción'});
            $("#actual_slctd").val("");
        }else{
            $("#actual_slctd").val($("#slcBodega").val());
        }
        $("#slcSector option:selected").removeAttr('selected');
        $("#slcSector").select2({placeholder: 'Seleccione una opción'});

        row = row + 1;
        limpiar_select_producto();
        //Se actualizan los totales
        calcularTotales();
    });//En of function agregar

    $(".btnEditProd").live('click', function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id + " .select-text").hide();

        $("#" + parent[0].id + " .select-edit").select2();
        $("#" + parent[0].id + " .select2-container").css('width', '100%');
        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');

        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarProd").show();
    });

    //Guardar
    $(".btnGuardarProd").live('click', function () {
        var parent = $(this).parent().parent();
        var id_parent = $("#" + parent[0].id).data('id');
        var cantidad_real = $("#hdnCantidad_" + id_parent).val();
        var txtCantidad = $("#txtCantidad_" + id_parent).val();
        var txtPrecio = $("#txtPrecioUnitario_" + id_parent).val();
        var txtDescuento = $("#txtDescuento_" + id_parent).val();
        if($("#hdnCantidad_"+id_parent).length >0 && parseFloat(cantidad_real)<parseFloat(txtCantidad)){
            crear_alerta('error', 'Orden de compra', 'La cantidad ingresada excede la cantidad emitida en la orden de compra');
            return false;
        }
        if (txtCantidad == '' || txtCantidad == 0) {
            crear_alerta('error', 'Orden de compra', 'Debe ingresar una cantidad válida');
            return false;
        }
        if (txtPrecio == '' || txtPrecio == 0) {
            crear_alerta('error', 'Orden de compra', 'Debe ingresar un precio válido');
            return false;
        }
        $("#" + parent[0].id + " .select-edit").each(function () {
            var select_id = $(this).attr('id');
            var valor = $("#" + select_id).val();
            var text = $("#" + select_id + " option:selected").text();
            if (valor != '') {
                $("#" + select_id).prev().val(text);
            } else {
                $("#" + select_id).prev().val('');
            }
            $("#" + select_id).prev().show();
        });
        $("#" + parent[0].id + " .select-edit").select2('destroy');
        $("#" + parent[0].id + " .select-edit").hide();
        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');
        $(this).hide();
        $("#" + parent[0].id + " .btnEditProd").show();
        // Se calculan los totales de la fila
        calcularTotalFila(parent[0].id);
        // Se actualizan los totales
        calcularTotales();
    });

    // Eliminar Producto
    $(".btnDelProd").live("click", function () {
        var parent = $(this).parent().parent();
        $("#" + parent[0].id).remove().delay(300);
        //Se actualizan los totales
        calcularTotales();
    });

    //Modal de Multiselects
    $(".multiSelectModal").fancybox({
        width: '75%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            var etiqueta = $(this.element[0]).attr('data-etiqueta');
            var html = $(this.element[0]).data('html');
            var id = $(this.element[0]).attr('id');
            $("#hdnElementoOculto").val(id);
            $("#lblSelect").text(etiqueta + ':');
            $("#slcMultiCargos").html(html);
            $("#slcMultiCargos").select2();
        },
        beforeClose: function () {
            $("#hdnElementoOculto").val('');
            $("#lblSelect").text('');
            $("#slcMultiCargos").html('');
            $("#slcMultiCargos").select2('destroy');
        }
    });

    $(".porcentaje").live('change', function(){
        var cantidad = $(this).val();
        if (cantidad <= 100) {
            $(this).val(number_format($(this).val(),$decimal_global,".",""));
        } else {
            $(this).val("0.00");
            $.pnotify({
                type: 'error',
                title: 'Aviso',
                text: 'El descuento no debe ser mayor a 100%.',
                icon: 'ui-icon ui-icon-info white',
                opacity: 0.95,
                history: false,
                sticker: false
            });
        }
    })

    $("#btnGuardarDescuento").on('click', function(){
        var subtotal = $("#subtotal_modal_descuento").val();
        var descuento_id = $("#id_modal_descuento").val();
        var descuento_porcentaje = $("#descuento_nuevo").val();
        var descuento_monto = $("#monto_nuevo").val();
        var id = $("#id_row").val();

        $(descuento_id).closest('tr').find('.descuentosProducto').val(descuento_porcentaje);
        $(descuento_id).attr('porcentaje', number_format(descuento_porcentaje, $("#hdnDecimal").val(), '.',''));
        $(descuento_id).val(number_format(descuento_porcentaje, $("#hdnDecimal").val(), '.',''));
        $('#txtMonto_'+id).val(number_format(descuento_monto, $("#hdnDecimal").val(), '.',''));
        var id_parent = $(descuento_id).closest('tr').attr('id');
        //Se calculan los totales de la fila
        calcularTotalFila(id_parent);
        //Se actualizan los totales
        calcularTotales();

        $.fancybox.close();
    })

    //Modal de Multiselects
    $(".modal_descuento").fancybox({
        width: '75%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            var id = $(this.element[0]).attr('data-id');
            var etiqueta = $(this.element[0]).attr('data-etiqueta');
            var valor = $("#txtDescuento_"+id).val();
            var descuento = $("#txtDescuento_"+id).attr('porcentaje');
            var subtotal = $("#txtDescuento_"+id).attr('subtotal');
            $("#subtotal_modal_descuento").val(subtotal);
            $("#id_modal_descuento").val("#txtDescuento_"+id);
            $("#id_row").val(id);
            $("#descuento_nuevo").val(descuento);
            $("#lblDescuento").text(etiqueta + ':');
            $("#descuento_nuevo").trigger('keyup');
        },
        beforeClose: function () {
            $("#hdnElementoOculto").val('');
            $("#lblSelect").text('');
            $("#slcMultiCargos").html('');
            $("#slcMultiCargos").select2('destroy');
        }
    });

$("#descuento_total").change(function () {
    var descuento_nuevo = parseFloat($(this).val().replace(',', '')) || 0;

    if (descuento_nuevo >= 100) {
        crear_alerta("error", "Descuento", "Descuento debe ser menor al 100%");
        $(this).val("");
        $("#txtDescuentoGeneral").val("");
        return;
    }

    let totalDescuento = 0;
    let totalSuma = parseFloat($("#txtSumaGeneral").val().replace(',', '')) || 0;

    $(".detalle_doc_proveedor").each(function () {
        let $row = $(this);
        let tr = $row.attr('id');
        let id = $row.find(".modal_descuento").data('id');
        let descuento_id = $row.find(".porcentaje").attr("id");
        let prod_id = $row.data('prod');
        let precio = parseFloat($row.find('.preciosUnidades').val().replace(/,/g, '')) || 0;
        let cantidad = parseFloat($row.find('.cantidadProducto').val().replace(/,/g, '')) || 0;

        if (typeof omitir_descuento_id_producto !== 'undefined' && omitir_descuento_id_producto.indexOf(prod_id) !== -1) {
            $row.find('.descuentosProducto').val("0.00");
            $row.find('.desc_mon').val("0.00");
            $("#" + descuento_id).val("0.00").attr('porcentaje', "0.00");
        } else {
            let descuento_linea = (precio * cantidad) * (descuento_nuevo / 100);
            totalDescuento += descuento_linea;

            $("#" + descuento_id).val(number_format(descuento_nuevo, $("#hdnDecimal").val(), '.', '')).attr('porcentaje', number_format(descuento_nuevo, $("#hdnDecimal").val(), '.', ''));
            $row.find('.descuentosProducto').val(number_format(descuento_nuevo, $("#hdnDecimal").val(), '.', ''));
            $("#txtMonto_" + id).val(number_format(descuento_linea, $("#hdnDecimal").val(), '.', ''));
            $("#hdnDescuentosmonto_" + id).val(number_format(descuento_linea, $("#hdnDecimal").val(), '.', ''));
        }

        calcularTotalFila(tr);
    });

    $("#txtDescuentoGeneral").val(number_format(totalDescuento, $("#hdnDecimal").val(), '.', ','));
    calcularTotales();
});



    //Modal de Prorrateos
    $(".prorrateosModal").fancybox({
        width: '90%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        closeBtn: false,
        type: 'inline',
        //closeBtn: false,
        hideOnOverlayClick: true,
        helpers: {
            overlay: {closeClick: false} // prevents closing when clicking OUTSIDE fancybox
        },
        keys : {
            close  : null
        },
        beforeLoad: function () {
            var prod = $(this.element[0]).attr('data-prod');
            var row = $(this.element[0]).attr('data-row');
            var cec = $("#slcCentroCosto").val();
            $("#slcProrrateo_" + row).select2({placeholder: "Seleccione una opción"});
            $("#slcCentroCosto_" + row).val(cec);
            $("#slcCentroCosto_" + row).select2({placeholder: "Seleccione una opción"});
            $("#slcCuenta_" + row).select2({placeholder: "Seleccione una opción"});
            glb_idprod  = prod;
            acciones    = 0;
            precargar_prorrateo(prod, "", row);
        },
        beforeClose: function () {
            var prod = $(this.element[0]).attr('data-prod');
            var row = $(this.element[0]).attr('data-row');
            glb_idprod = prod+'_'+row;
            //return false;
            var totalPorc = 0;
            if ($("#slcProrrateo_" + row).val() > 0 || $("#tblProrrateo_" + row + " tr .porcentajeCentroCos").length > 0) {
                var totalPorc = 0;
                $("#tblProrrateo_" + row + " tr .porcentajeCentroCos").each(function () {
                    var valor = $(this).val();
                    valor = parseFloat(valor);
                    totalPorc += valor;
                });

                /*if (totalPorc != 100) {
                    crear_alerta('error', 'Prorrateo', 'El porcentaje debe ser igual 100%');
                    return false;
                }*/
            }
            //jQuery.fancybox.close();
        }
    });

    $("#btnGuardarSelect").click(function () {
        var idLink = $("#hdnElementoOculto").val();
        var idSeleccionados = $("#slcMultiCargos").val();
        var idHidden = $("#" + idLink).attr('data-hidden');
        var idInput = $("#" + idLink).attr('data-input');
        var tipo = $("#" + idLink).attr('data-tipo');
        $("#" + idHidden).val(idSeleccionados);
        var opciones = "";//$("#slcMultiCargos").html();
        $("#slcMultiCargos option").each(function () {
            if (!$(this).attr('selected')) {
                $(this).removeAttr('selected');
            } else {
                $(this).attr('selected', 'selected');
            }
            opciones += this.outerHTML;
        });

        $("#" + idLink).data('html', opciones);
        var parent = $("#" + idLink).parent().parent();
        //var descuento = parent.find('.porcentaje').val();
        var cantidad = parent.find('.cantidadProducto').val().replace(/,/g, "");
        var subtotal = 0.00;//parent.find('.subtotalProductos').val();
        if (tipo == 1) {
            var subtotal = parent.find('.subtotalProductos').val().replace(/,/g, "");
        } else if (tipo == 2) {
            var subtotal = parent.find('.preciosUnidades').val().replace(/,/g, "");
        }
        var montoSubtotal = calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subtotal, cantidad);
        if (tipo == 2) {
            montoSubtotal = montoSubtotal * cantidad;
        }
        var prueba = number_format(montoSubtotal, $("#hdnDecimal").val(), '.','');
        $("#" + $.trim(idInput)).val(prueba);
        calcularTotalFila(parent[0].id);
        //Se actualizan los totales
        calcularTotales();

        $.fancybox.close();
    });

    //Modal de Sectores
    $(".modalBodegas").fancybox({
        width: '75%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            var isdisable = $("#orden_ya_afecto").val();
            var etiqueta = $(this.element[0]).attr('data-etiqueta');
            var html = $(this.element[0]).attr('data-html');
            var etiqueta_padre = $(this.element[0]).attr('data-etiqueta-padre');
            var html_padre = $(this.element[0]).attr('data-html-padre');

            $("#hdnElementoOcultoSec").val($(this.element[0]).attr('id'));
            $("#lblSelectPadre").html(etiqueta_padre + ': <b class="red">*</b>');
            $("#slcOpcionesPadre").html(html_padre);
            $("#slcOpcionesPadre").select2({placeholder: "Seleccione una opción"});
            if (isdisable > 0) {
                $('#slcOpcionesPadre').select2('disable');
            } else {
                $('#slcOpcionesPadre').select2('enable');
            }

            $("#lblSelectHijo").html(etiqueta + ': <b class="red">*</b>');
            $("#slcOpcionesHijo").html(html);
            $("#slcOpcionesHijo").select2({placeholder: "Seleccione una opción"});

        },
        beforeClose: function () {
            $("#hdnElementoOcultoSec").val('');
            $("#lblSelectPadre").text('');
            $("#slcOpcionesPadre").html('');
            $("#slcOpcionesPadre").select2('destroy');

            $("#lblSelectHijo").text('');
            $("#slcOpcionesHijo").html('');
            $("#slcOpcionesHijo").select2('destroy');
        }
    });

    $("#btnGuardarSelectSector").click(function () {
        var idLink = $("#hdnElementoOcultoSec").val();
        var idPadre = $("#slcOpcionesPadre").val();
        var idDependencia = $("#slcOpcionesHijo").val();
        var textoPadre = $("#slcOpcionesPadre option:selected").text();
        var textoDependencia = $("#slcOpcionesHijo option:selected").text();
        var idHidden = $("#" + idLink).attr('data-hidden');
        var idHiddenPadre = $("#" + idLink).attr('data-hiddenPadre');
        var idInput = $("#" + idLink).attr('data-input');
        var idInputBod = $("#" + idLink).attr('data-inputBod');
        var usa_sectores = $("#param_sectores").val();

        if (idPadre == '' || idDependencia == '') {
            if (idPadre == '') {
                crear_alerta('error','Bodegas','Debe completar todos los campos.');
                return false;
            }
            if (idDependencia == '' && usa_sectores > 0) {
                crear_alerta('error','Sectores','Debe completar todos los campos.');
                return false;
            }
        }

        $("#" + idHidden).val(idDependencia);
        $("#" + idHiddenPadre).val(idPadre);

        var opcionesPadre = "";
        var opcionesDependencia = "";

        opcionesPadre = getOpcionesSelect('slcOpcionesPadre');
        opcionesDependencia = getOpcionesSelect('slcOpcionesHijo');

        $("#" + idLink).attr('data-html-padre', opcionesPadre);
        $("#" + idLink).attr('data-html', opcionesDependencia);

        $("#" + idInput).val(textoDependencia);
        $("#" + idInputBod).val(textoPadre);
        $.fancybox.close();
    });


    //Calculo cuando es desde una requisicion
    $(".input-requisicion").live('keyup', function () {
        var parent = $(this).parent().parent();

        var valor = parseFloat($(this).val());

        var inputHidden = $(this).data('hidden');

        $("#" + inputHidden).val(valor);

        var cantidad = parseFloat($("#" + parent[0].id).find('.cantidadProducto').val());
        var precio = parseFloat($("#" + parent[0].id).find('.preciosUnidades').val());

        var subtotal = number_format(parseFloat(cantidad * precio), $("#hdnDecimal").val(), '.','');

        $("#" + parent[0].id).find('.subtotalProductos').val(subtotal);

        calcularTotalFila(parent[0].id);
        calcularTotales();
    });


    //Carpeta de Anexos
    var anx = 0;
    var folder_anx_temp = $('#carpeta_temporal').attr('value');
    var ruta_anx = urlj + 'inicio/guardar_gral/' + folder_anx_temp;
    new FUload('btnAnexo', ruta_anx, {
        start: function (file) {
            wait.start();
        },
        sucess: function (data) {
            wait.close();

            if ($.trim(data) !== "") {

                var a_exten = $.trim(data).split('.');

                var exten = "." + a_exten[(a_exten.length - 1)];
                // verifica existencia del mismo documento en la carpeta.
                var preview = "<tr id='preview" + anx + "' style='display:none;' class='preview_documento'>";
                if (a_exten[(a_exten.length - 1)] === 'png' || a_exten[(a_exten.length - 1)] === 'jpg' || a_exten[(a_exten.length - 1)] === 'jpeg' || a_exten[(a_exten.length - 1)] === 'pdf') {
                    preview += "<td><a  title=\"Ver Anexo\" class='ver_en_modal fancybox-buttons' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                } else {
                    preview += "<td><a target='_blank' title=\"Ver Anexo\" class='' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                }

                preview += "<img id='pre" + anx + "' src='' width='88' height='88' class='imagen_documento'></a></td>";
                preview += "<td><input maxlength='75' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc[]' value='" + $.trim(data).replace(exten, '') + "'><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc" + anx + "'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                //preview+="<td><input maxlength='50' readonly='readonly' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc"+i+"' value='"+$.trim(data).replace(exten,'')+"'><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc"+i+"'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                preview += "<td style='vertical-align:middle !important; width:30px !important;'><img  style='display:none;' src='" + urlj + "media/editar_documento.png" + "' title='Editar' value='titulo_doc" + anx + "' class='editar_documento'/></td>";
                preview += "<td style='background:#E1E7F0!important;'><a href=\"javascript: void(0);\" title=\"Eliminar Anexo\" class='eliminar_imagen' id='delete" + anx + "' custom='' custom_id=''><img class='quitar_documento' src='" + urlj + "media/eliminar_documento.png" + "' title='Eliminar documento'></a></div>";
                preview += "<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></td></tr>";

                $("#previews").append(preview).show(300);
                $("#awesome_form").append("<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></div>");
                $("#preview" + anx).fadeIn(400);

                //document.getElementById('pre'+i).src=base+"media/imagenes/sistema/pdf.png";
                document.getElementById('pre' + anx).src = urlj + "media/imagenes/sistema/" + a_exten[(a_exten.length - 1)] + ".png";
                document.getElementById('ruta' + anx).value = $.trim(data);
                document.getElementById('delete' + anx).custom = $.trim(data);
                document.getElementById('delete' + anx).custom_id = i;
                valor = document.getElementById('pre' + anx).src;

                // $('input[name=titulo_doc'+i+']').focus();
                // nombre_doc=$('input[name=titulo_doc'+i+']').val();

                anx++;
                $(".eliminar_imagen, .verAnexo").tooltip();
            } else { //el formato es incorrecto
                crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
            }
        }
    });

    $(".eliminar_imagen").live("click", function (event) {
        event.preventDefault();

        url = this.custom;
        id_key = this.custom_id;
        id = this.id;
        $.ajax({
            type: 'POST',
            url: urlj + 'inicio/eliminar_imagen_gral/' + folder_anx_temp,
            data: {url: url},
            success: function (data) {
                $("#ruta" + id_key).val("");
                $("#" + id).parent().parent().remove().delay(300);
            }
        });
    });

    $(".delete_anexo").live('click', function (event) {
        event.preventDefault();

        var anexo = $(this).data('anexo');

        $("#anexo_" + anexo).remove().delay(500);
    });

    $(".verAnexo").fancybox({
        openEffect: 'elastic',
        closeEffect: 'elastic',
        href: $(this).attr('href'),
        type: 'iframe',
        helpers: {
            title: {
                type: 'inside'
            }
        }
    });

    $(".selectorProrrateo").live('change', function () {

        /*var slcElementoHijo = $(this).data('centro');
        var prorrateo = $(this).val();
        var prod = $(this).data('prod');

        //$("#tbProrrateo_" + prod).html('');
        if (prorrateo != '') {
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {prorrateo: prorrateo},
                url: urlj + 'modulo_compras/procesos/get_detalle_prorrateo',
                success: function (data) {
                    $("#" + slcElementoHijo).html(data.opciones);
                    $("#" + slcElementoHijo + " option[value='0']").text('');
                    $("#" + slcElementoHijo + " option[value='0']").val('');
                    $("#" + slcElementoHijo).select2({placeholder: 'Seleccione una opción'});
                }
            });
        }*/
    });

    $(".selectorCentroCostos").live('change', function () {

        var centro = $(this).val();
        var porcentaje = 0;
        var prod = $(this).data('prod');

        if (centro > 0) {
            porcentaje = $("#" + this.id + " option:selected").data('porcentaje');
            $("#txtPorcentaje_" + prod).val(porcentaje);
        } else {
            $("#txtPorcentaje_" + prod).val('');
        }
    });

    $(".btnAgregarCentroCosto").live('click', function () {
        var html = '';
        var prod = $(this).data('prod');
        var modal = $(this).closest('.modalProrrateo');
        var row = modal.data('row');

        var centro_costo        = $("#slcCentroCosto_" + row).val();
        var centro_costo_nombre = $("#slcCentroCosto_" + row + " option:selected").text();
        var codigo_centro_costo = "";

        var porcentaje = $("#txtPorcentaje_" + row).val();
        //var cuenta_contable = $("#slcCentroCosto_" + prod + " option:selected").data('cuenta');
        var idcuenta_contable = $("#idcnt_" + row).val();
        var cuenta_contable = $("#ccon_" + row).val();

        var cuenta        = $("#slcCuenta_" + row).val();
        var cuenta_nombre = $("#slcCuenta_" + row + " option:selected").text();

        idcuenta_contable = (idcuenta_contable != '')?idcuenta_contable:cuenta;
        cuenta_contable = (cuenta_contable != '')?cuenta_contable:cuenta_nombre;

        porcentaje = parseFloat(porcentaje);

        var totalProd = parseFloat($("#tr_" + row).find('.subtotalProductos').val());


        var total = (porcentaje / 100) * totalProd;

        if (centro_costo_nombre == '' || porcentaje == '') {
            crear_alerta('error', 'Prorrateo', 'Debe completar todos los campos.');
            return false;
        }

        var idTr = "tr_cec_" + centro_costo +"_"+cuenta;
        if($('#tbProrrateo_'+row +  " #" + idTr).length > 0){
            crear_alerta('error', 'Prorrateo', 'El centro de costo ya fue ingresado.');
            return false;
        }

        var totalPorc = 0;
        $("#tbProrrateo_" + row + " > tr .porcentajeCentroCos").each(function () {
            var valor = $(this).val();
            valor = parseFloat(valor);
            totalPorc += valor;
        });

        totalPorc = porcentaje + totalPorc;

        if (totalPorc > 100) {
            crear_alerta('error', 'Prorrateo', 'El porcentaje no debe ser mayor al 100%');
            return false;
        }

        html += '<tr id="' + idTr + '" data-id="' + centro_costo + '" data-prod="' + prod + '" class="new" ><td>';
        html += '<input type="hidden" name="centroCostos_' + prod + '[]" id="hdnCentroCosto_' + centro_costo + '" value="' + codigo_centro_costo + '"/>';//detalle prorrateo
        html += '<input type="hidden" name="codigo_centro_costo_' + prod + '[]" id="codigo_centro_costo_' + row + '" value="' + centro_costo  + '"/>';//centro costo
        html += centro_costo_nombre + '</td>';

        html += '<td>';
        html += '<input type="hidden" name="cuentacontablenew_' + prod + '[]"  class="text tables-input" value="' + idcuenta_contable + '" readonly="readonly"/>';
        html += '<input type="hidden" name="prorrateo_exist_' + row +'_'+ prod + '[]" value="" />';
        html += cuenta_contable + '</td>';

        html += '<td>';
        html += '<input type="text" id="txtPorcentaje_' + centro_costo + '" name="porcentajesCec_' + prod + '[]" class="text tables-input-show tables-input porcentajeCentroCos" value="' + number_format(porcentaje, $("#hdnDecimal").val(), '.','') + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input totalCentroCos" id="txtTotalCec_' + centro_costo + '" name="totalCec_' + prod + '[]" value="' + number_format(total, $("#hdnDecimal").val(), '.','') + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<button type="button" class="btn btn-primary btn-mini btnGuardarCec" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;">Guardar</button>';
        html += '<button type="button" class="btn btn-primary btn-mini btnEditCec" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;">Editar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelCec" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;">Eliminar</button>';
        html += '</td>';

        html += '</tr>';

        $("#tbProrrateo_" + row).append(html);

        $("#slcCentroCosto_" + row + " option:selected").removeAttr('selected');
        $("#slcCentroCosto_" + row).select2({placeholder: "Seleccione una opción"});
        $("#txtPorcentaje_" + row).val('');

        $("#slcCuenta_" + row + " option:selected").removeAttr('selected');
        $("#slcCuenta_" + row).select2({placeholder: "Seleccione una opción"});
    });

    $(".btnEditCec").live('click', function () {
        var parent = $(this).closest('tr');
        parent.find(".select-text").hide();

        parent.find(".select-edit").select2();
        parent.find(".select2-container").css('width', '100%');
        parent.find(".tables-input-show").removeClass('tables-input');
        parent.find(".tables-input-show").removeAttr('readonly');

        $(this).hide();
        parent.find(".btnGuardarCec").show();
    });

    //Guardar
    $(".btnGuardarCec").live('click', function () {
        var parent = $(this).closest('tr');
        var tbody = $(this).closest('tbody');
        var id_parent = $("#" + parent[0].id).data('id');
        var prod = $("#" + parent[0].id).data('prod');
        var modal = $(this).closest('.modalProrrateo');
        var row = modal.data('row');

        var totalProd = parseFloat($("#tr_" + row).find('.totalProductos').val());
        var txtPorcentaje = parent.find("#txtPorcentaje_" + row).val();

        var total = 0;

        if (txtPorcentaje == '' || txtPorcentaje == 0) {
            crear_alerta('error', 'Prorrateo', 'Debe ingresar un porcentaje válido');
            return false;
        }

        //$("#" + parent[0].id + " .select-edit").select2('destroy');
        //$("#" + parent[0].id + " .select-edit").hide();
        var totalPorc = 0;
        $("#" + tbody[0].id + " > tr .porcentajeCentroCos").each(function () {
            var valor = $(this).val();
            valor = parseFloat(valor);
            totalPorc += valor;
        });

        if (totalPorc > 100) {
            crear_alerta('error', 'Prorrateo', 'El porcentaje no debe ser mayor al 100%');
            return false;
        }

        parent.find("#txtPorcentaje_" + row).val(number_format(txtPorcentaje,$("#hdnDecimal").val(),".",""))
        // $("#txtPorcentaje_" + id_parent).val(number_format(txtPorcentaje,decimal_global,".",""));
        total = (txtPorcentaje / 100) * totalProd;

        parent.find("#txtTotalCec_" + row).val(number_format(total,$("#hdnDecimal").val(),".",""));
        // $("#txtTotalCec_" + id_parent).val(number_format(total,decimal_global,".",""));

        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');
        $(this).hide();
        $("#" + parent[0].id + " .btnEditCec").show();
    });

    //Eliminar Producto
    $(".btnDelCec").live("click", function () {
        var parent = $(this).parent().parent();

        $("#" + parent[0].id).remove().delay(300);
    });

    $(".btnGuardarPro").live('click', function () {
        var prod = $(this).attr('data-prod');

        if ($("#tblProrrateo_" + prod + " tr .porcentajeCentroCos").length > 0) {
            var totalPorc = 0;
            $("#tblProrrateo_" + prod + " tr .porcentajeCentroCos").each(function () {
                var valor = $(this).val();
                valor = parseFloat(valor);
                totalPorc += valor;
            });

            if (totalPorc != 100) {
                crear_alerta('error', 'Prorrateo', 'El porcentaje debe ser igual 100%');
                return false;
            }
            $('.new').removeClass("new");

            jQuery.fancybox.close();
        } else {
            jQuery.fancybox.close();
        }

        var filas_prorrateo = $("#tbProrrateo_"+prod +" tr").length;
        if ( filas_prorrateo == 0) {
            $("#seteo_prorrateo_"+prod).val(0);
        } else {
            $("#seteo_prorrateo_"+prod).val(1);
        }
    });

    $("#registrar_solicitud").click(function () {
        if ($('#datagried tr').length <= 1 || $('#descripcion_req').val().trim() == '' || $('#fecha').val() == '' || $('#documento').val() == '') {
            if ($('#datagried tr').length <= 1) {
                $('#datagried').addClass('error');
                $('#validar_datagried').text('Debe seleccionar al menos un producto');
            }

            if ($("#descripcion_req").val() == '') {
                $('#descripcion_req').addClass('error');
                $('#validar_descripcion_req').text('Campo requerido');
            }
            /*if ($('#documento').val() == '') {
             //$('#documento').addClass('error');
             $('#validar_documento').text('Campo requerido');
             }*/
            if ($('#bodega').val() == '') {
                //$('#documento').addClass('error');
                $('#validar_bodega').text('Campo requerido');
            }

        } else {
            $("#fecha").prop('disabled', false);
            $("#documento").prop('disabled', false);
            $("#txtFechaVencimiento").prop('disabled', false);
            $("#slcOrdenCompra").removeAttr("disabled");
            $("#slcCajaChica").removeAttr("disabled");
            var aprobar_presupuesto = evaluar_presupuesto(); 
            if ( aprobar_presupuesto == false) {
                return false;
            }
            quitar_atributo();
            $("#frm").submit();
        }
    });

    //Eliminar detalles de la grid al hacer click en x de cerrar
    $(".fancybox-close").live('click', function () {
        //idprod = glb_idprod;
        //$('#tbProrrateo_' + idprod).html('');
        $('.new').remove();
    })

    //Determina si el centro de costos esta asociado a la categoria del producto
    $('.selectorCentroCostos').live('change', function () {
        idprod = glb_idprod;
        idcec = $(':selected', this).attr('id');//Id centro de costos
        var modal = $(this).closest('.modalProrrateo');
        var row = modal.data('row');
        $.ajax({
            async: true,
            dataType: 'json',
            type: 'POST',
            url: urlj + 'modulo_compras/procesos/get_cen_cos_aso_catprod',
            data: {idprod: glb_idprod, idcec: idcec },
            success: function (data) {
                if (!data.estado) {
                    //crear_alerta("info", "Aviso", "Este centro de costo no se encuentra enlazado a la categoría del producto.");
                    ///$('#slcCentroCosto_'+ idprod).select2('val','');
                    $('#ccon_'+ row).val("");
                    $('#idcnt_'+ row).val("");
                }else{
                    $('#ccon_'+ row).val(data.cnt_nombre);
                    $('#idcnt_'+ row).val(data.cnt_id);
                    $("#slcCuenta_" + row).val(data.cnt_id);
                    $("#slcCuenta_" + row).select2();
                }
            }
        });
    })

/*
        SELECT ajax
*/

    $("#slcProducto_ajx").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_compras/procesos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    // servicio: 5,
                    servicio: $("#slcTipo").val(),
                    otro: 1
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.codigo+' - '+item.prod_nombre
                    });
                });

                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#slcProducto_ajx").live("change", function (e) {
        var valor       = $(this).val();
        var proveedor   = $("#slcProveedor").val();
        var actividad_especifica= $("#slc_actividad_espeficifica").val();
        //return false;
        if ($.trim(valor) != "") {
            $.ajax({
                url: urlj + 'modulo_compras/procesos/cargar_impuestos_ajax',
                type: 'POST',
                dataType: 'json',
                data: {producto: valor, proveedor: proveedor},
                success: function (data) {
                    if ($.trim(data.impuesto) != "") {
                        $("#slcImpuestos").html(data.impuesto);
                        $("#slcImpuestos").select2({placeholder: 'Seleccione una opción'});
                    }
                }
            });

            if (actividad_especifica != "") {
                var especifico  = $("#slc_actividad_espeficifica").val();
                var presupuesto = $("#slc_presupuesto").val();
                validacion_articulo_aprobado(valor,especifico,presupuesto);
            }

        } else {
            $("#slcImpuestos").html('<option value=""></option>');
            $("#slcImpuestos").select2({placeholder: 'Seleccione una opción'});
        }
    });

    function validacion_articulo_aprobado(valor,especifico,presupuesto) {
        $.ajax({
            dataType: 'json',
            type: 'post',
            data: {
                producto: valor,
                especifico: especifico,
                presupuesto: presupuesto
            },
            url: urlj + 'modulo_compras/procesos/articulo_aprobado',
            success: function (data) {
                $("#articulo_presupuesto").val(data.aprobacion);
                if ( $("#articulo_presupuesto").val() == 0  && $("#slcProducto_ajx").val() != "") {
                    var producto_tmp = $("#slcProducto_ajx").select2('data').text;
                    crear_alerta("info", "Producto/ servicio", '"'+producto_tmp+'"'+' no esta disponible para la partida o rubro seleccionado');            
                    $('.dinamic option:selected').removeAttr('selected');
                    $('select[class="dinamic"]').last().select2({placeholder: 'Seleccione una opción'});
                    limpiar_select_producto();
                }
            }
        });
    }


    function limpiar_select_producto(){
        categoria_tip = typeof $("select[class='dinamic']").last().val() !== 'undefined' ?  $("select[class='dinamic']").last().val() : '';

        if($.trim(categoria_tip) != ''){
            $('#slcProductos option:selected').removeAttr('selected');
            $("#slcProductos").select2({placeholder: 'Seleccione una opción'});
            $("#slcProducto_ajx + .select2-container ").hide();
            $("#slcProducto_ajx").select2('data', null);
        } else{
            $("#slcProductos").html('<option value=""></option>');
            $("#slcProductos").select2('destroy');
            $("#slcProductos").hide();

            $("#slcProducto_ajx").val('');
            $("#slcProducto_ajx").select2('data', null);
            $("#slcProducto_ajx + .select2-container").show();
        }
    }

    function bloquear_select_ajax(){
        categoria_tip = typeof $("select[class='dinamic']").last().val() !== 'undefined' ?  $("select[class='dinamic']").last().val() : '';
        var tipoReq = $("#slcTipo").val();

        if (tipoReq > 0) {
            if(tipoReq == 3){
                // $("#div_mNuevoProducto").hide();
                // $("#div-categorias").show();
                // $('#slcProductos option:selected').removeAttr('selected');
                // $('#slcProductos').select2({placeholder: 'Seleccione una opción'});
                $("#slcProductos").html('<option value=""></option>');
                $("#slcProductos").select2('destroy');
                $("#slcProductos").hide();

                // $("#slcProducto_ajx").select2('disable');
                // $("#slcProducto_ajx + .select2-container ").hide();
                // $("#slcProducto_ajx").select2('data', null);
                $("#div_mNuevoProducto").show();
                $("#slcProducto_ajx").val('');
                $("#slcProducto_ajx").select2('data', null);
                $("#slcProducto_ajx + .select2-container").show();
                $("#slcProducto_ajx").select2('enable');
            } else{
                $("#div-categorias").hide();
                $("#div_mNuevoProducto").show();
                if($.trim(categoria_tip) != ''){

                    $('#slcProductos option:selected').removeAttr('selected');
                    $('#slcProductos').select2({placeholder: 'Seleccione una opción'});
                    $("#slcProducto_ajx").select2('disable');
                    $("#slcProducto_ajx + .select2-container ").hide();
                    $("#slcProducto_ajx").select2('data', null);
                } else{
                    $("#slcProductos").html('<option value=""></option>');
                    $("#slcProductos").select2('destroy');
                    $("#slcProductos").hide();

                    $("#slcProducto_ajx").val('');
                    $("#slcProducto_ajx").select2('data', null);
                    $("#slcProducto_ajx + .select2-container").show();
                    $("#slcProducto_ajx").select2('enable');
                }
            }
        } else {
            if($.trim(categoria_tip) != ''){
                $('#slcProductos option:selected').removeAttr('selected');
                $('#slcProductos').select2({placeholder: 'Seleccione una opción'});
                $("#slcProducto_ajx").select2('disable');
                $("#slcProducto_ajx + .select2-container ").hide();
                $("#slcProducto_ajx").select2('data', null);
            } else{
                $("#slcProductos").html('<option value=""></option>');
                $("#slcProductos").select2('destroy');
                $("#slcProductos").hide();

                $("#slcProducto_ajx").val('');
                $("#slcProducto_ajx").select2('data', null);
                $("#slcProducto_ajx + .select2-container").show();
                $("#slcProducto_ajx").select2('disable');
            }
        }
    }




    $("#slcProducto_ajx").live("change", function (e) {
        var tipoProd = $("#slcTipo").val();
        product = $(this).val();
        cliente = ($('#slcCliente').val() > 0) ? $('#slcCliente').val() : 0 ;
        $("#productos_cantidad").hide();
        $("#productos_null").hide();
        var tipoReq = $("#slcTipo").val();        
        if (tipoReq == 1 || tipoReq == 4) {
            $("#slcMedidas").html('<option></option>');
            $("#slcMedidas").select2({placeholder: 'Seleccione una opción'});
            //Se obtienen los detalles del producto
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {producto: product, cliente: cliente, servicio: tipoProd},
                url: urlj + 'modulo_compras/procesos/get_detalles_producto',
                success: function (data) {
                    $("#slcMedidas").html(data.medidas);
                    $("#slcMedidas option[value='0']").text('');
                    $("#slcMedidas option[value='0']").val('');
                    $("#slcMedidas").select2({placeholder: 'Seleccione una opción'});

                    $("#slcBodega").html(data.bodegas);
                    $("#slcBodega option[value='0']").text('');
                    $("#slcBodega option[value='0']").val('');
                    if ($("#actual_slctd").val() != "" && $("#reset_bod").val() == 'super') {
                        $("#slcBodega").val($("#actual_slctd").val());
                    }
                    $("#slcBodega").select2({placeholder: 'Seleccione una opción'});
                    $("#hdnInventariable").val(data.inventariable);

                    $("#slcSector").html(data.sectores);
                    $("#slcSector option[value='0']").text('');
                    $("#slcSector option[value='0']").val('');
                    $("#slcSector").select2({placeholder: 'Seleccione una opción'});

                }
            });
        } else if (tipoReq == 2) {
            $("#slcMedidas").html('<option></option>');
            $("#slcMedidas").select2({placeholder: 'Seleccione una opción'});
            $("#txtCantidad").val(1);

            //Se obtienen los detalles del producto
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {producto: product, cliente: cliente, servicio: tipoProd},
                url: urlj + 'modulo_compras/procesos/get_detalles_producto',
                success: function (data) {
                    $("#slcBodega").html(data.bodegas);
                    $("#slcBodega option[value='0']").text('');
                    $("#slcBodega option[value='0']").val('');
                    $("#slcBodega").select2({placeholder: 'Seleccione una opción'});

                    $("#slcSector").html(data.sectores);
                    $("#slcSector option[value='0']").text('');
                    $("#slcSector option[value='0']").val('');
                    $("#slcSector").select2({placeholder: 'Seleccione una opción'});

                    $("#slcMedidas").html(data.medidas);
                    $("#slcMedidas option[value='0']").text('');
                    $("#slcMedidas option[value='0']").val('');
                    $("#slcMedidas").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else if (tipoReq == 3) {

            //Se obtienen los detalles del producto
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {producto: product, cliente: cliente, servicio: tipoProd},
                url: urlj + 'modulo_compras/procesos/get_detalles_producto',
                success: function (data) {
                    console.log(data);
                    $("#slcMedidas").html(data.medidas);
                    $("#slcMedidas option[value='0']").text('');
                    $("#slcMedidas option[value='0']").val('');
                    $("#slcMedidas").select2({placeholder: 'Seleccione una opción'});

                }
            });
        }
        setTimeout(function() {verificar_ultima_entrada();}, 3000);        
        if ($("#tpv_compra_dfct").val() > 0) {
            $('#slcTipoVenta').val($("#tpv_compra_dfct").val()).trigger('change');
        }
    });
    limpiar_select_producto();

    //Modal del detalle de impuestos
    $(".impuestosModal").fancybox({
        width: '75%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {

            var html = '';

            $("#tbProductos tr").each(function () {
                var id_parent   = $(this).data('id');

                if (id_parent != undefined) {
                    var productoCod   = $("#dato_prod_cod_" + id_parent).text();
                    var producto      = $("#dato_prod_nom_" + id_parent).text();
                    var htmlImpuestos = $("#lnkImpuestos_" + id_parent).data('html');

                    var cantidad = $("#txtCantidad_" + id_parent).val().replace(/,/g, "");
                    var precio   = $("#txtPrecioUnitario_" + id_parent).val().replace(/,/g, "");

                    var subTotal = precio * cantidad;

                    $("#slcMultiCargos").html(htmlImpuestos);
                    var rowspan = $("#slcMultiCargos option:selected").length;

                    html += '<tr>';
                    html += '<td style="text-align:center;">';
                    html += producto;
                    html += '</td>';

                    html += '<td style="padding: 0px;">';
                    html += '<table class="responsive table table-bordered" style="margin: 0px;">';
                    html += '<thead><tr><th style="width:50%;">Impuesto</th><th style="width:50%;">Monto</th></tr></thead>';
                    html += '<tbody>';
                    $("#slcMultiCargos option:selected").each(function () {

                        var nombreImpuesto = $(this).text();
                        var porcentajeImpuesto = $(this).data('porcentaje');

                        var montoImpuesto = subTotal * (porcentajeImpuesto / 100);

                        html += '<tr>';
                        html += '<td>' + nombreImpuesto + '</td>';
                        html += '<td>' + number_format(montoImpuesto,$decimal_global,".","") + '</td>';
                        html += '</tr>';

                    });
                    html += '</tbody>';
                    html += '</table>';
                    html += '</td>';
                    html += '</tr>';
                }
            });

            $("#tbImpuestos").html(html);
            $("#slcMultiCargos").html('');
        },
        beforeClose: function () {
            $("#tbImpuestos").html('');
        }
    });

    // Agregar nuevo producto desde Orden de Compra
    $("body").on("click", ".mNuevoProducto", function() {
        event.preventDefault();
        var mNuevoProducto = $(this);
        var Invalida = 0;
        //Se obtienen los detalles del producto
        $.ajax({
            dataType: 'json',
            type: 'post',
            url: urlj + 'modulo_compras/procesos/get_permisos_padre_prod',
            async: false,
            success: function (data) {
                if (data.permiso == 1) {
                    Invalida = 1;
                }
            }
        });

        if (Invalida === 1) {
            var url = mNuevoProducto.attr('href');
            $.fancybox({
                'href': url,
                type: 'iframe',
                width:'100%',
                closeBtn: true,
                height: '100%'
            });
        } else {
            crear_alerta('error', 'Permiso', 'Debe tener permiso de Agregar Nuevo Producto');
        }

    });

    $( "#txtCantidad" ).keyup(function() {
        if ( $("#txtDescuento").val() != "" ) {
            descuento( $("#txtCantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),1);
        } else if ( $("#txtDescuento_monetario").val() != "" ) {
            descuento( $("#txtCantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),2);
        }
    });
    
    $( "#txtPrecio" ).keyup(function() {
        if ( $("#txtDescuento").val() != "" ) {
            descuento( $("#txtCantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),1);
        } else if ( $("#txtDescuento_monetario").val() != "" ) {
            descuento( $("#txtCantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),2);
        }
    });

    $( "#txtDescuento" ).keyup(function() {
        descuento( $("#txtCantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),1);
    });

    $( "#txtDescuento_monetario" ).keyup(function() {
        descuento( $("#txtCantidad").val(), $("#txtPrecio").val(), $("#txtDescuento"), $("#txtDescuento_monetario"),2);
    });

    $("#txtDescuentoGeneral").change(function() {
    if ($("#txtSumaGeneral").val() != "") {
        let total_aplicable = 0;
        $(".detalle_doc_proveedor").each(function () {
            let $row = $(this);
            let prod_id = $row.data("prod");

            if (typeof omitir_descuento_id_producto === 'undefined' || omitir_descuento_id_producto.indexOf(prod_id) === -1) {
                let precio = parseFloat($row.find('.preciosUnidades').val().replace(/,/g, '')) || 0;
                let cantidad = parseFloat($row.find('.cantidadProducto').val().replace(/,/g, '')) || 0;
                total_aplicable += (precio * cantidad);
            }
        });

        if (parseFloat($(this).val()) >= total_aplicable) {
            crear_alerta('error', 'Descuento', 'Descuento no puede ser mayor al subtotal aplicable.');
            $(this).val("");  
            $("#descuento_total").val("");
        } else {
            descuento(1, total_aplicable, $("#descuento_total"), $("#txtDescuentoGeneral"), 2);
        }
    }

    $("#descuento_total").trigger("change");
});



    function descuento( cantidad, precio, porcentaje, valor , tipo) {
        //tipo 1 = obtener el valor des un porcentaje;
        //tipo 2 = obtener el porcentaje de un valor;
        if ( cantidad != "" || precio != ""){

            let precio_limpio;
            try {
                precio_limpio = parseFloat(precio.replace(',', ''));
                if (isNaN(precio_limpio)) throw "NaN";
            } catch (e) {
                precio_limpio = parseFloat(precio);
            }
            var sub_total = parseFloat(cantidad) * precio_limpio;


            // var sub_total = parseFloat( cantidad ) * parseFloat( precio.replace(',', '') ) ;
            if ( tipo == 1) {
                if ( porcentaje.val() != "") {
                    var new_calculo = ( parseFloat(sub_total) * parseFloat(porcentaje.val()) )/100 ;
                    if ( parseFloat(porcentaje.val()) >= 100 ) {
                        crear_alerta("error","Descuento","Descuento debe ser menor al 100%.");
                        porcentaje.val("");
                        valor.val("");
                    } else {
                        valor.val( number_format( new_calculo, $("#hdnDecimal").val() ) );
                    }
                } else {
                    valor.val("");
                }
            } else {
                if ( valor.val() != "") {
                    // alert(parseFloat(valor.val()));
                    var new_calculo = ( parseFloat(valor.val()) ) * 100 /parseFloat(sub_total);
                    if (parseFloat(new_calculo) >= 100 ) {
                        crear_alerta("error","Descuento","Descuento debe ser menor al 100%.");
                        porcentaje.val("");
                        valor.val("");
                    } else {
                        porcentaje.val( number_format( new_calculo, $("#hdnDecimal").val(),".","" ) );
                    }
                } else {
                    porcentaje.val("");
                }
            }
        } 
    }

    $("#slcProyecto").change(function (){
        var proyecto = $(this).val();
        if ( $("#datagried tbody tr").length > 0 ) {
            var mensaje = 'Al cambiar el proyecto seleccionado, se quitarán los productos agregados/servicios agregados, ¿desea continuar?';
            var titulo = 'Confirmar cambiar detalle';
            alerta_confirm_ajax(consulta_proyecto, proyecto, titulo, mensaje,  cancelar_consulta_proyecto, global_proyecto);
            return false;
        }
        consulta_proyecto(proyecto);
    });

    $("#slc_presupuesto").change(function (){
        var presupuesto = $(this).val();
        if ( $("#datagried tbody tr").length > 0 ) {
            var mensaje = 'Al cambiar el presupuesto seleccionado, se quitarán los productos agregados/servicios agregados, ¿desea continuar?';
            var titulo = 'Confirmar cambiar detalle';
            alerta_confirm_ajax(consulta_presupuesto, presupuesto, titulo, mensaje,  cancelar_consulta_presupuesto, global_presupuesto);
            return false;
        }
        consulta_presupuesto(presupuesto);
    });

    $("#slc_actividad_general").change(function (){
        var general     = $(this).val();
        if ( $("#datagried tbody tr").length > 0 ) {
            var mensaje = 'Al cambiar el actividad general seleccionado, se quitarán los productos agregados/servicios agregados, ¿desea continuar?';
            var titulo = 'Confirmar cambiar detalle';
            alerta_confirm_ajax(consulta_general, general, titulo, mensaje,  cancelar_consulta_general, global_general);
            return false;
        }
        consulta_general(general);
    });

    $("#slc_actividad_espeficifica").change(function (){
        var especifica = $("#slc_actividad_espeficifica option:selected").data("nombre");
        $("#txt_nombre_actividad").val(especifica);
    });

    $('#slcTipoDocumento').change(function(){ 
        var abreviacion = $("#slcTipoDocumento option:selected").data("abreviatura");
        $("#txt_abreviacion").val(abreviacion);
        if ($("#suj_exc_elect").val() == 1 && $("#es_fact_elect").val() == 1 && $("#slcTipoDocumento").val() == $("#idtif_suj_exc").val()) {
            get_num_sef_sujexc();
        } else {
            $("#txtNumDoc").val("");
            $("#txtSerieDoc").val("");
            $("#txtSerieDoc, #txtNumDoc").removeAttr("readonly");
        }
        validar_num_dpv();
    });

}); //fin document

function reestablecerAnexo() {
    $('#txtTituloAnexoDoc').val('');
    $("#txtTituloAnexoDoc").attr('readonly', 'readonly');
    $("#txtTituloAnexoDoc").removeAttr('style');
    $("#del_anexo").attr('href', '#');
    $("#link_anexo").attr('href', '#');
    $("#ruta_temporal").val('');
    $("#titulo_temporal").val('');
    $("#link_anexo, #del_anexo ").hide('slow');
    $("#btnAnexoDoc").show('slow');
}

function cargar_categorias(tipoOrden, edicion) {
    var usa_sectores = $("#param_sectores").val();
    $("#div-categorias").html('');
    $("#slcProductos").html('');
    $("#slcProductos").select2('destroy').select2();
    if (edicion == '') {
        $("#datagried tbody").html('');
    }

    if (tipoOrden) {
        tipoOrden = parseInt(tipoOrden);
        switch (tipoOrden) {
            case 1:
                $("#dvBodegas").show();
                $("#thSector").show();
                $("#slcMedidas").html('<option></option>');
                $("#slcMedidas").select2();
                $("#dvImpuestos").show();
                $("#lbl_producto").text("Producto:");
                if (usa_sectores > 0) {
                    $("#dvSectores").show();
                } else {
                    $("#dvSectores").hide();    
                }
                break;
            case 2:
                $("#dvBodegas").hide();
                $("#dvSectores").hide();
                $("#slcMedidas").html('<option></option>');
                $("#slcMedidas").select2();
                // $("#thSector").hide();
                $("#lbl_producto").text("Producto:");
                break;
            case 3:
                $("#dvBodegas").hide();
                $("#dvSectores").hide();
                $("#slcMedidas").html('<option></option>');
                $("#slcMedidas").select2();
                // $("#slcMedidas").select2('destroy');
                // $("#thSector").hide();
                $("#lbl_producto").text("Activo Fijo:");
                break;
            case 4:
                $("#slcMedidas").html('<option></option>');
                $("#slcMedidas").select2();
                $("#dvBodegas").show();
                $("#thSector").show();
                $("#lbl_producto").text("Producto:");
                if (usa_sectores > 0) {
                    $("#dvSectores").show();
                } else {
                    $("#dvSectores").hide();    
                }
                break;
        }

        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'modulo_compras/procesos/get_categorias_productos',
            data: {tipo: tipoOrden},
            success: function (data) {
                //$("#departamento").html(data.drop);

                $("#div-categorias").html(
                        '<div class="span7" style="margin-bottom:10px;">'
                        + '<div class="row-fluid">'
                        + '<label class="form-label span3">Categoría:</label>'
                        + '<div class="span6 controls">'
                        + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                        + '</div></div></div>');
                $(".dinamic").html(data.categoria);
                $('.dinamic option[value="0"]').text('');
                $('.dinamic option[value="0"]').val('');
                $('.dinamic').select2({placeholder: "Seleccione una opción"});
                producto = data.producto;
                $("#slcProductos").html(producto);
                $('#slcProductos option[value="0"]').text('');
                $('#slcProductos option[value="0"]').val('');
                if(tipoOrden == 3){
                    $("#div-categorias").hide();
                }
                //$("#slcProductos").select2('destroy').select2({placeholder: "Seleccione una opción"});
            }
        });
    }
}

function calcularGastosMultiSelect(idElemento, nombreAtributo, subTotalString, cantidad) {
    cantidad = typeof cantidad !== 'undefined' ?  cantidad : null;
    var total = 0;
    var subTotal = subTotalString.toString().replace("$", '');
    $("#" + idElemento + " option:selected").each(function () {
        var porcentaje = $(this).attr(nombreAtributo);
        if(cantidad != null){
            var tipo = $(this).attr('data-type');            
            if(tipo != 0){
                porcentaje = parseFloat(parseFloat(porcentaje) / 100);
                total = parseFloat(total) + (porcentaje * parseFloat(subTotal));
            } else{
                porcentaje = parseFloat(parseFloat(porcentaje) * cantidad );
                total = parseFloat(total) + (porcentaje);
            }
        } else{
            porcentaje = parseFloat(parseFloat(porcentaje) / 100);
            total = parseFloat(total) + (porcentaje * parseFloat(subTotal));
        }
        
    });
    return number_format(total, $("#hdnDecimal").val(), '.','');
}

// function calcularTotalFila(idFila) {
//     var cantidad = parseFloat($("#" + idFila).find('.cantidadProducto').val().replace(/,/g, ""));
//     var precio = parseFloat($("#" + idFila).find('.preciosUnidades').val().replace(/,/g, ""));
//     var descuentos = parseFloat($("#" + idFila).find('.porcentaje').val());
//     descuentos = (descuentos > 0) ? descuentos : 0;
//     var subTotal = cantidad * (precio - ((descuentos/100) * precio));
//     $("#" + idFila).find('.subtotalProductos').val(number_format(subTotal, $("#hdnDecimal").val(), '.',''));
//     calcularMontosMultiSelect(idFila);

//     var impuestos = parseFloat($("#" + idFila).find('.impuestosProducto').val().replace(/,/g, ""));
//     var retenciones = parseFloat($("#" + idFila).find('.retencionesProducto').val().replace(/,/g, ""));
//     var total = (subTotal - retenciones) + impuestos;
//     //var montoDescuento = (descuentos / 100) * subTotal;
//     $("#" + idFila).find('.totalProductos').val(number_format(total, $("#hdnDecimal").val(), '.',''));
//     var producto = $("#" + idFila).find('[name="productos[]"]').val();

//     calcularProrrateos(producto, total);
// }

function calcularTotalFila(idFila) {
    var $row = $("#" + idFila);

    var cantidad = parseFloat($row.find('.cantidadProducto').val()?.replace(/,/g, "")) || 0;
    var precio = parseFloat($row.find('.preciosUnidades').val()?.replace(/,/g, "")) || 0;

    var desc_mon = parseFloat($row.find('.desc_mon').val()?.replace(/,/g, "")) || 0;
    var desc_pct = parseFloat($row.find('.porcentaje').val()?.replace(/,/g, "")) || 0;

    // Si desc_mon es mayor que 0, usarlo directamente, de lo contrario calcular con porcentaje
    var subTotal;
    if (desc_mon > 0) {
        subTotal = (precio * cantidad) - desc_mon;
    } else {
        let monto_descuento = (precio * (desc_pct / 100));
        subTotal = (precio - monto_descuento) * cantidad;
    }

    $row.find('.subtotalProductos').val(number_format(subTotal, $("#hdnDecimal").val(), '.', ''));

    calcularMontosMultiSelect(idFila);

    var impuestos = parseFloat($row.find('.impuestosProducto').val()?.replace(/,/g, "")) || 0;
    var retenciones = parseFloat($row.find('.retencionesProducto').val()?.replace(/,/g, "")) || 0;

    var total = (subTotal - retenciones) + impuestos;
    $row.find('.totalProductos').val(number_format(total, $("#hdnDecimal").val(), '.', ''));

    var producto = $row.find('[name="productos[]"]').val();
    calcularProrrateos(producto, total);
}



function calcularTotales() {
    if ($("#tbProductos").length === 0) return;

    let totalSuma = 0.00;
    let totalDescuentos = 0.00;
    let totalImpuestos = 0.00;
    let totalSubtotal = 0.00;
    let totalRetenciones = 0.00;
    let totalGeneral = 0.00;

    // Lista de IDs a los que NO se aplica descuento
    if (typeof omitir_descuento_id_producto === 'undefined' || $.trim(omitir_descuento_id_producto) == "") {
        omitir_descuento_id_producto = [];
    }

    $("#tbProductos > tr").each(function () {
        let $row = $(this);
        let cantidad = parseFloat($row.find('.cantidadProducto').val().replace(/,/g, "")) || 0;
        let precio = parseFloat($row.find('.preciosUnidades').val().replace(/,/g, "")) || 0;
        let impuesto = parseFloat($row.find('.impuestosProducto').val().replace(/,/g, "")) || 0;
        let retencion = parseFloat($row.find('.retencionesProducto').val().replace(/,/g, "")) || 0;

        let producto_id = parseInt($row.data("prod")) || 0;
        let aplicar_descuento = omitir_descuento_id_producto.indexOf(producto_id) === -1;

        // Si se aplica descuento, tomar el valor. Si no, forzar a 0.
        let descuento_porcentaje = aplicar_descuento ? parseFloat($row.find('.descuentosProducto').val().replace(/,/g, "")) || 0 : 0;

        // También borrar visualmente si no aplica
        if (!aplicar_descuento) {
            $row.find('.descuentosProducto').val("0.00");
            $row.find('.desc_mon').val("0.00");
        }

        let monto_descuento_unitario = (precio * descuento_porcentaje / 100);
        let subtotal_unitario = precio - monto_descuento_unitario;

        let subtotal = cantidad * subtotal_unitario;
        let descuento_total = monto_descuento_unitario * cantidad;

        // Forzar a mostrar 0.00% si el descuento resultante es 0
        if (descuento_total === 0) {
            $row.find('.descuentosProducto').val("0.00");
        }

        totalSuma += (cantidad * precio);
        totalDescuentos += descuento_total;
        totalSubtotal += subtotal;
        totalImpuestos += impuesto;
        totalRetenciones += retencion;

        // Actualiza visualmente el subtotal
        $row.find('.subtotalProductos').val(number_format(subtotal, 2, '.', ','));
    });

    totalGeneral = ((totalSuma - totalDescuentos) - totalRetenciones) + totalImpuestos;

    $("#txtSumaGeneral").val(number_format(totalSuma, 2, '.', ','));
    $("#txtDescuentoGeneral").val(number_format(totalDescuentos, 2, '.', ','));
    $("#txtSubtotalGeneral").val(number_format(totalSubtotal, 2, '.', ','));
    $("#txtImpuestosGeneral").val(number_format(totalImpuestos, 2, '.', ','));
    $("#txtRetencionGeneral").val(number_format(totalRetenciones, 2, '.', ','));
    $("#txtTotalGeneral").val(number_format(totalGeneral, 2, '.', ','));
}



function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }

        opciones += this.outerHTML;
    });

    return opciones;
}

function calcularMontosMultiSelect(idFila) {
    $("#" + idFila + " .multiSelectModal").each(function () {
        var html = $(this).data('html');
        var idInput = $(this).data('input');
        var tipo = $(this).data('tipo');
        var cantidad = parseFloat($("#" + idFila).find('.cantidadProducto').val().replace(/,/g, ""));
        var descuento = parseFloat($("#" + idFila).find('.porcentaje').val().replace(/,/g, ""));
        var subTotal = 0;
        if (tipo == 1) {
            subTotal = parseFloat($("#" + idFila).find('.subtotalProductos').val().replace(/,/g, ""));
        } else {
            p_u = parseFloat($("#" + idFila).find('.preciosUnidades').val().replace(/,/g, ""));
            subTotal = p_u * cantidad;
            if (descuento > 0) {
                desc_tot  = ((descuento/100) * subTotal);
                subTotal = subTotal - desc_tot;
            }
        }
        $("#slcMultiCargos").html(html);
        var montoSubtotal = calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subTotal,cantidad);        
        if (tipo == 2) {
            // montoSubtotal = montoSubtotal * cantidad;
        }
        $("#" + idInput).val(number_format(montoSubtotal, $("#hdnDecimal").val(), '.',''));
    });
    $("#slcMultiCargos").html('');
}

function cerrar_modal(iframe) {
    if (iframe == 1) {
        parent.jQuery.fancybox.close();
    } else {
        jQuery.fancybox.close();
    }
}

function getModalProrrateo(idColumna, idProducto){

    var slcProrrateos       = $('#slcProrrateos').html();
    var slc_centro_costos   = $('#slc_centro_costos').html();
    var slc_cuenta          = $('#slcCuenta').html();

    var html = "";
    //Inicio
    html += '<div id="modalProrrateo_' + idColumna + '" class="modalProrrateo" data-row="'+idColumna+'" style="display: none;">';

    html += '<input type="hidden" id="ccon_'+ idColumna +'" value="" >';
    html += '<input type="hidden" id="idcnt_'+ idColumna +'" value="" >';
    html += '<input type="hidden" id="seteo_prorrateo_'+ idColumna +'" value="0" >';

    html += '<div class="box">';
    html += '<div class="title"><h4><span></span></h4></div>';
    html += '<div class="content">';

    html += '<div class="form-row row-fluid">';
    //Elemento Select Padre

    html += '<div class="span10"';
    html += 'style="margin-bottom: 20px;"><div class="row-fluid"><label class="form-label span3" id="">Tabla:</label><div class="span9 controls">';
    html += '<select id="slcProrrateo_' + idColumna + '" data-prod="' + idProducto + '" data-centro="slcCentroCosto_' + idColumna + '" class="nostyle selectorProrrateo">' + slcProrrateos + '</select>';
    html += '</div></div></div>';

    html += '<div class="span2"><div class="row-fluid"><div class="span6 controls"><button type="button" class="btn btn-info btn-primary btn_cargar_tabla" data-prod="' + idProducto + '" style="float: left;height: 30px;margin-top: 5px;margin-left: -17;" value="' + idProducto + '">Cargar</button></div></div></div>';
    html += '</div>';

    //Elemento Centro costo
    html += '<div class="form-row row-fluid">';
    html += '<div class="span6"><div class="row-fluid"><label class="form-label span3" id="">Centro de Costo: </label><div class="span6 controls">';
    html += '<select id="slcCentroCosto_' + idColumna + '" data-prod="' + idProducto + '" data-sector="txtPorcentaje_' + idColumna + '" class="nostyle selectorCentroCostos">' + slc_centro_costos + '</select>';
    html += '</div></div></div>';

    //Elemento Porcentaje
    html += '<div class="span6"><div class="row-fluid"><label class="form-label span3" id="">Porcentaje</label><div class="span6 controls">';
    html += '<input type="text" id="txtPorcentaje_' + idColumna + '" data-prod="' + idProducto + '" class="text cantidadProducto soloNumeros" extras="." value=""/>';
    html += '</div></div></div>';

    //Elemento Cuenta
    html += '<div class="span6"><div class="row-fluid"><label class="form-label span3" id="">Cuenta: </label><div class="span6 controls">';
    html += '<select id="slcCuenta_' + idColumna + '" data-prod="' + idProducto + '" class="nostyle">' + slc_cuenta + '</select>';
    html += '</div></div></div>';

    html += '<div class="span2"><div class="row-fluid"><div class="span6 controls">';
    html += '<button type="button" class="btn btn-info btn-primary btnAgregarCentroCosto" data-prod="' + idProducto + '" style="float: right;height: 30px;margin-top: 5px;">Agregar</button>';
    html += '</div></div></div></div>';

    //Tabla
    html += '<div class="form-row row-fluid">';
    html += '<div class="span12" style="overflow-x: scroll;padding: 10px 0px 0px 5px;margin-bottom: 2%;">';
    html += '<div class="contenedor">';
    html += '<table class="responsive table table-bordered contenedor" id="tblProrrateo_' + idColumna + '">';
    html += '<thead><tr><td>Centro de Costo</td><td>Cuenta</td><td>Porcentaje</td><td>Total($)</td><td>Acciones</td></tr></thead>';
    html += '<tbody id="tbProrrateo_' + idColumna + '"></tbody>';
    html += '</table>';

    html += '</div></div></div>';

    //Acciones

    html += '<div class="form-actions" style="text-align: center;">';
    html += '<button type="button" class="btn btn-success btnGuardarPro" id="btnGuardarPro_' + idColumna + '" data-prod="' + idProducto + '" style="margin-right: 10px;" value="'+ idProducto +'"><span class="icon16 icomoon-icon-checkmark white"></span>Guardar</button>';
    html += '<button type="button" class="btn btn-danger  btnCancelarPro" data-id_btn="'+idColumna+'" id="btnCancelarPro_' + idColumna + '" style="margin-right: 10px;" value="'+ idProducto +'"><span class="icon16 icomoon-icon-checkmark white"></span>Cancelar</button>';
    //html += '<a onclicks="javascript:$.fancybox.close();" class="btn btn-danger btn-close" id=""><span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar</a>';
    html += '</div>';

    html += '</div>';
    html += '</div>';
    //End
    html += '</div>';

    html = html.replace(/\n/g, "");

    return html;
}

function validar_caja(caja){
    var monto = $.ajax({
            dataType: 'json',
            type: 'POST',
            async: false,
            url: urlj + 'modulo_compras/procesos/get_monto_disponible',
            data: {caja: caja},
            success: function (data) {

                    return data.monto;
            }
        }).responseText;

    return monto;
}

function calcularProrrateos(idProd, TotalProd) {

    if ($("#tbProrrateo_" + idProd).length > 0) {

        $("#tbProrrateo_" + idProd + " > tr").each(function () {
            var idTr = $(this).attr('id');
            var porcentaje = parseFloat($("#" + idTr).find('.porcentajeCentroCos').val());

            var totalFila = (porcentaje / 100) * TotalProd;

            $("#" + idTr).find('.totalCentroCos').val(number_format(totalFila, $("#hdnDecimal").val(), '.',''));
        });
    }
}

function limpiar_filtro_categorias() {
    menor = Number($(".dinamic:first").attr('id')) + 2;

    $(".dinamic").each(function (index, el) {
        if ($(el).attr('id') > menor) {
            $(el).parent('div').siblings('label').remove();
            $(el).siblings('select').remove();
            $(el).parent('div').parent('div').parent('div').remove();
            $(el).remove();
        }
    });
    $(".plus:last").remove();
    $(".dinamic:first option:selected").removeAttr('selected');
    $(".dinamic:first").next().append('<button class="btn plus">+</button>');
    $(".dinamic:first").select2({placeholder: 'Seleccione una opción'});
}

//cancelar prorrateo
$(".btnCancelarPro").live('click', function () {

    // var producto    = $(this).val();
    // var modalProrrateo = $(this).closest('.modalProrrateo');
    // var row = modalProrrateo.data('row');
    // var valor_seteo = $("#seteo_prorrateo_"+row).val();

    // if (valor_seteo == 0){
    //     $("#tbProrrateo_"+row).html("");
    // } else {
    //     $("#tbProrrateo_"+row).html(tabla_prorrateo);
    // }
    id_boton = $(this).attr('data-id_btn');
    //ejecutar el trigger en guardar
    $("#btnGuardarPro_"+id_boton).trigger('click');
    setTimeout(function() {  $.fancybox.close(); }, 100);   
});

function precargar_prorrateo(producto,tabla, row) {
    var filas_prorrateo = $("#tbProrrateo_"+row +" tr").length;
    if ( filas_prorrateo == 0) {
        var numero_fila = $("#tr_"+row).data("id");
        var bodega      = $("#hdnBodega_"+row).val();
        var total       = $("#txtSubtotal_"+row).val();
        $.ajax({
            dataType: 'text',
            type: 'POST',
            async: false,
            url: urlj + 'modulo_compras/procesos/get_tabla_prorrateo',
            data: {
                bodega: bodega,
                producto: producto,
                total: total,
                tabla: tabla,
                row: row
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#tbProrrateo_"+row).html(data);
                wait.close();
            }
        });
    } else {
        tabla_prorrateo =  $("#tbProrrateo_"+row).html();
    }
}


//cancelar prorrateo
$(".btn_cargar_tabla").live('click', function () {
    var producto    = $(this).val();
    var modalProrrateo = $(this).closest('.modalProrrateo');
    var row = modalProrrateo.data('row');
    tabla = $("#slcProrrateo_"+row).val();
    if ( tabla != ""){
        $("#tbProrrateo_"+row).html("");
        precargar_prorrateo(producto, tabla, row);
    } else {
        crear_alerta('info', 'Tabla de prorrateo', 'Seleccione una tabla de prorrateo.');
    }
});

function aplicar_fancy() {
    $(".detalle_fanc").fancybox({
        width: '35%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {

        },
        beforeClose: function () {

        }
    });
}

function calcular_impuestos_retenciones(porcentaje,tipo){
    var total = 0;
    if (typeof tipo === "undefined") {
        tipo = 1;
    }

    if(tipo != 0){
        $(".subtotalProductos").each(function(e){
            if ( $.isNumeric($(this).val()) ){
                total += (( parseFloat($(this).val()) * parseFloat(porcentaje) )/100);
            }
        });
    } else {
        $(".cantidadProducto").each(function(e){
            if ( $.isNumeric($(this).val()) ){
                total += (( parseFloat($(this).val()) * parseFloat(porcentaje) ));
            }
        });
    }
     
    return number_format(total, 2, '.', '');
}

function agregar_nuevo_calculos(id,item,impuestos_add,impuestos_del){
    var idLink = item;
    var html = $("#"+idLink).data('html');
    $("#slcMultiCargos").html(html);
    $("#slcMultiCargos").select2();
    var actuales = $("#slcMultiCargos").val();
    if (impuestos_del.length > 0 && actuales != null) {
        impuestos_del.forEach(function(x) {
            var b = actuales.indexOf(x.toString());
            if (b >= 0) {
                actuales.splice(b,1);
            }
        });
    }
    if (impuestos_add.length > 0) {
        if (actuales == null) {
            actuales = [];
        }
        impuestos_add.forEach(function(x) {
            var b = actuales.indexOf(x.toString());
            if (b < 0) {
                actuales.push(x.toString());
            }
        });
    }
    $("#slcMultiCargos").val(actuales);
    $("#slcMultiCargos").select2();

  var idSeleccionados = $("#slcMultiCargos").val();
  var idHidden = $("#" + idLink).attr('data-hidden');
  var idInput = $("#" + idLink).attr('data-input');
  var tipo = $("#" + idLink).attr('data-tipo');

  $("#" + idHidden).val(idSeleccionados);

  var opciones = "";

  $("#slcMultiCargos option").each(function () {

      if (!$(this).attr('selected')) {
          $(this).removeAttr('selected');
      } else {
          $(this).attr('selected', 'selected');
      }

      opciones += this.outerHTML;
  });

  $("#" + idLink).data('html',opciones);

  var parent = $("#" + idLink).parent().parent();
  //var descuento = parent.find('.porcentaje').val();
  var cantidad = parent.find('.cantidadProducto').val().replace(/,/g, "");
  var subtotal = 0.00;//parent.find('.subtotalProductos').val();
  if (tipo == 1) {
      var subtotal = parent.find('.subtotalProductos').val().replace(/,/g, "");
  } else if (tipo == 2) {
      var subtotal = parent.find('.preciosUnidades').val().replace(/,/g, "");
  }
  var montoSubtotal = calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subtotal, cantidad);

  if (tipo == 2) {
      montoSubtotal = montoSubtotal * cantidad;
  }

  var prueba = number_format(montoSubtotal, $("#hdnDecimal").val(), '.','');
  $("#" + $.trim(idInput)).val(prueba);


  calcularTotalFila(parent[0].id);
  //Se actualizan los totales
  calcularTotales();
  $("#slcMultiCargos").html('');
  $("#slcMultiCargos").select2();
}

function evaluar_presupuesto(actividad_especifica) {
    var monto_disponible    =  parseFloat($("#slc_actividad_espeficifica option:selected").data("monto_disponible"));
    var total_gasto         =  number_format($("#txtTotalGeneral").val(),"2",".",""); 
    var total_gasto         =  parseFloat( total_gasto ); 
    var aprobado            = true;
    
    if (total_gasto > monto_disponible && actividad_especifica != "" && $("#sobre_giro").val() == 0 ) {
        aprobado = false;
        crear_alerta('error', 'Presupuesto', 'El monto total del documento del proveedor sobrepasa el presupuesto asignado ($'+number_format(monto_disponible,"2",".",",")+')'); 
    }

    return aprobado;
}

function quitar_atributo() {
    $("#slcProyecto").removeAttr("disabled");
    $("#slc_presupuesto").removeAttr("disabled");
    $("#slc_actividad_general").removeAttr("disabled");
    $("#slc_actividad_espeficifica").removeAttr("disabled");
}

function verificar_ultima_entrada() {
    precio_lista    = ($("#txtPrecio").val() >0)? $("#txtPrecio").val():0;
    id_articulo     = ($("#slcProductos").val() > 0) ? $("#slcProductos").val() : $("#slcProducto_ajx").val();
    unidad_medida   = $("#slcMedidas").val();
    tipo_doc_suj_ex = $("#idtif_suj_exc").val();
    this_tipo_doc   = $("#slcTipoDocumento").val();
    console.log( this_tipo_doc == tipo_doc_suj_ex);


    if (unidad_medida > 0  && id_articulo > 0)
    {
        url_ajax = window.satelite.base_url('facturacion/entradas/get_valor_ultima_entrada');
        $.ajax({
            url: url_ajax,
            type: 'POST',
            dataType: 'json',
            data: {
                precio_lista: precio_lista,
                id_articulo: id_articulo,
                unidad_medida: 0,
                id_cva: unidad_medida
            },
            error: function (xhr, status, error){
                exportarError(xhr.responseText);
            },
            success: function (json) {
                crear_alerta('info',('ULTIMA COMPRA: <h3>$'+ round_number(json.ultima_compra,2)+'</h3>'),'');
                
            }
        });
    }
}

function consulta_proyecto(proyecto,){
    $("#datagried tbody").html('');
    calcularTotales();

    global_proyecto = proyecto;
    if ( proyecto != "" ) {
        $.ajax({
            dataType: 'text',
            type: 'post',
            data: {proyecto: proyecto},
            url: urlj + 'modulo_compras/procesos/get_presupuestoxproyecto',
            success: function (data) {
                $("#slc_presupuesto").html("");
                $("#slc_presupuesto").html(data);
                $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
            }
        });
    } else {
        $("#slc_presupuesto").html('<option value=""></option>');
        $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});

        $("#slc_presupuesto").html('<option value=""></option>');
        $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});

        $("#slc_actividad_general").html('<option value=""></option>');
        $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});

        $("#slc_actividad_espeficifica").html('<option value=""></option>');
        $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
    }
    $("#disponible_compras").val("");
}

function cancelar_consulta_proyecto(global_proyecto){
    $('#slcProyecto').val(global_proyecto);
    $('#slcProyecto').select2();
}

function consulta_presupuesto(presupuesto){ 
    $("#datagried tbody").html('');
    calcularTotales();

    global_presupuesto = presupuesto;

    if ( presupuesto != "" ) {
        $.ajax({
            dataType: 'text',
            type: 'post',
            data: {presupuesto: presupuesto},
            url: urlj + 'modulo_compras/procesos/get_actividades_generalesxpresupusto',
            success: function (data) {
                $("#slc_actividad_general").html("");
                $("#slc_actividad_general").html(data);
                $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
            }
        });
    } else {
        $("#slc_actividad_general").html('<option value=""></option>');
        $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});

        $("#slc_actividad_espeficifica").html('<option value=""></option>');
        $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
    }
    $("#disponible_compras").val("");
}

function cancelar_consulta_presupuesto(presupuesto){
    $('#slc_presupuesto').val(presupuesto);
    $('#slc_presupuesto').select2();
}

function consulta_general(general){  
    $("#datagried tbody").html('');
    calcularTotales();

    if ( $("#fecha").val() == "" ) {
        var d = new Date();
        var strDate = ('0' + d.getDate()).slice(-2) + "-" + ('0' + (d.getMonth()+1))  + "-" + d.getFullYear();
        $("#fecha").val(strDate);
    }
    
    global_general  = general;
    var presupuesto = $("#slc_presupuesto").val();
    var fecha       = $("#fecha").val();
    if ( general != "" ) {
        $.ajax({
            dataType: 'text',
            type: 'post',
            data: {general: general,presupuesto:presupuesto,fecha:fecha},
            url: urlj + 'modulo_compras/procesos/get_actividades_especificas_x_actividad_general',
            success: function (data) {
                $("#slc_actividad_espeficifica").html("");
                $("#slc_actividad_espeficifica").html(data);
                $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
            }
        });
    }  else {
        $("#slc_actividad_espeficifica").html('<option value=""></option>');
        $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
    }
    $("#disponible_compras").val("");
}

function cancelar_consulta_general(general){
    $('#slc_actividad_general').val(general);
    $('#slc_actividad_general').select2();
}

function consulta_especifica(especifica){  
    $("#datagried tbody").html('');
    calcularTotales();
    
    global_especifico  = especifica;
    if ( especifica != "") {
        var mensual_disponible = $("#slc_actividad_espeficifica option:selected").data('monto_disponible_mensual');
        $("#disponible_compras").val("$"+mensual_disponible);
    } else{
        $("#disponible_compras").val("");
    }    
}

function cancelar_consulta_especifica(especifica){
    $('#slc_actividad_espeficifica').val(especifica);
    $('#slc_actividad_espeficifica').select2();
}

function borrar_grid(confirmacion) {
    if (confirmacion > 0) {
        var order_com = $('#slcOrdenCompra').val();
        if(!(order_com > 0)){
            $("#tbProductos").html('');
            calcularTotales();
        }
    }
}

function validar_num_dpv() {
    var prv  = $("#slcProveedor").val();
    var tipo = $("#slcTipoDocumento").val();
    var num  = $.trim($("#txtNumDoc").val());
    if (prv != "" && tipo != "" && num != "") {
        $.ajax({
            url: urlj + 'modulo_compras/procesos/get_documentos_proveedor',
            data: {proveedor: prv, numDocumento: num, tipo: tipo},
            type: 'POST',
            dataType: 'json',
            success: function (data) {
                if (data > 0) {
                    $("#txtNumDoc").val('');
                    $("#txtNumDoc").focus();
                    crear_alerta('error', 'Número de Documento', 'El número de documento ya ha sido ingresado.');
                }
            }
        });
    }
}

function get_num_sef_sujexc() {
    var tif = $('#slcTipoDocumento').val();
    var caj = $('#id_caj_sujexc').val();
    $.ajax({
        type: 'POST',
        dataType: 'json',
        url: urlj + 'modulo_compras/procesos/get_correlativo_suj_exc',
        data: {
            tipo: tif, 
            caja: caj
        },
        success: function (data) {
            if (data.numero > 0 && data.serie != "") {
                $("#txtNumDoc").val(data.numero);
                $("#txtSerieDoc").val(data.serie);
                $("#txtSerieDoc, #txtNumDoc").attr("readonly", true);
            } else {
                $("#txtNumDoc").val("");
                $("#txtSerieDoc").val("");
                $("#txtSerieDoc, #txtNumDoc").removeAttr("readonly");
            }
        }
    });
}