$(document).ready(function () {
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    $('select').select2({placeholder: 'Seleccione una opción'});
    $(".soloNumeros").numeric();

    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        minDate: 0
    });
    $(".txtFechas").mask('99-99-9999');
    $(".btn-close").live('click', function () {
        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    $("#slcProyecto").select2({placeholder: 'Seleccione una opción'});
    $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
    $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
    $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});

    var id_bod;
    var id_cat;
    var id_prod;
    var p_actual;

    $("#frm-orden").validate({
        ignore: [],
        rules: {
            txtFechaCotizacion: {required: true},
            slcTipo: {required: true},
            slcProveedor: {required: true},
            slcRequisicion: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#datagried tr').length <= 1) {
                crear_alerta('error', 'Productos', 'Debe seleccionar al menos un producto');
                return false;
            }
            if ( $("#slc_presupuesto").val() != "" ) {
                if ( $("#slc_actividad_espeficifica").val() == "" ) {
                    crear_alerta('error', 'Actividad específica', 'Seleccione una actividad específica');
                    return false;
                }   
            }
            var flag = 0;
            $('.p_u').each(function (index, value) {
                var actual = $(this).val();
                if (parseFloat(actual) <= 0) {
                    flag++;
                }
            });
            var aprobar_presupuesto = evaluar_presupuesto(); 
            if ( aprobar_presupuesto == false) {
                return false;
            }
            quitar_atributo();
            if (flag > 0) {
                crear_alerta('error', 'Precios', 'Debe ingresar un precio para cada artículo');
                return false;
            } else {
                form.submit();
            }
        }
    });

    $(".positive").numeric({negative: false}, function () {
        alert("No negative values");
        this.value = "";
        this.focus();
    });

    $(".positive").live("keyup", function () {
        if ($(this).val() <= 0.0) {
            campo = $(this).attr("id");
            $(this).addClass('error');
            //document.getElementById('validar_'+campo+'').innerHTML='La cantidad debe ser mayor a uno';
            $('#validar_' + campo).text('La cantidad debe ser mayor a uno');
        }
    });

    $("#documento").blur(function () {
        var doc_numero = $(this).val();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/gestion_productos/validar_documento',
            data: {id: doc_numero},
            success: function (data) {
                if (data.drop != null) {
                    crear_alerta("info", "Aviso", "Por favor elija otro número de documento.");
                    $("#documento").focus().val('');
                }
            }
        });
    });

    $("body").on("click", ".nuevo_proveedor", function () {
        event.preventDefault();
        //var mNuevoCliente = $(this);
        var permitido = 0;
        
        $.ajax({
            dataType: 'json',
            type: 'post',
            url: urlj + 'modulo_compras/procesos/get_permisos',
            async: false,
            data: { url: "modulo_compras/catalogos/proveedores" },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                if (data.permiso == 1) {
                    permitido = 1;
                }
                wait.close();
            }
        });
        if (permitido === 1) {
            var url = $(this).attr('href');
            $.fancybox({
                'href': url,
                type: 'iframe',
                width: '100%',
                closeBtn: true,
                height: '100%'
            });
        } else {
            crear_alerta('error', 'Permiso', 'Debe tener permiso de Agregar Nuevo Proveedor');
        }

    });

    $("#editar").live("click", function () {
        event.preventDefault();
        //$(this).toggleClass('guardar editar');

        id_row = $(this).attr('name');

        var nuevo_cant = 1
        do {
            nuevo_cant = prompt("Ingrese nuevo valor de cantidad(Mayor a cero)", "1");

        } while ((nuevo_cant <= 0 || String(parseFloat(nuevo_cant)) == "NaN") && (nuevo_cant != null));

        if (nuevo_cant != null) {
            document.getElementById('cantidadl' + id_row + '').innerHTML = nuevo_cant;
            $('#cantidadi' + id_row + '').val(nuevo_cant);
        }

    });//Fin de editat

    $("#remove").live("click", function () {
        $(this).parents("tr").remove();
    });//Fin de eliminar

    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    //Calculo de la URL PATH

    $("#slcBodega").change(function () {
        var bodega = $('#slcBodega').val();
        var tipoReq = $("#slcTipo").val();

        if (bodega > 0 && tipoReq > 0) {
            cargar_categorias(bodega, tipoReq);
        } else {
            $("#div-categorias").html('');
            $("#slcProductos").html('');
            $("#slcProductos").select2('destroy').select2();
            $("#datagried tbody").html('');
        }
    });

    $(document).on("focus",".p_u",function() {
        p_actual = 0;
        var valor = $(this).val();
        if (valor > 0) {
            p_actual = $(this).val();
            console.log(p_actual);
        }
        $(this).val('');
    });

    $(document).on("focusout",".p_u",function() {
        var nueva = $(this).val();
        if (nueva == '') {
            if (p_actual >= 0) {
                $(this).val(p_actual);
            } else {
                //crear_alerta('error', 'Cotización', 'Debe ingresar un valor');
                $(this).val('');
                $(this).focus();
                return false;            
            }            
        }        
    });

    $("#slcTipo").change(function () {
        //var bodega = $('#slcBodega').val();
        var tipoReq = $("#slcTipo").val();

        if (tipoReq > 0) {
            cargar_categorias(tipoReq);
        } else {
            $("#div-categorias").html('');
            $("#slcProductos").html('');
            $("#slcProductos").select2('destroy').select2();
            $("#datagried tbody").html('');
        }
    });

    $("#slcRequisicion").change(function () {
        var requisicion = $(this).val();
        $("#datagried tbody").html('');
        if (requisicion > 0) {
            wait.start();
            $("#dvContenedorProductos").hide();
            $(".btn-agregar").hide();
            $("#thAcciones").hide();
            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_detalle_requisicion',
                dataType: 'json',
                type: 'POST',
                data: {requisicion: requisicion},
                success: function (result) {
                    wait.close();                    
                    if (result != '') {
                        $("#slcTipo option[value='" + result.req.tipo + "']").attr('selected', 'selected');
                        $("#slcTipo").select2({placeholder: "Seleccione una opción"});
                        $("#slcTipo").select2('disable');
                        if (result.detalle.length > 0) {
                            var row = 0;
                            var html = '';
                            $.each(result.detalle, function (val, key) {
                                html += '<tr id="tr_' + key.prd + row + '" data-id="' + row + '">';
                                html += '<input type="hidden" name="conversion[]" id="hdnConversion_' + row + '" value="' + key.conversion + '"/>';
                                html += '<input type="hidden" name="productos[]" id="hdnProducto_' + row + '" value="' + key.prd + '"/>';
                                html += '<input type="hidden" name="impuestos[]" id="hdnImpuestos_' + row + '" value="' + key.ids_imp + '"/>';
                                html += '<input type="hidden" name="gastos[]" id="hdnGastos_' + row + '" value=""/>';
                                //html += '<label id="dato_prod_cod_' + row + '">' + key.categoria + '</label></td>';
                                html += '<td><label id="dato_prod_nom_' + row + '">' + key.producto_codigo + '-' + key.producto + '</label></td>';
                                var precio = key.precio;
                                var cantidad = key.cantidad;
                                var descuento = key.descuento;
                                var descuentoMonto = precio * (descuento / 100);
                                //var subtotalNeto = cantidad * precio;
                                var subTotal = cantidad * (precio - descuentoMonto);
                                var totalImpuestos = 0;
                                var totalGastos = 0;
                                var TotalProducto = subTotal + totalImpuestos + totalGastos;
                                var slcImpuestosHtml = key.impuestos_html;
                                var slcGastosHtml = key.gastos_html;
                                slcImpuestosHtml = slcImpuestosHtml.replace(/"/g, "'");
                                slcGastosHtml = slcGastosHtml.replace(/"/g, "'");
                                //Se formatean los montos
                                cantidad = number_format(cantidad, 2);
                                precio = number_format(precio, 2);
                                totalImpuestos = number_format(totalImpuestos, 2);
                                totalGastos = number_format(totalGastos, 2);
                                subTotal = number_format(subTotal, 2);
                                TotalProducto = number_format(TotalProducto, 2);
                                html += '<td>';
                                html += '<input type="text" class="text tables-input select-text" value="' + key.medida + '" readonly="readonly"/>';
                                //html += '<select id="slcMedidas_' + row + '" data-id="' + row + '" style="display:none;" class="select-edit">' + medidasHtml + '</select>';
                                html += '</td>';

                                html += '<td>';
                                html += '<input type="text" id="txtCantidad_' + row + '" name="cantidades[]" class="text tables-input-show tables-input cantidadProducto soloNumeros" value="' + cantidad + '" readonly="readonly"/>';
                                html += '</td>';
                                html += '<td>';
                                html += '<input type="text" id="txtPrecioUnitario_' + row + '" name="precios[]" class="text tables-input-show soloNumeros preciosUnidades registrosReq p_u" extras="." value="' + precio + '" />';
                                html += '</td>';

                                html += '<td>';
                                html += '<a href="#modalSelect" id="lnkImpuestos_' + row + '" data-tipo="1" data-input="txtImpuesto_' + row + '" data-etiqueta="Impuestos" data-html="' + slcImpuestosHtml + '" data-id="' + row + '" data-hidden="hdnImpuestos_' + row + '" class="icon-table multiSelectModal"><span class="icon16 icomoon-icon-list-view"></span></a>';
                                html += '<input type="text" id="txtImpuesto_' + row + '" name="impuestosProducto[]" class="text tables-input soloNumeros input-table impuestosProducto" extras="." value="' + totalImpuestos + '" readonly="readonly"/>';
                                html += '</td>';
                               /* html += '<td>';
                                html += '<a href="#modalSelect" id="lnkGastos_' + row + '" data-tipo="1" data-input="txtGasto_' + row + '" data-etiqueta="Gastos" data-html="' + slcGastosHtml + '" data-id="' + row + '" data-hidden="hdnGastos_' + row + '" class="icon-table multiSelectModal"><span class="icon16 icomoon-icon-list-view"></span></a>';
                                html += '<input type="text" id="txtGasto_' + row + '" name="gastosProducto[]" class="text tables-input soloNumeros input-table gastosProducto" extras="." value="' + totalGastos + '" readonly="readonly"/>';
                                html += '</td>';*/
                                html += '<td>';
                                html += '<input type="text" id="txtDescuento_' + row + '" name="descuentos[]" class="text tables-input-show soloNumeros descuentosProducto registrosReq" extras="." value="' + descuento + '" />';
                                html += '</td>';

                                html += '<td>';
                                html += '<input type="text" id="txtSubtotal_' + row + '" name="subtotalesProducto[]" class="text tables-input subtotalProductos" extras="." value="' + subTotal + '" readonly="readonly"/>';
                                html += '</td>';

                                html += '<td>';
                                html += '<input type="text" id="txtTotal_' + row + '" name="totalesProducto[]" class="text tables-input totalProductos" extras="." value="' + TotalProducto + '" readonly="readonly"/>';
                                html += '</td>';

                                html += '<td style="display:none;">';
                                html += '</td>';

                                row++;
                            });
                            $("#datagried").append(html);
                            //Se actualizan los totales
                            calcularTotales();
                        }
                    }
                }
            });
            //buscar proyecto
            wait.start();
            $.ajax({
                url: urlj+'modulo_compras/procesos/get_datos_proyectos',
                type: 'POST',
                data: {
                    tipo: 1,
                    codigo: requisicion
                },
                success:function(data) {
                    var obj = jQuery.parseJSON(data);
                    if (obj.info == true) {
                        $("#slcProyecto").html("");
                        $("#slcProyecto").html(obj.proyectos);
                        $("#slcProyecto").prop("disabled", true);
                        $("#slcProyecto").select2({placeholder: 'Seleccione una opción'});

                        $("#slc_presupuesto").html("");
                        $("#slc_presupuesto").html(obj.presupuesto);
                        $("#slc_presupuesto").prop("disabled", true);
                        $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
    
                        $("#slc_actividad_general").html("");
                        $("#slc_actividad_general").html(obj.general);
                        $("#slc_actividad_general").prop("disabled", true);
                        $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
    
                        $("#slc_actividad_espeficifica").html("");
                        $("#slc_actividad_espeficifica").html(obj.especifica);
                        $("#slc_actividad_espeficifica").prop("disabled", true);
                        $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
                    }           
                    wait.close();
                }
            });
        } else {
            $("#slcProyecto").prop("disabled", false);
            $("#slcProyecto option:selected").removeAttr('selected');
            $("#slcProyecto").select2({placeholder: 'Seleccione una opción'});

            $("#slc_presupuesto").html('<option value=""></option>');
            $("#slc_presupuesto").prop("disabled", false);
            $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});

            $("#slc_actividad_general").html('<option value=""></option>');
            $("#slc_actividad_general").prop("disabled", false);
            $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});

            $("#slc_actividad_espeficifica").html('<option value=""></option>');
            $("#slc_actividad_espeficifica").prop("disabled", false);
            $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});

            $("#slcTipo option:selected").removeAttr('selected');
            $("#slcTipo").select2({placeholder: "Seleccione una opción"});
            $("#dvContenedorProductos").show();
            $(".btn-agregar").show();
            $("#thAcciones").show();
        }
    });


    $(".registrosReq").live('keyup', function () {
        var parent = $(this).parent().parent();
        console.log($(this).closest("tr").data('id'));
        var id_parent = $("#" + parent[0].id).data('id');
        var valor = $(this).val();
        
        var cantidad = parseFloat($("#" + parent[0].id).find('.cantidadProducto').val().replace(/,/g, ""));
        var precio = parseFloat($("#" + parent[0].id).find('.preciosUnidades').val().replace(/,/g, ""));
        var descuento = ($("#" + parent[0].id).find('.descuentosProducto').val() != '') ? parseFloat($("#" + parent[0].id).find('.descuentosProducto').val().replace(/,/g, "")) : 0;
        
        var subtotalNeto = (cantidad * precio) - ((cantidad * precio) * (descuento / 100));
        
        var subtotal = number_format(parseFloat(cantidad * precio), 2);

        //Impuestos
        var htmlImpuestos = $("#lnkImpuestos_" + id_parent).attr('data-html');
        $("#slcMultiCargos").html(htmlImpuestos);
        var montoImpuestos = parseFloat(calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subtotalNeto));
        
        
        parseFloat($("#" + parent[0].id).find('.impuestosProducto').val(number_format(montoImpuestos, 2)));
        $("#slcMultiCargos").html('');
        
        //Gastos
        //
        var htmlGastos = $("#lnkGastos_" + id_parent).attr('data-html');
        $("#slcMultiCargos").html(htmlGastos);
        // var montoGastos = parseFloat(calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subtotalNeto));
        // parseFloat($("#" + parent[0].id).find('.gastosProducto').val(number_format(montoGastos, 2)));
        $("#slcMultiCargos").html('');
        
        if($(this).hasClass('descuentosProducto')){
            if(valor > 100){
                crear_alerta('error', 'Cotización', 'El descuento no puede superar al 100%');
                $(this).val(100);
            }
        }
        
        calcularTotalFila(parent[0].id);
        //Se actualizan los totales
        calcularTotales();
    });

    $(".dinamic").live('change', function () {
        var tipoReq = $("#slcTipo").val();
        var proveedor = $("#slcProveedor").val();
        if (tipoReq == 1 || tipoReq == 4) {
            menor = Number($(this).attr('id')) + 2;
            bodega = 1;//$('#slcBodega').val();
            padre = $("select[class='dinamic']").last().val();
            $(".dinamic").each(function (index, el) {
                if ($(el).attr('id') > menor) {
                    $(el).parent('div').siblings('label').remove();
                    $(el).siblings('select').remove();
                    $(el).parent('div').parent('div').parent('div').parent('div').remove();
                    $(el).remove();
                }
            });
            $(".plus:last").remove();
            $(this).next().append('<button class="btn plus">+</button>');
            if (padre != "") {
                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                    data: {
                        padre: padre,
                        proveedor: proveedor
                    },
                    success: function (data) {
                        producto = data.producto;
                        impuestos = data.impuestos;
                        $("#slcProductos").html(producto);
                        $("#slcProductos option[value='0']").text('');
                        $("#slcProductos option[value='0']").val('');
                        $("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                        $("#slcMedidas").html('');
                        $("#slcMedidas").select2();
                        $("#slcImpuestos").html(impuestos);
                        $("#slcImpuestos").select2({placeholder: 'Seleccione una opción'});
                        $('.dinamic').each(function (index, el) {
                            $(this).attr('id', index);
                        });
                    }
                });
            }
        } else if (tipoReq == 2) {
            menor = Number($(this).attr('id')) + 2;
            padre = $("select[class='dinamic']").last().val();
            $(".dinamic").each(function (index, el) {
                if ($(el).attr('id') > menor) {
                    $(el).parent('div').siblings('label').remove();
                    $(el).siblings('select').remove();
                    $(el).parent('div').parent('div').parent('div').parent('div').remove();
                    $(el).remove();

                }
            });
            $(".plus:last").remove();
            $(this).next().append('<button class="btn plus">+</button>');
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {
                    padre: padre,
                    proveedor: proveedor, 
                    servicio: 1
                },
                success: function (data) {
                    servicios = data.producto;
                    impuestos = data.impuestos;
                    $("#slcProductos").html(servicios);
                    $("#slcProductos option[value='0']").text('');
                    $("#slcProductos option[value='0']").val('');
                    $("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                    $("#slcImpuestos").html(impuestos);
                    $("#slcImpuestos").select2();
                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });
                }
            });

        } else if (tipoReq == 3) {

            var categoria = $(this).val();
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_activos_tipo',
                data: {tipo_activo: categoria},
                success: function (data) {
                    producto = data.activos;
                    $("#slcProductos").html(producto);
                    $("#slcProductos option[value='0']").text('');
                    $("#slcProductos option[value='0']").val('');
                    $("#slcProductos").select2('destroy').select2({placeholder: 'Seleccione una opción'});
                }
            });

            $.ajax({
                dataType: 'json',
                type: 'post',
                //data: {producto: product},
                url: urlj + 'modulo_compras/procesos/get_impuestos',
                success: function (data) {
                    $("#dvImpuestos").show();
                    $("#slcImpuestos").html(data.impuestos);
                    $("#slcImpuestos").select2();
                }
            });

        }
    });

    $(".plus").live('click', function (event) {
        var tipoReq = $("#slcTipo").val();
        event.preventDefault();
        bodega = 1;//$('#slcBodega').val();
        padre = $("select[class*='dinamic']").last().val();

        if (tipoReq == 1) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {padre: padre},
                success: function (data) {
                    categoria = data.drop;
                    producto = data.producto;
                    $i = 0;
                    $(".plus").last().remove();
                    if (categoria.length > 0) {
                        numero = $('#div-categorias select').last().length + 1;
                        //<div class="form-row row-fluid"></div>
                        linea = $("#div-categorias").append(''
                                + '<div class="span7" style="margin-bottom: 10px;">'
                                + '<div class="row-fluid">'
                                + '<label class="form-label span3">Categoría:</label>'
                                + '<div class="span6 controls">'
                                + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                                + '</div></div></div>');
                        linea2 = $('select[class="dinamic"]').last().html();
                        nueva = linea2.replace(/#/g, numero);
                        $('#div-categorias').append(nueva);
                        $('select[class="dinamic"]').last().html(categoria);
                        $('select[class="dinamic"] option[value="0"]').last().text('');
                        $('select[class="dinamic"] option[value="0"]').last().val('');
                        //$('select[class="dinamic"]').last().html(categoria);
                        $('select[class="dinamic"]').last().select2({placeholder: "Seleccione una opción"});
                        $("#slcProductos").html(producto);
                        $("#slcMedidas").html('');
                        $("#slcMedidas").select2();
                    } else {
                        $("#slcProductos").html(producto);
                        $("#slcMedidas").html('');
                        $("#slcMedidas").select2();
                        $.pnotify({
                            type: 'info',
                            title: 'Aviso',
                            text: 'No se encontraron mas dependencias.',
                            icon: 'ui-icon ui-icon-info',
                            opacity: 0.95,
                            history: false,
                            sticker: false
                        });
                    }

                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });


                }
            });
        } else if (tipoReq == 2) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'modulo_compras/procesos/get_dependencias_categoria',
                data: {padre: padre, servicios: 1},
                success: function (data) {
                    categoria = data.drop;
                    servicios = data.servicios;
                    $i = 0;
                    $(".plus").last().remove();
                    if (categoria.length > 0) {
                        numero = $('#div-categorias select').last().length + 1;
                        linea = $("#div-categorias").append(''
                                + '<div class="span7">'
                                + '<div class="row-fluid">'
                                + '<label class="form-label span3">Categoría:</label>'
                                + '<div class="span6 controls">'
                                + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                                + '</div></div></div>');
                        linea2 = $('select[class="dinamic"]').last().html();
                        nueva = linea2.replace(/#/g, numero);
                        $('#div-categorias').append(nueva);
                        $('select[class="dinamic"]').last().html(categoria);
                        $('select[class="dinamic"] option[value="0"]').last().text('');
                        $('select[class="dinamic"] option[value="0"]').last().val('');
                        $('select[class="dinamic"]').last().select2({placeholder: "Seleccione una opción"});
                        $("#slcProductos").html(servicios);
                    } else {
                        $("#slcProductos").html(servicios);
                        $.pnotify({
                            type: 'info',
                            title: 'Aviso',
                            text: 'No se encontraron mas dependencias.',
                            icon: 'ui-icon ui-icon-info',
                            opacity: 0.95,
                            history: false,
                            sticker: false
                        });
                    }

                    $('.dinamic').each(function (index, el) {
                        $(this).attr('id', index);
                    });
                }
            });
        }
    });

    $("#slcProductos").change(function () {
        $("#productos_cantidad").hide();
        $("#productos_null").hide();
        var tipoReq = $("#slcTipo").val();
        product = $('#slcProductos').val();
        if (tipoReq == 1) {
            $("#slcMedidas").html('');
            $("#slcMedidas").select2();
            $("#dvCantidades").show();

            //Se obtienen los detalles del producto
            $.ajax({
                dataType: 'json',
                type: 'post',
                data: {producto: product},
                url: urlj + 'modulo_compras/procesos/get_detalles_producto',
                success: function (data) {
                    $("#dvMedidas").show();
                    $("#slcMedidas").html(data.medidas);
                    $("#slcMedidas option[value='0']").text('');
                    $("#slcMedidas option[value='0']").val('');
                    $("#slcMedidas").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else if (tipoReq == 2) {
            $("#slcMedidas").html('');
            $("#slcMedidas").select2('destroy');
            $("#dvMedidas").hide();
            $("#dvCantidades").hide();
            $("#cantidad").val(1);

        } else if (tipoReq == 3) {
            $("#slcMedidas").html('');
            $("#slcMedidas").select2('destroy');
            $("#dvMedidas").hide();
            $("#dvCantidades").hide();
            $("#cantidad").val(1);
        }
    });

    $("#categoria").change(function () {
        $("#categoria option:selected").each(function () {
            bodega = $('#bodega').val();
            categoria = $('#categoria').val();

            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/gestion_productos/get_productos_xcat',
                data: {bodega_sel: bodega, categoria_sel: categoria},
                success: function (data) {
                    $("#slcProductos").html(data.drop);
                }
            });

            $('#slcProductos')
                    .find('option')
                    .remove()
                    .end()
                    .append('<option>Seleccione una opción</option>')
                    ;

            $("#slcProductos").select2('destroy').select2();

            $('#cantidad').val('');

        });
    }); //end of function categoria

    var row = 0;
    if ($('#datagried tr').length > 0) {
        row = $("#datagried tr").length;
    }
    $("#agregar").click(function () {
        $("#cabezera").show();

        var tipoReq = $("#slcTipo").val();
        var categoria = $('select[class="dinamic"]').last().val();
        var categoria_nombre = $('select[class="dinamic"] option:selected').last().text();
        var cantidad = $('#cantidad').val();
        var producto = $('#slcProductos').val();
        var precio = $("#txtPrecio").val();
        var descuento = ($("#txtDescuento").val() != '') ? $("#txtDescuento").val() : 0.00;
        var impuestos = ($("#slcImpuestos").val() != '' && $("#slcImpuestos").val() != null) ? $("#slcImpuestos").val() : '';
        var gastos = ($("#slcGastos").val() != '' && $("#slcGastos").val() != null) ? $("#slcGastos").val() : '';
        var medidas = $('#slcMedidas').val();
        var medidasHtml = "";
        var codigoProducto = $('#slcProductos option:selected').data('codigo');
        var nombreArticulo = $('#slcProductos option:selected').data('nombre');
        var nombreMedida = "";

        //Se realizan las validaciones en base al tipo de Orden
        if (tipoReq == 1) {
            if (cantidad == '' || !parseInt(medidas) || !parseInt(producto) || precio == '') {
                crear_alerta('info', 'Productos', 'Debe especificar las características del producto');
                return false;
            } else if (descuento > 100) {
                crear_alerta('info', 'Productos', 'El porcentaje del descuento no puede superar al 100%');
                return false;
            }
            medidasHtml = $("#slcMedidas").html();
            nombreMedida = $("#slcMedidas option:selected").text();
        } else if (tipoReq == 2) {
            if (cantidad == '' || !parseInt(producto) || precio == '') {
                crear_alerta('info', 'Servicio', 'Debe especificar las características del servicio');
                return false;
            } else if (descuento > 100) {
                crear_alerta('info', 'Productos', 'El porcentaje del descuento no puede superar al 100%');
                return false;
            }
        } else if (tipoReq == 3) {
            if (cantidad == '' || !parseInt(producto) || precio == '') {
                crear_alerta('info', 'Activo Fijo', 'Debe especificar las características del activo fijo');
                return false;
            } else if (descuento > 100) {
                crear_alerta('info', 'Productos', 'El porcentaje del descuento no puede superar al 100%');
                return false;
            }
        }
        if ($("#tr_" + producto).length > 0) {
            crear_alerta('error', 'Cotización', 'El producto ya fue ingresado.');
            return false;
        }
        if (precio == '' || precio <= 0) {
            crear_alerta('error', 'Cotización', 'Precio del producto no puede ser cero.');
            return false;
        }

        var slcImpuestosHtml = getOpcionesSelect("slcImpuestos");
        var slcGastosHtml = getOpcionesSelect("slcGastos");

        slcImpuestosHtml = slcImpuestosHtml.replace(/"/g, "'");
        slcGastosHtml = slcGastosHtml.replace(/"/g, "'");

        var descuentoMonto = precio * (descuento / 100);
        var subtotalNeto = cantidad * precio;
        var subTotal = cantidad * (precio - descuentoMonto);
        var totalImpuestos = calcularGastosMultiSelect("slcImpuestos", "data-porcentaje", subtotalNeto);
        totalImpuestos = parseFloat(totalImpuestos.replace(/,/g, ""));
        var totalGastos = calcularGastosMultiSelect("slcGastos", "data-porcentaje", subtotalNeto);
        totalGastos = parseFloat(totalGastos.replace(/,/g, ""));
        var TotalProducto = subTotal + totalImpuestos + totalGastos;

        var html = '';

        var requisicion = $("#slcRequisicion").val();

        html += '<tr id="tr_' + producto + row + '" data-id="' + row + '">';
        html += '<input type="hidden" name="conversion[]" id="hdnConversion_' + row + '" value="' + medidas + '"/>';
        html += '<input type="hidden" name="productos[]" id="hdnProducto_' + row + '" value="' + producto + '"/>';
        //html += '<input type="hidden" name="cantidades[]" id="cantidadi' + row + '" value="' + cantidad + '"/>';
        //html += '<input type="hidden" name="precios[]" id="hdnPrecio_' + row + '" value="' + precio + '"/>';
        html += '<input type="hidden" name="impuestos[]" id="hdnImpuestos_' + row + '" value="' + impuestos + '"/>';
        html += '<input type="hidden" name="gastos[]" id="hdnGastos_' + row + '" value="' + gastos + '"/>';
        html += '<input type="hidden" name="descuentos[]" id="hdnDescuento_' + row + '" value="' + descuento + '"/>';

        //html += '<label id="dato_prod_cod_' + row + '">' + categoria_nombre + '</label></td>';
        html += '<td><label id="dato_prod_nom_' + row + '">' + codigoProducto+ '-' +nombreArticulo + '</label></td>';

        //Se formatean los montos
        //cantidad = number_format(cantidad, 2);
        precio = number_format(precio, 2);
        descuento = number_format(descuento, 2);
        totalImpuestos = number_format(totalImpuestos, 2);
        totalGastos = number_format(totalGastos, 2);
        subTotal = number_format(subTotal, 2);
        TotalProducto = number_format(TotalProducto, 2);

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + nombreMedida + '" readonly="readonly"/>';
        html += '<select id="slcMedidas_' + row + '" data-id="' + row + '" style="display:none;" class="select-edit">' + medidasHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtCantidad_' + row + '" name="cantidades[]" class="text tables-input-show tables-input cantidadProducto soloNumeros" value="' + cantidad + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtPrecioUnitario_' + row + '" name="precios[]" class="text tables-input-show tables-input soloNumeros preciosUnidades" extras="." value="' + precio + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<a href="#modalSelect" id="lnkImpuestos_' + row + '" data-tipo="1" data-input="txtImpuesto_' + row + '" data-etiqueta="Impuestos" data-html="' + slcImpuestosHtml + '" data-id="' + row + '" data-hidden="hdnImpuestos_' + row + '" class="icon-table multiSelectModal"><span class="icon16 icomoon-icon-list-view"></span></a>';
        html += '<input type="text" id="txtImpuesto_' + row + '" name="impuestosProducto[]" class="text tables-input soloNumeros input-table impuestosProducto" extras="." value="' + totalImpuestos + '" readonly="readonly"/>';
        html += '</td>';

      /*  html += '<td>';
        html += '<a href="#modalSelect" id="lnkGastos_' + row + '" data-tipo="1" data-input="txtGasto_' + row + '" data-etiqueta="Gastos" data-html="' + slcGastosHtml + '" data-id="' + row + '" data-hidden="hdnGastos_' + row + '" class="icon-table multiSelectModal"><span class="icon16 icomoon-icon-list-view"></span></a>';
        html += '<input type="text" id="txtGasto_' + row + '" name="gastosProducto[]" class="text tables-input soloNumeros input-table gastosProducto" extras="." value="' + totalGastos + '" readonly="readonly"/>';
        html += '</td>';*/

        html += '<td>';
        html += '<input type="text" id="txtDescuento_' + row + '" class="text tables-input-show tables-input soloNumeros descuentosProducto" extras="." value="' + descuento + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtSubtotal_' + row + '" name="subtotalesProducto[]" class="text tables-input subtotalProductos" extras="." value="' + subTotal + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtTotal_' + row + '" name="totalesProducto[]" class="text tables-input totalProductos" extras="." value="' + TotalProducto + '" readonly="readonly"/>';
        html += '</td>';

        if (!requisicion > 0) {
            html += '<td>';
            html += '<button type="button" class="btn btn-primary btn-mini btnGuardarProd" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;"><input type="hidden" value="6" id="txtest">Guardar</button>'
            html += '<button type="button" class="btn btn-primary btn-mini btnEditProd" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;"><input type="hidden" value="6" id="txtest">Editar</button>';
            html += '<button type="button" class="btn btn-danger btn-mini btnDelProd" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
            html += '</td>';
        }

        $("#datagried").append(html);

        if ($('#datagried tr').length > 0)
        {
            $('#datagried').removeClass('error');
            $('#validar_datagried').text('');
        }

        limpiar_filtro_categorias();
        $("#cantidad").val('');
        $("#txtDescuento").val('');
        $("#txtPrecio").val('');
        $('#slcProductos option:selected').removeAttr('selected');
        $('#slcProductos').select2({placeholder: 'Seleccione una opción'});
        $('#slcMedidas option:selected').removeAttr('selected');
        $('#slcMedidas').select2({placeholder: 'Seleccione una opción'});
        $('#slcImpuestos option:selected').removeAttr('selected');
        $('#slcImpuestos').select2({placeholder: 'Seleccione una opción'});
        $('#slcGastos option:selected').removeAttr('selected');
        $('#slcGastos').select2({placeholder: 'Seleccione una opción'});

        row = row + 1;
        //Se actualizan los totales
        calcularTotales();
    });//En of function agregar

    $(".btnEditProd").live('click', function () {
        var parent = $(this).parent().parent();

        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');

        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarProd").show();
    });

    //Guardar Email
    $(".btnGuardarProd").live('click', function () {
        var parent = $(this).parent().parent();

        var id_parent = $("#" + parent[0].id).data('id');

        var txtCantidad = $("#txtCantidad_" + id_parent).val().replace(/,/g, "");
        var txtPrecio = $("#txtPrecioUnitario_" + id_parent).val().replace(/,/g, "");
        var txtDescuento = $("#txtDescuento_" + id_parent).val().replace(/,/g, "");

        if (txtCantidad == '' || txtCantidad == 0) {
            crear_alerta('error', 'Cotización', 'Debe ingresar una cantidad válida');
            return false;
        }

        if (txtPrecio == '' || txtPrecio == 0) {
            crear_alerta('error', 'Cotización', 'Debe ingresar un precio válido');
            return false;
        }

        if (txtDescuento > 100) {
            crear_alerta('error', 'Cotización', 'El descuento no puede superar al 100%');
            return false;
        }


        //$("#cantidadi" + id_parent).val(txtCantidad);
        //$("#hdnPrecio_" + id_parent).val(txtPrecio);

        var descuentos = parseFloat($("#" + parent[0].id).find('.descuentosProducto').val());

        var montoDescuento = (descuentos / 100) * txtPrecio;
        var subtotalNeto = txtCantidad * txtPrecio;
        var subTotal = (txtCantidad * (txtPrecio - montoDescuento));
        var htmlImpuestos = $("#lnkImpuestos_" + id_parent).data('html');

        $("#slcMultiCargos").html(htmlImpuestos);

        var montoImpuestos = calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subtotalNeto);

        montoImpuestos = parseFloat(montoImpuestos.replace(/,/g, ""));


        parseFloat($("#" + parent[0].id).find('.impuestosProducto ').val(number_format(montoImpuestos, 2)));

        $("#slcMultiCargos").html('');

        $("#txtCantidad_" + id_parent).val(txtCantidad);
        $("#txtPrecioUnitario_" + id_parent).val(number_format(txtPrecio,2));
        $("#txtDescuento_" + id_parent).val(number_format(txtDescuento,2));

        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');
        $(this).hide();
        $("#" + parent[0].id + " .btnEditProd").show();
        //Se actualizan los totales
        calcularTotalFila(parent[0].id);
        calcularTotales();
    });


    //Eliminar Producto
    $(".btnDelProd").live("click", function () {
        var parent = $(this).parent().parent();

        $("#" + parent[0].id).remove().delay(300);

        //Se actualizan los totales
        calcularTotales();
    });

    //Modal de Multiselects
    $(".multiSelectModal").fancybox({
        width: '75%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            //var id = $(this.element[0]).attr('data-id');
            var etiqueta = $(this.element[0]).attr('data-etiqueta');
            var html = $(this.element[0]).attr('data-html');

            $("#hdnElementoOculto").val($(this.element[0]).attr('id'));
            $("#lblSelect").text(etiqueta + ':');
            $("#slcMultiCargos").html(html);
            $("#slcMultiCargos").select2();
        },
        beforeClose: function () {

            $("#hdnElementoOculto").val('');
            $("#lblSelect").text('');
            $("#slcMultiCargos").html('');
            $("#slcMultiCargos").select2('destroy');
        }
    });

    //Modal del detalle de impuestos
    $(".impuestosModal").fancybox({
        width: '75%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {

            var html = '';

            $("#tbProductos tr").each(function () {
                var id_parent = $(this).data('id');
                var producto = $("#dato_prod_nom_" + id_parent).text();
                var htmlImpuestos = $("#lnkImpuestos_" + id_parent).attr('data-html');
                var subTotal = $("#txtSubtotal_" + id_parent).val();
                var precio = $("#txtPrecioUnitario_" + id_parent).val().replace(/,/g, "");
                ;
                var cantidad = $("#txtCantidad_" + id_parent).val().replace(/,/g, "");
                ;
                $("#slcMultiCargos").html(htmlImpuestos);
                var rowspan = $("#slcMultiCargos option:selected").length;
                //console.log($("#slcMultiCargos option:selected"));

                var montoNeto = cantidad * precio;


                html += '<tr>';
                html += '<td  style="text-align:center;">';
                html += producto;
                html += '</td>';

                html += '<td style="padding: 0px;">';
                html += '<table class="responsive table table-bordered" style="margin: 0px;">';
                html += '<thead><tr><th style="width:50%;">Impuesto</th><th style="width:50%;">Monto</th></tr></thead>';
                html += '<tbody>';
                $("#slcMultiCargos option:selected").each(function () {

                    var nombreImpuesto = $(this).text();
                    var porcentajeImpuesto = $(this).data('porcentaje');


                    var montoImpuesto = montoNeto * (porcentajeImpuesto / 100);

                    html += '<tr>';
                    html += '<td>' + nombreImpuesto + '</td>';
                    html += '<td>' + number_format(montoImpuesto, 2) + '</td>';
                    html += '</tr>';

                });
                html += '</tbody>';
                html += '</table>';
                html += '</td>';
                html += '</tr>';
            });

            $("#tbImpuestos").html(html);
            $("#slcMultiCargos").html('');
        },
        beforeClose: function () {
            $("#tbImpuestos").html('');
        }
    });

    //Modal del detalle de impuestos
    $(".gastosModal").fancybox({
        width: '75%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {

            var html = '';

            $("#tbProductos tr").each(function () {
                var id_parent = $(this).data('id');
                var producto = $("#dato_prod_nom_" + id_parent).text();
                var htmlGastos = $("#lnkGastos_" + id_parent).attr('data-html');
                var subTotal = $("#txtSubtotal_" + id_parent).val();
                var precio = $("#txtPrecioUnitario_" + id_parent).val().replace(/,/g, "");
                ;
                var cantidad = $("#txtCantidad_" + id_parent).val().replace(/,/g, "");
                ;
                $("#slcMultiCargos").html(htmlGastos);
                var rowspan = $("#slcMultiCargos option:selected").length;

                var montoNeto = cantidad * precio;


                html += '<tr>';
                html += '<td style="text-align:center;">';
                html += producto;
                html += '</td>';

                html += '<td style="padding: 0px;">';
                html += '<table class="responsive table table-bordered" style="margin: 0px;">';
                html += '<thead><tr><th style="width:50%;">Gasto</th><th style="width:50%;">Monto</th></tr></thead>';
                html += '<tbody>';
                $("#slcMultiCargos option:selected").each(function () {

                    var nombreGasto = $(this).text();
                    var porcentajeGasto = $(this).data('porcentaje');


                    var montoGasto = montoNeto * (porcentajeGasto / 100);

                    html += '<tr>';
                    html += '<td>' + nombreGasto + '</td>';
                    html += '<td>' + number_format(montoGasto, 2) + '</td>';
                    html += '</tr>';

                });
                html += '</tbody>';
                html += '</table>';
                html += '</td>';
                html += '</tr>';
            });

            $("#tbGastos").html(html);
            $("#slcMultiCargos").html('');
        },
        beforeClose: function () {
            $("#tbGastos").html('');
        }
    });

    $("#btnGuardarSelect").click(function () {
        var parent = $(this).parent().parent();
        var idLink = $("#hdnElementoOculto").val();

        var idSeleccionados = $("#slcMultiCargos").val();
        var idHidden = $("#" + idLink).attr('data-hidden');
        var idInput = $("#" + idLink).attr('data-input');

        $("#" + idHidden).val(idSeleccionados);

        var opciones = "";//$("#slcMultiCargos").html();

        $("#slcMultiCargos option").each(function () {

            if (!$(this).attr('selected')) {
                $(this).removeAttr('selected');
            } else {
                $(this).attr('selected', 'selected');
            }
            //console.log($(this).attr('selected'));
            //console.log(this);
            opciones += this.outerHTML;
        });
        //console.log(opciones);
        $("#" + idLink).attr('data-html', opciones);

        var parent = $("#" + idLink).parent().parent();
        var precio = parent.find('.preciosUnidades').val().replace(/,/g, "");
        var cantidad = parent.find('.cantidadProducto').val().replace(/,/g, "");
        var subtotalNeto = precio * cantidad;
        var subtotal = parent.find('.subtotalProductos').val();
        var montoSubtotal = calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subtotalNeto);
        $("#" + idInput).val(montoSubtotal);

        calcularTotalFila(parent[0].id);
        //Se actualizan los totales
        calcularTotales();

        $.fancybox.close();
    });

    //Calculo cuando es desde una requisicion
    // $(".input-requisicion").live('keyup', function () {
    //     var parent = $(this).parent().parent();
    //     var id_parent = $("#" + parent[0].id).data('id');
    //     var valor = parseFloat($(this).val());

    //     var inputHidden = $(this).data('hidden');

    //     $("#" + inputHidden).val(valor);
        
    //     var cantidad = parseFloat($("#" + parent[0].id).find('.cantidadProducto').val().replace(/,/g, ""));
    //     var precio = parseFloat($("#" + parent[0].id).find('.preciosUnidades').val().replace(/,/g, ""));
        
    //     var subtotalNeto = cantidad * precio;
    //     var subtotal = number_format(parseFloat(cantidad * precio), 2);
    //     var htmlImpuestos = $("#lnkImpuestos_" + id_parent).data('html');

    //     $("#slcMultiCargos").html(htmlImpuestos);

    //     var montoImpuestos = parseFloat(calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subtotalNeto));
    //     parseFloat($("#" + parent[0].id).find('.impuestosProducto ').val(number_format(montoImpuestos, 2)));
        
    //     $("#slcMultiCargos").html('');
        

    //     $("#" + parent[0].id).find('.subtotalProductos').val(subtotal);

    //     calcularTotalFila(parent[0].id);
    //     calcularTotales();
    // });


    $("#registrar_solicitud").click(function () {
        if ($('#datagried tr').length <= 1 || $('#descripcion_req').val().trim() == '' || $('#fecha').val() == '' || $('#documento').val() == '') {
            //alert("Debe haber agregado al menos un producto y descripción!"); //Deshabilitado mientras provisional de requisiciones UTE
            if ($('#datagried tr').length <= 1) {
                $('#datagried').addClass('error');
                $('#validar_datagried').text('Debe seleccionar al menos un producto');
            }

            if ($("#descripcion_req").val() == '') {
                $('#descripcion_req').addClass('error');
                $('#validar_descripcion_req').text('Campo requerido');
            }
            /*if ($('#documento').val() == '') {
             //$('#documento').addClass('error');
             $('#validar_documento').text('Campo requerido');
             }*/
            if ($('#bodega').val() == '') {
                //$('#documento').addClass('error');
                $('#validar_bodega').text('Campo requerido');
            }

        } else {
            $("#fecha").prop('disabled', false);
            $("#documento").prop('disabled', false);
            var aprobar_presupuesto = evaluar_presupuesto($("#slc_presupuesto").val()); 
            if ( aprobar_presupuesto == false) {
                return false;
            }
            
            quitar_atributo();
            
            $("#frm").submit();
        }
    });

    $("#slcProyecto").change(function (){
        var proyecto = $(this).val();
        if ( proyecto != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {proyecto: proyecto},
                url: urlj + 'modulo_compras/procesos/get_presupuestoxproyecto',
                success: function (data) {
                    $("#slc_presupuesto").html("");
                    $("#slc_presupuesto").html(data);
                    $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else {
            $("#slc_presupuesto").html('<option value=""></option>');
            $("#slc_presupuesto").select2({placeholder: 'Seleccione una opción'});
        }
    });

    $("#slc_presupuesto").change(function (){
        var presupuesto = $(this).val();
        if ( presupuesto != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {presupuesto: presupuesto},
                url: urlj + 'modulo_compras/procesos/get_actividades_generalesxpresupusto',
                success: function (data) {
                    $("#slc_actividad_general").html("");
                    $("#slc_actividad_general").html(data);
                    $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } else {
            $("#slc_actividad_general").html('<option value=""></option>');
            $("#slc_actividad_general").select2({placeholder: 'Seleccione una opción'});
        }
    });

    $("#slc_actividad_general").change(function (){
        var general     = $(this).val();
        var presupuesto = $("#slc_presupuesto").val();
        if ( general != "" ) {
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {general: general,presupuesto:presupuesto},
                url: urlj + 'modulo_compras/procesos/get_actividades_especificas_x_actividad_general',
                success: function (data) {
                    $("#slc_actividad_espeficifica").html("");
                    $("#slc_actividad_espeficifica").html(data);
                    $("#slc_actividad_espeficifica").select2({placeholder: 'Seleccione una opción'});
                }
            });
        } 
    });

        $("#slcProveedor").change(function () {
        var proveedor = $(this).val();
        var requisicion = $("#slcRequisicion").val();
            $.ajax({
                url: urlj + 'modulo_compras/procesos/existencia_proveedor_cotizacion',
                dataType: 'json',
                type: 'POST',
                data: {proveedor: proveedor,
                        requisicion: requisicion},
                success: function (result) {
                    wait.close();
                    /*console.log(result.contador);
                    return false;*/   
                     if (result.contador > 0) {  
            $('#slcProveedor option:selected').removeAttr('selected');
            $("#slcProveedor").select2({placeholder: 'Seleccione una opción'});
            $("#slcProveedor").val('');            
                    crear_alerta('info', 'proveedor', 'El proveedor seleccionado ya posee una cotización para esta requisición.');
                }
                }
            });
        });

});// END DOCUMENT READY

function cargar_categorias(tipoOrden, edicion) {

    $("#div-categorias").html('');
    $("#slcProductos").html('');
    $("#slcProductos").select2('destroy').select2();
    if (edicion == '') {
        $("#datagried tbody").html('');
    }

    if (tipoOrden) {
        tipoOrden = parseInt(tipoOrden);
        switch (tipoOrden) {
            case 1:
                $("#dvImpuestos").show();
                $("#slcMedidas").html('');
                $("#dvMedidas").show();
                $("#slcMedidas").select2();
                $("#lblProducto").html('Producto:<b class="orange">*<b/>');
                break;
            case 2:
                //$("#dvImpuestos").hide();
                $("#slcMedidas").html('');
                $("#dvMedidas").hide();
                $("#slcMedidas").select2();
                $("#lblProducto").html('Producto/Servicio:<b class="orange">*<b/>');
                break;
            case 3:
                $("#slcMedidas").html('');
                $("#slcMedidas").select2('destroy');
                $("#dvMedidas").hide();
                $("#lblProducto").html('Producto/Servicio:<b class="orange">*<b/>');
                //$("#dvImpuestos").hide();
                //$("#slcImpuestos").select2('destroy');
                //$("#slcImpuestos").html('');
                break;
        }

        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'modulo_compras/procesos/get_categorias_productos',
            data: {tipo: tipoOrden},
            success: function (data) {
                //$("#departamento").html(data.drop);

                $("#div-categorias").html(''
                        + '<div class="span7">'
                        + '<div class="row-fluid">'
                        + '<label class="form-label span3">Categoría<b class="orange">*</b>:</label>'
                        + '<div class="span6 controls">'
                        + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                        + '</div></div></div>');
                $(".dinamic").html(data.categoria);
                $('.dinamic option[value="0"]').text('');
                $('.dinamic option[value="0"]').val('');
                $('.dinamic').select2({placeholder: "Seleccione una opción"});
                producto = data.producto;
                $("#slcProductos").html(producto);
                $('#slcProductos option[value="0"]').text('');
                $('#slcProductos option[value="0"]').val('');
                $("#slcProductos").select2('destroy').select2({placeholder: "Seleccione una opción"});
            }
        });
    }
}

function calcularGastosMultiSelect(idElemento, nombreAtributo, subTotalString) {
    var total = 0;
    var subTotal = subTotalString.toString().replace("$", '').replace(/,/g, "");

    subTotal = parseFloat(subTotal);
    $("#" + idElemento + " option:selected").each(function () {

        var porcentaje = $(this).attr(nombreAtributo);
        porcentaje = parseFloat(porcentaje) / 100;

        total += (porcentaje * subTotal);
    });

    total = number_format(total, 2);
    return total;
}

function calcularTotalFila(idFila) {

    var impuestos = parseFloat($("#" + idFila).find('.impuestosProducto').val().replace(/,/g, ""));
    //var gastos = parseFloat($("#" + idFila).find('.gastosProducto').val().replace(/,/g, ""));
    var descuentos = parseFloat($("#" + idFila).find('.descuentosProducto').val().replace(/,/g, ""));
    var cantidad = parseFloat($("#" + idFila).find('.cantidadProducto').val().replace(/,/g, ""));
    var precio = parseFloat($("#" + idFila).find('.preciosUnidades').val().replace(/,/g, ""));
    var data_id = $("#" + idFila).data('id');


    var montoDescuento = (descuentos / 100) * precio;
    var subTotal = (cantidad * (precio - montoDescuento));

    var total = subTotal + impuestos ;
    parseFloat($("#" + idFila).find('.subtotalProductos').val(number_format(subTotal, 2)));
    $("#" + idFila).find('.totalProductos').val(number_format(total, 2));
}


function calcularTotales() {
    if ($("#tbProductos").length > 0) {

        var totalSuma = 0.00;
        var totalDescuentos = 0.00;
        var totalImpuestos = 0.00;
        var totalGastos = 0.00;
        var totalSubtotal = 0.00;
        var totalGeneral = 0.00;

        $("#tbProductos tr").each(function () {
            var cantidad = parseFloat($(this).find('.cantidadProducto').val().replace(/,/g, ""));
            var precio = parseFloat($(this).find('.preciosUnidades').val().replace(/,/g, ""));
            var impuesto = parseFloat($(this).find('.impuestosProducto').val().replace(/,/g, ""));
            //var gastos = parseFloat($(this).find('.gastosProducto').val().replace(/,/g, ""));
            var descuento = parseFloat($(this).find('.descuentosProducto').val().replace(/,/g, ""));

            descuento_porc = (descuento / 100);
            descuento = (precio) * descuento_porc;

            descuento_total = descuento * cantidad;

            totalSuma += (cantidad * precio);
            totalImpuestos += impuesto;
            //totalGastos += gastos;
            totalDescuentos += descuento_total;
            totalSubtotal += (cantidad * (precio - descuento));

        });

        totalGeneral = totalSubtotal + totalImpuestos;

        $("#txtSumaGeneral").val(number_format(totalSuma, 2));
        $("#txtDescuentoGeneral").val(number_format(totalDescuentos, 2));
        $("#txtSubtotalGeneral").val(number_format(totalSubtotal, 2));
        $("#txtImpuestosGeneral").val(number_format(totalImpuestos, 2));
        //$("#txtGastosGeneral").val(number_format(totalGastos, 2));
        $("#txtTotalGeneral").val(number_format(totalGeneral, 2));
    }
}

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        //console.log($(this).attr('selected'));
        //console.log(this);
        opciones += this.outerHTML;
    });

    return opciones;
}

function cerrar_modal() {
    //alert('asdasd');
    jQuery.fancybox.close();
}

function limpiar_filtro_categorias() {
    menor = Number($(".dinamic:first").attr('id')) + 2;

    $(".dinamic").each(function (index, el) {
        if ($(el).attr('id') > menor) {
            $(el).parent('div').siblings('label').remove();
            $(el).siblings('select').remove();
            $(el).parent('div').parent('div').parent('div').remove();
            $(el).remove();
        }
    });
    $(".plus:last").remove();
    $(".dinamic:first option:selected").removeAttr('selected');
    $(".dinamic:first").next().append('<button class="btn plus">+</button>');
    $(".dinamic:first").select2({placeholder: 'Seleccione una opción'});
}

function evaluar_presupuesto(actividad_especifica) {
    var monto_disponible    =  parseFloat($("#slc_actividad_espeficifica option:selected").data("monto_disponible"));
    var total_gasto         =  number_format($("#txtTotalGeneral").val(),"2",".",""); 
    var total_gasto         =  parseFloat( total_gasto ); 
    var aprobado            = true;
    
    if (total_gasto > monto_disponible && actividad_especifica != "" && $("#sobre_giro").val() == 0 ) {
        aprobado = false;
        crear_alerta('error', 'Presupuesto', 'El monto total de la cotización sobrepasa el presupuesto asignado ($'+number_format(monto_disponible,"2",".",",")+')'); 
    }

    return aprobado;
}

function quitar_atributo() {
    $("#slcProyecto").removeAttr("disabled");
    $("#slc_presupuesto").removeAttr("disabled");
    $("#slc_actividad_general").removeAttr("disabled");
    $("#slc_actividad_espeficifica").removeAttr("disabled");
}