$(document).ready(function () {
    //URL PATH
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;

    $("select option[value='0']").text('');
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    $('select').select2({placeholder: 'Seleccione una opción'});
    $(".select-edit").select2('destroy');
    $(".select-edit").hide();

    // mascara = $("#txtNrc").data('mask');
    // if (mascara != "" ){
    //     $("#txtNrc").mask(mascara);
    // }

    $(".txtFecha").datepicker('destroy');
    $(".txtFecha").datepicker('destroy');
    $(".txtFecha").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $('#agregar_dpv').click(function() {
        var caja_chica = $('#id_caja').val();
        $.ajax({
            type: 'POST',
            url: window.gSateliteWhite.baseUrl('modulo_compras/procesos/caja_chica_flashdata'),
            dataType: 'text',
            data: {
                'caja_chica': caja_chica
            },
            beforeSend: function () {
                wait.start();
            },
            success: function(data) {
                if (data > 0) {
                    window.location.href = url_base_proyecto + "modulo_compras/procesos/agregar_doc_proveedor";
                } else {
                    crear_alerta("error","Caja Chica","No tiene permiso para a&ntilde;adir comprobantes.");
                    wait.close();
                }
            }
        });                        
    });

   $("#slcProveedor").select2({
        placeholder: "Buscar Proveedor",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_compras/procesos/get_proveedores',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (proveedor) {
                return {
                    proveedor: proveedor
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.proveedor,
                        'text': item.nombre_proveedor
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var id_elemento = element[0].id;
            var valor = $("#" + id_elemento).val();
            if (valor !== "") {
                var texto = $("#" + id_elemento).data('nombre');
                callback({id: valor, text: texto});

            }
        }
    }); 

   $("#slcProveedor").live('change', function(event) {
    var id_proveedor = $(this).val();
   
    if(id_proveedor>0){
        $("#txtNumDoc").removeAttr('readonly');
        wait.start('Obteniendo NRC...');
        $.ajax({
            async: true,
            url: gSateliteWhite.baseUrl('modulo_compras/procesos/get_nrc_proveedor'),
            type: "POST",
            dataType: "json",
            data: {id: id_proveedor},
            success: function(data) {
                if(data!=''){
                    $("#txtNrc").val(data);
                }else{
                     $("#txtNrc").val("");
                }
                wait.close();
            },
            error: function(data) {
                wait.close();
                crear_alerta("info","Obtener NRC","El proveedor no posee NRC asignado.");
            }
        });
    }else{
        $("#txtNrc").val("");
        $("#txtNumDoc").attr('readonly', 'readonly');
    }
   });

   $("#txtNumDoc").focusout(function () {
        var proveedor = $("#slcProveedor").val();
        var numDocumento = $(this).val();

        if (proveedor != '') {
            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_documentos_caja',
                data: {proveedor: proveedor, numDocumento: numDocumento},
                type: 'POST',
                dataType: 'json',
                success: function (data) {
                    if (data > 0) {
                        $("#txtNumDoc").val('');
                        crear_alerta('info', 'Número de Documento', 'El número de documento ya ha sigo ingresado.');
                    }
                }
            });
        }
    });

   $("#slcImpuestos").change(function(event) {
       var monto       = ($("#txtMonto").val() !="")?parseFloat($("#txtMonto").val()):0;
       var cantidad    = ($("#txtCantidad").val() != "")?parseFloat($("#txtCantidad").val()):0;
       var total       = cantidad*monto;

        if ( total > 0 ) { 
            imp  = getOpcionesSelectResult("slcImpuestos"); // Porcentaje total seleccionado
            imp2 = getOpcionesSelectResult2("slcImpuestos",cantidad);
          
            tltImpuesto = (imp / 100)*total;
            tltImpuesto += imp2;
            $("#txtImpuesto").val(number_format(tltImpuesto, $("#decimales").val()));
            
            newtotal = (parseFloat(total) + parseFloat(tltImpuesto)) - parseFloat(tltRetencion);
            $("#lblTotal").text(number_format(newtotal,$("#decimales").val()));
            $("#txtTotal_lbl").val(number_format(newtotal,$("#decimales").val()));
       } 

   });

   $("#slcRetenciones").change(function(event) {
        var monto       = ($("#txtMonto").val() !="")?parseFloat($("#txtMonto").val()):0;
        var cantidad    = ($("#txtCantidad").val() != "")?parseFloat($("#txtCantidad").val()):0;
        var total       = cantidad*monto;
       
        if (total > 0) {
            ret = getOpcionesSelectResult("slcRetenciones"); // Porcentaje total seleccionado
            tltRetencion = (ret / 100)*total;
            $("#txtRetencion").val(number_format(tltRetencion,$("#decimales").val()));
            newtotal = (parseFloat(total) + parseFloat(tltImpuesto)) - parseFloat(tltRetencion);
            $("#lblTotal").text(number_format(newtotal,$("#decimales").val()));
            $("#txtTotal_lbl").val(number_format(newtotal,$("#decimales").val()));
        }
   });

    $("#txtMonto, #txtCantidad").live('keypress, keyup', function(event) {
        var monto       = ($("#txtMonto").val() !="")?parseFloat($("#txtMonto").val()):0;
        var cantidad    = ($("#txtCantidad").val() != "")?parseFloat($("#txtCantidad").val()):0;
        var total       = cantidad*monto;

        if ( total > 0 ) {
            imp = getOpcionesSelectResult("slcImpuestos"); // Porcentaje total seleccionado
            imp2 = getOpcionesSelectResult2("slcImpuestos",cantidad);
            ret = getOpcionesSelectResult("slcRetenciones"); // Porcentaje total seleccionado
            tltRetencion = 0;
            tltImpuesto = 0;

            if(total > 0){
                tltImpuesto = (imp / 100)*total;
                tltImpuesto += imp2;
                $("#txtImpuesto").val(number_format(tltImpuesto,$("#decimales").val()));
        
                tltRetencion = (ret / 100)*total;
                $("#txtRetencion").val(number_format(tltRetencion,$("#decimales").val()));
            }
            
            newtotal = ( (parseFloat(total)) + parseFloat(tltImpuesto)) - parseFloat(tltRetencion);
            $("#lblTotal").text(number_format(newtotal,$("#decimales").val()));
            $("#txtTotal_lbl").val(number_format(newtotal,$("#decimales").val()));
        } else {
            $("#lblTotal").text("");
            $("#txtTotal_lbl").val("");
            $("#txtImpuesto").val("");
            $("#txtRetencion").val("");
        }
   });
   

    /**************** Funciones para el modal de proeedores *******************************/

    $("#slcPersoneria").change(function () {
        $("#slcPersoneria_error").text('');
        if ($(this).val() == 1) {
            $("#lblNombreProv").html('Nombre:<b style="color:red;">*</b>');
            $("#lblApellidoProv").html('Apellido:<b style="color:red;">*</b>');
        } else {
            $("#lblNombreProv").html('R. Comercial:<b style="color:red;">*</b>');
            $("#lblApellidoProv").html('R. Social:<b style="color:red;">*</b>');
        }
    });

    $("#slcNacionalidad").change(function () {
        $("#slcDepartamento").html('');
        $("#slcMunicipio").html('<option value=""></option>');
        $("#slcDepartamento").select2({placeholder: 'Seleccione una opción'});
        $("#slcMunicipio").select2({placeholder: 'Seleccione una opción'});
        
        $("#slcNacionalidad_error").text('');
        $("#slcDepartamento_error").text('');
        $("#slcMunicipio_error").text('');


        if ($(this).val() > 0) {
            wait.start();
            var filtro = $(this).val();

            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_localidades',
                data: {filtro: filtro, tipo: 2},
                type: "POST",
                success: function (result) {
                    wait.close();
                    $("#slcDepartamento").html(result);
                    $("#slcDepartamento").select2({placeholder: 'Seleccione una opción'});
                }
            });
        }
    });

    $("#slcDepartamento").change(function () {
        $("#slcMunicipio").html('');
        $("#slcMunicipio").select2({placeholder: 'Seleccione una opción'});
        $("#slcDepartamento_error").text('');
        $("#slcMunicipio_error").text('');

        if ($(this).val() > 0) {
            wait.start();
            var filtro = $(this).val();

            $.ajax({
                url: urlj + 'modulo_compras/procesos/get_localidades',
                data: {filtro: filtro, tipo: 3},
                type: "POST",
                success: function (result) {
                    wait.close();
                    $("#slcMunicipio").html(result);
                    $("#slcMunicipio").select2({placeholder: 'Seleccione una opción'});
                }
            });
        }
    });

    $("#slcActividad").change(function(event) {
       $("#slcActividad_error").text("");
    });

    $("#txtNombreProv").keyup(function(event) {
      $("#txtNombreProv_error").text('');
      $("#txtNombreProv").removeClass('error');
    });
    $("#txtApellidoProv").keyup(function(event) {
      $("#txtApellidoProv_error").text('');
      $("#txtApellidoProv").removeClass('error');
    });


    $("#btnProveedor").click(function(event) {
        fields= $("#frm-proveedorCaja").serializeArray();
        $.each( fields, function( i, field ) {
            if($("#"+field.name).hasClass('required')){
                if(field.value==''){
                        $("#"+field.name+"_error").text("Campo requerido");
                        $("#"+field.name).addClass('error');
                }else{
                    $("#"+field.name+"_error").text("");
                    $("#"+field.name).removeClass('error');
                }
            }
        });
       

       if($("#txtCodigo").val()=='' || $("#txtFechaRegistro").val()=='' || $("#slcPersoneria").val()<=0 || $("#slcNacionalidad").val()<=0 || $("#txtNombreProv").val()=='' || $("#txtApellidoProv").val()=='' || $("#slcDepartamento").val()<=0 || $("#slcMunicipio").val()<=0 || $("#slcActividad").val()<=0 ){
        crear_alerta("error", "Agregar proveedor", "Debe completar los campos requeridos");
       }else{
        wait.start();
            $.ajax({
                type: 'post',
                dataType: 'json',
                url:  urlj+'modulo_compras/procesos/guardar_proveedor',
                data: $("#frm-proveedorCaja").serialize(),
                success: function (data) {  
                   crear_alerta(data.tipo_alerta, data.titulo_alerta, data.texto_alerta);
                   $.fancybox.close();
                   wait.close();
                }
            });
       }
    });
    
    /*******************************************************************************************/

    var row = 0;
    if ($('#datagried tr').length > 0) {
        row = $("#datagried tr").length;
    }

    $("#agregar").click(function () {
        event.preventDefault();
        var proveedor       = $("#slcProveedor").val();
        var proveedorText   = ($("#slcProveedor").val() != '' && $("#slcProveedor").val() != null) ? $("#slcProveedor").next().children().text() : '';

        var nrc         = $('#txtNrc').val();
        var concepto    = $('#txtConcepto').val();
        var impuestos   = ($("#slcImpuestos").val() != '' && $("#slcImpuestos").val() != null) ? $("#slcImpuestos").val() : '';
        var retenciones = ($("#slcRetenciones").val() != '' && $("#slcRetenciones").val() != null) ? $("#slcRetenciones").val() : '';
        
        var tipo_documento      = $("#slcTipoDoc").val();
        var tipo_documentoText  = ($("#slcTipoDoc").val() != '' && $("#slcTipoDoc").val() != null) ? $("#slcTipoDoc option:selected").text() : '';
        
        var numero_doc      = $("#txtNumDoc").val();
        var tipo_venta      = ($("#slcTipoVenta").val() != '' && $("#slcTipoVenta").val() != null) ? $("#slcTipoVenta").val() : '';
        var tipo_ventaText  = ($("#slcTipoVenta").val() != '' && $("#slcTipoVenta").val() != null) ? $("#slcTipoVenta option:selected").text() : '';
        var tipoMonto       = ($("#slcTipoMonto").val() != '' && $("#slcTipoMonto").val() != null) ? $("#slcTipoMonto").val() : '';
        var tipo_montoText  = ($("#slcTipoMonto").val() != '' && $("#slcTipoMonto").val() != null) ? $("#slcTipoMonto option:selected").text() : '';
        
        var txtmonto    = $('#txtMonto').val();
        var txtImpuesto = $("#txtImpuesto").val();
        var txtRetencion= $("#txtRetencion").val();
        var fecha_doc   = $("#txtFechaDocumento").val();
        var fecha_conta = $("#txtFechaConta").val();
        var cantidad    = $("#txtCantidad").val();

        if ( cantidad == "") {
            crear_alerta('error', 'Agregar comprobante', 'Cantidad es requerida.');
            $("#txtCantidad").focus();
            return false;
        }

        if ( cantidad <= 0) {
            crear_alerta('error', 'Agregar comprobante', 'Cantidad debe ser mayor a cero.');
            $("#txtCantidad").focus();
            return false;
        }
    
        var decimal = $("#decimales").val();

        if(proveedor > 0 && tipo_venta > 0 && txtmonto >0 && tipo_documento > 0 && numero_doc!='' && fecha_doc != '' && fecha_conta!=""){
            //var ocultar = "";
            var slcImpuestosHtml    = getOpcionesSelect("slcImpuestos");
            var slcRetencionesHtml  = getOpcionesSelect("slcRetenciones");
            var slcTipoVentaHtml    = getOpcionesSelect("slcTipoVenta");
            var slcTipoMontoHtml    = getOpcionesSelect("slcTipoMonto");

            slcImpuestosHtml    = slcImpuestosHtml.replace(/"/g, "'");
            slcRetencionesHtml  = slcRetencionesHtml.replace(/"/g, "'");
            slcTipoVentaHtml    = slcTipoVentaHtml.replace(/"/g, "'");
            slcTipoMontoHtml    = slcTipoMontoHtml.replace(/"/g, "'");

            //Se formatean los montos
            monto           = number_format(txtmonto, decimal, '.', '');
            TotalImpuesto   = number_format(txtImpuesto, decimal, '.', '');
            TotalRetencion  = number_format(txtRetencion, decimal, '.', '');

            //totalRetenciones = totalRetenciones * cantidad;
            var Total = (parseFloat(TotalImpuesto) + ( parseFloat(monto) * parseFloat(cantidad)) - parseFloat(TotalRetencion));
            var disponible = number_format($("#txtDisponible").val(), decimal, '.','');
            var sobregirar = $("#txtSobregirar").val();
            var sgirar     = false;
            if (sobregirar == 1) { sgirar = true;}
 
            if( ( parseFloat(Total) >= parseFloat(disponible) && sgirar == true )  || ( parseFloat(Total) <= parseFloat(disponible) )  ) {
                var html = '';
                var idTr = "tr_" + row;

                html += '<tr id="' + idTr + '" data-id="' + row + '" class="nuevoTR"><td>';
                    html += '<input type="hidden" name="proveedor[]" id="hdnProveedor_' + row + '" value="' + proveedor + '"/>';
                    html += '<input type="hidden" name="nrc[]" id="hdnNrc_' + row + '" value="' + nrc + '"/>';
                    html += '<input type="hidden" name="tipo_documento[]" id="hdnTipoDoc_' + row + '" value="' + tipo_documento + '"/>';
                    html += '<input type="hidden" name="numero_doc[]" id="hdnNumeroDoc_' + row + '" value="' + numero_doc + '"/>';
                    html += '<input type="hidden" name="tipo_venta[]" id="hdnTipoVenta_' + row + '" value="'+ tipo_venta +'"/>';
                    html += '<input type="hidden" name="concepto[]" id="hdnConcepto_' + row + '" value="'+ concepto +'"/>';
                    html += '<input type="hidden" name="monto[]" id="hdnMonto_' + row + '" value="'+ number_format(monto,decimal,'.','') +'"/>';
                    html += '<input type="hidden" name="tipo_monto[]" id="hdnTipoMonto_' + row + '" value="'+ tipoMonto +'"/>';
                    html += '<input type="hidden" name="impuestos[]" id="hdnImpuestos_' + row + '" value="'+ impuestos +'"/>';
                    html += '<input type="hidden" name="retenciones[]" id="hdnretenciones_' + row + '" value="'+ retenciones +'"/>';
                    html += '<input type="hidden" name="TotalImpuesto[]" id="hdnTotalImp_' + row + '" value="'+ number_format(TotalImpuesto,decimal,'.','') +'"/>';
                    html += '<input type="hidden" name="TotalRetencion[]" id="hdnTotalRet_' + row + '" value="'+ number_format(TotalRetencion,decimal,'.','') +'"/>';
                    html += '<input type="hidden" name="TotalFechaDoc[]" id="hdnFechaDoc_' + row + '" value="'+ fecha_doc +'"/>';
                    html += '<input type="hidden" name="TotalFechaConta[]" id="hdnFechaConta_' + row + '" value="'+ fecha_conta +'"/>';
                    html += '<input type="hidden" name="TotalMonto[]" id="hdnTotalMonto_' + row + '" value="'+ Total +'"/>';
                    html += '<input type="hidden" name="TotalCantidad[]" id="hdnTotalCantidad_' + row + '" value="'+ cantidad +'"/>';
                html += '<label/><textarea name="txtDocumento[]" id="txtDocumento_<?php echo $i; ?>" class="text tables-input" style="resize:none">' + proveedorText + '</textarea></td>';
                html += '<td><input type="text" id="txtTipo_doc_'+ row +'" class="text tables-input" value="' + nrc + '" readonly="readonly"/></td>';

                html += '<td>';
                html += '<input type="text" id="txtTipo_doc_'+ row +'" class="text tables-input" value="' + tipo_documentoText + '" readonly="readonly"/>';
                html += '</td>';

                html += '<td>';
                html += '<input type="text" id="txtNumeroDoc_'+ row +'" class="text tables-input" value="' + numero_doc + '" readonly="readonly"/>';
                html += '</td>';

                html += '<td>';
                html += '<input type="text" id="txtTipo_venta_'+ row +'" class="text tables-input select-text" value="' + tipo_ventaText + '" readonly="readonly"/>';
                html += '</td>';

                html += '<td>';
                html += '<textarea name="txtDocumento[]" id="txtDocumento_<?php echo $i; ?>" class="text tables-input" style="resize:none">' + concepto + '</textarea>';
                html += '</td>';

                html += '<td>';
                html += '<input type="text" id="txtCantidad_' + row + '" class="text tables-input-show tables-input " value="' + number_format(cantidad,decimal,'.',',') + '" readonly="readonly"/>';
                html += '</td>';

                html += '<td width="6%">';
                html += '<input type="text" id="txtMonto_' + row + '" class="text tables-input-show tables-input " value="' + number_format(monto,decimal,'.',',') + '" readonly="readonly"/>';
                html += '</td>';

                html += '<td>';
                html += '<input type="text" id="txtTipoMonto_' + row + '" class="text tables-input soloDecimales" value="' + tipo_montoText + '" readonly="readonly"/>';
                html += '</td>';

                html += '<td width="6%">';
                html += '<input type="text" id="txtTotalImp_' + row + '" class="text tables-input soloDecimales" value="' + number_format(TotalImpuesto,decimal,'.',',') + '" readonly="readonly"/>';
                html += '</td>';

                html += '<td width="6%">';
                html += '<input type="text" id="txtTotalRet_' + row + '" class="text tables-input soloDecimales" value="' + number_format(TotalRetencion,decimal,'.',',') + '" readonly="readonly"/>';
                html += '</td>';
                
                html += '<td width="6%">';
                html += '<input type="text" id="txtTotal_' + row + '" class="text tables-input soloDecimales clsTotal" style="min-width:100px" value="' + number_format(Total,decimal,'.',',') + '" readonly="readonly"/>';
                html += '</td>';

                html += '<td>';
                html += '<input type="text" id="txtFechaDoc_' + row + '" class="text tables-input" value="' + fecha_doc + '" readonly="readonly"/>';
                html += '</td>';

                html += '<td>';
                html += '<input type="text" id="txtFechaConta_' + row + '" class="text tables-input" value="' + fecha_conta + '" readonly="readonly"/>';
                html += '</td>';

                html += '<td>';
                html += '<button type="button" class="btn btn-danger btn-mini btnDelProd" data-corr="'+row+'" style="float:left; margin-left:5%; height:30px;width:50px;">Eliminar</button>';
                html += '</td>';
            
                html += '</tr>';

                $("#tbDetalles").append(html);

                if ($('#tbDetalles tr').length > 0)
                {
                    $('#tbDetalles').removeClass('error');
                }

                $("#txtNrc").val('');
                $("#txtConcepto").val('');
                $("#txtNumDoc").val('');
                $("#txtMonto").val('');
                $("#txtImpuesto").val('');
                $("#txtRetencion").val('');

                //$('#slcProveedor option:selected').removeAttr('selected');
                //$('#slcProveedor').select2({placeholder: 'Seleccione una opción'});
                $('#slcImpuestos option:selected').removeAttr('selected');
                $('#slcImpuestos').select2({placeholder: 'Seleccione una opción'});
                $('#slcRetenciones option:selected').removeAttr('selected');
                $('#slcRetenciones').select2({placeholder: 'Seleccione una opción'});
                $('#slcTipoDoc option:selected').removeAttr('selected');
                $('#slcTipoDoc').select2({placeholder: "Seleccione una opción"});
                $("#slcTipoVenta option:selected").removeAttr('selected');
                $("#slcTipoVenta").select2({placeholder: 'Seleccione una opción'});
                $("#slcTipoMonto option:selected").removeAttr('selected');
                $("#slcTipoMonto").select2({placeholder: 'Seleccione una opción'});
            
                $("#slcProveedor").select2('data', null);

                $("#txtCantidad").val("");
                $("#lblTotal").text('');
                total1 = $("#txtSumaGeneral").val();
                total2 = $("#txtTotal_"+row).val();
            
                total_sum = parseFloat(number_format(total1, decimal, '.',''))+parseFloat(number_format(total2, decimal, '.',''));
                $("#txtSumaGeneral").val(number_format(total_sum,decimal));
                limite = number_format($("#txtLimite").val(), decimal, '.','');
                sumaGral = number_format( $("#txtSumaGeneral").val(), decimal, '.','');
                total_dis = parseFloat(limite)-(parseFloat(sumaGral));
                $("#txtDisponible").val(number_format(total_dis,decimal));

                row = row + 1;
            }else{
            crear_alerta('error', 'Agregar comprobante', 'El monto del comprobante no puede ser mayor al disponible.');
            }
        }else{
            crear_alerta('error', 'Caja chica', 'Debe completar los campos necesarios.(Proveedor, Tipo de documento, Tipo de venta, Monto, Número de documento, Fecha del documento, Fecha contabilizaciòn).');
        }
    });//En of function agregar

    $(".btnDelProd").live("click", function () {
        var parent = $(this).parent().parent();
        var correlativo = $(this).data('corr');

        sumTotal = number_format($("#txtSumaGeneral").val(), $("#decimales").val(), '.', '');
        monto = number_format($("#txtTotal_"+ correlativo).val(), $("#decimales").val(), '.', '');
        disp = number_format($("#txtDisponible").val(), $("#decimales").val(), '.', '');
        
        nuevoTotal = parseFloat(sumTotal)-parseFloat(monto);
        $("#txtSumaGeneral").val(number_format(nuevoTotal,$("#decimales").val()));
        nuevoDisp = parseFloat(disp)+parseFloat(monto);
        $("#txtDisponible").val(number_format(nuevoDisp,$("#decimales").val()));

        $("#tr_" + correlativo).remove();

        $("#txt_eliminadas").val("1");
        //Se actualizan los totales
        //calcularTotales();
    });

    $("#btnCrear, #btnVolver").click(function(event) {
         event.preventDefault();
         if($(".nuevoTR").length<=0 && $("#txt_eliminadas").val() == 0){
            crear_alerta('error', 'Error', 'Debe agregar al menos un detalle');
         }else{
            $("#frm-cajaChica").submit();
         }
    });

    $("#close_modal").click(function(event) {
        event.preventDefault();
       $.fancybox.close();
    });



}); //End jQuery



function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }

        opciones += this.outerHTML;
    });

    return opciones;
}

function getOpcionesSelectResult(idElemento) {
    var total = 0;
    $("#" + idElemento + " option").each(function () {
        if ($(this).attr('selected') && $(this).data('type') == 1 ) {
           total += $(this).data('porcentaje');
        }
    });
    return total;
}

function getOpcionesSelectResult2(idElemento, cantidad) {
    cantidad = (cantidad == "")?0:cantidad;
    var total = 0;
    $("#" + idElemento + " option").each(function () {
        if ($(this).attr('selected') && $(this).data('type') == 0 ) {
           total += parseFloat($(this).data('porcentaje')) * parseFloat(cantidad);
        }
    });
    return total;
}

function validar_campos(array=null){
    /*var fields = array;
      alert(fields);*/
}

$("#datagried tr").click(function() {
    var id          = $(this).attr("id");
    var selected    = $("#"+id).hasClass("highlight");
    $("#"+id).removeClass("highlight");
    if(!selected) {
        $(this).addClass("highlight");
    }        
});

$(".ver-accion-modal").live('click', function (event) {
    event.preventDefault();
    var url = $(this).attr('href');
    $.fancybox({
        'href': url,
        type: 'iframe',
        width:'100%',
        closeBtn: true
    });
});

function cerrar_modal(){
    jQuery.fancybox.close();
}