$(document).ready(function () {
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione"});

    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


     $("#frmSeguimiento").validate({
       ignore: ".select2-container",
        rules: {
            txtFecha_seguimiento: {required: true},
            txtContacto: {required: true},
            txtComentario: {required: true},
            slcTipo: {required:true,min: 1},
            slcForma: {required:true, min: 1}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").text('Campo requerido');
        },
        submitHandler: function (form){
            if ( $("#txtProximo_seguimiento").val() != ""){
                if ( !validarPeriodo($("#txtFecha_seguimiento").val(), $("#txtProximo_seguimiento").val()) ) {
                    crear_alerta('error', 'Seguimiento de órdenes de compra', 'Verifique el período de las fechas.');
                    return false;
                }
                form.submit();
            } else{
                form.submit();
            }
        }
    });

});