$(document).ready(function () {
    //gSateliteWhite.jsSelect();
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder:"Seleccione una opción"});
     
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    $(".btn-close").live('click',function(){
        alerta_confirm_ajax(cerrar_modal,'','Alerta de Confirmación','Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });
    
    $("#slcFiltro").change(function(){
        var filtro = $(this).val();
        if($.trim(filtro) == ''){
            $("#txtFechaIni").val('');
            $("#txtFechaFin").val('');
        }
    })

    /*Busqueda*/
    $("#btnConsultar").click(function(e){
        e.preventDefault();
        var filtro    = $("#slcFiltro").val();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var caja_chica = $("#slCjch").val();

        if($.trim(filtro) != ''){
            if(filtro=='' || fecha_ini == '' || fecha_fin == ''){
                crear_alerta('error','Documentos por Proveedor','Verifique los filtros de búsqueda.');
                return false;
            }

            if(fecha_ini !='' && fecha_fin != ''){
                if(!verifica_fecha(fecha_ini,fecha_fin)){
                    crear_alerta('error','Documentos por Proveedor','Verifique el período de las fechas.');
                    return false;
                }
            }
        } else {
            fecha_ini = null;
            fecha_fin = null;
        }

        var orden_compra = $("#orden_compra").val();
        $("#dv_contenedor_documentos").hide('slide',{ direction:'right' }, 400,function(){
            $.ajax({
                type:'post',
                url:window.gSateliteWhite.baseUrl('modulo_compras/procesos/documentos_proveedor/'+orden_compra),
                data:{
                    filtro:filtro,
                    fecha_ini:fecha_ini,
                    fecha_fin:fecha_fin,
                    cj_chica: caja_chica
                },
                beforeSend:function(){
                    wait.start();
                },
                success:function(result){
                    $("#filtro_filtro").val(filtro);
                    $("#filtro_fecha_ini").val(fecha_ini);
                    $("#filtro_fecha_fin").val(fecha_fin);

                    wait.close();
                    var oTabla = $("#tblDocumentos").dataTable();
                    oTabla.fnDestroy();
                    $("#tbContenedorDocumentos").html(result);
                    $("#dv_contenedor_documentos").show("slide", {
                        direction: 'left'
                    }, 500);
                    aplidarDataTable('tblDocumentos');
                }
            });
        });
    });

    $("#btnConsultar").click();

    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width:'100%',
            closeBtn: true
        });
    });

   $(".quedan").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        //$.fancybox({
            //'href': url,
            //type: 'iframe',
            //width:'40%',
            //height:'50%',
            //closeBtn: true
        //});
        $.ajax({
          url: url
        }).done(function(html){
          $.fancybox(html);
        });
        
    });
});


function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": true,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}

function cerrar_modal(){
    //alert('asdasd');
    jQuery.fancybox.close();
}