$(document).ready(function () {    
    $("#total").text(sumar()+'%')
    $("#txtPorcentaje").numeric();
    window.gSateliteWhite.jsSelect();
    $("#frmProrrateo").validate({
        rules: {
            txtNombre: {required: true} 
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            //Se valida que exista al menos un prorrateo.
             if ($("#tblProrrateo .trProrrateo").length == 0){
                crear_alerta('error','Detalle de prorrateos','Debe agregar al menos un registro');
                return false;
            }
            var total = sumar();
        
            if (  total < 100 ){
                crear_alerta('error','Porcentaje incorrecto','El total de los porcentajes debe ser: 100%');
                return false;
            }
             $("#total").text(total+"%");
            form.submit();
        }
    });
    
    var j = 1;
    
    if ($("#tbContenedorProrrateo .trContenedorProrrateo").length > 0) {
        j = $("#tbContenedorProrrateo .trContenedorProrrateo").length + 1;
    }

     $("#btnAgregarProrrateo").live("click", function (event) {        
        event.preventDefault();
		
		var txtPorcentaje = $("#txtPorcentaje").val();

        var slcCentro_costo = $("#slcCentro_costo").val();
        var slcCentro_costo_Text = $("#slcCentro_costo option:selected").text();

        //Obtener cuenta contable
        var slcCuenta_contable = $("#cuenta_contable_cnt").val();
        var d = $("#cuenta_contable_cnt").select2('data');
        var slcCuenta_contable_Text = (d) ? d.text : '';
                
        var repetido = false;
        var repetido_cec = false;
        var repetido_cnt = false;

        if (slcCentro_costo == ""){
            crear_alerta('error','Centro de costo es necesario','Debe seleccionar un centro de costo');
            return false;
        }


		//verificar repetido
        if ($("#tbContenedorProrrateo .trProrrateo").length > 0){
			$("#tbContenedorProrrateo .trProrrateo").each(function(){
				if ( $(this).attr("name") == (slcCentro_costo)){
				    repetido_cec = true;
				}
	        })

            $("#tbContenedorProrrateo .trProrrateo").each(function(){                
                //Recorre las cuentas contables de la grid
                var comparar = $(this).children().next().children().val();
                if ( comparar == slcCuenta_contable){
                    repetido_cnt = true;
                }
            })
		}

        if(repetido_cec && repetido_cnt){
            repetido = true;            
        }else{
            repetido = false;            
        }

        if( repetido == true){
            crear_alerta('error','Campos repetidos','El Servicio ya fue agregado con el centro de costo');
            return false;
        }

        if( txtPorcentaje == ""){
            $("#txtPorcentaje").focus();
            crear_alerta('error','Porcentaje es necesario','Debe agregar un número de porcentaje');
            return false;
        }

        if( slcCuenta_contable_Text == ""){
            $("#cuenta_contable_cnt").focus();
            crear_alerta('error','Cuenta contable es necesario','Debe agregar una cuenta contable');
            return false;
        }

        if( txtPorcentaje <= 0){
            $("#txtPorcentaje").focus();
            crear_alerta('info','Porcentaje','Debe ser mayor que 0');
            return false;
        }

        var suma_porcentaje = parseFloat( $("#total").text() ||0,10 );
        suma_porcentaje = suma_porcentaje + parseFloat(txtPorcentaje ||0,10 );

        if( suma_porcentaje > 100){
            crear_alerta('error','Porcentaje excedido','El total de los porcentajes debe ser: 100%');
            return false;
        }else{
            $("#total").text(suma_porcentaje);
        }

        if (isNaN(txtPorcentaje) == true){
             crear_alerta('error','Porcentaje no es un número','Debe agregar un número de porcentaje');
            return false;
        } else {
            //Se dibuja el html
            var html = '<tr class="trProrrateo" id="' + j + '" name="'+slcCentro_costo+'">';

            html += '<td  id="' + slcCentro_costo + '"  class="tdContenedorProrrateo">';
            html += '<input type="hidden" id="txt_centro_costo'+j+'" name="txt_centro_costo[]" class="text tables-input select-text " value="'+slcCentro_costo+'" readonly="readonly"/>';
            html += '<input type="text" class="text tables-input select-text " value="'+slcCentro_costo_Text+'" readonly="readonly"/>';
            html += '</td>';

            html += '<td  id="' + slcCuenta_contable + '"  class="tdContenedorProrrateo">';
            html += '<input type="hidden" id="txt_cuenta_contable'+j+'" name="txt_cuenta_contable[]" class="text tables-input select-text " value="'+slcCuenta_contable+'" readonly="readonly"/>';
            html += '<input type="text" class="text tables-input select-text " value="'+slcCuenta_contable_Text+'" readonly="readonly"/>';
            html += '</td>';

            html += '<td>';
            html += '<input id="porcentaje_' + j + '" name="porcentaje[]" type="text" class="text tables-input-show tables-input porcentaje" readonly="readonly" value="' + txtPorcentaje + '%" />';
            html += '</td>';
            
            html += '<td>';
            html += '<button type="button" class="btn btn-danger btn-mini btnDelProrrateo" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
            html += '</td>';

            html += '</tr>';

            var content = '';

            if ($("#tbContenedorProrrateo .trContenedorProrrateo").length > 0) {
                content = $("#tbContenedorProrrateo").html();
            }

            content += html;

            $("#tbContenedorProrrateo").append(html);   

            $("#txtPorcentaje").val('');


            $("#slcCentro_costo option:selected").removeAttr('selected');
            $("#slcCentro_costo").select2();
            j++;
            $("#total").text( sumar()+'%');
        }

    });  

    $("#slc_categoria").change(function (){
        if ( $(this).val() != ""){
            $("#slcproducto_servicio").select2('data',null);
            get_articulos( $(this).val());
            $("#div_select_ajax").css("display","none");
            $("#div_select").css("display","block");

            $("#slcproducto_servicio_ajax").select2('data',null);
        } else{
            $("#slcproducto_servicio").select2('data',null);
            $("#div_select").css("display","none");
            $("#div_select_ajax").css("display","block");
        }
    });


    function get_articulos(categoria){
        $.ajax({
            url: window.gSateliteWhite.baseUrl('modulo_compras/procesos/get_articulos'),
            data: {
                categoria:categoria  
            },
            type: "post",
            dataType: "text",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                $("#slcproducto_servicio").html(result);
                wait.close();
            }
        });
    }

    /*$("#cuenta_contable_cnt").select2({
        placeholder: "Buscar Cuenta Contable",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'utm/cuentas/get_cuentas_contables_like_prorrateo',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cuenta) {
                return {
                    cuenta: cuenta, tipo: $('#tipo_cnt').val(), cat_art: $('#slc_categoria').val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cuenta,
                        'text': item.cuenta_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });*/
    /***********************Cuenta contable del prorrateo*************************************/
    $("#slc_categoria").on('change',function() {
        //if($(this).val().length > 0){//Lleno
            $.ajax({
                type: 'POST',
                url: urlj + 'utm/cuentas/get_cuentas_contables_like_prorrateo',
                dataType: 'json',
                data: {
                    tipo: $('#tipo_cnt').val(), 
                    cat_art: $('#slc_categoria').val()
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    console.log(data);                    
                    $("#cuenta_contable_cnt").select2('destroy'); 
                    $("#cuenta_contable_cnt").html(data); 
                    $("#cuenta_contable_cnt").select2(); 
                    wait.close();
                }
            });
        //}
        
    });

});//Fin document ready
//Eliminar un prorrateo
$(".btnDelProrrateo").live("click", function () {
    var parent = $(this).parent().parent();
    $("#" + parent[0].id).remove().delay(300);
   $("#total").text( sumar()+'%');
});

$("#slcproducto_servicio_ajax").select2({
          placeholder:'Buscar productos',
          multiple:true,
          minimumInputLength: 3,
          ajax: {
              url:urlj+'modulo_compras/procesos/consultar_articulos_compras',
              dataType: 'json',
              type: 'POST',
              delay: 250,
              data: function (articulo) {
                return {
                    articulo: articulo
                };
              },
              results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.art_id,
                        'text': item.art_codigo+'-'+item.art_nombre
                    });
                });
                return {
                    results: myResults
                };
				
            } 
          }
});  

function  contar_filas(){
    var suma = 1;
    $(".trProrrateo").each(function(){
	    suma++;
    });
    return suma;
}


function sumar() {
    suma = 0;
    celda = "";
    $('.porcentaje').each(function(){ 
        celda = $(this).val();
        celda = celda.substring(-1);
        suma += parseFloat( celda ||0,10 );
    });
    suma = suma.toFixed(2);
   return suma;
}
