$(document).ready(function () {    

    $("#chk_envio").iButton({
        'labelOn': 'Enviar',
        'labelOff': 'No enviar',
        change: function (element) {
            if ( element.is(":checked") ) {
                $("#txt_envio_aprobacion").val( 1 );   
                validar_disponible();       
            } else {
                $("#txt_envio_aprobacion").val( 0 );      
            }
        }
    });
    
    $("#slc_requisicion").select2();
    $(".select2-search-choice-close").css("display","none");
    $("#slc_aprobacion").select2();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("body").on("change","#slc_requisicion",function(e) {
        event.preventDefault();
        $("#txt_disponible").val("");
        $("#lbl_disponible").text("");
        $("#lbl_total").text("$0.00");
        $("#txt_total").val("0.00");
        $("#txt_sub_total").val("0.00");
        $("#txt_descuentos").val("0.00");
        $("#txt_impuestos").val("0.00");

        var requisicion = $("#slc_requisicion").val();
        var especifica  = $('#slc_requisicion option:selected').data('especifica');
        var nombre      = $('#slc_requisicion option:selected').data('nombre');
        var codigo      = $('#slc_requisicion option:selected').data('codigo');
        
        if ( requisicion == "" ) {
            crear_alerta('error', 'Comparativo Compras', 'Seleccione una requisición');         
            return false;
        } 
        if ( codigo != "" ) {
            $("#txt_nombre_especifico").html("<b>Pda. Presup. / Rubro: </b>" + codigo + " - " + nombre);
        } else {
            $("#txt_nombre_especifico").html("");
        }
        if ( especifica != "") {
            $('#div_disponible').css('display','block');
            $('#txt_evaluar').val("1");
        } else{
            $('#div_disponible').css('display','none');
            $('#txt_evaluar').val("0");
        }
        $("#txt_requisicion").val(requisicion);
        wait.start();
        $.ajax({
            url: urlj+'modulo_compras/procesos/get_comparativos_cotizaciones',
            type: 'POST',
            data: {
                requisicion: requisicion
            },
            success:function(data) {
                var obj = jQuery.parseJSON(data);
                $("#div_detalle_cotizaciones").html(obj.detalle_comparativo_cotizacion);
                $("#div_detalle_cotizaciones").show("slide", {
                    direction: 'left'
                }, 500);

                $("#div_cotizaciones").html(obj.detalle_comparativo_proveedores);
                $("#div_cotizaciones").show("slide", {
                    direction: 'left'
                }, 500);

                $("#lbl_disponible").text("$" + number_format( obj.disponible,"2",".",",") );
                $("#txt_disponible").val( obj.disponible );
                wait.close();
            }
        });
    });


    $("body").on("click",".chk_padre",function(e) {
        var clase = $(this).data("proveedor");
        var valor = false;
        if ( $(this).is(":checked")) {
            valor = true;
        }
        $('.chk').each(function() {            
            $(this).attr('checked',false); 
        }); 
        $(this).attr('checked',valor); 
        $('.'+clase).each(function() {
            $(this).attr('checked',valor); 
        });
        sumar_chequeados();
    });

    $("body").on("click",".chk_articulo",function(e) {
        var clase               = $(this).data("articulo");
        var clase_padre         = $(this).data("proveedor");
        var contador_chequeados = 0;
        var valor = false;
        if ( $(this).is(":checked")) {
            valor = true;
        }
        
        $('.'+clase).each(function() {            
            $(this).attr('checked',false); 
        }); 

        $(this).attr('checked',valor); 

        $('.'+clase_padre).each(function() {         
            if($(this).is(":checked")){
                contador_chequeados++;
            }      
        }); 

        $('.chk_padre').each(function() {         
            $(this).attr('checked',false); 
        }); 
        
        if (contador_chequeados == $(".fila").length) {
            $("#"+clase_padre).attr('checked',true); 
        } else {
            $("#"+clase_padre).attr('checked',false); 
        }
        sumar_chequeados();
    });

    function sumar_chequeados() {
        $('.chk_padre').each(function() {     
            var sub_total   = 0;
            var impuesto    = 0;
            var descuento   = 0;
            var totales     = 0;
            var cantidades  = 0;

            var proveedor   = $(this).data("proveedor");
            var prv         = $(this).data("prv");

            $('.'+proveedor).each(function() { 
                var sumar  = $(this).data("sumar");              
                if($(this).is(":checked")){
                    sub_total   += parseFloat( $("#documento_"+sumar).val() );  
                    impuesto    += parseFloat( $("#impuesto_documento_"+sumar).val() );  
                    descuento   += parseFloat( $("#descuento_documento_"+sumar).val() );  
                    totales     += parseFloat( $("#total_documento_"+sumar).val() ); 
                    cantidades  += parseFloat( $("#cantidad_"+sumar).val() );     
                }      
            }); 
            
            $("#can_input_proveedor_"+prv).text( number_format(parseFloat(cantidades) ,2, ".",""));
            $("#sub_input_proveedor_"+prv).text( number_format(parseFloat(sub_total) ,2, ".",""));
            $("#imp_input_proveedor_"+prv).text( number_format(parseFloat(impuesto) ,2, ".",""));
            $("#des_input_proveedor_"+prv).text( number_format(parseFloat(descuento) ,2, ".",""));
            $("#input_proveedor_"+prv).text( number_format(parseFloat(totales) ,2, ".",""));
        }); 
        calcular_total();
    }

    function calcular_total(){
        var sub_total   = 0;
        var impuesto    = 0;
        var descuento   = 0;
        var total       = 0;

        $('.sub_totales').each(function() { 
            sub_total += parseFloat( $(this).text() );    
        }); 

        $('.impuestos').each(function() { 
            impuesto += parseFloat( $(this).text() );    
        });
         
        $('.decuentos').each(function() { 
            descuento += parseFloat( $(this).text() );    
        }); 

        $('.totales').each(function() { 
            total += parseFloat( $(this).text() );    
        });   

        $("#lbl_total").text( "$"+number_format(parseFloat(total) ,2, ".",""));  
        $("#txt_sub_total").val( number_format(parseFloat(sub_total) ,2, ".",""));  
        $("#txt_impuestos").val( number_format(parseFloat(impuesto) ,2, ".",""));  
        $("#txt_descuentos").val( number_format(parseFloat(descuento) ,2, ".",""));  
        $("#txt_total").val( number_format(parseFloat(total) ,2, ".",""));  
    }

    $("#enviar_comparativo").click(function () { 
        event.preventDefault();
        cantidad_filas         = $(".fila").length;
        cantidad_chequeados    = 0;
        aprobacion             = $("#slc_aprobacion").val();
        if (cantidad_filas == 0) {
            crear_alerta('error', 'Comparativo Compras', 'No se han seleccionado cotizaciones.');
            $("#id_generales").trigger("click");
            wait.close();
            return false;
        }
        $('.chk_articulo').each(function() {         
            if($(this).is(":checked")){
                cantidad_chequeados++;
            }    
        }); 
        if ( cantidad_chequeados < cantidad_filas) {
            crear_alerta('error', 'Comparativo Compras', 'No se han seleccionado cotizaciones para todos los articulos.');
            $("#id_generales").trigger("click");
            wait.close();
            return false;
        }
        // if ( $(".new").length <= 0) {
        //     crear_alerta('error', 'Comparativo Compras', 'Se debe agregar al menos un comentario.');
        //     $("#id_seguimiento").trigger("click");
        //     wait.close();
        //     return false;
        // }
        var validar_flujos = jQuery.parseJSON(validar_flujo("COMPARATIVO_COMPRA"));        
        if (validar_flujos.no_par == 0) {
            crear_alerta('error', 'Comparativo Compras', 'Parametro configurado erroneamente o no configurado, favor revisar.');
            wait.close();
            return false;
        }
        if (validar_flujos.no_flu == 0) {
            crear_alerta('error', 'Comparativo Compras', 'Flujo no configurado para proceso a realizar, favor revisar configuraciones.');
            wait.close();
            return false;
        }
        //return false;
        $("#frm-comparativo").submit();
    });

    $("body").on("click","#btnComentario",function(e) {
        event.preventDefault();
        var comentario  = $("#txt_comentario").val();
        var date        = new Date();
        var fecha       = date.getDate() + "-" + (date.getMonth()+1) + "-" +  date.getFullYear();

        if ( comentario == "") {
            $("#txt_comentario").focus();
            crear_alerta('error', 'Comparativo Compras', 'Agregue un comentario');
            return false;
        }

        var linea = '<tr class="new">';
            linea += '<td>'+fecha+'</td>';
            linea += '<td>'+global_nombre_empleado+'</td>';
            linea += '<td><textarea id="txt_seguimiento" name="txt_seguimiento[]" cols="30" rows="3" readonly>'+comentario+'</textarea></td>';
            linea += '<td><button type="button" class="btn btn-danger btn-mini btnDelChe" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;">Eliminar</button></td>';
        linea += '</tr>';

        $('#tbody_seguimiento').append(linea);    
        $("#txt_comentario").val("");
    });

    //Eliminar elemento
    $(document).on('click', '.btnDelChe', function () {
        $(this).parent().parent().remove();
    });


    function validar_disponible(){       
        var total       = parseFloat( $("#txt_total").val() );
        var disponible  = parseFloat( $("#txt_disponible").val() );
        if ( $("#txt_evaluar").val() == 1) {
            if ( total > disponible ) {
                crear_alerta('info', 'Monto disponible', 'EL total global sobrepasa el monto disponible');
                $("#chk_envio").removeAttr("checked");
                $("#chk_envio").trigger("change");
            }    
          
        }        
    }

});

function validar_flujo(parametro) {
    var resultado = '';
    $.ajax({
        url: urlj + 'modulo_compras/procesos/validar_flujo',
        type: 'POST',
        async: false,
        data: {
            parametro: parametro
        },
        success: function (data) {
            resultado = data;
        }
    });

    return resultado;
}