$(document).ready(function () {

    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: 'Seleccione una opción'});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");

    /*Busqueda*/
    $("#btnConsultar").click(function () {

        var proveedor   = $("#slcProveedor").val();
        var fecha_ini   = $("#txtFechaIni").val();
        var fecha_fin   = $("#txtFechaFin").val();
        var permiso_val = $("#permiso_val").val();
        var slc_requisicion = $("#slc_requisicion").val();
        var slc_sucusal = $("#slc_sucusal").val(); 
        var slcEstado = $("#slcEstado").val();

        if (fecha_ini != '' && fecha_fin != '') {
            if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Cotizaciones', 'Verifique el período de las fechas.');
                return false;
            }
        }

        var requisicion = $("#hdnRequisicion").val();

        requisicion = (requisicion > 0) ? requisicion : '0';

        $("#dv_contenedor_cotizaciones").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('modulo_compras/procesos/cotizaciones/' + requisicion+'/1'),
                        data: {proveedor: proveedor, 
                            fecha_ini: fecha_ini, 
                            fecha_fin: fecha_fin, 
                            permiso_val:permiso_val,
                            slc_requisicion:slc_requisicion,
                            slc_sucusal:slc_sucusal,
                            slc_estado: slcEstado},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            var oTabla = $("#tblCotizaciones").dataTable();

                            oTabla.fnDestroy();
                            $("#tbContenedorCotizaciones").html(result);

                            $("#dv_contenedor_cotizaciones").show("slide", {
                                direction: 'left'
                            }, 500);
                            aplidarDataTable('tblCotizaciones');
                        }
                    });
                }
        );
    });

    $("#btnConsultar").click();

    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width: '100%',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        },
        "aaSorting": []
    });
}
