$(document).ready(function () {

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");

    $("#btnCrear").click(function () {
        event.preventDefault();
        wait.start();

        fecha_ini = $("#fecha_ini").val();
        fecha_fin = $("#fecha_fin").val();
        if($("#tbContenedorListado").length <= 0 || $("#txtMontoTotal").val()<=0 ) {
            wait.close();
            crear_alerta('error', 'Cierre de caja chica', 'Debe agregar comprobantes de caja chica.');
        }else{
            if($("#fecha_fin").val()!=""){
                if(!verifica_fecha(fecha_ini,fecha_fin)){
                     wait.close();
                     return false;
                }else{
                    $("#frm-listado").submit();
                    wait.close();
                }  
            }else{
                crear_alerta('error', 'Cierre de caja chica', 'Debe agregar una fecha final.');
                wait.close();
            }
        }
    });
 
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 5,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}




function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}


