$(document).ready(function () {    
    
    $("#chk_envio").iButton({
        'labelOn': 'Enviar',
        'labelOff': 'No enviar'
    });
    
    $("body").on("change","#chk_envio",function(e) {
        aprobacion = ($("#chkProceso").attr('checked'))? 1:0;
        $("#txt_envio_aprobacion").val( aprobacion );        
    });

    $('.checker').removeClass('checker');
    $('.chk_articulo').css({ opacity: 1 });
    $( ".chk_articulo" ).prop( "disabled", true );    
    $("#slc_requisicion, #slc_aprobacion").select2();

    sumar_chequeados();

    $(".chk").attr('disabled','disabled');

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("body").on("click","#btnConsultar",function(e) {
        event.preventDefault();
        var desde       = $("#txtFechaIni").val();
        var hasta       = $("#txtFechaFin").val();
        var requisicion = $("#slc_requisicion").val();

        if ( desde == "" ) {
            crear_alerta('error', 'Comparativo Compras', 'Por favor agrege una fecha desde.');
            $("#txtFechaIni").focus();
            return false;
        } 

        if ( hasta == "" ) {
            crear_alerta('error', 'Comparativo Compras', 'Por favor agrege una fecha hasta.');
            $("#txtFechaFin").focus();
            return false;
        } 

        if (!validarPeriodo(desde, hasta)) {
            crear_alerta('error', 'Comparativo Compras', 'Verifique el período de fechas.');
            return false;
        }

        if ( requisicion == "" ) {
            crear_alerta('error', 'Comparativo Compras', 'Seleccione una requisición');         
            return false;
        } 

        $("#txt_requisicion").val(requisicion);        
        $("#txt_fecha_inicio").val(desde); 
        $("#txt_fecha_fin").val(hasta); 

        wait.start();
        $.ajax({
            url: urlj+'modulo_compras/procesos/get_comparativos_cotizaciones',
            type: 'POST',
            data: {
                desde: desde,
                hasta: hasta,
                requisicion: requisicion
            },
            success:function(data) {
                var obj = jQuery.parseJSON(data);
                $("#div_detalle_cotizaciones").html(obj.detalle_comparativo_cotizacion);
                $("#div_detalle_cotizaciones").show("slide", {
                    direction: 'left'
                }, 500);

                $("#div_cotizaciones").html(obj.detalle_comparativo_proveedores);
                $("#div_cotizaciones").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            }
        });

    });

    $("body").on("click",".chk_padre",function(e) {
        var clase = $(this).data("proveedor");
        var valor = false;
        if ( $(this).is(":checked")) {
            valor = true;
        }
        
        $('.chk').each(function() {            
            $(this).attr('checked',false); 
        }); 

        $(this).attr('checked',valor); 

        $('.'+clase).each(function() {            
            $(this).attr('checked',valor); 
        });
        sumar_chequeados();
    });

    $("body").on("click",".chk_articulo",function(e) {
        var clase               = $(this).data("articulo");
        var clase_padre         = $(this).data("proveedor");
        var contador_chequeados = 0;
        var valor = false;
        if ( $(this).is(":checked")) {
            valor = true;
        }
        
        $('.'+clase).each(function() {            
            $(this).attr('checked',false); 
        }); 

        $(this).attr('checked',valor); 

        $('.'+clase_padre).each(function() {         
            if($(this).is(":checked")){
                contador_chequeados++;
            }      
        }); 

        $('.chk_padre').each(function() {         
            $(this).attr('checked',false); 
        }); 
        
        if (contador_chequeados == $(".fila").length) {
            $("#"+clase_padre).attr('checked',true); 
        } else {
            $("#"+clase_padre).attr('checked',false); 
        }
        sumar_chequeados();
    });

    function sumar_chequeados() {
        $('.chk_padre').each(function() {     
            var sub_total   = 0;
            var impuesto    = 0;
            var descuento   = 0;
            var totales     = 0;
            var cantidades  = 0;

            var proveedor   = $(this).data("proveedor");
            var prv         = $(this).data("prv");

            $('.'+proveedor).each(function() { 
                var sumar  = $(this).data("sumar");              
                if($(this).is(":checked")){
                    sub_total   += parseFloat( $("#documento_"+sumar).val() );  
                    impuesto    += parseFloat( $("#impuesto_documento_"+sumar).val() );  
                    descuento   += parseFloat( $("#descuento_documento_"+sumar).val() );  
                    totales     += parseFloat( $("#total_documento_"+sumar).val() ); 
                    cantidades  += parseFloat( $("#cantidad_"+sumar).val() );     
                }      
            }); 

            $("#can_input_proveedor_"+prv).text( number_format(parseFloat(cantidades) ,2, ".",""));
            $("#sub_input_proveedor_"+prv).text( number_format(parseFloat(sub_total) ,2, ".",""));
            $("#imp_input_proveedor_"+prv).text( number_format(parseFloat(impuesto) ,2, ".",""));
            $("#des_input_proveedor_"+prv).text( number_format(parseFloat(descuento) ,2, ".",""));
            $("#input_proveedor_"+prv).text( number_format(parseFloat(totales) ,2, ".",""));
        }); 
        calcular_total();
    }

    function calcular_total(){
        var sub_total   = 0;
        var impuesto    = 0;
        var descuento   = 0;
        var total       = 0;

        $('.sub_totales').each(function() { 
            sub_total += parseFloat( $(this).text() );    
        }); 

        $('.impuestos').each(function() { 
            impuesto += parseFloat( $(this).text() );    
        });
         
        $('.decuentos').each(function() { 
            descuento += parseFloat( $(this).text() );    
        }); 

        $('.totales').each(function() { 
            total += parseFloat( $(this).text() );    
        });   

        $("#lbl_total").text( "$"+number_format(parseFloat(total) ,2, ".",""));  
        $("#txt_sub_total").val( number_format(parseFloat(sub_total) ,2, ".",""));  
        $("#txt_impuestos").val( number_format(parseFloat(impuesto) ,2, ".",""));  
        $("#txt_descuentos").val( number_format(parseFloat(descuento) ,2, ".",""));  
        $("#txt_total").val( number_format(parseFloat(total) ,2, ".",""));  
    }

    $("#enviar_comparativo").click(function () { 
        event.preventDefault();
        cantidad_filas         = $(".fila").length;
        cantidad_chequeados    = 0;
        aprobacion             = $("#slc_aprobacion").val();

        if (cantidad_filas == 0) {
            crear_alerta('error', 'Comparativo Compras', 'No se han seleccionado cotizaciones.');
            return false;
        }

        $('.chk_articulo').each(function() {         
            if($(this).is(":checked")){
                cantidad_chequeados++;
            }    
        }); 

        if ( cantidad_chequeados < cantidad_filas) {
            crear_alerta('error', 'Comparativo Compras', 'No se han seleccionado cotizaciones para todos los articulos.');
            $("#id_generales").trigger("click");
            return false;
        }

        /*if ( aprobacion == "") {
           crear_alerta('error', 'Comparativo Compras', 'Se debe aprobar o rechazar el comparativo.');
           $("#id_generales").trigger("click");
           return false;
        }*/

        // if ( $(".new").length <= 0) {
        //     crear_alerta('error', 'Comparativo Compras', 'Se debe agregar al menos un comentario.');
        //     $("#id_seguimiento").trigger("click");
        //     return false;
        // }

        $(".chk").removeAttr('disabled');
        $("#frm-comparativo").submit();
    });

    $("body").on("click","#btnComentario",function(e) {
        event.preventDefault();
        var comentario  = $("#txt_comentario").val();
        var date        = new Date();
        var fecha       = date.getDate() + "-" + (date.getMonth()+1) + "-" +  date.getFullYear();

        if ( comentario == "") {
            $("#txt_comentario").focus();
            crear_alerta('error', 'Comparativo Compras', 'Agregue un comentario');
            return false;
        }

        var linea = '<tr class="new">';
            linea += '<td>'+fecha+'</td>';
            linea += '<td>'+global_nombre_empleado+'</td>';
            linea += '<td><textarea id="txt_seguimiento" name="txt_seguimiento[]" cols="30" rows="3" readonly>'+comentario+'</textarea></td>';
            linea += '<td><button type="button" class="btn btn-danger btn-mini btnDelChe" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;">Eliminar</button></td>';
        linea += '</tr>';

        $('#tbody_seguimiento').append(linea);    
        $("#txt_comentario").val("");
    });

    //Eliminar elemento
    $(document).on('click', '.btnDelChe', function () {
        $(this).parent().parent().remove();
    });

});